/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.block;

import gtneioreplugin.plugin.block.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityEyeOfHarmony
extends TileEntity {
    private static final double EOH_STAR_FIELD_RADIUS = 13.0;
    private float size = 10.0f;
    private float rotationSpeed = 10.0f;
    private long tier = 9L;
    private final ArrayList<OrbitingObject> orbitingObjects = new ArrayList();
    private static final Set<String> BLACKLISTED_BLOCKS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Tf", "Ow", "ED", "EA", "VA")));
    private static final Map<String, Block> BLOCKS = new HashMap<String, Block>();
    private static final float MAX_ANGLE = 30.0f;
    public float angle;
    private static final String EOH_NBT_TAG = "EOH:";
    private static final String ROTATION_SPEED_NBT_TAG = "EOH:rotationSpeed";
    private static final String SIZE_NBT_TAG = "EOH:size";
    private static final String TIER_NBT_TAG = "EOH:tier";

    public AxisAlignedBB getRenderBoundingBox() {
        double x = this.field_145851_c;
        double y = this.field_145848_d;
        double z = this.field_145849_e;
        return AxisAlignedBB.func_72330_a((double)(x - 13.0), (double)(y - 13.0), (double)(z - 13.0), (double)(x + 13.0 + 1.0), (double)(y + 13.0 + 1.0), (double)(z + 13.0 + 1.0));
    }

    public void setSize(float size) {
        this.size = size;
    }

    public void setRotationSpeed(float rotationSpeed) {
        this.rotationSpeed = rotationSpeed;
    }

    public static <T> ArrayList<T> selectNRandomElements(Collection<T> inputList, long n) {
        ArrayList randomElements = new ArrayList((int)n);
        ArrayList inputArray = new ArrayList(inputList);
        Random rand = new Random();
        IntStream.range(0, (int)n).forEach(i -> {
            int randomIndex = rand.nextInt(inputArray.size());
            randomElements.add(inputArray.get(randomIndex));
            inputArray.remove(randomIndex);
        });
        return randomElements;
    }

    public static float generateRandomFloat(float a, float b) {
        Random rand = new Random();
        return rand.nextFloat() * (b - a) + a;
    }

    public long getTier() {
        return this.tier;
    }

    public void setTier(long tier) {
        this.tier = tier;
    }

    public float getSize() {
        return this.size;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public void func_145845_h() {
        this.angle += 10.0f;
    }

    public ArrayList<OrbitingObject> getOrbitingObjects() {
        return this.orbitingObjects;
    }

    public void generateImportantInfo() {
        int index = 0;
        for (Block block : TileEntityEyeOfHarmony.selectNRandomElements(BLOCKS.values(), this.tier + 1L)) {
            float xAngle = TileEntityEyeOfHarmony.generateRandomFloat(-30.0f, 30.0f);
            float zAngle = TileEntityEyeOfHarmony.generateRandomFloat(-30.0f, 30.0f);
            float distance = (float)(++index) + TileEntityEyeOfHarmony.generateRandomFloat(-0.2f, 0.2f);
            float scale = TileEntityEyeOfHarmony.generateRandomFloat(0.2f, 0.9f);
            float rotationSpeed = TileEntityEyeOfHarmony.generateRandomFloat(0.5f, 1.5f);
            float orbitSpeed = TileEntityEyeOfHarmony.generateRandomFloat(0.5f, 1.5f);
            this.orbitingObjects.add(new OrbitingObject(block, distance, rotationSpeed, orbitSpeed, xAngle, zAngle, scale));
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74776_a(ROTATION_SPEED_NBT_TAG, this.rotationSpeed);
        compound.func_74776_a(SIZE_NBT_TAG, this.size);
        compound.func_74772_a(TIER_NBT_TAG, this.tier);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.rotationSpeed = compound.func_74760_g(ROTATION_SPEED_NBT_TAG);
        this.size = compound.func_74760_g(SIZE_NBT_TAG);
        this.tier = compound.func_74763_f(TIER_NBT_TAG);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    static {
        ModBlocks.blocks.forEach((dimString, dimBlock) -> {
            if (!BLACKLISTED_BLOCKS.contains(dimString)) {
                BLOCKS.put((String)dimString, (Block)dimBlock);
            }
        });
    }

    public static class OrbitingObject {
        public final Block block;
        public final float distance;
        public final float rotationSpeed;
        public final float orbitSpeed;
        public final float xAngle;
        public final float zAngle;
        public final float scale;

        public OrbitingObject(Block block, float distance, float rotationSpeed, float orbitSpeed, float xAngle, float zAngle, float scale) {
            this.block = block;
            this.distance = distance;
            this.rotationSpeed = rotationSpeed;
            this.orbitSpeed = orbitSpeed;
            this.xAngle = xAngle;
            this.zAngle = zAngle;
            this.scale = scale;
        }
    }
}

