/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.block;

import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityForgeOfGods
extends TileEntity {
    private float radius = 32.0f;
    private float rotationSpeed = 10.0f;
    private int ringCount = 1;
    private float colorR = 0.7f;
    private float colorG = 0.8f;
    private float colorB = 1.0f;
    private float gamma = 3.0f;
    private float rotAngle = 0.0f;
    private float rotAxisX = 1.0f;
    private float rotAxisY = 0.0f;
    private float rotAxisZ = 0.0f;
    private static final String NBT_TAG = "FOG:";
    private static final String ROTATION_SPEED_NBT_TAG = "FOG:ROTATION";
    private static final String SIZE_NBT_TAG = "FOG:RADIUS";
    private static final String RINGS_NBT_TAG = "FOG:RINGS";
    private static final String COLOR_RED_NBT_TAG = "FOG:COLOR_RED";
    private static final String COLOR_GREEN_NBT_TAG = "FOG:COLOR_GREEN";
    private static final String COLOR_BLUE_NBT_TAG = "FOG:COLOR_BLUE";
    private static final String COLOR_GAMMA_NBT_TAG = "FOG:COLOR_GAMMA";
    private static final String ROT_ANGLE_NBT_TAG = "FOG:ROT_ANGLE";
    private static final String ROT_AXIS_X_NBT_TAG = "FOG:ROT_AXIS_X";
    private static final String ROT_AXIS_Y_NBT_TAG = "FOG:ROT_AXIS_Y";
    private static final String ROT_AXIS_Z_NBT_TAG = "FOG:ROT_AXIS_Z";
    public static final float BACK_PLATE_DISTANCE = -121.5f;
    public static final float BACK_PLATE_RADIUS = 13.0f;

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 51200.0;
    }

    public void setStarRadius(float size) {
        this.radius = size;
    }

    public float getStarRadius() {
        return this.radius;
    }

    public float getRotationSpeed() {
        return this.rotationSpeed;
    }

    public void setRotationSpeed(float speed) {
        this.rotationSpeed = speed;
    }

    public float getColorR() {
        return this.colorR;
    }

    public float getColorG() {
        return this.colorG;
    }

    public float getColorB() {
        return this.colorB;
    }

    public float getGamma() {
        return this.gamma;
    }

    public void setColor(float r, float g, float b) {
        this.setColor(r, g, b, 1.0f);
    }

    public void setColor(float r, float g, float b, float gamma) {
        this.colorR = r;
        this.colorG = g;
        this.colorB = b;
        this.gamma = gamma;
    }

    public int getRingCount() {
        return this.ringCount;
    }

    public void setRingCount(int count) {
        if (this.ringCount < 1) {
            return;
        }
        this.ringCount = count;
    }

    public float getRotAngle() {
        return this.rotAngle;
    }

    public float getRotAxisX() {
        return this.rotAxisX;
    }

    public float getRotAxisY() {
        return this.rotAxisY;
    }

    public float getRotAxisZ() {
        return this.rotAxisZ;
    }

    public void setRenderRotation(Rotation rotation, ForgeDirection direction) {
        switch (direction) {
            case SOUTH: {
                this.rotAngle = 90.0f;
                break;
            }
            case NORTH: {
                this.rotAngle = 90.0f;
                break;
            }
            case WEST: {
                this.rotAngle = 0.0f;
                break;
            }
            case EAST: {
                this.rotAngle = 180.0f;
                break;
            }
            case UP: {
                this.rotAngle = -90.0f;
                break;
            }
            case DOWN: {
                this.rotAngle = -90.0f;
            }
        }
        this.rotAxisX = 0.0f;
        this.rotAxisY = direction.offsetZ + direction.offsetX;
        this.rotAxisZ = direction.offsetY;
        this.updateToClient();
    }

    public float getLensDistance(int lensID) {
        float f;
        switch (lensID) {
            case 0: {
                f = -61.5f;
                break;
            }
            case 1: {
                f = -54.5f;
                break;
            }
            case 2: {
                f = -44.5f;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + lensID);
            }
        }
        return f;
    }

    public float getLenRadius(int lensID) {
        float f;
        switch (lensID) {
            case 0: {
                f = 1.1f;
                break;
            }
            case 1: {
                f = 3.5f;
                break;
            }
            case 2: {
                f = 5.0f;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + lensID);
            }
        }
        return f;
    }

    public float getStartAngle() {
        float x = -this.getLensDistance(this.getRingCount() - 1);
        float y = this.getLenRadius(this.getRingCount() - 1);
        float alpha = (float)Math.atan2(y, x);
        float beta = (float)Math.asin((double)this.radius / Math.sqrt(x * x + y * y));
        return alpha + (1.5707964f - beta);
    }

    public static float interpolate(float x0, float x1, float y0, float y1, float x) {
        return y0 + (x - x0) * (y1 - y0) / (x1 - x0);
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74776_a(ROTATION_SPEED_NBT_TAG, this.rotationSpeed);
        compound.func_74776_a(SIZE_NBT_TAG, this.radius);
        compound.func_74768_a(RINGS_NBT_TAG, this.ringCount);
        compound.func_74776_a(COLOR_RED_NBT_TAG, this.colorR);
        compound.func_74776_a(COLOR_GREEN_NBT_TAG, this.colorG);
        compound.func_74776_a(COLOR_BLUE_NBT_TAG, this.colorB);
        compound.func_74776_a(COLOR_GAMMA_NBT_TAG, this.gamma);
        compound.func_74776_a(ROT_ANGLE_NBT_TAG, this.rotAngle);
        compound.func_74776_a(ROT_AXIS_X_NBT_TAG, this.rotAxisX);
        compound.func_74776_a(ROT_AXIS_Y_NBT_TAG, this.rotAxisY);
        compound.func_74776_a(ROT_AXIS_Z_NBT_TAG, this.rotAxisZ);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.rotationSpeed = compound.func_74760_g(ROTATION_SPEED_NBT_TAG);
        this.radius = compound.func_74760_g(SIZE_NBT_TAG);
        this.ringCount = compound.func_74762_e(RINGS_NBT_TAG);
        if (this.ringCount < 1) {
            this.ringCount = 1;
        }
        this.colorR = compound.func_74760_g(COLOR_RED_NBT_TAG);
        this.colorG = compound.func_74760_g(COLOR_GREEN_NBT_TAG);
        this.colorB = compound.func_74760_g(COLOR_BLUE_NBT_TAG);
        this.gamma = compound.func_74760_g(COLOR_GAMMA_NBT_TAG);
        this.rotAngle = compound.func_74760_g(ROT_ANGLE_NBT_TAG);
        this.rotAxisX = compound.func_74760_g(ROT_AXIS_X_NBT_TAG);
        this.rotAxisY = compound.func_74760_g(ROT_AXIS_Y_NBT_TAG);
        this.rotAxisZ = compound.func_74760_g(ROT_AXIS_Z_NBT_TAG);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void updateToClient() {
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }
}

