/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchDataAccess;
import gregtech.api.objects.GTRenderedTexture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.reflect.FieldUtils;
import tectech.mechanics.dataTransport.InventoryDataPacket;
import tectech.mechanics.pipe.IConnectsToDataPipe;
import tectech.recipe.TTRecipeAdder;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataConnector;
import tectech.util.CommonValues;
import tectech.util.TTUtility;

public class MTEHatchDataItemsInput
extends MTEHatchDataAccess
implements IConnectsToDataPipe {
    public boolean delDelay = true;
    private ItemStack[] stacks;
    private String clientLocale = "en_US";

    public MTEHatchDataItemsInput(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
        TTUtility.setTier(aTier, this);
    }

    public MTEHatchDataItemsInput(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GTRenderedTexture(MTEHatchDataConnector.EM_D_ACTIVE, Dyes.getModulation(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL.getRGBA())), new GTRenderedTexture(MTEHatchDataConnector.EM_D_CONN)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GTRenderedTexture(MTEHatchDataConnector.EM_D_SIDES, Dyes.getModulation(this.getBaseMetaTileEntity().getColorization(), Dyes.MACHINE_METAL.getRGBA())), new GTRenderedTexture(MTEHatchDataConnector.EM_D_CONN)};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchDataItemsInput(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        try {
            EntityPlayerMP player = (EntityPlayerMP)aPlayer;
            this.clientLocale = (String)FieldUtils.readField((Object)player, (String)"translator", (boolean)true);
        }
        catch (Exception e) {
            this.clientLocale = "en_US";
        }
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isDataInputFacing(ForgeDirection side) {
        return this.isInputFacing(side);
    }

    @Override
    public boolean canConnectData(ForgeDirection side) {
        return this.isInputFacing(side);
    }

    @Override
    public IConnectsToDataPipe getNext(IConnectsToDataPipe source) {
        return null;
    }

    public void setContents(InventoryDataPacket iIn) {
        if (iIn == null) {
            this.stacks = null;
        } else if (((ItemStack[])iIn.getContent()).length > 0) {
            this.stacks = (ItemStack[])iIn.getContent();
            this.delDelay = true;
        } else {
            this.stacks = null;
        }
    }

    @Override
    public void onRemoval() {
        this.stacks = null;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        NBTTagCompound stacksTag = new NBTTagCompound();
        if (this.stacks != null) {
            stacksTag.func_74768_a("count", this.stacks.length);
            for (int i = 0; i < this.stacks.length; ++i) {
                stacksTag.func_74782_a(Integer.toString(i), (NBTBase)this.stacks[i].func_77955_b(new NBTTagCompound()));
            }
        }
        aNBT.func_74782_a("data_stacks", (NBTBase)stacksTag);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        NBTTagCompound stacksTag = aNBT.func_74775_l("data_stacks");
        int count = stacksTag.func_74762_e("count");
        if (count > 0) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int i = 0; i < count; ++i) {
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)stacksTag.func_74775_l(Integer.toString(i)));
                if (stack == null) continue;
                stacks.add(stack);
            }
            if (stacks.size() > 0) {
                this.stacks = stacks.toArray(TTRecipeAdder.nullItem);
            }
        }
    }

    @Override
    public int func_70302_i_() {
        return this.stacks != null ? this.stacks.length : 0;
    }

    @Override
    public ItemStack func_70301_a(int aIndex) {
        return this.stacks != null && aIndex < this.stacks.length ? this.stacks[aIndex] : null;
    }

    @Override
    public List<ItemStack> getInventoryItems(Predicate<ItemStack> filter) {
        if (this.stacks == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.stacks).filter(stack -> stack != null && filter.test((ItemStack)stack)).collect(Collectors.toList());
    }

    @Override
    public boolean shouldDropItemAt(int index) {
        return false;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (4L == aTick % 20L) {
            if (this.stacks == null) {
                this.getBaseMetaTileEntity().setActive(false);
            } else {
                this.getBaseMetaTileEntity().setActive(true);
                if (this.delDelay) {
                    this.delDelay = false;
                } else {
                    this.setContents(null);
                }
            }
        }
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.datainass.desc.0"), StatCollector.func_74838_a((String)"gt.blockmachines.hatch.datainass.desc.1"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.hatch.datainass.desc.2")};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.func_74837_a((String)"tt.keyphrase.Content_Stack_Count", (Object[])new Object[]{this.clientLocale}) + ": " + (this.stacks == null ? 0 : this.stacks.length)};
    }

    @Override
    public byte getColorization() {
        return this.getBaseMetaTileEntity().getColorization();
    }
}

