/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDynamo;
import gregtech.api.metatileentity.implementations.MTEHatchEnergy;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchMaintenance;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import tectech.loader.ConfigHandler;
import tectech.loader.NetworkDispatcher;
import tectech.mechanics.spark.RendererMessage;
import tectech.mechanics.spark.ThaumSpark;
import tectech.mechanics.tesla.ITeslaConnectable;
import tectech.mechanics.tesla.ITeslaConnectableSimple;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.hatch.MTEHatchCapacitor;
import tectech.thing.metaTileEntity.hatch.MTEHatchDynamoMulti;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;
import tectech.thing.metaTileEntity.hatch.MTEHatchParam;
import tectech.thing.metaTileEntity.multi.base.INameFunction;
import tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import tectech.thing.metaTileEntity.multi.base.LedStatus;
import tectech.thing.metaTileEntity.multi.base.Parameters;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;
import tectech.util.CommonValues;

public class MTETeslaTower
extends TTMultiblockBase
implements ISurvivalConstructable,
ITeslaConnectable {
    private final Multimap<Integer, ITeslaConnectableSimple> teslaNodeMap = MultimapBuilder.treeKeys().linkedListValues().build();
    private final HashSet<ThaumSpark> sparkList = new HashSet();
    private int sparkCount = 10;
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private int mTier = 0;
    private int plasmaTier = 0;
    private FluidStack[] mOutputFluidsQueue;
    private final ArrayList<MTEHatchCapacitor> eCapacitorHatches = new ArrayList();
    private long energyCapacity = 0L;
    private long outputVoltageMax = 0L;
    private int vTier = -1;
    private long outputCurrentMax = 0L;
    private long outputVoltage;
    private long outputCurrent;
    private byte oldRotation = (byte)-1;
    private ForgeDirection oldOrientation = ForgeDirection.UNKNOWN;
    public Vec3Impl posTop = Vec3Impl.NULL_VECTOR;
    private static final String[] description;
    private static final IStructureDefinition<MTETeslaTower> STRUCTURE_DEFINITION;
    protected Parameters.Group.ParameterIn popogaSetting;
    protected Parameters.Group.ParameterIn histLowSetting;
    protected Parameters.Group.ParameterIn histHighSetting;
    protected Parameters.Group.ParameterIn transferRadiusTowerSetting;
    protected Parameters.Group.ParameterIn transferRadiusTransceiverSetting;
    protected Parameters.Group.ParameterIn transferRadiusCoverUltimateSetting;
    protected Parameters.Group.ParameterIn outputVoltageSetting;
    protected Parameters.Group.ParameterIn outputCurrentSetting;
    protected Parameters.Group.ParameterIn sortTimeMinSetting;
    protected Parameters.Group.ParameterIn overDriveSetting;
    protected Parameters.Group.ParameterOut popogaDisplay;
    protected Parameters.Group.ParameterOut transferRadiusTowerDisplay;
    protected Parameters.Group.ParameterOut transferRadiusTransceiverDisplay;
    protected Parameters.Group.ParameterOut transferRadiusCoverUltimateDisplay;
    protected Parameters.Group.ParameterOut outputVoltageDisplay;
    protected Parameters.Group.ParameterOut outputCurrentDisplay;
    protected Parameters.Group.ParameterOut outputMaxDisplay;
    protected Parameters.Group.ParameterOut energyCapacityDisplay;
    protected Parameters.Group.ParameterOut energyStoredDisplay;
    protected Parameters.Group.ParameterOut energyFractionDisplay;
    protected Parameters.Group.ParameterOut sortTimeDisplay;
    private static final INameFunction<MTETeslaTower> HYSTERESIS_LOW_SETTING_NAME;
    private static final INameFunction<MTETeslaTower> HYSTERESIS_HIGH_SETTING_NAME;
    private static final INameFunction<MTETeslaTower> TRANSFER_RADIUS_TOWER_SETTING_NAME;
    private static final INameFunction<MTETeslaTower> TRANSFER_RADIUS_TRANSCEIVER_SETTING_NAME;
    private static final INameFunction<MTETeslaTower> TRANSFER_RADIUS_COVER_ULTIMATE_SETTING_NAME;
    private static final INameFunction<MTETeslaTower> OUTPUT_VOLTAGE_SETTING_NAME;
    private static final INameFunction<MTETeslaTower> OUTPUT_CURRENT_SETTING_NAME;
    private static final INameFunction<MTETeslaTower> SCAN_TIME_MIN_SETTING_NAME;
    private static final INameFunction<MTETeslaTower> OVERDRIVE_SETTING_NAME;
    private static final INameFunction<MTETeslaTower> POPOGA_NAME;
    private static final INameFunction<MTETeslaTower> TRANSFER_RADIUS_TOWER_DISPLAY_NAME;
    private static final INameFunction<MTETeslaTower> TRANSFER_RADIUS_TRANSCEIVER_DISPLAY_NAME;
    private static final INameFunction<MTETeslaTower> TRANSFER_RADIUS_COVER_ULTIMATE_DISPLAY_NAME;
    private static final INameFunction<MTETeslaTower> OUTPUT_VOLTAGE_DISPLAY_NAME;
    private static final INameFunction<MTETeslaTower> OUTPUT_MAX_DISPLAY_NAME;
    private static final INameFunction<MTETeslaTower> OUTPUT_CURRENT_DISPLAY_NAME;
    private static final INameFunction<MTETeslaTower> ENERGY_CAPACITY_DISPLAY_NAME;
    private static final INameFunction<MTETeslaTower> ENERGY_STORED_DISPLAY_NAME;
    private static final INameFunction<MTETeslaTower> ENERGY_FRACTION_DISPLAY_NAME;
    private static final INameFunction<MTETeslaTower> SCAN_TIME_DISPLAY_NAME;
    private static final IStatusFunction<MTETeslaTower> HYSTERESIS_LOW_STATUS;
    private static final IStatusFunction<MTETeslaTower> HYSTERESIS_HIGH_STATUS;
    private static final IStatusFunction<MTETeslaTower> TRANSFER_RADIUS_TOWER_STATUS;
    private static final IStatusFunction<MTETeslaTower> TRANSFER_RADIUS_TRANSCEIVER_STATUS;
    private static final IStatusFunction<MTETeslaTower> TRANSFER_RADIUS_COVER_ULTIMATE_STATUS;
    private static final IStatusFunction<MTETeslaTower> OUTPUT_VOLTAGE_OR_CURRENT_STATUS;
    private static final IStatusFunction<MTETeslaTower> SCAN_TIME_MIN_STATUS;
    private static final IStatusFunction<MTETeslaTower> OVERDRIVE_STATUS;
    private static final IStatusFunction<MTETeslaTower> POPOGA_STATUS;
    private static final IStatusFunction<MTETeslaTower> SCAN_TIME_STATUS;
    private static final IStatusFunction<MTETeslaTower> POWER_STATUS;
    private static final IStatusFunction<MTETeslaTower> ENERGY_STATUS;

    public MTETeslaTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTETeslaTower(String aName) {
        super(aName);
    }

    private float getRangeMulti(int mTier, int vTier) {
        int plasmaBoost;
        switch (this.plasmaTier) {
            case 2: {
                plasmaBoost = 4;
                break;
            }
            case 1: {
                plasmaBoost = 2;
                break;
            }
            default: {
                plasmaBoost = 1;
            }
        }
        if (vTier > mTier) {
            return 1.25f * (float)plasmaBoost;
        }
        return 1.0f * (float)plasmaBoost;
    }

    private void checkPlasmaBoost() {
        if (this.mOutputFluidsQueue != null) {
            this.mOutputFluids = this.mOutputFluidsQueue;
            this.mOutputFluidsQueue = null;
        }
        for (MTEHatchInput fluidHatch : this.mInputHatches) {
            if (fluidHatch.mFluid == null) continue;
            if (fluidHatch.mFluid.isFluidEqual(Materials.Helium.getPlasma(1L)) && fluidHatch.mFluid.amount >= 100) {
                fluidHatch.mFluid.amount -= 100;
                this.plasmaTier = 1;
                return;
            }
            if (fluidHatch.mFluid.isFluidEqual(Materials.Nitrogen.getPlasma(1L)) && fluidHatch.mFluid.amount >= 50) {
                fluidHatch.mFluid.amount -= 50;
                this.plasmaTier = 1;
                return;
            }
            if (!fluidHatch.mFluid.isFluidEqual(Materials.Radon.getPlasma(1L)) || fluidHatch.mFluid.amount < 50) continue;
            fluidHatch.mFluid.amount -= 50;
            this.plasmaTier = 2;
            return;
        }
        this.plasmaTier = 0;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTETeslaTower(this.mName);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        for (MTEHatchCapacitor cap : GTUtility.validMTEList(this.eCapacitorHatches)) {
            cap.getBaseMetaTileEntity().setActive(false);
        }
        this.eCapacitorHatches.clear();
        this.mTier = -1;
        if (this.structureCheck_EM("main", 3, 16, 0)) {
            for (MTEHatchCapacitor cap : GTUtility.validMTEList(this.eCapacitorHatches)) {
                cap.getBaseMetaTileEntity().setActive(iGregTechTileEntity.isActive());
            }
            if (this.oldRotation != this.getExtendedFacing().ordinal() || this.oldOrientation != iGregTechTileEntity.getFrontFacing()) {
                this.oldRotation = (byte)this.getExtendedFacing().ordinal();
                this.oldOrientation = iGregTechTileEntity.getFrontFacing();
                Vec3Impl posBMTE = new Vec3Impl(this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
                this.posTop = this.getExtendedFacing().getWorldOffset(new Vec3Impl(0, 0, 2)).add(posBMTE);
                this.posTop = this.getExtendedFacing().getWorldOffset(new Vec3Impl(0, -14, 2)).add(posBMTE);
            }
            if (!this.getBaseMetaTileEntity().isClientSide()) {
                ITeslaConnectable.TeslaUtil.teslaSimpleNodeSetAdd(this);
                ITeslaConnectable.TeslaUtil.generateTeslaNodeMap(this);
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected CheckRecipeResult checkProcessing_EM() {
        this.checkPlasmaBoost();
        if (!this.histHighSetting.getStatus((boolean)false).isOk || !this.histLowSetting.getStatus((boolean)false).isOk) {
            return SimpleCheckRecipeResult.ofFailure("invalid_hysteresis");
        }
        if (!(this.transferRadiusTowerSetting.getStatus((boolean)false).isOk && this.transferRadiusTransceiverSetting.getStatus((boolean)false).isOk && this.transferRadiusCoverUltimateSetting.getStatus((boolean)false).isOk)) {
            return SimpleCheckRecipeResult.ofFailure("invalid_transfer_radius");
        }
        if (!this.outputVoltageSetting.getStatus((boolean)false).isOk) {
            return SimpleCheckRecipeResult.ofFailure("invalid_voltage_setting");
        }
        if (!this.outputCurrentSetting.getStatus((boolean)false).isOk) {
            return SimpleCheckRecipeResult.ofFailure("invalid_current_setting");
        }
        if (!this.sortTimeMinSetting.getStatus((boolean)false).isOk) {
            return SimpleCheckRecipeResult.ofFailure("invalid_time_setting");
        }
        if (!this.overDriveSetting.getStatus((boolean)false).isOk) {
            return SimpleCheckRecipeResult.ofFailure("invalid_overdrive_setting");
        }
        this.mEfficiencyIncrease = 10000;
        this.mMaxProgresstime = 20;
        this.vTier = -1;
        for (MTEHatchCapacitor cap : GTUtility.validMTEList(this.eCapacitorHatches)) {
            if (cap.getCapacitors()[0] <= (long)this.vTier) continue;
            this.vTier = (int)cap.getCapacitors()[0];
        }
        this.energyCapacity = 0L;
        this.outputCurrentMax = 0L;
        if (this.vTier < 0) {
            this.outputVoltageMax = 0L;
            return SimpleCheckRecipeResult.ofSuccess("routing");
        }
        if (this.vTier > this.mTier && this.getEUVar() > 0L) {
            this.explodeMultiblock();
        }
        this.outputVoltageMax = GTValues.V[this.vTier + 1];
        for (MTEHatchCapacitor cap : GTUtility.validMTEList(this.eCapacitorHatches)) {
            cap.getBaseMetaTileEntity().setActive(true);
            long[] capacitorData = cap.getCapacitors();
            if (capacitorData[0] < (long)this.vTier) {
                if (this.getEUVar() > 0L && capacitorData[0] != 0L) {
                    cap.getBaseMetaTileEntity().setToFire();
                }
                this.eCapacitorHatches.remove(cap);
                continue;
            }
            this.outputCurrentMax += capacitorData[1];
            this.energyCapacity += capacitorData[2];
        }
        return SimpleCheckRecipeResult.ofSuccess("routing");
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.name")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.desc.0")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.desc.1")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.desc.2")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.desc.3")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.desc.4")).addInfo(StatCollector.func_74838_a((String)"tt.keyword.Structure.StructureTooComplex")).addSeparator().beginStructureBlock(7, 17, 7, false).addOtherStructurePart(StatCollector.func_74838_a((String)"gt.blockmachines.hatch.capacitor.tier.03.name"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyTeslaBaseCasingOuter"), 1).addEnergyHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyTeslaBaseCasingOuter"), 1).addMaintenanceHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyTeslaBaseCasingOuter"), 1).toolTipFinisher(CommonValues.THETA_MOVEMENT);
        return tt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/TM_TESLA_TOWER");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/TM_TESLA_TOWER_ACTIVE");
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][22], new TTRenderedExtendedFacingTexture(aActive ? ScreenON : ScreenOFF)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][22]};
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        if (!this.getBaseMetaTileEntity().isClientSide()) {
            ITeslaConnectable.TeslaUtil.teslaSimpleNodeSetRemove(this);
            for (MTEHatchCapacitor cap : GTUtility.validMTEList(this.eCapacitorHatches)) {
                cap.getBaseMetaTileEntity().setActive(false);
            }
        }
    }

    @Override
    public void onUnload() {
        if (!this.getBaseMetaTileEntity().isClientSide()) {
            ITeslaConnectable.TeslaUtil.teslaSimpleNodeSetRemove(this);
        }
    }

    @Override
    protected void parametersInstantiation_EM() {
        Parameters.Group hatch_0 = this.parametrization.getGroup(0, true);
        Parameters.Group hatch_1 = this.parametrization.getGroup(1, true);
        Parameters.Group hatch_2 = this.parametrization.getGroup(2, true);
        Parameters.Group hatch_3 = this.parametrization.getGroup(3, true);
        Parameters.Group hatch_4 = this.parametrization.getGroup(4, true);
        Parameters.Group hatch_5 = this.parametrization.getGroup(5, true);
        Parameters.Group hatch_6 = this.parametrization.getGroup(6, true);
        Parameters.Group hatch_7 = this.parametrization.getGroup(7, true);
        Parameters.Group hatch_8 = this.parametrization.getGroup(8, true);
        Parameters.Group hatch_9 = this.parametrization.getGroup(9, true);
        this.histLowSetting = hatch_0.makeInParameter(0, 0.25, HYSTERESIS_LOW_SETTING_NAME, HYSTERESIS_LOW_STATUS);
        this.popogaSetting = hatch_0.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.histHighSetting = hatch_1.makeInParameter(0, 0.75, HYSTERESIS_HIGH_SETTING_NAME, HYSTERESIS_HIGH_STATUS);
        this.popogaSetting = hatch_1.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.transferRadiusTowerSetting = hatch_2.makeInParameter(0, 32.0, TRANSFER_RADIUS_TOWER_SETTING_NAME, TRANSFER_RADIUS_TOWER_STATUS);
        this.popogaSetting = hatch_2.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.transferRadiusTransceiverSetting = hatch_3.makeInParameter(0, 16.0, TRANSFER_RADIUS_TRANSCEIVER_SETTING_NAME, TRANSFER_RADIUS_TRANSCEIVER_STATUS);
        this.transferRadiusCoverUltimateSetting = hatch_3.makeInParameter(1, 16.0, TRANSFER_RADIUS_COVER_ULTIMATE_SETTING_NAME, TRANSFER_RADIUS_COVER_ULTIMATE_STATUS);
        this.outputVoltageSetting = hatch_4.makeInParameter(0, -1.0, OUTPUT_VOLTAGE_SETTING_NAME, OUTPUT_VOLTAGE_OR_CURRENT_STATUS);
        this.popogaSetting = hatch_4.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.outputCurrentSetting = hatch_5.makeInParameter(0, -1.0, OUTPUT_CURRENT_SETTING_NAME, OUTPUT_VOLTAGE_OR_CURRENT_STATUS);
        this.popogaSetting = hatch_5.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaSetting = hatch_6.makeInParameter(0, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaSetting = hatch_6.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.sortTimeMinSetting = hatch_7.makeInParameter(0, 100.0, SCAN_TIME_MIN_SETTING_NAME, SCAN_TIME_MIN_STATUS);
        this.popogaSetting = hatch_7.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.overDriveSetting = hatch_8.makeInParameter(0, 0.0, OVERDRIVE_SETTING_NAME, OVERDRIVE_STATUS);
        this.popogaSetting = hatch_8.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaSetting = hatch_9.makeInParameter(0, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaSetting = hatch_9.makeInParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_0.makeOutParameter(0, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_0.makeOutParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_1.makeOutParameter(0, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_1.makeOutParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.transferRadiusTowerDisplay = hatch_2.makeOutParameter(0, 0.0, TRANSFER_RADIUS_TOWER_DISPLAY_NAME, TRANSFER_RADIUS_TOWER_STATUS);
        this.popogaDisplay = hatch_2.makeOutParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.transferRadiusTransceiverDisplay = hatch_3.makeOutParameter(0, 0.0, TRANSFER_RADIUS_TRANSCEIVER_DISPLAY_NAME, TRANSFER_RADIUS_TRANSCEIVER_STATUS);
        this.transferRadiusCoverUltimateDisplay = hatch_3.makeOutParameter(1, 0.0, TRANSFER_RADIUS_COVER_ULTIMATE_DISPLAY_NAME, TRANSFER_RADIUS_COVER_ULTIMATE_STATUS);
        this.outputVoltageDisplay = hatch_4.makeOutParameter(0, 0.0, OUTPUT_VOLTAGE_DISPLAY_NAME, POWER_STATUS);
        this.outputMaxDisplay = hatch_4.makeOutParameter(1, 0.0, OUTPUT_MAX_DISPLAY_NAME, POWER_STATUS);
        this.outputCurrentDisplay = hatch_5.makeOutParameter(0, 0.0, OUTPUT_CURRENT_DISPLAY_NAME, POWER_STATUS);
        this.energyCapacityDisplay = hatch_5.makeOutParameter(1, 0.0, ENERGY_CAPACITY_DISPLAY_NAME, ENERGY_STATUS);
        this.energyStoredDisplay = hatch_6.makeOutParameter(0, 0.0, ENERGY_STORED_DISPLAY_NAME, ENERGY_STATUS);
        this.energyFractionDisplay = hatch_6.makeOutParameter(1, 0.0, ENERGY_FRACTION_DISPLAY_NAME, ENERGY_STATUS);
        this.sortTimeDisplay = hatch_7.makeOutParameter(0, 0.0, SCAN_TIME_DISPLAY_NAME, SCAN_TIME_STATUS);
        this.popogaDisplay = hatch_7.makeOutParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_8.makeOutParameter(0, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_8.makeOutParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_9.makeOutParameter(0, 0.0, POPOGA_NAME, POPOGA_STATUS);
        this.popogaDisplay = hatch_9.makeOutParameter(1, 0.0, POPOGA_NAME, POPOGA_STATUS);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("eEnergyCapacity", this.energyCapacity);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.energyCapacity = aNBT.func_74763_f("eEnergyCapacity");
        ITeslaConnectable.TeslaUtil.teslaSimpleNodeSetAdd(this);
    }

    @Override
    public void stopMachine(@Nonnull ShutDownReason reason) {
        super.stopMachine(reason);
        for (MTEHatchCapacitor cap : GTUtility.validMTEList(this.eCapacitorHatches)) {
            cap.getBaseMetaTileEntity().setActive(false);
        }
        this.ePowerPass = false;
        this.setEUVar(0L);
        this.energyStoredDisplay.set(0.0);
        this.energyFractionDisplay.set(0.0);
        this.outputMaxDisplay.set(0.0);
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        float energyFrac = (float)this.getEUVar() / (float)this.energyCapacity;
        this.energyCapacityDisplay.set(this.energyCapacity);
        this.energyStoredDisplay.set(this.getEUVar());
        this.energyFractionDisplay.set(energyFrac);
        if (!this.ePowerPass && (double)energyFrac > this.histHighSetting.get()) {
            this.ePowerPass = true;
        } else if (this.ePowerPass && (double)energyFrac < this.histLowSetting.get()) {
            this.ePowerPass = false;
        }
        this.outputVoltage = this.outputVoltageSetting.get() > 0.0 ? Math.min(this.outputVoltageMax, (long)this.outputVoltageSetting.get()) : this.outputVoltageMax;
        this.outputVoltageDisplay.set(this.outputVoltage);
        this.outputCurrent = this.outputCurrentSetting.get() > 0.0 ? Math.min(this.outputCurrentMax, (long)this.outputCurrentSetting.get()) : this.outputCurrentMax;
        int transferRadiusTower = this.getTeslaTransmissionRange();
        this.transferRadiusTowerDisplay.set(transferRadiusTower);
        this.transferRadiusTransceiverDisplay.set(transferRadiusTower * 2);
        this.transferRadiusCoverUltimateDisplay.set(transferRadiusTower);
        this.outputCurrentDisplay.set(ITeslaConnectable.TeslaUtil.powerTeslaNodeMap(this));
        this.outputMaxDisplay.set(Math.max(this.outputCurrentDisplay.get(), this.outputMaxDisplay.get()));
        --this.sparkCount;
        if (this.sparkCount == 0 && ConfigHandler.teslaTweaks.TESLA_VISUAL_EFFECT) {
            IGregTechTileEntity mte = this.getBaseMetaTileEntity();
            this.sparkCount = 10;
            if (!this.sparkList.isEmpty()) {
                NetworkDispatcher.INSTANCE.sendToAllAround(new RendererMessage.RendererData(this.sparkList), mte.getWorld().field_73011_w.field_76574_g, mte.getXCoord(), mte.getYCoord(), mte.getZCoord(), 256.0);
                this.sparkList.clear();
            }
        }
        return true;
    }

    @Override
    public long maxEUStore() {
        return this.getBaseMetaTileEntity().isActive() ? this.energyCapacity * 2L : 0L;
    }

    @Override
    public long getEUVar() {
        return this.getBaseMetaTileEntity().isActive() ? super.getEUVar() : 1L;
    }

    private boolean addCapacitorToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchCapacitor) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eCapacitorHatches.add((MTEHatchCapacitor)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchMaintenance) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mMaintenanceHatches.add((MTEHatchMaintenance)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchEnergy) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mEnergyHatches.add((MTEHatchEnergy)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchEnergyMulti) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eEnergyMulti.add((MTEHatchEnergyMulti)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchDynamo) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDynamoHatches.add((MTEHatchDynamo)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchDynamoMulti) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eDynamoMulti.add((MTEHatchDynamoMulti)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchParam) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eParamHatches.add((MTEHatchParam)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mInputHatches.add((MTEHatchInput)aMetaTileEntity);
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mOutputHatches.add((MTEHatchOutput)aMetaTileEntity);
        }
        return false;
    }

    public IStructureDefinition<MTETeslaTower> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM("main", 3, 16, 0, stackSize, hintsOnly);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece("main", stackSize, 3, 16, 0, elementBudget, source, actor, false, true);
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    @Override
    public byte getTeslaReceptionCapability() {
        return 0;
    }

    @Override
    public float getTeslaReceptionCoefficient() {
        return 0.0f;
    }

    @Override
    public Multimap<Integer, ITeslaConnectableSimple> getTeslaNodeMap() {
        return this.teslaNodeMap;
    }

    @Override
    public HashSet<ThaumSpark> getSparkList() {
        return this.sparkList;
    }

    @Override
    public byte getTeslaTransmissionCapability() {
        return 1;
    }

    @Override
    public int getTeslaTransmissionRange() {
        return (int)(this.transferRadiusTowerSetting.get() * (double)this.getRangeMulti(this.mTier, this.vTier));
    }

    @Override
    public boolean isOverdriveEnabled() {
        return this.overDriveSetting.get() > 0.0;
    }

    @Override
    public int getTeslaEnergyLossPerBlock() {
        int n;
        switch (this.plasmaTier) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return n;
    }

    @Override
    public float getTeslaOverdriveLossCoefficient() {
        return 0.25f;
    }

    @Override
    public long getTeslaOutputVoltage() {
        return this.outputVoltage;
    }

    @Override
    public long getTeslaOutputCurrent() {
        return this.outputCurrent;
    }

    @Override
    public boolean teslaDrainEnergy(long teslaVoltageDrained) {
        if (this.getEUVar() < teslaVoltageDrained) {
            return false;
        }
        this.setEUVar(this.getEUVar() - teslaVoltageDrained);
        return true;
    }

    @Override
    public boolean isTeslaReadyToReceive() {
        return !this.ePowerPass;
    }

    @Override
    public long getTeslaStoredEnergy() {
        return this.getEUVar();
    }

    @Override
    public Vec3Impl getTeslaPosition() {
        return this.posTop;
    }

    @Override
    public Integer getTeslaDimension() {
        return this.getBaseMetaTileEntity().getWorld().field_73011_w.field_76574_g;
    }

    @Override
    public boolean teslaInjectEnergy(long teslaVoltageInjected) {
        if (this.getEUVar() + teslaVoltageInjected <= this.maxEUStore() / 2L) {
            this.getBaseMetaTileEntity().increaseStoredEnergyUnits(teslaVoltageInjected, true);
            return true;
        }
        return false;
    }

    static {
        description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.hint.1")};
        STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"       ", "       ", "  BBB  ", "  BBB  ", "  BBB  ", "       ", "       "}, {"       ", "  BBB  ", " BBBBB ", " BBBBB ", " BBBBB ", "  BBB  ", "       "}, {"       ", "  BBB  ", " BBBBB ", " BBBBB ", " BBBBB ", "  BBB  ", "       "}, {"       ", "  BBB  ", " BBBBB ", " BBBBB ", " BBBBB ", "  BBB  ", "       "}, {"       ", "       ", "  BBB  ", "  BCB  ", "  BBB  ", "       ", "       "}, {"       ", "       ", "       ", "   C   ", "       ", "       ", "       "}, {"       ", "  BBB  ", " B F B ", " BFCFB ", " B F B ", "  BBB  ", "       "}, {"       ", "       ", "       ", "   C   ", "       ", "       ", "       "}, {"       ", "  BBB  ", " B F B ", " BFCFB ", " B F B ", "  BBB  ", "       "}, {"       ", "       ", "       ", "   C   ", "       ", "       ", "       "}, {"       ", "  BBB  ", " B F B ", " BFCFB ", " B F B ", "  BBB  ", "       "}, {"       ", "       ", "       ", "   C   ", "       ", "       ", "       "}, {"       ", "  BBB  ", " B F B ", " BFCFB ", " B F B ", "  BBB  ", "       "}, {"       ", "       ", "       ", "   C   ", "       ", "       ", "       "}, {"       ", "       ", "       ", "   C   ", "       ", "       ", "       "}, {"       ", "  DDD  ", " D   D ", " D C D ", " D   D ", "  DDD  ", "       "}, {" EE~EE ", "EAAAAAE", "EADDDAE", "EADADAE", "EADDDAE", "EAAAAAE", " EEEEE "}})).addElement('A', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)6)).addElement('B', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)7)).addElement('C', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsBA0, (int)8)).addElement('D', StructureUtility.ofBlocksTiered((block, meta) -> block != TTCasingsContainer.sBlockCasingsBA0 ? null : (meta <= 5 ? Integer.valueOf(meta) : (meta == 9 ? Integer.valueOf(6) : null)), IntStream.range(0, 7).map(tier -> tier == 6 ? 9 : tier).mapToObj(meta -> Pair.of((Object)TTCasingsContainer.sBlockCasingsBA0, (Object)meta)).collect(Collectors.toList()), (Object)-1, (t, v) -> {
            t.mTier = v;
        }, t -> t.mTier)).addElement('E', GTStructureUtility.buildHatchAdder(MTETeslaTower.class).atLeast(CapacitorHatchElement.INSTANCE, TTMultiblockBase.HatchElement.EnergyMulti, HatchElement.Energy, TTMultiblockBase.HatchElement.DynamoMulti, HatchElement.Dynamo, HatchElement.InputHatch, HatchElement.OutputHatch, TTMultiblockBase.HatchElement.Param, HatchElement.Maintenance).dot(1).casingIndex(1046).buildAndChain(TTCasingsContainer.sBlockCasingsBA0, 6)).addElement('F', GTStructureUtility.ofFrame(Materials.Titanium)).build();
        HYSTERESIS_LOW_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.0");
        HYSTERESIS_HIGH_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.1");
        TRANSFER_RADIUS_TOWER_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.2");
        TRANSFER_RADIUS_TRANSCEIVER_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.3");
        TRANSFER_RADIUS_COVER_ULTIMATE_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.4");
        OUTPUT_VOLTAGE_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.5");
        OUTPUT_CURRENT_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.6");
        SCAN_TIME_MIN_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.7");
        OVERDRIVE_SETTING_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.8");
        POPOGA_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgi.9");
        TRANSFER_RADIUS_TOWER_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.0");
        TRANSFER_RADIUS_TRANSCEIVER_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.1");
        TRANSFER_RADIUS_COVER_ULTIMATE_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.2");
        OUTPUT_VOLTAGE_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.3");
        OUTPUT_MAX_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.9");
        OUTPUT_CURRENT_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.4");
        ENERGY_CAPACITY_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.5");
        ENERGY_STORED_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.6");
        ENERGY_FRACTION_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.7");
        SCAN_TIME_DISPLAY_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.tm.teslaCoil.cfgo.8");
        HYSTERESIS_LOW_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if (value <= 0.05) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (value > base.histHighSetting.get()) {
                return LedStatus.STATUS_TOO_HIGH;
            }
            return LedStatus.STATUS_OK;
        };
        HYSTERESIS_HIGH_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if (value <= base.histLowSetting.get()) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (value > 0.95) {
                return LedStatus.STATUS_TOO_HIGH;
            }
            return LedStatus.STATUS_OK;
        };
        TRANSFER_RADIUS_TOWER_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((int)value)) < 0.0) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (value > 32.0) {
                return LedStatus.STATUS_HIGH;
            }
            if (value < 32.0) {
                return LedStatus.STATUS_LOW;
            }
            return LedStatus.STATUS_OK;
        };
        TRANSFER_RADIUS_TRANSCEIVER_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((int)value)) < 0.0) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (value > 16.0) {
                return LedStatus.STATUS_HIGH;
            }
            if (value < 16.0) {
                return LedStatus.STATUS_LOW;
            }
            return LedStatus.STATUS_OK;
        };
        TRANSFER_RADIUS_COVER_ULTIMATE_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((int)value)) < 0.0) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (value > 16.0) {
                return LedStatus.STATUS_HIGH;
            }
            if (value < 16.0) {
                return LedStatus.STATUS_LOW;
            }
            return LedStatus.STATUS_OK;
        };
        OUTPUT_VOLTAGE_OR_CURRENT_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((long)value)) == -1.0) {
                return LedStatus.STATUS_OK;
            }
            if (value <= 0.0) {
                return LedStatus.STATUS_TOO_LOW;
            }
            return LedStatus.STATUS_OK;
        };
        SCAN_TIME_MIN_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((int)value)) < 100.0) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (value == 100.0) {
                return LedStatus.STATUS_OK;
            }
            return LedStatus.STATUS_HIGH;
        };
        OVERDRIVE_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((int)value)) < 0.0) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (value == 0.0) {
                return LedStatus.STATUS_LOW;
            }
            return LedStatus.STATUS_HIGH;
        };
        POPOGA_STATUS = (base, p) -> {
            if (base.getBaseMetaTileEntity().getWorld().func_72911_I()) {
                return LedStatus.STATUS_WTF;
            }
            return LedStatus.STATUS_NEUTRAL;
        };
        SCAN_TIME_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((int)value)) == 0.0) {
                return LedStatus.STATUS_HIGH;
            }
            return LedStatus.STATUS_LOW;
        };
        POWER_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if ((value = (double)((long)value)) > 0.0) {
                return LedStatus.STATUS_OK;
            }
            return LedStatus.STATUS_LOW;
        };
        ENERGY_STATUS = (base, p) -> {
            double value = p.get();
            if (Double.isNaN(value)) {
                return LedStatus.STATUS_WRONG;
            }
            if (base.energyFractionDisplay.get() > base.histHighSetting.get()) {
                return LedStatus.STATUS_HIGH;
            }
            if (base.energyFractionDisplay.get() < base.histLowSetting.get()) {
                return LedStatus.STATUS_LOW;
            }
            return LedStatus.STATUS_OK;
        };
    }

    private static enum CapacitorHatchElement implements IHatchElement<MTETeslaTower>
    {
        INSTANCE;


        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Collections.singletonList(MTEHatchCapacitor.class);
        }

        @Override
        public IGTHatchAdder<? super MTETeslaTower> adder() {
            return (rec$, x$0, x$1) -> ((MTETeslaTower)rec$).addCapacitorToMachineList(x$0, x$1);
        }

        @Override
        public long count(MTETeslaTower MTETeslaTower2) {
            return MTETeslaTower2.eCapacitorHatches.size();
        }
    }
}

