/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.single;

import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.objects.GTRenderedTexture;
import gregtech.api.util.GTUtility;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.Textures;
import tectech.util.CommonValues;
import tectech.util.TTUtility;

public class MTEBuckConverter
extends MTETieredMachineBlock
implements IAddUIWidgets,
IAddGregtechLogo {
    private static GTRenderedTexture BUCK;
    private static GTRenderedTexture BUCK_ACTIVE;
    public int EUT = 0;
    public int AMP = 0;
    private static NumberFormatMUI numberFormat;

    public MTEBuckConverter(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{CommonValues.TEC_MARK_GENERAL, StatCollector.func_74838_a((String)"gt.blockmachines.machine.tt.buck.desc.0"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.machine.tt.buck.desc.1")}, new ITexture[0]);
        TTUtility.setTier(aTier, this);
    }

    public MTEBuckConverter(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
        TTUtility.setTier(aTier, this);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEBuckConverter(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        BUCK = new GTRenderedTexture(new Textures.BlockIcons.CustomIcon("iconsets/BUCK"));
        BUCK_ACTIVE = new GTRenderedTexture(new Textures.BlockIcons.CustomIcon("iconsets/BUCK_ACTIVE"));
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = Textures.MACHINE_CASINGS_TT[this.mTier][colorIndex + 1];
        iTextureArray[1] = side == facing ? (aActive ? BUCK_ACTIVE : BUCK) : (side == facing.getOpposite() ? Textures.OVERLAYS_ENERGY_IN_POWER_TT[this.mTier] : (aActive ? Textures.OVERLAYS_ENERGY_OUT_POWER_TT[this.mTier] : Textures.OVERLAYS_ENERGY_IN_POWER_TT[this.mTier]));
        return iTextureArray;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("eEUT", this.EUT);
        aNBT.func_74768_a("eAMP", this.AMP);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.EUT = aNBT.func_74762_e("eEUT");
        this.AMP = aNBT.func_74762_e("eAMP");
        this.getBaseMetaTileEntity().setActive((long)this.AMP * (long)this.EUT >= 0L);
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GTUIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isElectric() {
        return true;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getBackFacing();
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return this.getBaseMetaTileEntity().isActive() && side != this.getBaseMetaTileEntity().getFrontFacing() && side != this.getBaseMetaTileEntity().getBackFacing();
    }

    @Override
    public long maxAmperesIn() {
        return 2L;
    }

    @Override
    public long maxAmperesOut() {
        return this.getBaseMetaTileEntity().isActive() ? (long)Math.min(Math.abs(this.AMP), 64) : 0L;
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxEUOutput() {
        return this.getBaseMetaTileEntity().isActive() ? Math.min((long)Math.abs(this.EUT), this.maxEUInput()) : 0L;
    }

    @Override
    public long maxEUStore() {
        return GTValues.V[this.mTier] << 4;
    }

    @Override
    public long getMinimumStoredEU() {
        return GTValues.V[this.mTier] << 2;
    }

    @Override
    public int getProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyStored();
    }

    @Override
    public int maxProgresstime() {
        return (int)this.getBaseMetaTileEntity().getUniversalEnergyCapacity();
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_GT_LOGO_17x17_TRANSPARENT_GRAY).setSize(17, 17).setPos(113, 56));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setSize(90, 72).setPos(43, 4))).widget(new TextWidget().setStringSupplier(() -> "EUT: " + numberFormat.format((long)this.EUT)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 8))).widget(new TextWidget().setStringSupplier(() -> "TIER: " + GTValues.VN[GTUtility.getTier(Math.abs(this.EUT))]).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 16))).widget(new TextWidget().setStringSupplier(() -> "AMP: " + numberFormat.format((long)this.AMP)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 24))).widget(new TextWidget().setStringSupplier(() -> "SUM: " + numberFormat.format((long)this.AMP * (long)this.EUT)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 32));
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.EUT -= val.intValue(), 512, 64, 7, 4);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.EUT /= val.intValue(), 512, 64, 7, 22);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.AMP -= val.intValue(), 512, 64, 7, 40);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.AMP /= val.intValue(), 512, 64, 7, 58);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.EUT -= val.intValue(), 16, 1, 25, 4);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.EUT /= val.intValue(), 16, 2, 25, 22);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.AMP -= val.intValue(), 16, 1, 25, 40);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.AMP /= val.intValue(), 16, 2, 25, 58);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.EUT += val.intValue(), 16, 1, 133, 4);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.EUT *= val.intValue(), 16, 2, 133, 22);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.AMP += val.intValue(), 16, 1, 133, 40);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.AMP *= val.intValue(), 16, 2, 133, 58);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.EUT += val.intValue(), 512, 64, 151, 4);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.EUT *= val.intValue(), 512, 64, 151, 22);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.AMP += val.intValue(), 512, 64, 151, 40);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.AMP *= val.intValue(), 512, 64, 151, 58);
    }

    private void addChangeNumberButton(ModularWindow.Builder builder, IDrawable overlay, Consumer<Integer> setter, int changeNumberShift, int changeNumber, int xPos, int yPos) {
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
            setter.accept(clickData.shift ? changeNumberShift : changeNumber);
            this.getBaseMetaTileEntity().setActive((long)this.AMP * (long)this.EUT >= 0L);
        }).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD, overlay}).setSize(18, 18).setPos(xPos, yPos));
    }

    static {
        numberFormat = new NumberFormatMUI();
    }
}

