/*
 * Decompiled with CFR 0.152.
 */
package tectech.util;

import com.gtnewhorizon.gtnhlib.client.renderer.CapturingTessellator;
import com.gtnewhorizon.gtnhlib.client.renderer.TessellatorManager;
import com.gtnewhorizon.gtnhlib.client.renderer.vbo.VertexBuffer;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.DefaultVertexFormat;
import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.tuple.Pair;
import tectech.util.FaceCulledRenderBlocks;
import tectech.util.FaceVisibility;
import tectech.util.TextureUpdateRequester;

public class StructureVBO {
    private String[][] structure;
    private HashSet<Character> values = new HashSet();
    private HashMap<Character, Pair<Block, Integer>> mapper = new HashMap();

    public StructureVBO assignStructure(String[][] structure) {
        this.structure = structure;
        return this;
    }

    public StructureVBO addMapping(char letter, Block block) {
        this.mapper.put(Character.valueOf(letter), (Pair<Block, Integer>)Pair.of((Object)block, (Object)0));
        return this;
    }

    public StructureVBO addMapping(char letter, Block block, int meta) {
        this.mapper.put(Character.valueOf(letter), (Pair<Block, Integer>)Pair.of((Object)block, (Object)meta));
        return this;
    }

    public TextureUpdateRequester getTextureUpdateRequestor() {
        TextureUpdateRequester textureUpdateRequester = new TextureUpdateRequester();
        for (char key : this.mapper.keySet()) {
            Pair<Block, Integer> pair = this.mapper.get(Character.valueOf(key));
            textureUpdateRequester.add((Block)pair.getLeft(), (Integer)pair.getRight());
        }
        return textureUpdateRequester;
    }

    private boolean isOpaqueAt(int x, int y, int z) {
        char letter = this.structure[x][y].charAt(z);
        if (letter == ' ') {
            return false;
        }
        Pair<Block, Integer> info = this.mapper.get(Character.valueOf(letter));
        if (info == null) {
            return false;
        }
        if (info.getLeft() == Blocks.field_150350_a) {
            return false;
        }
        return ((Block)info.getLeft()).func_149662_c();
    }

    private FaceVisibility getVisibleFaces(int x, int y, int z) {
        FaceVisibility visibility = new FaceVisibility();
        int maxX = this.structure.length - 1;
        int maxY = this.structure[0].length - 1;
        int maxZ = this.structure[0][0].length() - 1;
        if (x > 0 && this.isOpaqueAt(x - 1, y, z)) {
            visibility.left = false;
        }
        if (x < maxX && this.isOpaqueAt(x + 1, y, z)) {
            visibility.right = false;
        }
        if (y > 0 && this.isOpaqueAt(x, y - 1, z)) {
            visibility.top = false;
        }
        if (y < maxY && this.isOpaqueAt(x, y + 1, z)) {
            visibility.bottom = false;
        }
        if (z > 0 && this.isOpaqueAt(x, y, z - 1)) {
            visibility.back = false;
        }
        if (z < maxZ && this.isOpaqueAt(x, y, z + 1)) {
            visibility.front = false;
        }
        return visibility;
    }

    public VertexBuffer build() {
        TessellatorManager.startCapturing();
        CapturingTessellator tess = (CapturingTessellator)TessellatorManager.get();
        FaceCulledRenderBlocks renderer = new FaceCulledRenderBlocks((IBlockAccess)Minecraft.func_71410_x().field_71441_e);
        renderer.field_147863_w = false;
        for (int x = 0; x < this.structure.length; ++x) {
            String[] plane = this.structure[x];
            for (int y = 0; y < plane.length; ++y) {
                String row = plane[y];
                for (int z = 0; z < row.length(); ++z) {
                    FaceVisibility faceInfo;
                    char letter = row.charAt(z);
                    if (letter == ' ') continue;
                    Pair<Block, Integer> info = this.mapper.get(Character.valueOf(letter));
                    if (info == null) {
                        this.values.add(Character.valueOf(letter));
                        continue;
                    }
                    if (info.getLeft() == Blocks.field_150350_a || (faceInfo = this.getVisibleFaces(x, y, z)).isEntireObscured()) continue;
                    renderer.setFaceVisibility(faceInfo);
                    tess.func_78373_b((double)((float)(-this.structure.length) / 2.0f + (float)x), (double)((float)plane.length / 2.0f - (float)y), (double)((float)(-row.length()) / 2.0f + (float)z));
                    renderer.func_147800_a((Block)info.getLeft(), (Integer)info.getRight(), 1.0f);
                }
            }
        }
        return TessellatorManager.stopCapturingToVBO((VertexFormat)DefaultVertexFormat.POSITION_TEXTURE_NORMAL);
    }
}

