/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEItemStack;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.IGuiTooltipHandler;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.container.implementations.ContainerOptimizePatterns;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketOptimizePatterns;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.parts.reporting.PartCraftingTerminal;
import appeng.parts.reporting.PartPatternTerminal;
import appeng.parts.reporting.PartPatternTerminalEx;
import appeng.parts.reporting.PartTerminal;
import appeng.util.Platform;
import appeng.util.ReadableNumberConverter;
import appeng.util.calculators.ArithHelper;
import appeng.util.calculators.Calculator;
import com.google.common.base.Joiner;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiOptimizePatterns
extends AEBaseGui
implements IGuiTooltipHandler {
    private GuiTextField amountToCraft;
    private int amountToCraftI = 1;
    private final List<IAEItemStack> visual = new ArrayList<IAEItemStack>();
    private int rows = 5;
    private final boolean tallMode;
    final GuiScrollbar scrollbar;
    private GuiBridge OriginalGui;
    private GuiButton cancel;
    private GuiButton optimize;
    private int tooltip = -1;
    private IAEItemStack hoveredStack;
    private final HashSet<IAEItemStack> ignoreList = new HashSet();
    private final HashMap<IAEItemStack, Integer> multiplierMap = new HashMap();
    Comparator<IAEItemStack> comparator = (i1, i2) -> (int)(i2.getCountRequestableCrafts() - i1.getCountRequestableCrafts());

    public GuiOptimizePatterns(InventoryPlayer inventoryPlayer, ITerminalHost te) {
        super(new ContainerOptimizePatterns(inventoryPlayer, te));
        this.tallMode = AEConfig.instance.getConfigManager().getSetting(Settings.TERMINAL_STYLE) == TerminalStyle.TALL;
        this.field_146999_f = 238;
        this.rows = 5;
        this.field_147000_g = 206;
        this.scrollbar = new GuiScrollbar();
        this.setScrollBar(this.scrollbar);
        if (te instanceof WirelessTerminalGuiObject) {
            this.OriginalGui = GuiBridge.GUI_WIRELESS_TERM;
        }
        if (te instanceof PartTerminal) {
            this.OriginalGui = GuiBridge.GUI_ME;
        }
        if (te instanceof PartCraftingTerminal) {
            this.OriginalGui = GuiBridge.GUI_CRAFTING_TERMINAL;
        }
        if (te instanceof PartPatternTerminal) {
            this.OriginalGui = GuiBridge.GUI_PATTERN_TERMINAL;
        }
        if (te instanceof PartPatternTerminalEx) {
            this.OriginalGui = GuiBridge.GUI_PATTERN_TERMINAL_EX;
        }
    }

    @Override
    public void func_73866_w_() {
        if (this.tallMode) {
            int maxAvailableHeight = this.field_146295_m - 64;
            this.rows = (maxAvailableHeight - 91) / 23;
            this.field_147000_g = 91 + this.rows * 23;
        } else {
            this.rows = 5;
            this.field_147000_g = 206;
        }
        super.func_73866_w_();
        this.setScrollBar();
        this.optimize = new GuiButton(0, this.field_147003_i + this.field_146999_f - 76, this.field_147009_r + this.field_147000_g - 25, 50, 20, GuiText.Optimize.getLocal());
        this.optimize.field_146124_l = false;
        this.field_146292_n.add(this.optimize);
        this.cancel = new GuiButton(0, this.field_147003_i + 6, this.field_147009_r + this.field_147000_g - 25, 50, 20, GuiText.Cancel.getLocal());
        this.field_146292_n.add(this.cancel);
        this.amountToCraft = new GuiTextField(this.field_146289_q, this.field_147003_i + 113, this.field_147009_r + this.field_147000_g - 68, 100, 20);
        this.amountToCraft.func_146185_a(true);
        this.amountToCraft.func_146203_f(16);
        this.amountToCraft.func_146193_g(GuiColors.CraftAmountToCraft.getColor());
        this.amountToCraft.func_146189_e(true);
        this.amountToCraft.func_146195_b(true);
        this.amountToCraft.func_146180_a("1");
        this.amountToCraft.func_146199_i(0);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float btn) {
        super.func_73863_a(mouseX, mouseY, btn);
        int gx = (this.field_146294_l - this.field_146999_f) / 2;
        int gy = (this.field_146295_m - this.field_147000_g) / 2;
        this.tooltip = -1;
        int offY = 23;
        int y = 0;
        int x = 0;
        for (int z = 0; z <= 4 * this.rows; ++z) {
            int minX = gx + 9 + x * 67;
            int minY = gy + 22 + y * 23;
            if (minX < mouseX && minX + 67 > mouseX && minY < mouseY && minY + 23 - 2 > mouseY) {
                this.tooltip = z;
                break;
            }
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(GuiText.PatternOptimizer.getLocal(), 8, 7, GuiColors.CraftConfirmCraftingPlan.getColor());
        this.field_146289_q.func_78276_b(GuiText.StepsPerCraft.getLocal() + ":", 6, this.field_147000_g - 68 + 10 - this.field_146289_q.field_78288_b / 2, GuiColors.CraftConfirmSimulation.getColor());
        String dsp = GuiText.PatternsAffected.getLocal() + ": " + this.multiplierMap.size();
        int offset = (219 - this.field_146289_q.func_78256_a(dsp)) / 2;
        this.field_146289_q.func_78276_b(dsp, offset, this.field_147000_g - 41, GuiColors.CraftConfirmSimulation.getColor());
        int viewStart = this.getScrollBar().getCurrentScroll() * 3;
        int viewEnd = viewStart + 3 * this.rows;
        int sectionLength = 67;
        int x = 0;
        int y = 0;
        int xo = 9;
        int yo = 22;
        int offY = 23;
        String dspToolTip = "";
        LinkedList<String> lineList = new LinkedList<String>();
        int toolPosX = 0;
        int toolPosY = 0;
        this.hoveredStack = null;
        for (int z = viewStart; z < Math.min(viewEnd, this.visual.size()); ++z) {
            IAEItemStack refStack = this.visual.get(z);
            if (refStack == null) continue;
            GL11.glPushMatrix();
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
            int lines = 1;
            long multipliedBy = this.multiplierMap.getOrDefault(refStack, 0).intValue();
            if (this.amountToCraftI > 0 && multipliedBy > 0L) {
                ++lines;
            }
            int negY = (lines - 1) * 5 / 2;
            int downY = 0;
            String str = GuiText.ToCraftRequests.getLocal() + ": " + ReadableNumberConverter.INSTANCE.toWideReadableForm(refStack.getCountRequestableCrafts());
            int w = 4 + this.field_146289_q.func_78256_a(str);
            this.field_146289_q.func_78276_b(str, (int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0), (y * 23 + 22 + 6 - negY + downY) * 2, GuiColors.CraftConfirmMissing.getColor());
            if (this.tooltip == z - viewStart) {
                lineList.add(GuiText.ToCraftRequests.getLocal() + ": " + NumberFormat.getInstance().format(refStack.getCountRequestableCrafts()));
            }
            downY += 5;
            if (this.amountToCraftI > 0 && multipliedBy > 0L) {
                str = GuiText.Multiplied.getLocal() + ": x" + ReadableNumberConverter.INSTANCE.toWideReadableForm(1L << (int)multipliedBy);
                w = 4 + this.field_146289_q.func_78256_a(str);
                this.field_146289_q.func_78276_b(str, (int)(((double)(x * 68 + 9 + 67 - 19) - (double)w * 0.5) * 2.0), (y * 23 + 22 + 6 - negY + downY) * 2, GuiColors.CraftConfirmMissing.getColor());
                if (this.tooltip == z - viewStart) {
                    lineList.add(GuiText.MultipliedBy.getLocal() + ": " + NumberFormat.getInstance().format(1L << (int)multipliedBy));
                    lineList.add(GuiText.CurrentPatternOutput.getLocal() + ": " + NumberFormat.getInstance().format(refStack.getCountRequestable()));
                    lineList.add(GuiText.NewPatternOutput.getLocal() + ": " + NumberFormat.getInstance().format(refStack.getCountRequestable() << (int)multipliedBy));
                }
                downY += 5;
            }
            GL11.glPopMatrix();
            int posX = x * 68 + 9 + 67 - 19;
            int posY = y * 23 + 22;
            ItemStack is = refStack.copy().getItemStack();
            if (this.tooltip == z - viewStart) {
                dspToolTip = Platform.getItemDisplayName(is);
                if (!lineList.isEmpty()) {
                    this.addItemTooltip(is, lineList);
                    dspToolTip = dspToolTip + '\n' + Joiner.on((String)"\n").join(lineList);
                }
                toolPosX = x * 68 + 9 + 67 - 8;
                toolPosY = y * 23 + 22;
                this.hoveredStack = refStack.copy();
            }
            this.drawItem(posX, posY, is);
            if (this.ignoreList.contains(refStack) || multipliedBy == 0L) {
                int startX = x * 68 + 9;
                int startY = posY - 4;
                GuiOptimizePatterns.func_73734_a((int)startX, (int)startY, (int)(startX + 67), (int)(startY + 23), (int)GuiColors.CraftConfirmMissingItem.getColor());
            }
            if (++x <= 2) continue;
            ++y;
            x = 0;
        }
        if (this.tooltip >= 0 && !dspToolTip.isEmpty()) {
            this.drawTooltip(toolPosX, toolPosY + 10, 0, dspToolTip);
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/craftingreport.png");
        if (this.tallMode) {
            this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, 41);
            int y = 41;
            for (int row = 1; row < this.rows - 1; ++row) {
                this.func_73729_b(offsetX, offsetY + y, 0, 41, this.field_146999_f, 23);
                y += 23;
            }
            this.func_73729_b(offsetX, offsetY + y, 0, 110, this.field_146999_f, 96);
        } else {
            this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
        }
        this.amountToCraft.func_146194_f();
    }

    protected void func_73869_a(char character, int key) {
        if (!this.func_146983_a(key)) {
            if (key == 28 || key == 156) {
                this.func_146284_a(this.optimize);
            }
            this.amountToCraft.func_146201_a(character, key);
            super.func_73869_a(character, key);
            String out = this.amountToCraft.func_146179_b();
            double resultD = Calculator.conversion(out);
            int resultI = resultD <= 0.0 || Double.isNaN(resultD) ? 0 : (int)ArithHelper.round(resultD, 0);
            this.amountToCraftI = resultI;
            this.updateMultipliers();
            this.optimize.field_146124_l = resultI > 0 && !this.multiplierMap.isEmpty();
        }
    }

    private void updateMultipliers() {
        if (this.amountToCraftI == 0) {
            return;
        }
        this.multiplierMap.clear();
        for (IAEItemStack stack : this.visual) {
            int v;
            if (this.ignoreList.contains(stack) || (v = Math.min(ContainerOptimizePatterns.getBitMultiplier(stack.getCountRequestableCrafts(), stack.getCountRequestable(), this.amountToCraftI), (int)(stack.getStackSize() & 0x1FL))) <= 0) continue;
            this.multiplierMap.put(stack, v);
        }
    }

    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        if (btn == this.cancel) {
            if (this.OriginalGui != null) {
                NetworkHandler.instance.sendToServer(new PacketSwitchGuis(this.OriginalGui));
            }
        } else if (btn == this.optimize && this.optimize.field_146124_l) {
            try {
                NetworkHandler.instance.sendToServer(new PacketOptimizePatterns(this.multiplierMap));
            }
            catch (Throwable e) {
                AELog.debug(e);
            }
        }
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        if (this.hoveredStack != null) {
            if (this.ignoreList.contains(this.hoveredStack)) {
                this.ignoreList.remove(this.hoveredStack);
            } else {
                this.ignoreList.add(this.hoveredStack);
            }
            this.updateMultipliers();
            this.optimize.field_146124_l = this.amountToCraftI > 0 && !this.multiplierMap.isEmpty();
            return;
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    public void postUpdate(List<IAEItemStack> list, byte ref) {
        this.visual.clear();
        for (IAEItemStack stack : list) {
            this.visual.add(stack.copy());
        }
        this.sortItems();
        this.setScrollBar();
        this.updateMultipliers();
        this.optimize.field_146124_l = this.amountToCraftI > 0 && !this.multiplierMap.isEmpty();
    }

    @Override
    public ItemStack getHoveredStack() {
        if (this.hoveredStack != null) {
            return this.hoveredStack.getItemStack();
        }
        return null;
    }

    private void sortItems() {
        this.visual.sort(this.comparator);
    }

    private void setScrollBar() {
        if (this.getScrollBar() == null) {
            this.setScrollBar(this.scrollbar);
        }
        int size = this.visual.size();
        this.getScrollBar().setTop(19).setLeft(218).setHeight(this.field_147000_g - 92);
        this.getScrollBar().setRange(0, (size + 2) / 3 - this.rows, 1);
    }
}

