/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.ceres.world.dungeon;

import galaxyspace.SolarSystem.planets.ceres.tile.TileEntityDungeonSpawnerCeres;
import galaxyspace.core.block.BlockFutureGlass;
import galaxyspace.core.register.GSBlocks;
import galaxyspace.core.world.dungeon.GSDungeonBoundingBox;
import galaxyspace.core.world.dungeon.GSDungeonRoom;
import galaxyspace.core.world.dungeon.GSMapGenDungeon;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class RoomBossCeres
extends GSDungeonRoom {
    public int sizeX;
    public int sizeY;
    public int sizeZ;
    Random rand;
    ChunkCoordinates spawnerCoords;

    public RoomBossCeres(GSMapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            this.rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = 24;
            this.sizeY = 11;
            this.sizeZ = 24;
        }
    }

    @Override
    public void generate(Block[] chunk, byte[] meta, int cx, int cz) {
        for (int i = this.posX - 1; i <= this.posX + this.sizeX; ++i) {
            for (int k = this.posZ - 1; k <= this.posZ + this.sizeZ; ++k) {
                for (int j = this.posY - 1; j <= this.posY + this.sizeY; ++j) {
                    if (i == this.posX - 1 || i == this.posX + this.sizeX || j == this.posY - 1 || j == this.posY + this.sizeY || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                        if (j == this.posY - 1 && (i <= this.posX + 1 || i >= this.posX + this.sizeX - 2 || k == this.posZ + 1 || k == this.posZ + this.sizeZ - 2) && this.rand.nextInt(4) == 0) {
                            this.placeBlock(chunk, meta, i, j, k, cx, cz, GSBlocks.CeresGlowStone, 0);
                            continue;
                        }
                        if (j == this.posY - 1 || i == this.posX + this.sizeX) {
                            this.placeBlock(chunk, meta, i, j, k, cx, cz, GSBlocks.CeresBlocks, 4);
                        }
                        if (j == this.posY + this.sizeY || i == this.posX - 1 || i == this.posX + this.sizeX || k == this.posZ - 1 || k == this.posZ + this.sizeZ) {
                            this.placeBlock(chunk, meta, i, j, k, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        }
                        if (j != this.posY + this.sizeY && i != this.posX + this.sizeX + 1) continue;
                        this.placeBlock(chunk, meta, i, j, k, cx, cz, GSBlocks.CeresBlocks, 5);
                        continue;
                    }
                    if (j != this.posY || i > this.posX + 1 && i < this.posX + this.sizeX - 2 && k != this.posZ + 1 && k != this.posZ + this.sizeZ - 2 || this.rand.nextInt(6) == 0) {
                        // empty if block
                    }
                    this.placeBlock(chunk, meta, i, j, k, cx, cz, Blocks.field_150350_a, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        this.spawnerCoords = new ChunkCoordinates(hx, this.posY + 2, hz);
        BlockFutureGlass block = GSBlocks.FutureGlass;
        int n = 11;
        for (int l = -n; l < n; ++l) {
            for (int m = -n; m < n; ++m) {
                this.placeBlock(chunk, meta, hx, this.posY - 1, hz + m, cx, cz, (Block)block, 0);
                this.placeBlock(chunk, meta, hx + l, this.posY - 1, hz, cx, cz, (Block)block, 0);
                this.placeBlock(chunk, meta, hx + l, this.posY - 2, hz + m, cx, cz, Blocks.field_150355_j, 0);
            }
        }
    }

    @Override
    public GSDungeonBoundingBox getBoundingBox() {
        return new GSDungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    @Override
    protected GSDungeonRoom makeRoom(GSMapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new RoomBossCeres(dungeon, x, y, z, dir);
    }

    @Override
    protected void handleTileEntities(Random rand) {
        if (this.spawnerCoords == null) {
            return;
        }
        this.worldObj.func_147465_d(this.spawnerCoords.field_71574_a, this.spawnerCoords.field_71572_b, this.spawnerCoords.field_71573_c, MarsBlocks.marsBlock, 10, 3);
        TileEntity tile = this.worldObj.func_147438_o(this.spawnerCoords.field_71574_a, this.spawnerCoords.field_71572_b, this.spawnerCoords.field_71573_c);
        if (tile == null || !(tile instanceof TileEntityDungeonSpawnerCeres)) {
            TileEntityDungeonSpawnerCeres spawner = new TileEntityDungeonSpawnerCeres();
            spawner.setRoom(new Vector3((double)this.posX, (double)this.posY, (double)this.posZ), new Vector3((double)this.sizeX, (double)this.sizeY, (double)this.sizeZ));
            this.worldObj.func_147455_a(this.spawnerCoords.field_71574_a, this.spawnerCoords.field_71572_b, this.spawnerCoords.field_71573_c, (TileEntity)spawner);
        } else if (tile instanceof TileEntityDungeonSpawner) {
            ((TileEntityDungeonSpawner)tile).setRoom(new Vector3((double)this.posX, (double)this.posY, (double)this.posZ), new Vector3((double)this.sizeX, (double)this.sizeY, (double)this.sizeZ));
        }
    }
}

