/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.graphics;

import com.github.weisj.darklaf.graphics.Outline;
import com.github.weisj.darklaf.util.Scale;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import com.github.weisj.darklaf.util.graphics.GraphicsUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;

public final class PaintUtil {
    public static final Color TRANSPARENT_COLOR = new Color(0, true);
    private static final AlphaComposite transparentComposite = AlphaComposite.getInstance(3, 0.6f);
    private static AlphaComposite glowComposite = AlphaComposite.getInstance(3, 0.5f);
    private static AlphaComposite dropComposite = AlphaComposite.getInstance(3, 0.8f);
    private static AlphaComposite shadowComposite = AlphaComposite.getInstance(3, 0.1f);
    private static Color errorGlow;
    private static Color errorFocusGlow;
    private static Color focusGlow;
    private static Color focusInactiveGlow;
    private static Color warningGlow;
    private static final RoundRectangle2D roundRect;

    public static void setGlowOpacity(float alpha) {
        glowComposite = glowComposite.derive(alpha);
    }

    public static void setShadowOpacity(float alpha) {
        shadowComposite = shadowComposite.derive(alpha);
    }

    public static void setDropOpacity(float alpha) {
        dropComposite = dropComposite.derive(alpha);
    }

    public static AlphaComposite getDropComposite() {
        return dropComposite;
    }

    public static AlphaComposite getShadowComposite() {
        return shadowComposite;
    }

    public static AlphaComposite getTransparentComposite() {
        return transparentComposite;
    }

    public static AlphaComposite getGlowComposite() {
        return glowComposite;
    }

    public static void setErrorGlow(Color errorGlow) {
        PaintUtil.errorGlow = errorGlow;
    }

    public static void setErrorFocusGlow(Color errorFocusGlow) {
        PaintUtil.errorFocusGlow = errorFocusGlow;
    }

    public static void setFocusGlow(Color focusGlow) {
        PaintUtil.focusGlow = focusGlow;
    }

    public static void setFocusInactiveGlow(Color focusInactiveGlow) {
        PaintUtil.focusInactiveGlow = focusInactiveGlow;
    }

    public static void setWarningGlow(Color warningGlow) {
        PaintUtil.warningGlow = warningGlow;
    }

    public static Color getErrorGlow() {
        return errorGlow;
    }

    public static Color getErrorFocusGlow() {
        return errorFocusGlow;
    }

    public static Color getFocusGlow() {
        return focusGlow;
    }

    public static Color getFocusInactiveGlow() {
        return focusInactiveGlow;
    }

    public static Color getWarningGlow() {
        return warningGlow;
    }

    private static void doPaint(Graphics2D g, float width, float height, float arc, float bw, boolean inside) {
        RectangularShape innerRect;
        RectangularShape outerRect;
        GraphicsContext context = GraphicsUtil.setupStrokePainting(g);
        if (Scale.equalWithError(arc, 0.0)) {
            outerRect = new Rectangle2D.Float(0.0f, 0.0f, width, height);
            innerRect = new Rectangle2D.Float(bw, bw, width - 2.0f * bw, height - 2.0f * bw);
        } else {
            float outerArc = inside ? arc : arc + bw;
            float innerArc = inside ? arc - bw : arc;
            outerRect = new RoundRectangle2D.Float(0.0f, 0.0f, width, height, outerArc, outerArc);
            innerRect = new RoundRectangle2D.Float(bw, bw, width - 2.0f * bw, height - 2.0f * bw, innerArc, innerArc);
        }
        Path2D.Float path = new Path2D.Float(0);
        path.append(outerRect, false);
        path.append(innerRect, false);
        g.fill(path);
        context.restore();
    }

    public static void paintFocusBorder(Graphics2D g, int width, int height, float arc, float bw) {
        PaintUtil.paintFocusBorder(g, width, height, arc, bw, true);
    }

    public static void paintFocusBorder(Graphics2D g, int width, int height, float arc, float bw, boolean active) {
        GraphicsContext config = new GraphicsContext(g);
        g.setComposite(glowComposite);
        PaintUtil.paintOutlineBorder(g, width, height, arc, bw, active, Outline.focus);
        config.restore();
    }

    public static void paintOutlineBorder(Graphics2D g, int width, int height, float arc, float bw, boolean hasFocus, Outline type) {
        PaintUtil.paintOutlineBorder(g, width, height, arc, bw, hasFocus, type, true);
    }

    public static void paintOutlineBorder(Graphics2D g, int width, int height, float arc, float bw, boolean hasFocus, Outline type, boolean withLineBorder) {
        type.setGraphicsColor(g, hasFocus);
        PaintUtil.doPaint(g, width, height, arc, withLineBorder ? bw + PaintUtil.getStrokeWidth(g) : bw, false);
    }

    public static void fillFocusRect(Graphics2D g, int x, int y, int width, int height) {
        PaintUtil.fillFocusRect(g, x, y, width, height, true);
    }

    public static void fillFocusRect(Graphics2D g, int x, int y, int width, int height, boolean active) {
        GraphicsContext config = new GraphicsContext(g);
        g.setComposite(glowComposite);
        Outline.focus.setGraphicsColor(g, active);
        g.fillRect(x, y, width, height);
        config.restore();
    }

    public static void paintFocusOval(Graphics2D g, int x, int y, int width, int height, int bw) {
        PaintUtil.paintFocusOval(g, (float)x, (float)y, (float)width, (float)height, (float)bw);
    }

    public static void paintFocusOval(Graphics2D g, float x, float y, float width, float height, float bw) {
        PaintUtil.paintFocusOval(g, x, y, width, height, true, bw);
    }

    public static void paintFocusOval(Graphics2D g, float x, float y, float width, float height, boolean active, float bw) {
        GraphicsContext config = new GraphicsContext(g);
        g.setComposite(glowComposite);
        Outline.focus.setGraphicsColor(g, active);
        Path2D.Float shape = new Path2D.Float(0);
        shape.append(new Ellipse2D.Float(x - bw, y - bw, width + bw * 2.0f, height + bw * 2.0f), false);
        shape.append(new Ellipse2D.Float(x, y, width, height), false);
        g.fill(shape);
        config.restore();
    }

    public static float getStrokeWidth(Graphics2D g) {
        Stroke stroke = g.getStroke();
        return stroke instanceof BasicStroke ? ((BasicStroke)stroke).getLineWidth() : 1.0f;
    }

    public static void paintLineBorder(Graphics2D g, float width, float height, Insets ins, int arc) {
        PaintUtil.paintLineBorder(g, ins.left, ins.top, width - (float)ins.left - (float)ins.right, height - (float)ins.top - (float)ins.bottom, arc);
    }

    public static void paintLineBorder(Graphics2D g, float x, float y, float width, float height, int arc) {
        float lw = PaintUtil.getStrokeWidth(g);
        g.translate(x, y);
        PaintUtil.doPaint(g, width, height, arc, lw, true);
        g.translate(-x, -y);
    }

    public static void fillRoundRect(Graphics2D g, float width, float height, Insets ins, int arc) {
        PaintUtil.fillRoundRect(g, ins.left, ins.top, width - (float)ins.left - (float)ins.right, height - (float)ins.bottom - (float)ins.top, arc, true);
    }

    public static void fillRoundRect(Graphics2D g, float x, float y, float width, float height, int arc) {
        PaintUtil.fillRoundRect(g, x, y, width, height, arc, true);
    }

    public static void fillRoundRect(Graphics2D g, float x, float y, float width, float height, int arc, boolean adjustForBorder) {
        GraphicsContext context = GraphicsUtil.setupStrokePainting(g);
        int stroke = adjustForBorder ? (int)PaintUtil.getStrokeWidth(g) : 0;
        float lw = Scale.equalWithError(Scale.getScaleX(g), 1.0) ? (float)stroke : (float)stroke / 2.0f;
        float arcSize = arc;
        g.translate(lw, lw);
        roundRect.setRoundRect(x, y, width - 2.0f * lw, height - 2.0f * lw, arcSize -= (float)stroke, arcSize);
        g.fill(roundRect);
        g.translate(-lw, -lw);
        context.restore();
    }

    public static void drawRect(Graphics g, Rectangle rect, int thickness) {
        PaintUtil.drawRect(g, rect.x, rect.y, rect.width, rect.height, thickness);
    }

    public static void drawRect(Graphics g, Rectangle rect) {
        PaintUtil.drawRect(g, rect, 1);
    }

    public static void drawRect(Graphics g, int x, int y, int width, int height, int thickness) {
        g.fillRect(x, y, width, thickness);
        g.fillRect(x, y + thickness, thickness, height - 2 * thickness);
        g.fillRect(x + width - thickness, y + thickness, thickness, height - 2 * thickness);
        g.fillRect(x, y + height - thickness, width, thickness);
    }

    public static void drawRect(Graphics g, Rectangle r, Insets lineWidths) {
        PaintUtil.drawRect(g, r.x, r.y, r.width, r.height, lineWidths);
    }

    public static void drawRect(Graphics g, int x, int y, int width, int height, Insets lineWidths) {
        g.fillRect(x, y, width, lineWidths.top);
        g.fillRect(x, y + lineWidths.top, lineWidths.left, height - lineWidths.top - lineWidths.bottom);
        g.fillRect(x + width - lineWidths.right, y + lineWidths.top, lineWidths.right, height - lineWidths.left - lineWidths.right);
        g.fillRect(x, y + height - lineWidths.bottom, width, lineWidths.bottom);
    }

    public static void fillRect(Graphics g, Rectangle r) {
        PaintUtil.fillRect(g, r.x, r.y, r.width, r.height);
    }

    public static void fillRect(Graphics g, int x, int y, int w, int h) {
        g.fillRect(x, y, w, h);
    }

    public static void drawVLine(Graphics g, int x, int y1, int y2) {
        if (y2 < y1) {
            int temp = y2;
            y2 = y1;
            y1 = temp;
        }
        g.fillRect(x, y1, 1, y2 - y1 + 1);
    }

    public static void drawHLine(Graphics g, int x1, int x2, int y) {
        if (x2 < x1) {
            int temp = x2;
            x2 = x1;
            x1 = temp;
        }
        g.fillRect(x1, y, x2 - x1 + 1, 1);
    }

    static {
        roundRect = new RoundRectangle2D.Double();
    }
}

