/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.platform.windows.ui;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;

class TitleBarButton
extends JButton {
    private Color hoverColor;
    private Color clickColor;

    public TitleBarButton(Action action) {
        super(action);
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setBorderPainted(false);
    }

    @Override
    public Color getBackground() {
        if (this.getModel().isArmed()) {
            return this.clickColor;
        }
        if (this.getModel().isRollover()) {
            return this.hoverColor;
        }
        return super.getBackground();
    }

    @Override
    public void paint(Graphics g) {
        Icon icon = null;
        if (this.getModel().isArmed()) {
            g.setColor(this.clickColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            icon = this.getPressedIcon();
        } else if (this.getModel().isRollover()) {
            g.setColor(this.hoverColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            icon = this.getRolloverIcon();
        }
        if (icon == null) {
            icon = this.getIcon();
        }
        icon.paintIcon(this, g, (this.getWidth() - icon.getIconWidth()) / 2, (this.getHeight() - icon.getIconHeight()) / 2);
    }

    public void setHoverColor(Color hoverColor) {
        this.hoverColor = hoverColor;
        if (this.getModel().isRollover()) {
            this.repaint();
        }
    }

    public void setClickColor(Color clickColor) {
        this.clickColor = clickColor;
        if (this.getModel().isArmed()) {
            this.repaint();
        }
    }
}

