/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.relauncher;

import com.google.common.base.Throwables;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import me.eigenraven.lwjgl3ify.relauncher.Relauncher;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

public class Downloader {
    @NotNull
    public final Path mavenCachePath;
    private final AtomicInteger remainingTasks = new AtomicInteger(0);
    private final List<Path> jarPaths = new ArrayList<Path>();
    private final List<Path> nativePaths = new ArrayList<Path>();
    private final List<DownloadTask> tasks = new ArrayList<DownloadTask>();
    private final ConcurrentLinkedDeque<Throwable> taskExceptions = new ConcurrentLinkedDeque();
    public final Set<String> busyDownloads = Collections.newSetFromMap(new ConcurrentHashMap(8));

    public Downloader(@NotNull Path mavenCachePath) {
        this.mavenCachePath = Objects.requireNonNull(mavenCachePath);
    }

    public int remainingTasks() {
        return this.remainingTasks.get() + this.tasks.size();
    }

    public List<Path> jarPaths() {
        return this.jarPaths;
    }

    public List<Path> nativePaths() {
        return this.nativePaths;
    }

    public void loadTasks() {
        try {
            JsonElement versionRoot;
            boolean isArm;
            String osFull = "";
            String os = "";
            String archBits = SystemUtils.OS_ARCH.contains("64") ? "64" : "32";
            boolean bl = isArm = SystemUtils.OS_ARCH.equalsIgnoreCase("aarch64") || SystemUtils.OS_ARCH.toLowerCase(Locale.ROOT).startsWith("arm");
            if (SystemUtils.IS_OS_WINDOWS) {
                osFull = isArm ? "windows-arm64" : "windows";
                os = "windows";
            } else if (SystemUtils.IS_OS_MAC) {
                osFull = isArm ? "osx-arm64" : "osx";
                os = "osx";
            } else if (SystemUtils.IS_OS_LINUX) {
                osFull = isArm ? "linux-arm64" : "linux";
                os = "linux";
            } else {
                throw new UnsupportedOperationException("Unknown operating system " + SystemUtils.OS_NAME + ":" + SystemUtils.OS_ARCH);
            }
            try (InputStream is = Downloader.class.getResourceAsStream("version.json");
                 BufferedInputStream bis = new BufferedInputStream(is);
                 InputStreamReader rdr = new InputStreamReader((InputStream)bis, StandardCharsets.UTF_8);){
                versionRoot = new JsonParser().parse((Reader)rdr);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            JsonArray libraries = versionRoot.getAsJsonObject().getAsJsonArray("libraries");
            for (JsonElement libraryR : libraries) {
                JsonObject elLibrary = libraryR.getAsJsonObject();
                if (!Downloader.passesRules(elLibrary, osFull)) continue;
                String elGav = elLibrary.getAsJsonPrimitive("name").getAsString();
                if (elLibrary.has("downloads")) {
                    JsonObject elDownloads = elLibrary.getAsJsonObject("downloads");
                    if (elDownloads.has("artifact")) {
                        JsonObject elArtifact = elDownloads.getAsJsonObject("artifact");
                        this.addArtifactDownload(elGav, elArtifact, this.tasks);
                        continue;
                    }
                    JsonObject elNatives = elLibrary.getAsJsonObject("natives");
                    if (!elNatives.has(os)) continue;
                    String classifier = elNatives.getAsJsonPrimitive(os).getAsString().replace("${arch}", archBits);
                    JsonObject elClassifiers = elDownloads.getAsJsonObject("classifiers");
                    if (!elClassifiers.has(classifier)) {
                        throw new IllegalStateException("Missing download for " + elGav + " classifier " + classifier);
                    }
                    JsonObject elArtifact = elClassifiers.getAsJsonObject(classifier);
                    DownloadTask task = this.addArtifactDownload(elGav + ":" + classifier, elArtifact, this.tasks);
                    this.nativePaths.add(task.targetLocation());
                    continue;
                }
                String elMavenUrl = elLibrary.getAsJsonPrimitive("url").getAsString();
                GavCoords gav = new GavCoords(elGav);
                if (gav.mArtifact.equals("lwjgl3ify")) continue;
                String mURL = elMavenUrl + gav.mPath;
                Path path = this.mavenCachePath.resolve(gav.mPath);
                URL url = new URL(mURL);
                this.jarPaths.add(path);
                this.tasks.add(new DownloadTask(url, null, path));
            }
            JsonObject elClientDownload = versionRoot.getAsJsonObject().getAsJsonObject("downloads").getAsJsonObject("client");
            this.addArtifactDownload("net.minecraft:client:1.7.10", elClientDownload, this.tasks);
            Iterator<DownloadTask> it = this.tasks.iterator();
            while (it.hasNext()) {
                DownloadTask task = it.next();
                if (!Files.exists(task.targetLocation, new LinkOption[0])) continue;
                it.remove();
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runDownloads() {
        Path cacheLockPath = this.mavenCachePath.resolve("cache.lock");
        if (!Files.exists(cacheLockPath, new LinkOption[0])) {
            try {
                Files.createFile(cacheLockPath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try (FileChannel cacheChannel = FileChannel.open(cacheLockPath, StandardOpenOption.WRITE);){
            FileLock cacheLock = cacheChannel.tryLock();
            if (cacheLock == null) {
                Relauncher.logger.warn("Another process is already holding a lock on {}, waiting", new Object[]{cacheLockPath});
                cacheLock = cacheChannel.lock();
            }
            ExecutorService executor = Executors.newFixedThreadPool(4, r -> {
                Thread t = new Thread(r);
                t.setName("Lwjgl3ify downloader");
                t.setDaemon(true);
                return t;
            });
            try {
                this.remainingTasks.addAndGet(this.tasks.size());
                for (DownloadTask task : this.tasks) {
                    executor.submit(() -> {
                        String name = task.targetLocation().getFileName().toString();
                        this.busyDownloads.add(name);
                        try {
                            task.download();
                        }
                        catch (Throwable e) {
                            this.taskExceptions.add(e);
                        }
                        this.busyDownloads.remove(name);
                        this.remainingTasks.decrementAndGet();
                    });
                }
                this.tasks.clear();
                executor.shutdown();
                if (!executor.awaitTermination(1L, TimeUnit.DAYS)) {
                    throw new IllegalStateException("executor won't terminate");
                }
                if (!this.taskExceptions.isEmpty()) {
                    Relauncher.logger.error("Exceptions happened during download task execution:");
                    Throwable last = null;
                    while (!this.taskExceptions.isEmpty()) {
                        last = this.taskExceptions.removeFirst();
                        Relauncher.logger.error("Download exception", last);
                    }
                    if (last != null) {
                        throw Throwables.propagate(last);
                    }
                }
            }
            finally {
                executor.shutdownNow();
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private DownloadTask addArtifactDownload(String name, JsonObject elArtifact, List<DownloadTask> tasks) throws MalformedURLException, DecoderException {
        String elPath;
        if (elArtifact.has("path")) {
            elPath = elArtifact.getAsJsonPrimitive("path").getAsString();
        } else {
            GavCoords gav = new GavCoords(name);
            elPath = gav.mPath;
        }
        String elUrl = elArtifact.getAsJsonPrimitive("url").getAsString();
        String elSha1 = elArtifact.getAsJsonPrimitive("sha1").getAsString();
        URL url = new URL(elUrl);
        Path path = this.mavenCachePath.resolve(elPath);
        byte[] sha1 = Hex.decodeHex((char[])elSha1.toCharArray());
        this.jarPaths.add(path);
        DownloadTask task = new DownloadTask(url, sha1, path);
        tasks.add(task);
        return task;
    }

    private static boolean passesRules(JsonObject library, String os) {
        if (library.has("rules")) {
            JsonArray elRules = library.getAsJsonArray("rules");
            boolean allowed = false;
            block8: for (JsonElement ruleR : elRules) {
                String elAction;
                String elOsName;
                JsonObject elOs;
                JsonObject elRule = ruleR.getAsJsonObject();
                if (elRule.has("os") && (elOs = elRule.getAsJsonObject("os")).has("name") && !os.equals(elOsName = elOs.get("name").getAsString()) || !elRule.has("action")) continue;
                switch (elAction = elRule.get("action").getAsString()) {
                    case "allow": {
                        allowed = true;
                        continue block8;
                    }
                    case "disallow": {
                        allowed = false;
                        continue block8;
                    }
                }
                throw new IllegalStateException("Illegal rule action: " + elAction);
            }
            return allowed;
        }
        return true;
    }

    public static final class DownloadTask {
        private final URL sourceUrl;
        private final byte[] checksum;
        private final Path targetLocation;

        public DownloadTask(URL sourceUrl, byte[] checksum, Path targetLocation) {
            this.sourceUrl = sourceUrl;
            this.checksum = checksum;
            this.targetLocation = targetLocation;
        }

        public URL sourceUrl() {
            return this.sourceUrl;
        }

        public byte[] checksum() {
            return this.checksum;
        }

        public Path targetLocation() {
            return this.targetLocation;
        }

        public void download() throws IOException {
            Path targetDir = this.targetLocation.getParent();
            Path tempLocation = targetDir.resolve(this.targetLocation.getFileName().toString() + ".tmp");
            Files.createDirectories(targetDir, new FileAttribute[0]);
            Files.deleteIfExists(this.targetLocation);
            Files.deleteIfExists(tempLocation);
            byte[] data = null;
            Relauncher.logger.info("Downloading {} from {}", new Object[]{this.targetLocation, this.sourceUrl});
            for (int retries = 0; retries < 5; ++retries) {
                try {
                    byte[] dataSum;
                    data = IOUtils.toByteArray((URL)this.sourceUrl);
                    if (this.checksum == null || Arrays.equals(dataSum = DigestUtils.sha1((byte[])data), this.checksum)) continue;
                    throw new RuntimeException("Checksum mismatch for " + this.targetLocation);
                }
                catch (Exception e) {
                    if (retries != 4) continue;
                    throw e;
                }
            }
            Objects.requireNonNull(data);
            Files.write(tempLocation, data, new OpenOption[0]);
            Files.move(tempLocation, this.targetLocation, new CopyOption[0]);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            DownloadTask that = (DownloadTask)obj;
            return Objects.equals(this.sourceUrl, that.sourceUrl) && Arrays.equals(this.checksum, that.checksum) && Objects.equals(this.targetLocation, that.targetLocation);
        }

        public int hashCode() {
            return Objects.hash(this.sourceUrl, Arrays.hashCode(this.checksum), this.targetLocation);
        }

        public String toString() {
            return "DownloadTask[sourceUrl=" + this.sourceUrl + ", checksum=" + this.checksum + ", targetLocation=" + this.targetLocation + ']';
        }
    }

    public static final class GavCoords {
        public final String[] gav;
        final String mGroup;
        final String mArtifact;
        final String mVersion;
        final String mClassifier;
        final String mGroupPath;
        final String mFilename;
        final String mPath;

        public GavCoords(String elGav) {
            this.gav = elGav.split(":");
            this.mGroup = this.gav.length > 2 ? this.gav[0] : "";
            this.mArtifact = this.gav.length > 2 ? this.gav[1] : this.gav[0];
            this.mVersion = this.gav.length > 2 ? this.gav[2] : this.gav[1];
            this.mClassifier = this.gav.length > 3 ? this.gav[3] : "";
            this.mGroupPath = this.mGroup.replace('.', '/');
            String mFilename = this.mArtifact;
            if (!this.mVersion.isEmpty()) {
                mFilename = mFilename + '-' + this.mVersion;
            }
            if (!this.mClassifier.isEmpty()) {
                mFilename = mFilename + '-' + this.mClassifier;
            }
            this.mFilename = mFilename = mFilename + ".jar";
            this.mPath = this.mGroupPath + '/' + this.mArtifact + '/' + this.mVersion + '/' + mFilename;
        }
    }
}

