/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.service.itemfinder;

import codechicken.nei.recipe.StackInfo;
import com.gtnh.findit.FindIt;
import com.gtnh.findit.service.blockfinder.BlockFoundResponse;
import com.gtnh.findit.util.ProtoUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FindItemRequest
implements IMessage {
    private ItemStack targetStack;
    private FluidStack targetFluidStack;

    public FindItemRequest(ItemStack targetStack) {
        this.targetStack = targetStack;
        this.targetFluidStack = StackInfo.getFluid((ItemStack)targetStack);
    }

    public FindItemRequest() {
    }

    public void fromBytes(ByteBuf buf) {
        this.targetStack = ProtoUtils.readItemStack(buf);
        this.targetFluidStack = StackInfo.getFluid((ItemStack)this.targetStack);
    }

    public void toBytes(ByteBuf buf) {
        ProtoUtils.writeItemStack(buf, this.targetStack);
    }

    public ItemStack getStackToFind() {
        return this.targetStack;
    }

    public boolean hasFluidStack() {
        return this.targetFluidStack != null;
    }

    public boolean isFluidSatisfies(FluidStack fluid) {
        if (fluid != null && this.targetFluidStack != null) {
            return this.targetFluidStack.isFluidEqual(fluid);
        }
        return false;
    }

    public boolean isStackSatisfies(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.hasFluidStack()) {
            return this.targetFluidStack.isFluidEqual(StackInfo.getFluid((ItemStack)stack));
        }
        return StackInfo.equalItemAndNBT((ItemStack)this.targetStack, (ItemStack)stack, (boolean)true);
    }

    public static class Handler
    implements IMessageHandler<FindItemRequest, BlockFoundResponse> {
        public BlockFoundResponse onMessage(FindItemRequest message, MessageContext ctx) {
            if (message.targetStack != null) {
                FindIt.getItemFindService().handleRequest(ctx.getServerHandler().field_147369_b, message);
            }
            return null;
        }
    }
}

