/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.loader;

import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.kuba6000.mobsinfo.api.DummyWorld;
import com.kuba6000.mobsinfo.api.IVillagerInfoProvider;
import com.kuba6000.mobsinfo.api.RandomSequencer;
import com.kuba6000.mobsinfo.api.VillagerRecipe;
import com.kuba6000.mobsinfo.api.VillagerTrade;
import com.kuba6000.mobsinfo.api.helper.ProgressBarWrapper;
import com.kuba6000.mobsinfo.api.utils.GSONUtils;
import com.kuba6000.mobsinfo.api.utils.ItemID;
import com.kuba6000.mobsinfo.api.utils.ModUtils;
import com.kuba6000.mobsinfo.config.Config;
import com.kuba6000.mobsinfo.loader.MobRecipeLoader;
import com.kuba6000.mobsinfo.loader.VanillaVillagerTradesLoader;
import com.kuba6000.mobsinfo.mixin.minecraft.VillagerRegistryAccessor;
import com.kuba6000.mobsinfo.nei.VillagerTradesHandler;
import com.kuba6000.mobsinfo.network.LoadConfigPacket;
import cpw.mods.fml.common.registry.VillagerRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VillagerTradesLoader {
    private static final Logger LOG = LogManager.getLogger((String)"mobsinfo[Villager Recipe Loader]");
    private static boolean alreadyGenerated = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateVillagerTrades() {
        if (alreadyGenerated) {
            return;
        }
        alreadyGenerated = true;
        if (!Config.VillagerTradesHandler.enabled) {
            return;
        }
        VanillaVillagerTradesLoader.init();
        LOG.info("Generating Recipe Map for Villager Trades Handler");
        long startTime = System.currentTimeMillis();
        DummyWorld world = new DummyWorld();
        RandomSequencer frand = new RandomSequencer();
        world.field_73012_v = frand;
        File cache = Config.getConfigFile("VillagerTradesLoader.cache");
        Gson gson = GSONUtils.GSON_BUILDER.create();
        String modlistversion = Config.MobHandler.regenerationTrigger == Config.MobHandler._CacheRegenerationTrigger.ModAdditionRemoval ? ModUtils.getModListVersionForVillagerRecipes(false) : ModUtils.getModListVersionForVillagerRecipes(true);
        VillagerRegistry villagerRegistry = VillagerRegistry.instance();
        Multimap<Integer, VillagerRegistry.IVillageTradeHandler> tradeHandlerMap = ((VillagerRegistryAccessor)villagerRegistry).getTradeHandlers();
        HashMap<String, ArrayList> classNameToHandlerInstances = new HashMap<String, ArrayList>();
        for (VillagerRegistry.IVillageTradeHandler value : tradeHandlerMap.values()) {
            classNameToHandlerInstances.computeIfAbsent(value.getClass().getName(), k -> new ArrayList()).add(value);
        }
        MobRecipeLoader.isInGenerationProcess = true;
        if (Config.MobHandler.regenerationTrigger != Config.MobHandler._CacheRegenerationTrigger.Always && cache.exists()) {
            LOG.info("Parsing Cached map");
            BufferedReader reader = null;
            try {
                reader = Files.newReader((File)cache, (Charset)StandardCharsets.UTF_8);
                VillagerTradesLoaderCacheStructure s = (VillagerTradesLoaderCacheStructure)gson.fromJson((Reader)reader, VillagerTradesLoaderCacheStructure.class);
                if (Config.MobHandler.regenerationTrigger == Config.MobHandler._CacheRegenerationTrigger.Never || s.version.equals(modlistversion)) {
                    ProgressBarWrapper bar = new ProgressBarWrapper("Parsing cached Villager Trades Map", s.handlerList.size());
                    for (Map.Entry<Integer, ArrayList<VillagerTradesLoaderCacheStructure.VillagerTradesLoaderCacheStructure_Handler>> entry : s.handlerList.entrySet()) {
                        int profession = entry.getKey();
                        bar.step("Profession " + profession);
                        try {
                            ArrayList<VillagerTrade> trades = new ArrayList<VillagerTrade>();
                            if (profession >= 0 && profession <= 4) {
                                trades.addAll((Collection)VanillaVillagerTradesLoader.vanillaTrades.get(profession));
                            }
                            ArrayList<VillagerTradesLoaderCacheStructure.VillagerTradesLoaderCacheStructure_Handler> handlers = entry.getValue();
                            EntityVillager villager = new EntityVillager((World)world);
                            villager.func_70938_b(profession);
                            for (VillagerTradesLoaderCacheStructure.VillagerTradesLoaderCacheStructure_Handler handler : handlers) {
                                if (handler.tradeList == null) {
                                    ArrayList tradeHandlers = (ArrayList)classNameToHandlerInstances.get(handler.handler);
                                    if (tradeHandlers == null || tradeHandlers.isEmpty() || !(tradeHandlers.get(0) instanceof IVillagerInfoProvider)) continue;
                                    for (VillagerRegistry.IVillageTradeHandler tradeHandler : tradeHandlers) {
                                        ((IVillagerInfoProvider)tradeHandler).provideTrades(villager, profession, trades);
                                    }
                                    continue;
                                }
                                trades.addAll(handler.tradeList);
                            }
                            trades.forEach(VillagerTrade::reconstructStacks);
                            VillagerRecipe.recipes.put(profession, new VillagerRecipe(trades, profession, villager));
                        }
                        catch (Exception trades) {}
                    }
                    bar.end();
                    LOG.info("Parsed cached map, skipping generation");
                    MobRecipeLoader.isInGenerationProcess = false;
                    return;
                }
                LOG.info("Cached map version mismatch, generating a new one");
            }
            catch (Exception ignored) {
                LOG.warn("There was an exception while parsing cached map, generating a new one");
            }
            finally {
                if (reader != null) {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Exception ignored) {}
                }
            }
        } else {
            LOG.info("Cached map doesn't exist or config option forced, generating a new one");
        }
        VillagerTradesLoaderCacheStructure toCache = new VillagerTradesLoaderCacheStructure();
        toCache.version = modlistversion;
        toCache.handlerList = new HashMap<Integer, ArrayList<VillagerTradesLoaderCacheStructure.VillagerTradesLoaderCacheStructure_Handler>>();
        LOG.info("Generating villager recipes");
        ArrayList<Integer> villagerIDs = new ArrayList<Integer>(Arrays.asList(0, 1, 2, 3, 4));
        villagerIDs.addAll(VillagerRegistry.getRegisteredVillagers());
        ProgressBarWrapper bar = new ProgressBarWrapper("Generating Villager Traders Map", villagerIDs.size());
        for (int id : villagerIDs) {
            bar.step("Profession " + id);
            try {
                Collection handlers;
                EntityVillager villager = new EntityVillager((World)world);
                villager.func_70938_b(id);
                ArrayList<VillagerTrade> recipes = new ArrayList<VillagerTrade>();
                if (id >= 0 && id <= 4) {
                    recipes.addAll((Collection)VanillaVillagerTradesLoader.vanillaTrades.get(id));
                }
                if ((handlers = tradeHandlerMap.get((Object)id)) == null || handlers.isEmpty()) {
                    LOG.info("Didn't found any registered handlers for profession {}", new Object[]{id});
                    VillagerRecipe.recipes.put(id, new VillagerRecipe(recipes, id, villager));
                    toCache.handlerList.put(id, new ArrayList(0));
                    continue;
                }
                LOG.info("Generating recipes from registered handlers for profession {} handlers: ", new Object[]{id});
                for (VillagerRegistry.IVillageTradeHandler handler : handlers) {
                    LOG.info(" - {}{}", new Object[]{handler.getClass().getName(), handler instanceof IVillagerInfoProvider ? "(provider)" : ""});
                }
                ArrayList<VillagerTradesLoaderCacheStructure.VillagerTradesLoaderCacheStructure_Handler> handlersToCache = new ArrayList<VillagerTradesLoaderCacheStructure.VillagerTradesLoaderCacheStructure_Handler>(handlers.size());
                toCache.handlerList.put(id, handlersToCache);
                HashMap<String, VillagerTradesLoaderCacheStructure.VillagerTradesLoaderCacheStructure_Handler> classNameToHandlerCacheHelper = new HashMap<String, VillagerTradesLoaderCacheStructure.VillagerTradesLoaderCacheStructure_Handler>();
                frand.newRound();
                TradeCollector collector = new TradeCollector();
                for (VillagerRegistry.IVillageTradeHandler handler : handlers) {
                    TradeList trades = new TradeList();
                    VillagerTradesLoaderCacheStructure.VillagerTradesLoaderCacheStructure_Handler handlerToCache = (VillagerTradesLoaderCacheStructure.VillagerTradesLoaderCacheStructure_Handler)classNameToHandlerCacheHelper.get(handler.getClass().getName());
                    if (handlerToCache == null) {
                        handlerToCache = new VillagerTradesLoaderCacheStructure.VillagerTradesLoaderCacheStructure_Handler();
                        handlerToCache.handler = handler.getClass().getName();
                        handlerToCache.tradeList = new ArrayList();
                        handlersToCache.add(handlerToCache);
                        classNameToHandlerCacheHelper.put(handlerToCache.handler, handlerToCache);
                    }
                    if (handler instanceof IVillagerInfoProvider) {
                        IVillagerInfoProvider provider = (IVillagerInfoProvider)handler;
                        provider.provideTrades(villager, id, recipes);
                        handlerToCache.tradeList = null;
                        continue;
                    }
                    boolean second = false;
                    do {
                        MerchantRecipeList list = new MerchantRecipeList();
                        handler.manipulateTradesForVillager(villager, list, (Random)frand);
                        collector.collectTrades(trades, list, frand.chance);
                        if (second && frand.chance < 1.0E-7) {
                            LOG.warn("Skipping {} because it's too randomized", new Object[]{id});
                            break;
                        }
                        second = true;
                    } while (frand.nextRound());
                    frand.newRound();
                    collector.newRound();
                    for (TradeInstance value : trades.itemsToTrade.values()) {
                        VillagerTrade trade = new VillagerTrade(value.i1, value.i2, value.o, value.chance);
                        recipes.add(trade);
                        handlerToCache.tradeList.add(trade);
                    }
                }
                VillagerRecipe.recipes.put(id, new VillagerRecipe(recipes, id, villager));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        MobRecipeLoader.isInGenerationProcess = false;
        bar.end();
        long endTime = System.currentTimeMillis();
        LOG.info("Villager trades generation took {} ms, mapped {} recipes in total", new Object[]{endTime - startTime, VillagerRecipe.recipes.size()});
        LOG.info("Saving generated map to file");
        BufferedWriter writer = null;
        try {
            writer = Files.newWriter((File)cache, (Charset)StandardCharsets.UTF_8);
            gson.toJson((Object)toCache, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void processVillagerTrades() {
        LoadConfigPacket.instance.villagersToLoad.clear();
        for (VillagerRecipe value : VillagerRecipe.recipes.values()) {
            LoadConfigPacket.instance.villagersToLoad.add(value.profession);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void processVillagerTrades(Set<Integer> villagersToLoad) {
        VillagerTradesHandler.clearRecipes();
        for (int i : villagersToLoad) {
            VillagerTradesHandler.addRecipe(VillagerRecipe.recipes.get(i));
        }
        VillagerTradesHandler.sortCachedRecipes();
    }

    private static class VillagerTradesLoaderCacheStructure {
        String version;
        Map<Integer, ArrayList<VillagerTradesLoaderCacheStructure_Handler>> handlerList;

        private VillagerTradesLoaderCacheStructure() {
        }

        private static class VillagerTradesLoaderCacheStructure_Handler {
            String handler;
            ArrayList<VillagerTrade> tradeList;

            private VillagerTradesLoaderCacheStructure_Handler() {
            }
        }
    }

    private static class TradeCollector {
        private TradeCollector() {
        }

        void collectTrades(TradeList trades, MerchantRecipeList recipeList, double chance) {
            for (MerchantRecipe recipe : recipeList) {
                ItemStack i1 = recipe.func_77394_a();
                ItemStack i2 = recipe.func_77396_b();
                ItemStack o = recipe.func_77397_d();
                boolean i1randomchomenchantdetected = i1.func_77942_o() && i1.field_77990_d.func_74764_b("RandomEnchantmentDetected");
                int i1randomenchantmentlevel = 0;
                if (i1randomchomenchantdetected) {
                    i1randomenchantmentlevel = i1.field_77990_d.func_74762_e("RandomEnchantmentDetected");
                    i1.field_77990_d.func_82580_o("ench");
                    i1.field_77990_d.func_74768_a("RandomEnchantmentDetected", 0);
                }
                boolean i2randomchomenchantdetected = i2 != null && i2.func_77942_o() && i2.field_77990_d.func_74764_b("RandomEnchantmentDetected");
                int i2randomenchantmentlevel = 0;
                if (i2randomchomenchantdetected) {
                    i2randomenchantmentlevel = i2.field_77990_d.func_74762_e("RandomEnchantmentDetected");
                    i2.field_77990_d.func_82580_o("ench");
                    i2.field_77990_d.func_74768_a("RandomEnchantmentDetected", 0);
                }
                boolean orandomchomenchantdetected = o.func_77942_o() && o.field_77990_d.func_74764_b("RandomEnchantmentDetected");
                int orandomenchantmentlevel = 0;
                if (orandomchomenchantdetected) {
                    orandomenchantmentlevel = o.field_77990_d.func_74762_e("RandomEnchantmentDetected");
                    o.field_77990_d.func_82580_o("ench");
                    o.field_77990_d.func_74768_a("RandomEnchantmentDetected", 0);
                }
                TradeInstance instance = trades.addOrMerge(recipe, chance);
                if (i1randomchomenchantdetected) {
                    instance.i1.enchantability = i1randomenchantmentlevel;
                }
                if (i2randomchomenchantdetected) {
                    instance.i2.enchantability = i2randomenchantmentlevel;
                }
                if (!orandomchomenchantdetected) continue;
                instance.o.enchantability = orandomenchantmentlevel;
            }
        }

        void newRound() {
        }
    }

    private static class TradeList {
        HashMap<Pair<Pair<ItemID, ItemID>, ItemID>, TradeInstance> itemsToTrade = new HashMap();

        private TradeList() {
        }

        TradeInstance addOrMerge(MerchantRecipe recipe, double chance) {
            Pair key = Pair.of((Object)Pair.of((Object)ItemID.createNoCopy(recipe.func_77394_a()), recipe.func_77398_c() ? ItemID.createNoCopy(recipe.func_77396_b()) : null), (Object)ItemID.createNoCopy(recipe.func_77397_d()));
            TradeInstance instance = this.itemsToTrade.get(key);
            if (instance != null) {
                instance.update(recipe);
                instance.chance += chance;
            } else {
                instance = new TradeInstance();
                instance.i1 = new VillagerTrade.TradeItem(recipe.func_77394_a());
                instance.i2 = recipe.func_77398_c() ? new VillagerTrade.TradeItem(recipe.func_77396_b()) : null;
                instance.o = new VillagerTrade.TradeItem(recipe.func_77397_d());
                instance.chance = chance;
                this.itemsToTrade.put((Pair<Pair<ItemID, ItemID>, ItemID>)key, instance);
            }
            return instance;
        }
    }

    private static class TradeInstance {
        VillagerTrade.TradeItem i1;
        VillagerTrade.TradeItem i2;
        VillagerTrade.TradeItem o;
        double chance = 0.0;

        private TradeInstance() {
        }

        boolean update(MerchantRecipe recipe) {
            ItemStack item = recipe.func_77394_a();
            if (item.field_77994_a != this.i1.stack.field_77994_a) {
                if (this.i1.possibleSizes == null) {
                    this.i1.possibleSizes = new HashSet<Integer>();
                }
                this.i1.possibleSizes.add(this.i1.stack.field_77994_a);
                this.i1.possibleSizes.add(item.field_77994_a);
            }
            ItemStack itemStack = item = recipe.func_77398_c() ? recipe.func_77396_b() : null;
            if (item != null && item.field_77994_a != this.i2.stack.field_77994_a) {
                if (this.i2.possibleSizes == null) {
                    this.i2.possibleSizes = new HashSet<Integer>();
                }
                this.i2.possibleSizes.add(this.i2.stack.field_77994_a);
                this.i2.possibleSizes.add(item.field_77994_a);
            }
            item = recipe.func_77397_d();
            if (item.field_77994_a != this.o.stack.field_77994_a) {
                if (this.o.possibleSizes == null) {
                    this.o.possibleSizes = new HashSet<Integer>();
                }
                this.o.possibleSizes.add(this.o.stack.field_77994_a);
                this.o.possibleSizes.add(item.field_77994_a);
            }
            return false;
        }
    }
}

