/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.crafting;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;

public class AlloyMix {
    public final FluidStack result;
    public final List<FluidStack> mixers;

    public AlloyMix(FluidStack output, List<FluidStack> inputs) {
        this.result = output;
        this.mixers = inputs;
    }

    public FluidStack mix(List<FluidStack> liquids) {
        ArrayList<FluidStack> copyMix = new ArrayList<FluidStack>(this.mixers);
        ArrayList<Integer> effectiveAmount = new ArrayList<Integer>();
        block0: for (FluidStack liquid : liquids) {
            for (FluidStack mixer : copyMix) {
                if (!mixer.isFluidEqual(liquid)) continue;
                if (liquid.amount < mixer.amount) continue block0;
                int eAmt = liquid.amount / mixer.amount;
                effectiveAmount.add(eAmt);
                copyMix.remove(mixer);
                continue block0;
            }
        }
        if (copyMix.size() > 0) {
            return null;
        }
        int low = this.getLowestAmount(effectiveAmount);
        ArrayList<FluidStack> copyMix2 = new ArrayList<FluidStack>(this.mixers);
        block2: for (int i = 0; i < liquids.size(); ++i) {
            FluidStack liquid = liquids.get(i);
            for (FluidStack mixer : copyMix2) {
                if (!mixer.isFluidEqual(liquid)) continue;
                int eAmt = low * mixer.amount;
                liquid.amount -= eAmt;
                if (liquid.amount <= 0) {
                    liquids.remove(liquid);
                    --i;
                }
                copyMix2.remove(mixer);
                continue block2;
            }
        }
        FluidStack ret = this.result.copy();
        ret.amount *= low;
        return ret;
    }

    int getLowestAmount(ArrayList<Integer> list) {
        int first = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            int compare = list.get(i);
            if (first <= compare) continue;
            first = compare;
        }
        return first;
    }
}

