/*
 * Decompiled with CFR 0.152.
 */
package com.mitchej123.hodgepodge.mixins.early.minecraft;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.ForgeHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ForgeHooks.class}, remap=false)
public class MixinForgeHooks {
    @Unique
    private static final Pattern URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);

    @Overwrite
    public static IChatComponent newChatWithLinks(String string) {
        ChatComponentText ichat = new ChatComponentText("");
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            ChatComponentText link;
            String url;
            block3: {
                int start = matcher.start();
                int end = matcher.end();
                ichat.func_150258_a(string.substring(lastEnd, start));
                lastEnd = end;
                url = string.substring(start, end);
                link = new ChatComponentText(url);
                try {
                    if (new URI(url).getScheme() != null) break block3;
                    url = "http://" + url;
                }
                catch (URISyntaxException e) {
                    ichat.func_150258_a(url);
                    continue;
                }
            }
            ClickEvent click = new ClickEvent(ClickEvent.Action.OPEN_URL, url);
            link.func_150256_b().func_150241_a(click);
            ichat.func_150257_a((IChatComponent)link);
        }
        ichat.func_150258_a(string.substring(lastEnd));
        return ichat;
    }
}

