/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui.ranks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.StatCollector;
import serverutils.client.gui.ranks.GuiAddPermission;
import serverutils.client.gui.ranks.GuiRanks;
import serverutils.client.gui.ranks.RankInst;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.ContextMenuItem;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.SimpleButton;
import serverutils.lib.gui.Widget;
import serverutils.lib.gui.misc.GuiEditConfig;
import serverutils.lib.icon.Color4I;
import serverutils.lib.util.misc.MouseButton;
import serverutils.net.MessageRankModify;

public class GuiEditRank
extends GuiEditConfig {
    private final Button buttonAddPermission;
    private final Button buttonAddCommand;
    private final RankInst rank;

    public GuiEditRank(RankInst inst) {
        super(inst.group, null);
        this.rank = inst;
        this.buttonAddPermission = new SimpleButton(this, StatCollector.func_74838_a((String)"serverutilities.admin_panel.ranks.add_perm"), GuiIcons.ADD, (widget, button) -> this.openContextMenu(new GuiAddPermission(this.group, GuiRanks.allPerms)));
        this.buttonAddCommand = new SimpleButton(this, StatCollector.func_74838_a((String)"serverutilities.admin_panel.ranks.add_command"), GuiIcons.ADD_GRAY.withColor(Color4I.YELLOW), (widget, button) -> this.openContextMenu(new GuiAddPermission(this.group, GuiRanks.commandPerms)));
    }

    @Override
    public void addWidgets() {
        super.addWidgets();
        this.add(this.buttonAddPermission);
        this.add(this.buttonAddCommand);
    }

    @Override
    public void alignWidgets() {
        super.alignWidgets();
        this.buttonAddPermission.setPos(this.width - 58, 2);
        this.buttonAddCommand.setPos(this.width - 78, 2);
    }

    @Override
    public void onClosed() {
        if (this.shouldClose == 1) {
            ArrayList<String> removedEntries = new ArrayList<String>();
            for (ConfigValueInstance inst : this.originalGroup.getValues()) {
                if (this.rank.group.getValueInstance(inst.getId()) != null) continue;
                removedEntries.add(inst.getId());
            }
            new MessageRankModify(this.rank, removedEntries).sendToServer();
        }
        super.onClosed();
    }

    @Override
    public boolean onClosedByKey(int key) {
        if (key == 1 || Minecraft.func_71410_x().field_71474_y.field_151445_Q.func_151463_i() == key) {
            this.openUnsavedYesNo(save -> this.sendAndExit(save, false));
        }
        return false;
    }

    @Override
    public void onBack() {
        this.openUnsavedYesNo(save -> this.sendAndExit(save, true));
    }

    private void sendAndExit(boolean save, boolean back) {
        if (save) {
            this.shouldClose = 1;
        }
        this.closeGui(back);
    }

    public void removeEntry(String value) {
        Predicate<Widget> predicate = widget -> {
            if (!(widget instanceof ButtonNodeEntry)) return false;
            ButtonNodeEntry btn = (ButtonNodeEntry)widget;
            if (!btn.inst.getId().equals(value)) return false;
            return true;
        };
        this.configEntryButtons.removeIf(predicate);
        this.configPanel.widgets.removeIf(predicate);
        this.group.removeValue(value);
        this.alignWidgets();
    }

    public void addEntry(String value) {
        ConfigValueInstance inst = GuiRanks.getValue(value);
        if (inst == null) {
            return;
        }
        this.group.add(inst.copy(this.group));
        this.configPanel.add(this.getEntryButton(this.configPanel, null, inst));
        this.configEntryButtons.add(this.getEntryButton(this.configPanel, null, inst));
        this.configPanel.refreshWidgets();
        this.alignWidgets();
    }

    @Override
    protected Widget getEntryButton(Panel panel, @Nullable GuiEditConfig.ButtonConfigGroup group, ConfigValueInstance instance) {
        this.groupSize = 1;
        return new ButtonNodeEntry(panel, instance);
    }

    protected class ButtonNodeEntry
    extends GuiEditConfig.ButtonConfigEntry {
        private final List<ContextMenuItem> contextItems;

        public ButtonNodeEntry(Panel panel, ConfigValueInstance i) {
            super(panel, null, i);
            this.contextItems = new ArrayList<ContextMenuItem>();
            ContextMenuItem item = new ContextMenuItem(StatCollector.func_74838_a((String)"selectServer.delete"), GuiIcons.REMOVE, () -> GuiEditRank.this.removeEntry(i.getId()));
            this.contextItems.add(item);
        }

        @Override
        protected void addDescriptionText(List<String> list) {
            super.addDescriptionText(list);
            if (StatCollector.func_94522_b((String)("permission." + this.inst.getId()))) {
                list.add(StatCollector.func_74838_a((String)("permission." + this.inst.getId())));
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            if (button.isLeft()) {
                super.onClicked(button);
            }
            if (button == MouseButton.RIGHT) {
                GuiEditRank.this.openContextMenu(this.contextItems);
            }
        }
    }
}

