/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui;

import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.Theme;
import serverutils.lib.gui.Widget;
import serverutils.lib.gui.WidgetType;
import serverutils.lib.math.MathUtils;
import serverutils.lib.util.misc.MouseButton;

public class ScrollBar
extends Widget {
    public final Plane plane;
    private int scrollBarSize;
    private int value = 0;
    private int scrollStep = 20;
    private int grab = -10000;
    private int minValue = 0;
    private int maxValue = 100;
    private boolean canAlwaysScroll = false;
    private boolean canAlwaysScrollPlane = true;

    public ScrollBar(Panel parent, Plane p, int ss) {
        super(parent);
        this.plane = p;
        this.scrollBarSize = Math.max(ss, 0);
    }

    public void setCanAlwaysScroll(boolean v) {
        this.canAlwaysScroll = v;
    }

    public void setCanAlwaysScrollPlane(boolean v) {
        this.canAlwaysScrollPlane = v;
    }

    public void setMinValue(int min) {
        this.minValue = min;
        this.setValue(this.getValue());
    }

    public int getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(int max) {
        this.maxValue = max;
        this.setValue(this.getValue());
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setScrollStep(int s) {
        this.scrollStep = Math.max(1, s);
    }

    public int getScrollBarSize() {
        return this.scrollBarSize;
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        if (this.isMouseOver()) {
            this.grab = this.plane.isVertical ? this.getMouseY() - (this.getY() + this.getValueI(this.height - this.getScrollBarSize())) : this.getMouseX() - (this.getX() + this.getValueI(this.width - this.getScrollBarSize()));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseScrolled(int scroll) {
        if (scroll != 0 && this.canMouseScrollPlane() && this.canMouseScroll()) {
            this.setValue(this.getValue() - this.getScrollStep() * scroll);
            return true;
        }
        return false;
    }

    @Override
    public void addMouseOverText(List<String> list) {
        if (this.showValueOnMouseOver()) {
            String t = this.getTitle();
            list.add(t.isEmpty() ? Integer.toString(this.getValue()) : t + ": " + this.getValue());
        }
        if (Theme.renderDebugBoxes) {
            list.add(EnumChatFormatting.DARK_GRAY + "Size: " + this.getScrollBarSize());
            list.add(EnumChatFormatting.DARK_GRAY + "Max: " + this.getMaxValue());
            list.add(EnumChatFormatting.DARK_GRAY + "Value: " + this.getValue());
        }
    }

    public boolean showValueOnMouseOver() {
        return false;
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        int scrollBarSize = this.getScrollBarSize();
        if (scrollBarSize > 0) {
            int v = this.getValue();
            if (this.grab != -10000) {
                if (ScrollBar.isMouseButtonDown(MouseButton.LEFT)) {
                    v = this.plane.isVertical ? (int)((double)((this.getMouseY() - (y + this.grab)) * this.getMaxValue()) / (double)(this.height - scrollBarSize)) : (int)((double)((this.getMouseX() - (x + this.grab)) * this.getMaxValue()) / (double)(this.width - scrollBarSize));
                } else {
                    this.grab = -10000;
                }
            }
            this.setValue(v);
        }
        this.drawBackground(theme, x, y, this.width, this.height);
        if (scrollBarSize > 0) {
            if (this.plane.isVertical) {
                this.drawScrollBar(theme, x, y + this.getValueI(this.height - scrollBarSize), this.width, scrollBarSize);
            } else {
                this.drawScrollBar(theme, x + this.getValueI(this.width - scrollBarSize), y, scrollBarSize, this.height);
            }
        }
    }

    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        theme.drawScrollBarBackground(x, y, w, h, this.getWidgetType());
    }

    public void drawScrollBar(Theme theme, int x, int y, int w, int h) {
        theme.drawScrollBar(x, y, w, h, WidgetType.mouseOver(this.grab != -10000), this.plane.isVertical);
    }

    public void onMoved() {
    }

    public boolean canMouseScrollPlane() {
        return this.canAlwaysScrollPlane || ScrollBar.isShiftKeyDown() != this.plane.isVertical;
    }

    public boolean canMouseScroll() {
        return this.canAlwaysScroll || this.isMouseOver();
    }

    public void setValue(int v) {
        if (this.value != (v = MathHelper.func_76125_a((int)v, (int)this.getMinValue(), (int)this.getMaxValue()))) {
            this.value = v;
            this.onMoved();
        }
    }

    public int getValue() {
        return this.value;
    }

    public int getValueI(int max) {
        return (int)MathUtils.map(this.getMinValue(), this.getMaxValue(), 0.0, max, this.value);
    }

    public int getScrollStep() {
        return this.scrollStep;
    }

    public static enum Plane {
        HORIZONTAL(false),
        VERTICAL(true);

        public final boolean isVertical;

        private Plane(boolean v) {
            this.isVertical = v;
        }
    }
}

