/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.math;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkCoordIntPair;

public class MathUtils {
    public static final Random RAND = new Random();
    public static final float[] NORMALS_X = new float[]{0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f};
    public static final float[] NORMALS_Y = new float[]{-1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
    public static final float[] NORMALS_Z = new float[]{0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f};
    public static final int[] ROTATION_X = new int[]{90, 270, 0, 0, 0, 0};
    public static final int[] ROTATION_Y = new int[]{0, 0, 180, 0, 90, 270};
    private static final AxisAlignedBB FULL_BLOCK = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    private static final AxisAlignedBB[] FULL_BLOCK_AABB_ROTATED_BOXES = new AxisAlignedBB[]{FULL_BLOCK, FULL_BLOCK, FULL_BLOCK, FULL_BLOCK, FULL_BLOCK, FULL_BLOCK};
    private static final int CACHED_SPIRAL_POINTS_SIZE = 81;
    private static ChunkCoordIntPair[] CACHED_SPIRAL_POINTS = null;

    public static boolean isNumberBetween(int num, int num1, int num2) {
        int min = Math.min(num1, num2);
        int max = Math.max(num1, num2);
        return num >= min && num <= max;
    }

    public static int getAxis(int x1, int y1, int z1, int x2, int y2, int z2) {
        int x = x1 - x2;
        int y = y1 - y2;
        int z = z1 - z2;
        if (x != 0 && y == 0 && z == 0) {
            return 0;
        }
        if (x == 0 && y != 0 && z == 0) {
            return 1;
        }
        if (x == 0 && y == 0 && z != 0) {
            return 2;
        }
        return 3;
    }

    public static boolean isPosBetween(int posx, int posy, int posz, int pos1x, int pos1y, int pos1z, int pos2x, int pos2y, int pos2z) {
        if (posx == pos1x && posy == pos1y && posz == pos1z) {
            return true;
        }
        if (posx == pos2x && posy == pos2y && posz == pos2z) {
            return true;
        }
        int x = pos1x - pos2x;
        int y = pos1y - pos2y;
        int z = pos1z - pos2z;
        if (x != 0 && y == 0 && z == 0) {
            return posy == pos1y && posz == pos1z && MathUtils.isNumberBetween(posx, pos1x, pos2x);
        }
        if (x == 0 && y != 0 && z == 0) {
            return posx == pos1x && posz == pos1z && MathUtils.isNumberBetween(posy, pos1y, pos2y);
        }
        if (x == 0 && y == 0 && z != 0) {
            return posx == pos1x && posy == pos1y && MathUtils.isNumberBetween(posz, pos1z, pos2z);
        }
        return false;
    }

    @Nullable
    public static EnumFacing getFacing(int x1, int y1, int z1, int x2, int y2, int z2) {
        int x = x2 - x1;
        int y = y2 - y1;
        int z = z2 - z1;
        if (x != 0 && y == 0 && z == 0) {
            return x > 0 ? EnumFacing.EAST : EnumFacing.WEST;
        }
        if (x == 0 && y != 0 && z == 0) {
            return y > 0 ? EnumFacing.UP : EnumFacing.DOWN;
        }
        if (x == 0 && y == 0 && z != 0) {
            return z > 0 ? EnumFacing.SOUTH : EnumFacing.NORTH;
        }
        return null;
    }

    public static double sq(double value) {
        return value * value;
    }

    public static double sqrt(double value) {
        return value == 0.0 || value == 1.0 ? value : Math.sqrt(value);
    }

    public static double sqrt2sq(double x, double y) {
        return MathUtils.sqrt(MathUtils.sq(x) + MathUtils.sq(y));
    }

    public static double sqrt3sq(double x, double y, double z) {
        return MathUtils.sqrt(MathUtils.sq(x) + MathUtils.sq(y) + MathUtils.sq(z));
    }

    public static double distSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        return x1 == x2 && y1 == y2 && z1 == z2 ? 0.0 : MathUtils.sq(x2 - x1) + MathUtils.sq(y2 - y1) + MathUtils.sq(z2 - z1);
    }

    public static double dist(double x1, double y1, double z1, double x2, double y2, double z2) {
        return MathUtils.sqrt(MathUtils.distSq(x1, y1, z1, x2, y2, z2));
    }

    public static double distSq(double x1, double y1, double x2, double y2) {
        return MathUtils.sq(x2 - x1) + MathUtils.sq(y2 - y1);
    }

    public static double dist(double x1, double y1, double x2, double y2) {
        return MathUtils.sqrt(MathUtils.distSq(x1, y1, x2, y2));
    }

    public static int chunk(int i) {
        return i >> 4;
    }

    public static int chunk(double d) {
        return MathUtils.chunk(MathHelper.func_76128_c((double)d));
    }

    public static boolean canParseInt(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean canParseDouble(@Nullable String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static float lerp(float min, float max, float value) {
        return min + (max - min) * value;
    }

    public static double lerp(double min, double max, double value) {
        return min + (max - min) * value;
    }

    public static Vec3 lerp(double x1, double y1, double z1, double x2, double y2, double z2, double value) {
        return Vec3.func_72443_a((double)MathUtils.lerp(x1, x2, value), (double)MathUtils.lerp(y1, y2, value), (double)MathUtils.lerp(z1, z2, value));
    }

    public static Vec3 lerp(Vec3 v1, Vec3 v2, double value) {
        return MathUtils.lerp(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, value);
    }

    public static double map(double min1, double max1, double min2, double max2, double value) {
        return MathUtils.lerp(min2, max2, (value - min1) / (max1 - min1));
    }

    public static double mod(double i, double n) {
        return (i %= n) < 0.0 ? i + n : i;
    }

    public static int mod(int i, int n) {
        return (i %= n) < 0 ? i + n : i;
    }

    @Nullable
    public static MovingObjectPosition rayTrace(Entity entity, double dist, boolean useLiquids) {
        Vec3 start = Vec3.func_72443_a((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)entity.func_70047_e()), (double)entity.field_70161_v);
        Vec3 look = entity.func_70040_Z();
        Vec3 end = start.func_72441_c(look.field_72450_a * dist, look.field_72448_b * dist, look.field_72449_c * dist);
        return entity.field_70170_p.func_147447_a(start, end, useLiquids, !useLiquids, false);
    }

    @Nullable
    public static MovingObjectPosition rayTrace(EntityPlayer player, boolean useLiquids) {
        double d;
        if (player.field_70170_p.field_72995_K) {
            d = Minecraft.func_71410_x().field_71442_b.func_78757_d();
        } else if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            d = playerMP.field_71134_c.getBlockReachDistance();
        } else {
            d = 5.0;
        }
        double playerReach = d;
        return MathUtils.rayTrace((Entity)player, playerReach, useLiquids);
    }

    @Nullable
    public static MovingObjectPosition collisionRayTrace(int posx, int posy, int posz, Vec3 start, Vec3 end, Iterable<AxisAlignedBB> boxes) {
        MovingObjectPosition result = null;
        double dist = Double.POSITIVE_INFINITY;
        int i = 0;
        for (AxisAlignedBB aabb : boxes) {
            double d1;
            MovingObjectPosition r = MathUtils.collisionRayTrace(posx, posy, posz, start, end, aabb, i, null);
            if (r != null && (d1 = r.field_72307_f.func_72436_e(start)) < dist) {
                result = r;
                dist = d1;
            }
            ++i;
        }
        return result;
    }

    @Nullable
    public static MovingObjectPosition collisionRayTrace(int posx, int posy, int posz, Vec3 start, Vec3 end, @Nullable AxisAlignedBB box, int subHit, @Nullable Object hitInfo) {
        if (box == null) {
            return null;
        }
        MovingObjectPosition result = box.func_72317_d((double)posx, (double)posy, (double)posz).func_72327_a(start, end);
        if (result == null) {
            return null;
        }
        result = new MovingObjectPosition(posx, posy, posz, result.field_72310_e, result.field_72307_f);
        result.subHit = subHit;
        result.hitInfo = hitInfo;
        return result;
    }

    @Nullable
    public static MovingObjectPosition collisionRayTrace(int posx, int posy, int posz, Vec3 start, Vec3 end, AxisAlignedBB box) {
        return MathUtils.collisionRayTrace(posx, posy, posz, start, end, box, -1, null);
    }

    public static AxisAlignedBB rotateAABB(AxisAlignedBB box, EnumFacing facing) {
        AxisAlignedBB axisAlignedBB;
        switch (facing) {
            case UP: {
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)(1.0 - box.field_72340_a), (double)(1.0 - box.field_72338_b), (double)(1.0 - box.field_72339_c), (double)(1.0 - box.field_72336_d), (double)(1.0 - box.field_72337_e), (double)(1.0 - box.field_72334_f));
                break;
            }
            case NORTH: {
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)box.field_72340_a, (double)box.field_72339_c, (double)box.field_72338_b, (double)box.field_72336_d, (double)box.field_72334_f, (double)box.field_72337_e);
                break;
            }
            case SOUTH: {
                box = MathUtils.rotateAABB(box, EnumFacing.NORTH);
                axisAlignedBB = AxisAlignedBB.func_72330_a((double)(1.0 - box.field_72340_a), (double)box.field_72338_b, (double)(1.0 - box.field_72339_c), (double)(1.0 - box.field_72336_d), (double)box.field_72337_e, (double)(1.0 - box.field_72334_f));
                break;
            }
            case WEST: {
                axisAlignedBB = MathUtils.rotateCW(MathUtils.rotateAABB(box, EnumFacing.SOUTH));
                break;
            }
            case EAST: {
                axisAlignedBB = MathUtils.rotateCW(MathUtils.rotateAABB(box, EnumFacing.NORTH));
                break;
            }
            default: {
                axisAlignedBB = box;
            }
        }
        return axisAlignedBB;
    }

    public static AxisAlignedBB rotateCW(AxisAlignedBB box) {
        return AxisAlignedBB.func_72330_a((double)(1.0 - box.field_72339_c), (double)box.field_72338_b, (double)box.field_72340_a, (double)(1.0 - box.field_72334_f), (double)box.field_72337_e, (double)box.field_72336_d);
    }

    public static AxisAlignedBB[] getRotatedBoxes(AxisAlignedBB box) {
        if (box.equals(FULL_BLOCK)) {
            return FULL_BLOCK_AABB_ROTATED_BOXES;
        }
        AxisAlignedBB[] boxes = new AxisAlignedBB[6];
        for (EnumFacing f : EnumFacing.field_82609_l) {
            boxes[f.field_82603_g] = MathUtils.rotateAABB(box, f);
        }
        return boxes;
    }

    public static boolean intersects(int ax1, int ay1, int ax2, int ay2, int bx1, int by1, int bx2, int by2) {
        return ax1 < bx2 && ax2 > bx1 && ay1 < by2 && ay2 > by1;
    }

    public static boolean intersects(double ax1, double ay1, double ax2, double ay2, double bx1, double by1, double bx2, double by2) {
        return ax1 < bx2 && ax2 > bx1 && ay1 < by2 && ay2 > by1;
    }

    public static ChunkCoordIntPair getSpiralPoint(int index) {
        if (index < 0) {
            index = 0;
        }
        if (index < 81) {
            if (CACHED_SPIRAL_POINTS == null) {
                CACHED_SPIRAL_POINTS = new ChunkCoordIntPair[81];
                for (int i = 0; i < 81; ++i) {
                    MathUtils.CACHED_SPIRAL_POINTS[i] = MathUtils.getSpiralPoint0(i);
                }
            }
            return CACHED_SPIRAL_POINTS[index];
        }
        return MathUtils.getSpiralPoint0(index);
    }

    public static ChunkCoordIntPair getSpiralPoint0(int index) {
        int x = 0;
        int z = 0;
        int p = 1;
        int ringIndex = 0;
        double sqrtceil = Math.ceil(Math.sqrt(index));
        int s = (int)(sqrtceil + (sqrtceil % 2.0 + 1.0) % 2.0);
        if (s > 1) {
            ringIndex = index - (s - 2) * (s - 2);
            p = s * s - (s - 2) * (s - 2);
        }
        int ri = (ringIndex + s / 2) % p;
        if (s > 1) {
            int n = ri < p / 4 ? ri : (ri <= p / 4 * 2 - 1 ? p / 4 : (x = ri <= p / 4 * 3 ? p / 4 * 3 - ri : 0));
        }
        if (s > 1) {
            z = ri < p / 4 ? 0 : (ri <= p / 4 * 2 - 1 ? ri - p / 4 : (ri <= p / 4 * 3 ? p / 4 : p - ri));
        }
        return new ChunkCoordIntPair(x - s / 2, z - s / 2);
    }
}

