/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import serverutils.client.gui.ranks.RankInst;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToServer;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.net.ServerUtilitiesNetHandler;
import serverutils.ranks.Rank;
import serverutils.ranks.Ranks;

public class MessageRankModify
extends MessageToServer {
    private RankInst inst;
    private Collection<String> removedEntries;

    public MessageRankModify() {
    }

    public MessageRankModify(RankInst rank, Collection<String> removedEntries) {
        this.inst = rank;
        this.removedEntries = removedEntries;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.FILES;
    }

    @Override
    public void writeData(DataOut data) {
        RankInst.SERIALIZER.write(data, this.inst);
        data.writeCollection(this.removedEntries, DataOut.STRING);
    }

    @Override
    public void readData(DataIn data) {
        this.inst = RankInst.DESERIALIZER.read(data);
        this.removedEntries = data.readCollection(DataIn.STRING);
    }

    @Override
    public void onMessage(EntityPlayerMP player) {
        if (!PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.admin_panel.ranks.view")) {
            return;
        }
        boolean shouldSave = false;
        Rank rank = Ranks.INSTANCE.getRank(this.inst.getId());
        if (rank == null) {
            player.func_145747_a((IChatComponent)new ChatComponentText("Rank: " + this.inst.getId() + " not found"));
            return;
        }
        for (ConfigValueInstance value : this.inst.group.getValues()) {
            if (rank.setPermission(value.getId(), value.getValue()) == null) continue;
            shouldSave = true;
        }
        for (String removed : this.removedEntries) {
            if (rank.setPermission(removed, "") == null) continue;
            shouldSave = true;
        }
        if (shouldSave) {
            Ranks.INSTANCE.save();
        }
    }
}

