/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilitiesConfig;
import serverutils.ServerUtilitiesPermissions;
import serverutils.client.gui.ranks.GuiRanks;
import serverutils.client.gui.ranks.RankInst;
import serverutils.data.NodeEntry;
import serverutils.lib.command.CommandUtils;
import serverutils.lib.config.ConfigBoolean;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.config.RankConfigValueInfo;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.permission.DefaultPermissionHandler;
import serverutils.lib.util.permission.DefaultPermissionLevel;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.net.ServerUtilitiesNetHandler;
import serverutils.ranks.CommandOverride;
import serverutils.ranks.PlayerRank;
import serverutils.ranks.Rank;
import serverutils.ranks.Ranks;

public class MessageRanks
extends MessageToClient {
    private Collection<RankInst> ranks;
    private Map<String, RankInst> playerRanks;
    private static ConfigGroup allPermissions;
    private static ConfigGroup commandPermissions;

    public MessageRanks() {
    }

    public MessageRanks(Ranks r, ForgePlayer p) {
        this.ranks = new ArrayList<RankInst>();
        for (Rank rank : r.ranks.values()) {
            ConfigGroup group = ConfigGroup.newGroup("");
            ChatComponentText name = new ChatComponentText(EnumChatFormatting.BOLD + StringUtils.firstUppercase(rank.getId()));
            group.setDisplayName((IChatComponent)name);
            RankInst inst = new RankInst(rank.getId());
            for (Rank.Entry entry : rank.permissions.values()) {
                String permissionNode = entry.node;
                ConfigValue val = rank.getPermissionValue(permissionNode);
                ConfigValue defaultValue = RankConfigAPI.getConfigValue(permissionNode, false);
                if (ServerUtilitiesConfig.ranks.override_commands && permissionNode.startsWith("command.")) {
                    CommandOverride cmd = Ranks.INSTANCE.commands.get(permissionNode);
                    if (cmd == null) continue;
                    defaultValue = new ConfigBoolean(cmd.func_82362_a() == 0);
                    group.add(permissionNode, val, defaultValue, 30).setDisplayName((IChatComponent)new ChatComponentTranslation(permissionNode, new Object[0])).setInfo(CommandUtils.getTranslatedUsage((ICommand)cmd, (ICommandSender)p.getPlayer()));
                    continue;
                }
                group.add(permissionNode, val, defaultValue, 30).setDisplayName((IChatComponent)new ChatComponentTranslation(permissionNode, new Object[0]));
            }
            inst.group = group;
            Iterator<Rank> parents = new HashSet<String>();
            for (Rank rs : rank.getParents()) {
                parents.add((Rank)((Object)rs.getId()));
            }
            inst.parents = parents;
            this.ranks.add(inst);
        }
        this.playerRanks = new HashMap<String, RankInst>();
        for (ForgePlayer player : r.universe.getPlayers()) {
            RankInst inst = new RankInst(player.getProfile().getId().toString());
            boolean isOp = ServerUtils.isOP(null, player.getProfile());
            inst.group = ConfigGroup.newGroup(player.getName());
            inst.group.add("is_op", new ConfigBoolean(isOp), null).setExcluded(true);
            inst.player = player.getName();
            PlayerRank pRank = r.getPlayerRank(player.getProfile());
            for (Rank rank : pRank.getActualParents()) {
                inst.parents.add(rank.getId());
            }
            this.playerRanks.put(player.getName(), inst);
        }
        if (allPermissions == null) {
            allPermissions = ConfigGroup.newGroup("");
            for (RankConfigValueInfo info : RankConfigAPI.getHandler().getRegisteredConfigs()) {
                allPermissions.add(info.node, info.defaultValue, info.defaultValue, 30).setDisplayName((IChatComponent)new ChatComponentTranslation(info.node, new Object[0]));
            }
            for (String node : PermissionAPI.getPermissionHandler().getRegisteredNodes()) {
                DefaultPermissionLevel level = DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(node);
                String desc = PermissionAPI.getPermissionHandler().getNodeDescription(node);
                boolean printNode = true;
                for (NodeEntry nodeEntry : ServerUtilitiesPermissions.getPrefixesExcluding("serverutilities.leaderboard.")) {
                    if (!node.startsWith(nodeEntry.getNode())) continue;
                    if (nodeEntry.level == null || level != nodeEntry.level || !desc.isEmpty()) break;
                    printNode = false;
                    break;
                }
                if (!printNode) continue;
                ConfigBoolean val = new ConfigBoolean(level == DefaultPermissionLevel.ALL);
                allPermissions.add(node, val, val, 30).setDisplayName((IChatComponent)new ChatComponentTranslation(node, new Object[0]));
            }
        }
        if (commandPermissions == null) {
            commandPermissions = ConfigGroup.newGroup("");
            if (ServerUtilitiesConfig.ranks.override_commands) {
                for (CommandOverride command : Ranks.INSTANCE.commands.values()) {
                    String commandNode = command.node;
                    ConfigBoolean val = new ConfigBoolean(command.func_82362_a() == 0);
                    commandPermissions.add(commandNode, val, val, 30).setDisplayName((IChatComponent)new ChatComponentTranslation(commandNode, new Object[0])).setInfo(CommandUtils.getTranslatedUsage((ICommand)command, (ICommandSender)p.getPlayer()));
                }
            }
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.FILES;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeCollection(this.ranks, RankInst.SERIALIZER);
        data.writeMap(this.playerRanks, DataOut.STRING, RankInst.SERIALIZER);
        ConfigGroup.SERIALIZER.write(data, allPermissions);
        ConfigGroup.SERIALIZER.write(data, commandPermissions);
    }

    @Override
    public void readData(DataIn data) {
        this.ranks = data.readCollection(RankInst.DESERIALIZER);
        this.playerRanks = data.readMap(DataIn.STRING, RankInst.DESERIALIZER);
        allPermissions = ConfigGroup.DESERIALIZER.read(data);
        commandPermissions = ConfigGroup.DESERIALIZER.read(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        new GuiRanks(this.ranks, this.playerRanks, allPermissions, commandPermissions).openGui();
    }
}

