/*
 * Decompiled with CFR 0.152.
 */
package serverutils.ranks;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.eventhandler.Event;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesCommon;
import serverutils.ServerUtilitiesConfig;
import serverutils.data.BackwardsCompat;
import serverutils.data.NodeEntry;
import serverutils.lib.config.ConfigNull;
import serverutils.lib.config.ConfigValue;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.config.RankConfigValueInfo;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.Universe;
import serverutils.lib.io.DataReader;
import serverutils.lib.util.FileUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.permission.DefaultPermissionHandler;
import serverutils.lib.util.permission.DefaultPermissionLevel;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.ranks.CommandOverride;
import serverutils.ranks.PlayerRank;
import serverutils.ranks.Rank;
import serverutils.ranks.ServerUtilitiesPermissionHandler;

public class Ranks {
    public static Ranks INSTANCE;
    public static Pattern RANK_NAME_PATTERN;
    public final Universe universe;
    public final Map<String, Rank> ranks;
    private Collection<String> rankNames;
    private Collection<String> permissionNodes;
    public final Map<UUID, PlayerRank> playerRanks;
    private Optional<Rank> defaultPlayerRank;
    private Optional<Rank> defaultOPRank;
    public final Map<String, CommandOverride> commands;
    private File ranksFile;
    private File playersFile;

    public static boolean isActive() {
        return ServerUtilitiesConfig.ranks.enabled && INSTANCE != null && PermissionAPI.getPermissionHandler() == ServerUtilitiesPermissionHandler.INSTANCE;
    }

    public static boolean isValidName(@Nullable String id) {
        return id != null && !id.isEmpty() && !id.equals("none") && RANK_NAME_PATTERN.matcher(id).matches();
    }

    public Ranks(Universe u) {
        this.universe = u;
        this.ranks = new LinkedHashMap<String, Rank>();
        this.rankNames = null;
        this.permissionNodes = null;
        this.playerRanks = new LinkedHashMap<UUID, PlayerRank>();
        this.defaultPlayerRank = null;
        this.defaultOPRank = null;
        this.commands = new LinkedHashMap<String, CommandOverride>();
        this.ranksFile = null;
        this.playersFile = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean reload() {
        Rank.Entry entry;
        String value;
        String[] s1;
        String s;
        UUID rankUUID;
        String rankID;
        String[] extendss;
        String[] iss;
        String linein;
        this.ranks.clear();
        this.playerRanks.clear();
        this.clearCache();
        if (!Ranks.isActive()) {
            return true;
        }
        boolean save = false;
        this.ranksFile = this.universe.server.func_71209_f("serverutilities/server/ranks.txt");
        if (!this.ranksFile.exists()) {
            Rank pRank = new Rank(this, "player");
            pRank.add();
            pRank.setPermission("default_player_rank", true);
            pRank.setPermission("priority", 1);
            pRank.setPermission("serverutilities.claims.max_chunks", 100);
            pRank.setPermission("serverutilities.chunkloader.max_chunks", 50);
            pRank.setPermission("serverutilities.homes.max", 1);
            pRank.setPermission("serverutilities.homes.warmup", "5s");
            pRank.setPermission("serverutilities.homes.cooldown", "5s");
            pRank.setPermission("serverutilities.chunkloader.decay", "2w");
            pRank.setPermission("example.permission", true);
            pRank.setPermission("example.other_permission", false);
            pRank.setPermission("example.permission_with_value", 0);
            Rank vRank = new Rank(this, "vip");
            vRank.add();
            vRank.setPermission("priority", 20);
            vRank.setPermission("serverutilities.chat.name_format", "<&bVIP {name}&r>");
            vRank.setPermission("serverutilities.claims.max_chunks", 500);
            vRank.setPermission("serverutilities.chunkloader.max_chunks", 100);
            vRank.setPermission("serverutilities.homes.max", 25);
            vRank.setPermission("serverutilities.homes.warmup", "0s");
            vRank.setPermission("serverutilities.homes.cooldown", "1s");
            vRank.setPermission("serverutilities.homes.cross_dim", true);
            vRank.setPermission("example.other_permission", true);
            vRank.setPermission("example.permission_with_value", 15);
            Rank aRank = new Rank(this, "admin");
            aRank.add();
            aRank.setPermission("default_op_rank", true);
            aRank.setPermission("priority", 100);
            aRank.setPermission("serverutilities.chat.name_format", "<&2{name}&r>");
            aRank.setPermission("serverutilities.claims.max_chunks", 5000);
            aRank.setPermission("serverutilities.chunkloader.max_chunks", 1000);
            aRank.setPermission("serverutilities.claims.bypass_limits", true);
            aRank.setPermission("serverutilities.homes.max", 100);
            aRank.setPermission("serverutilities.homes.warmup", "0s");
            aRank.setPermission("serverutilities.homes.cooldown", "0s");
            aRank.setPermission("serverutilities.homes.cross_dim", true);
            aRank.setPermission("example.permission_with_value", 100);
            if (this.universe.shouldLoadLatmod()) {
                BackwardsCompat.loadRanks(pRank, aRank);
            }
            PlayerRank playerRank = new PlayerRank(this, UUID.fromString("069be141-3c1b-45c3-b3b1-60d3f9fcd236"), "FakeForgePlayer");
            playerRank.add();
            playerRank.addParent(vRank);
            playerRank.setPermission("example.permission_with_value", 150);
            save = true;
        }
        Rank currentRank = null;
        String lastComment = "";
        for (String string : DataReader.get(this.ranksFile).safeStringList()) {
            if (string.isEmpty()) {
                lastComment = "";
                continue;
            }
            if (string.startsWith("//")) {
                lastComment = string.substring(2).trim();
                continue;
            }
            if (string.startsWith("[") && string.endsWith("]")) {
                block31: {
                    linein = string.substring(1, string.length() - 1);
                    if (linein.isEmpty()) {
                        currentRank = null;
                        continue;
                    }
                    iss = linein.split(" is ", 2);
                    extendss = iss[0].split(" extends ", 2);
                    rankID = StringUtils.removeAllWhitespace(extendss[0]);
                    if (rankID.isEmpty()) {
                        currentRank = null;
                        continue;
                    }
                    rankUUID = StringUtils.fromString(rankID);
                    currentRank = rankUUID != null && this.universe.getPlayer(rankUUID) != null ? this.getPlayerRank(this.universe.getPlayer(rankUUID).getProfile()) : new Rank(this, rankID);
                    currentRank.comment = lastComment;
                    lastComment = "";
                    if (!currentRank.isPlayer()) {
                        if (Ranks.isValidName(currentRank.getId())) {
                            currentRank.add();
                            currentRank.setPermission("priority", String.valueOf(this.ranks.size()));
                            break block31;
                        } else {
                            currentRank = null;
                            continue;
                        }
                    }
                    save = true;
                }
                if (extendss.length == 2) {
                    currentRank.setPermission("parent", StringUtils.removeAllWhitespace(extendss[1]));
                    save = true;
                }
                if (iss.length != 2) continue;
                for (String tag : iss[1].split(",")) {
                    s = StringUtils.removeAllWhitespace(tag);
                    if (s.isEmpty()) continue;
                    currentRank.setPermission(s, true);
                    save = true;
                }
                continue;
            }
            if (currentRank == null) continue;
            s1 = string.split(":", 2);
            if (s1.length == 2) {
                value = s1[1].trim();
                if (value.length() > 2 && value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                    save = true;
                }
                if (!value.isEmpty() && (entry = currentRank.setPermission(s1[0].trim(), value)) != null) {
                    entry.comment = lastComment;
                }
            }
            lastComment = "";
        }
        this.playersFile = this.universe.server.func_71209_f("serverutilities/server/players.txt");
        currentRank = null;
        lastComment = "";
        for (String string : DataReader.get(this.playersFile).safeStringList()) {
            if (string.isEmpty()) {
                lastComment = "";
                continue;
            }
            if (string.startsWith("//")) {
                lastComment = string.substring(2).trim();
                continue;
            }
            if (string.startsWith("[") && string.endsWith("]")) {
                linein = string.substring(1, string.length() - 1);
                if (linein.isEmpty()) {
                    currentRank = null;
                    continue;
                }
                iss = linein.split(" is ", 2);
                extendss = iss[0].split(" extends ", 2);
                rankID = StringUtils.removeAllWhitespace(extendss[0]);
                if (rankID.isEmpty()) {
                    currentRank = null;
                    continue;
                }
                rankUUID = StringUtils.fromString(rankID);
                currentRank = rankUUID != null && this.universe.getPlayer(rankUUID) != null ? this.getPlayerRank(this.universe.getPlayer(rankUUID).getProfile()) : new Rank(this, rankID);
                currentRank.comment = lastComment;
                lastComment = "";
                if (!currentRank.isPlayer()) {
                    if (Ranks.isValidName(currentRank.getId())) {
                        currentRank.add();
                        currentRank.setPermission("priority", String.valueOf(this.ranks.size()));
                    } else {
                        currentRank = null;
                        continue;
                    }
                }
                if (extendss.length == 2) {
                    currentRank.setPermission("parent", StringUtils.removeAllWhitespace(extendss[1]));
                    save = true;
                }
                if (iss.length != 2) continue;
                for (String tag : iss[1].split(",")) {
                    s = StringUtils.removeAllWhitespace(tag);
                    if (s.isEmpty()) continue;
                    currentRank.setPermission(s, true);
                    save = true;
                }
                continue;
            }
            if (currentRank == null) continue;
            s1 = string.split(":", 2);
            if (s1.length == 2 && !(value = s1[1].trim()).isEmpty() && (entry = currentRank.setPermission(s1[0].trim(), value)) != null) {
                entry.comment = lastComment;
            }
            lastComment = "";
        }
        for (Rank rank : this.playerRanks.values()) {
            if (rank.setPermission("priority", "") == null) continue;
            save = true;
        }
        if (save) {
            this.save();
        }
        return true;
    }

    public void save() {
        this.universe.clearCache();
        ArrayList<String> list = new ArrayList<String>();
        list.add("// For more info visit https://github.com/GTNewHorizons/ServerUtilities");
        for (Rank rank : this.ranks.values()) {
            if (rank.permissions.isEmpty()) continue;
            list.add("");
            if (!rank.comment.isEmpty()) {
                list.add("// " + rank.comment);
            }
            list.add("[" + rank.getId() + "]");
            for (Rank.Entry entry : rank.permissions.values()) {
                if (!entry.comment.isEmpty()) {
                    list.add("// " + entry.comment);
                }
                list.add(entry.node + ": " + entry.value);
            }
        }
        FileUtils.saveSafe(this.ranksFile, list);
        list = new ArrayList();
        list.add("// For more info visit https://github.com/GTNewHorizons/ServerUtilities");
        for (Rank rank : this.playerRanks.values()) {
            if (rank.permissions.isEmpty()) continue;
            list.add("");
            if (!rank.comment.isEmpty()) {
                list.add("// " + rank.comment);
            }
            list.add("[" + rank.getId() + "]");
            for (Rank.Entry entry : rank.permissions.values()) {
                if (!entry.comment.isEmpty()) {
                    list.add("// " + entry.comment);
                }
                list.add(entry.node + ": " + entry.value);
            }
        }
        FileUtils.saveSafe(this.playersFile, list);
    }

    public Rank getRank(ICommandSender sender, String id) throws CommandException {
        if (id.startsWith("@")) {
            return this.getPlayerRank((EntityPlayer)CommandBase.func_82359_c((ICommandSender)sender, (String)id));
        }
        Rank r = this.getRank(id);
        if (r == null) {
            throw ServerUtilities.error(sender, "commands.ranks.not_found", id);
        }
        return r;
    }

    @Nullable
    public Rank getRank(String id) {
        ForgePlayer player;
        if (id.isEmpty() || id.equals("none")) {
            return null;
        }
        Rank rank = this.ranks.get(id);
        if (rank == null && (player = this.universe.getPlayer(id)) != null) {
            return this.getPlayerRank(player.getProfile());
        }
        return rank;
    }

    @Nullable
    public Rank getDefaultPlayerRank() {
        if (this.defaultPlayerRank == null) {
            for (Rank rank : this.ranks.values()) {
                if (!rank.isDefaultPlayerRank()) continue;
                this.defaultPlayerRank = Optional.of(rank);
                return rank;
            }
            int priority = Integer.MAX_VALUE;
            for (Rank rank : this.ranks.values()) {
                if (rank.getPriority() > priority) continue;
                priority = rank.getPriority();
                this.defaultPlayerRank = Optional.of(rank);
            }
            if (this.defaultPlayerRank == null) {
                this.defaultPlayerRank = Optional.empty();
            }
        }
        return this.defaultPlayerRank.orElse(null);
    }

    @Nullable
    public Rank getDefaultOPRank() {
        if (this.defaultOPRank == null) {
            for (Rank rank : this.ranks.values()) {
                if (!rank.isDefaultOPRank()) continue;
                this.defaultOPRank = Optional.of(rank);
                return rank;
            }
            int priority = 0;
            for (Rank rank : this.ranks.values()) {
                if (rank.getPriority() < priority) continue;
                priority = rank.getPriority();
                this.defaultOPRank = Optional.of(rank);
            }
            if (this.defaultOPRank == null) {
                this.defaultOPRank = Optional.empty();
            }
        }
        return this.defaultOPRank.orElse(null);
    }

    public PlayerRank getPlayerRank(GameProfile profile) {
        UUID id = profile.getId();
        if (id == null) {
            throw new NullPointerException("Null UUID in profile " + profile.getName() + "!");
        }
        PlayerRank rank = this.playerRanks.get(id);
        if (rank == null) {
            rank = new PlayerRank(this, id, profile.getName() == null ? "" : profile.getName());
            rank.add();
        }
        return rank;
    }

    public PlayerRank getPlayerRank(EntityPlayer player) {
        return this.getPlayerRank(player.func_146103_bH());
    }

    public ConfigValue getPermission(GameProfile profile, String node, boolean recursive) {
        if (!Ranks.isActive() || profile.getId() == null) {
            return ConfigNull.INSTANCE;
        }
        return this.getPlayerRank(profile).getPermissionValue(node, node, recursive);
    }

    public ConfigValue getPermission(EntityPlayerMP player, String node, boolean recursive) {
        return this.getPermission(player.func_146103_bH(), node, recursive);
    }

    public Event.Result getPermissionResult(GameProfile profile, String node, boolean recursive) {
        ConfigValue value = this.getPermission(profile, node, recursive);
        return value.isNull() ? Event.Result.DEFAULT : (value.getBoolean() ? Event.Result.ALLOW : Event.Result.DENY);
    }

    public Event.Result getPermissionResult(EntityPlayerMP player, String node, boolean recursive) {
        return this.getPermissionResult(player.func_146103_bH(), node, recursive);
    }

    public Collection<String> getPermissionNodes() {
        if (this.permissionNodes == null) {
            this.permissionNodes = new LinkedHashSet<String>();
            for (String s : ServerUtilitiesPermissionHandler.INSTANCE.getRegisteredNodes()) {
                DefaultPermissionLevel level = DefaultPermissionHandler.INSTANCE.getDefaultPermissionLevel(s);
                String desc = DefaultPermissionHandler.INSTANCE.getNodeDescription(s);
                boolean printNode = true;
                for (NodeEntry entry : ServerUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY) {
                    if (!s.startsWith(entry.getNode())) continue;
                    if (entry.level == null || level != entry.level || !desc.isEmpty()) break;
                    printNode = false;
                    break;
                }
                if (!printNode) continue;
                this.permissionNodes.add(s);
            }
            for (NodeEntry entry : ServerUtilitiesCommon.CUSTOM_PERM_PREFIX_REGISTRY) {
                this.permissionNodes.add(entry.node);
            }
            for (RankConfigValueInfo info : RankConfigAPI.getHandler().getRegisteredConfigs()) {
                this.permissionNodes.add(info.node);
            }
            this.permissionNodes.addAll(this.commands.keySet());
            this.permissionNodes = Arrays.asList(this.permissionNodes.toArray(StringUtils.EMPTY_ARRAY));
        }
        return this.permissionNodes;
    }

    public Collection<String> getRankNames(boolean includeNone) {
        if (!includeNone) {
            return this.ranks.keySet();
        }
        if (this.rankNames == null) {
            this.rankNames = new ArrayList<String>(this.ranks.keySet());
            this.rankNames.add("none");
            this.rankNames = Arrays.asList(this.rankNames.toArray(StringUtils.EMPTY_ARRAY));
        }
        return this.rankNames;
    }

    public void clearCache() {
        this.rankNames = null;
        this.permissionNodes = null;
        this.defaultPlayerRank = null;
        this.defaultOPRank = null;
        for (Rank rank : this.ranks.values()) {
            rank.clearCache();
        }
        for (PlayerRank playerRank : this.playerRanks.values()) {
            playerRank.clearCache();
        }
    }

    public static List<String> matchPossibleNodes(String last, Collection<String> nodes) {
        HashSet<String> s = new HashSet<String>();
        for (String node : nodes) {
            int i;
            if (!node.startsWith(last)) continue;
            for (i = last.length(); i < node.length() && node.charAt(i) != '.'; ++i) {
            }
            ServerUtilities.LOGGER.info((Object)i);
            s.add(node.substring(0, i));
        }
        return new ArrayList<String>(s);
    }

    static {
        RANK_NAME_PATTERN = Pattern.compile("^[a-z0-9_]+$");
    }
}

