/*
 * Decompiled with CFR 0.152.
 */
package remoteio.common.item;

import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import remoteio.common.core.TabRemoteIO;
import remoteio.common.lib.DimensionalCoords;
import remoteio.common.lib.ModInfo;
import remoteio.common.tile.TileRemoteInterface;
import remoteio.common.tile.TileRemoteInventory;

public final class ItemLocationChip
extends Item {
    public ItemLocationChip() {
        this.func_77625_d(1);
        this.func_77637_a(TabRemoteIO.TAB);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean debug) {
        DimensionalCoords coords = ItemLocationChip.getCoordinates(stack);
        if (coords != null) {
            list.add("Dimension: " + DimensionManager.getProvider((int)coords.dimensionID).func_80007_l());
            list.add("X: " + coords.x + " Y: " + coords.y + " Z: " + coords.z);
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntity tile = world.func_147438_o(x, y, z);
            if (player.func_70093_af() && !(tile instanceof TileRemoteInterface) && !(tile instanceof TileRemoteInventory)) {
                ItemLocationChip.setCoordinates(stack, new DimensionalCoords(world.field_73011_w.field_76574_g, x, y, z));
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.target.save", new Object[0]));
                return true;
            }
            if (tile != null && tile instanceof TileRemoteInterface && !((TileRemoteInterface)tile).locked) {
                DimensionalCoords coords = ItemLocationChip.getCoordinates(stack);
                if (coords != null) {
                    ((TileRemoteInterface)tile).setRemotePosition(coords);
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.target.load", new Object[0]));
                }
                return true;
            }
        }
        return false;
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(ModInfo.RESOURCE_PREFIX + "chip");
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    public static void setCoordinates(ItemStack stack, DimensionalCoords coords) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        NBTTagCompound tag = new NBTTagCompound();
        coords.writeToNBT(tag);
        nbt.func_74782_a("position", (NBTBase)tag);
        stack.func_77982_d(nbt);
    }

    public static DimensionalCoords getCoordinates(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (!nbt.func_74764_b("position")) {
            return null;
        }
        return DimensionalCoords.fromNBT(nbt.func_74775_l("position"));
    }
}

