/*
 * Decompiled with CFR 0.152.
 */
package api.player.server;

import api.player.server.IServerPlayer;
import api.player.server.ServerPlayerAPI;
import com.mojang.authlib.GameProfile;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ItemInWorldManager;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.DamageSource;
import net.minecraft.world.WorldServer;

public abstract class ServerPlayerBase {
    protected final EntityPlayerMP player;
    protected final IServerPlayer playerAPI;
    private final ServerPlayerAPI internalServerPlayerAPI;

    public ServerPlayerBase(ServerPlayerAPI playerAPI) {
        this.internalServerPlayerAPI = playerAPI;
        this.playerAPI = playerAPI.player;
        this.player = playerAPI.player.getEntityPlayerMP();
    }

    public void beforeBaseAttach(boolean onTheFly) {
    }

    public void afterBaseAttach(boolean onTheFly) {
    }

    public void beforeLocalConstructing(MinecraftServer paramMinecraftServer, WorldServer paramWorldServer, GameProfile paramGameProfile, ItemInWorldManager paramItemInWorldManager) {
    }

    public void afterLocalConstructing(MinecraftServer paramMinecraftServer, WorldServer paramWorldServer, GameProfile paramGameProfile, ItemInWorldManager paramItemInWorldManager) {
    }

    public void beforeBaseDetach(boolean onTheFly) {
    }

    public void afterBaseDetach(boolean onTheFly) {
    }

    public Object dynamic(String key, Object[] parameters) {
        return this.internalServerPlayerAPI.dynamicOverwritten(key, parameters, this);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void beforeAddExhaustion(float paramFloat) {
    }

    public void addExhaustion(float paramFloat) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenAddExhaustion(this);
        if (overwritten == null) {
            this.playerAPI.localAddExhaustion(paramFloat);
        } else if (overwritten != this) {
            overwritten.addExhaustion(paramFloat);
        }
    }

    public void afterAddExhaustion(float paramFloat) {
    }

    public void beforeAddExperience(int paramInt) {
    }

    public void addExperience(int paramInt) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenAddExperience(this);
        if (overwritten == null) {
            this.playerAPI.localAddExperience(paramInt);
        } else if (overwritten != this) {
            overwritten.addExperience(paramInt);
        }
    }

    public void afterAddExperience(int paramInt) {
    }

    public void beforeAddExperienceLevel(int paramInt) {
    }

    public void addExperienceLevel(int paramInt) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenAddExperienceLevel(this);
        if (overwritten == null) {
            this.playerAPI.localAddExperienceLevel(paramInt);
        } else if (overwritten != this) {
            overwritten.addExperienceLevel(paramInt);
        }
    }

    public void afterAddExperienceLevel(int paramInt) {
    }

    public void beforeAddMovementStat(double paramDouble1, double paramDouble2, double paramDouble3) {
    }

    public void addMovementStat(double paramDouble1, double paramDouble2, double paramDouble3) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenAddMovementStat(this);
        if (overwritten == null) {
            this.playerAPI.localAddMovementStat(paramDouble1, paramDouble2, paramDouble3);
        } else if (overwritten != this) {
            overwritten.addMovementStat(paramDouble1, paramDouble2, paramDouble3);
        }
    }

    public void afterAddMovementStat(double paramDouble1, double paramDouble2, double paramDouble3) {
    }

    public void beforeAttackEntityFrom(DamageSource paramDamageSource, float paramFloat) {
    }

    public boolean attackEntityFrom(DamageSource paramDamageSource, float paramFloat) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenAttackEntityFrom(this);
        boolean _result = overwritten == null ? this.playerAPI.localAttackEntityFrom(paramDamageSource, paramFloat) : (overwritten != this ? overwritten.attackEntityFrom(paramDamageSource, paramFloat) : false);
        return _result;
    }

    public void afterAttackEntityFrom(DamageSource paramDamageSource, float paramFloat) {
    }

    public void beforeAttackTargetEntityWithCurrentItem(Entity paramEntity) {
    }

    public void attackTargetEntityWithCurrentItem(Entity paramEntity) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenAttackTargetEntityWithCurrentItem(this);
        if (overwritten == null) {
            this.playerAPI.localAttackTargetEntityWithCurrentItem(paramEntity);
        } else if (overwritten != this) {
            overwritten.attackTargetEntityWithCurrentItem(paramEntity);
        }
    }

    public void afterAttackTargetEntityWithCurrentItem(Entity paramEntity) {
    }

    public void beforeCanBreatheUnderwater() {
    }

    public boolean canBreatheUnderwater() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenCanBreatheUnderwater(this);
        boolean _result = overwritten == null ? this.playerAPI.localCanBreatheUnderwater() : (overwritten != this ? overwritten.canBreatheUnderwater() : false);
        return _result;
    }

    public void afterCanBreatheUnderwater() {
    }

    public void beforeCanHarvestBlock(Block paramBlock) {
    }

    public boolean canHarvestBlock(Block paramBlock) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenCanHarvestBlock(this);
        boolean _result = overwritten == null ? this.playerAPI.localCanHarvestBlock(paramBlock) : (overwritten != this ? overwritten.canHarvestBlock(paramBlock) : false);
        return _result;
    }

    public void afterCanHarvestBlock(Block paramBlock) {
    }

    public void beforeCanPlayerEdit(int paramInt1, int paramInt2, int paramInt3, int paramInt4, ItemStack paramItemStack) {
    }

    public boolean canPlayerEdit(int paramInt1, int paramInt2, int paramInt3, int paramInt4, ItemStack paramItemStack) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenCanPlayerEdit(this);
        boolean _result = overwritten == null ? this.playerAPI.localCanPlayerEdit(paramInt1, paramInt2, paramInt3, paramInt4, paramItemStack) : (overwritten != this ? overwritten.canPlayerEdit(paramInt1, paramInt2, paramInt3, paramInt4, paramItemStack) : false);
        return _result;
    }

    public void afterCanPlayerEdit(int paramInt1, int paramInt2, int paramInt3, int paramInt4, ItemStack paramItemStack) {
    }

    public void beforeCanTriggerWalking() {
    }

    public boolean canTriggerWalking() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenCanTriggerWalking(this);
        boolean _result = overwritten == null ? this.playerAPI.localCanTriggerWalking() : (overwritten != this ? overwritten.canTriggerWalking() : false);
        return _result;
    }

    public void afterCanTriggerWalking() {
    }

    public void beforeClonePlayer(EntityPlayer paramEntityPlayer, boolean paramBoolean) {
    }

    public void clonePlayer(EntityPlayer paramEntityPlayer, boolean paramBoolean) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenClonePlayer(this);
        if (overwritten == null) {
            this.playerAPI.localClonePlayer(paramEntityPlayer, paramBoolean);
        } else if (overwritten != this) {
            overwritten.clonePlayer(paramEntityPlayer, paramBoolean);
        }
    }

    public void afterClonePlayer(EntityPlayer paramEntityPlayer, boolean paramBoolean) {
    }

    public void beforeDamageEntity(DamageSource paramDamageSource, float paramFloat) {
    }

    public void damageEntity(DamageSource paramDamageSource, float paramFloat) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenDamageEntity(this);
        if (overwritten == null) {
            this.playerAPI.localDamageEntity(paramDamageSource, paramFloat);
        } else if (overwritten != this) {
            overwritten.damageEntity(paramDamageSource, paramFloat);
        }
    }

    public void afterDamageEntity(DamageSource paramDamageSource, float paramFloat) {
    }

    public void beforeDisplayGUIChest(IInventory paramIInventory) {
    }

    public void displayGUIChest(IInventory paramIInventory) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenDisplayGUIChest(this);
        if (overwritten == null) {
            this.playerAPI.localDisplayGUIChest(paramIInventory);
        } else if (overwritten != this) {
            overwritten.displayGUIChest(paramIInventory);
        }
    }

    public void afterDisplayGUIChest(IInventory paramIInventory) {
    }

    public void beforeDisplayGUIDispenser(TileEntityDispenser paramTileEntityDispenser) {
    }

    public void displayGUIDispenser(TileEntityDispenser paramTileEntityDispenser) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenDisplayGUIDispenser(this);
        if (overwritten == null) {
            this.playerAPI.localDisplayGUIDispenser(paramTileEntityDispenser);
        } else if (overwritten != this) {
            overwritten.displayGUIDispenser(paramTileEntityDispenser);
        }
    }

    public void afterDisplayGUIDispenser(TileEntityDispenser paramTileEntityDispenser) {
    }

    public void beforeDisplayGUIFurnace(TileEntityFurnace paramTileEntityFurnace) {
    }

    public void displayGUIFurnace(TileEntityFurnace paramTileEntityFurnace) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenDisplayGUIFurnace(this);
        if (overwritten == null) {
            this.playerAPI.localDisplayGUIFurnace(paramTileEntityFurnace);
        } else if (overwritten != this) {
            overwritten.displayGUIFurnace(paramTileEntityFurnace);
        }
    }

    public void afterDisplayGUIFurnace(TileEntityFurnace paramTileEntityFurnace) {
    }

    public void beforeDisplayGUIWorkbench(int paramInt1, int paramInt2, int paramInt3) {
    }

    public void displayGUIWorkbench(int paramInt1, int paramInt2, int paramInt3) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenDisplayGUIWorkbench(this);
        if (overwritten == null) {
            this.playerAPI.localDisplayGUIWorkbench(paramInt1, paramInt2, paramInt3);
        } else if (overwritten != this) {
            overwritten.displayGUIWorkbench(paramInt1, paramInt2, paramInt3);
        }
    }

    public void afterDisplayGUIWorkbench(int paramInt1, int paramInt2, int paramInt3) {
    }

    public void beforeDropOneItem(boolean paramBoolean) {
    }

    public EntityItem dropOneItem(boolean paramBoolean) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenDropOneItem(this);
        Object _result = overwritten == null ? this.playerAPI.localDropOneItem(paramBoolean) : (overwritten != this ? overwritten.dropOneItem(paramBoolean) : null);
        return _result;
    }

    public void afterDropOneItem(boolean paramBoolean) {
    }

    public void beforeDropPlayerItem(ItemStack paramItemStack, boolean paramBoolean) {
    }

    public EntityItem dropPlayerItem(ItemStack paramItemStack, boolean paramBoolean) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenDropPlayerItem(this);
        EntityItem _result = overwritten == null ? this.playerAPI.localDropPlayerItem(paramItemStack, paramBoolean) : (overwritten != this ? overwritten.dropPlayerItem(paramItemStack, paramBoolean) : null);
        return _result;
    }

    public void afterDropPlayerItem(ItemStack paramItemStack, boolean paramBoolean) {
    }

    public void beforeFall(float paramFloat) {
    }

    public void fall(float paramFloat) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenFall(this);
        if (overwritten == null) {
            this.playerAPI.localFall(paramFloat);
        } else if (overwritten != this) {
            overwritten.fall(paramFloat);
        }
    }

    public void afterFall(float paramFloat) {
    }

    public void beforeGetAIMoveSpeed() {
    }

    public float getAIMoveSpeed() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenGetAIMoveSpeed(this);
        float _result = overwritten == null ? this.playerAPI.localGetAIMoveSpeed() : (overwritten != this ? overwritten.getAIMoveSpeed() : 0.0f);
        return _result;
    }

    public void afterGetAIMoveSpeed() {
    }

    public void beforeGetCurrentPlayerStrVsBlock(Block paramBlock, boolean paramBoolean) {
    }

    public float getCurrentPlayerStrVsBlock(Block paramBlock, boolean paramBoolean) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenGetCurrentPlayerStrVsBlock(this);
        float _result = overwritten == null ? this.playerAPI.localGetCurrentPlayerStrVsBlock(paramBlock, paramBoolean) : (overwritten != this ? overwritten.getCurrentPlayerStrVsBlock(paramBlock, paramBoolean) : 0.0f);
        return _result;
    }

    public void afterGetCurrentPlayerStrVsBlock(Block paramBlock, boolean paramBoolean) {
    }

    public void beforeGetCurrentPlayerStrVsBlockForge(Block paramBlock, boolean paramBoolean, int paramInt) {
    }

    public float getCurrentPlayerStrVsBlockForge(Block paramBlock, boolean paramBoolean, int paramInt) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenGetCurrentPlayerStrVsBlockForge(this);
        float _result = overwritten == null ? this.playerAPI.localGetCurrentPlayerStrVsBlockForge(paramBlock, paramBoolean, paramInt) : (overwritten != this ? overwritten.getCurrentPlayerStrVsBlockForge(paramBlock, paramBoolean, paramInt) : 0.0f);
        return _result;
    }

    public void afterGetCurrentPlayerStrVsBlockForge(Block paramBlock, boolean paramBoolean, int paramInt) {
    }

    public void beforeGetDistanceSq(double paramDouble1, double paramDouble2, double paramDouble3) {
    }

    public double getDistanceSq(double paramDouble1, double paramDouble2, double paramDouble3) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenGetDistanceSq(this);
        double _result = overwritten == null ? this.playerAPI.localGetDistanceSq(paramDouble1, paramDouble2, paramDouble3) : (overwritten != this ? overwritten.getDistanceSq(paramDouble1, paramDouble2, paramDouble3) : 0.0);
        return _result;
    }

    public void afterGetDistanceSq(double paramDouble1, double paramDouble2, double paramDouble3) {
    }

    public void beforeGetBrightness(float paramFloat) {
    }

    public float getBrightness(float paramFloat) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenGetBrightness(this);
        float _result = overwritten == null ? this.playerAPI.localGetBrightness(paramFloat) : (overwritten != this ? overwritten.getBrightness(paramFloat) : 0.0f);
        return _result;
    }

    public void afterGetBrightness(float paramFloat) {
    }

    public void beforeGetEyeHeight() {
    }

    public float getEyeHeight() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenGetEyeHeight(this);
        float _result = overwritten == null ? this.playerAPI.localGetEyeHeight() : (overwritten != this ? overwritten.getEyeHeight() : 0.0f);
        return _result;
    }

    public void afterGetEyeHeight() {
    }

    public void beforeHeal(float paramFloat) {
    }

    public void heal(float paramFloat) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenHeal(this);
        if (overwritten == null) {
            this.playerAPI.localHeal(paramFloat);
        } else if (overwritten != this) {
            overwritten.heal(paramFloat);
        }
    }

    public void afterHeal(float paramFloat) {
    }

    public void beforeIsEntityInsideOpaqueBlock() {
    }

    public boolean isEntityInsideOpaqueBlock() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenIsEntityInsideOpaqueBlock(this);
        boolean _result = overwritten == null ? this.playerAPI.localIsEntityInsideOpaqueBlock() : (overwritten != this ? overwritten.isEntityInsideOpaqueBlock() : false);
        return _result;
    }

    public void afterIsEntityInsideOpaqueBlock() {
    }

    public void beforeIsInWater() {
    }

    public boolean isInWater() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenIsInWater(this);
        boolean _result = overwritten == null ? this.playerAPI.localIsInWater() : (overwritten != this ? overwritten.isInWater() : false);
        return _result;
    }

    public void afterIsInWater() {
    }

    public void beforeIsInsideOfMaterial(Material paramMaterial) {
    }

    public boolean isInsideOfMaterial(Material paramMaterial) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenIsInsideOfMaterial(this);
        boolean _result = overwritten == null ? this.playerAPI.localIsInsideOfMaterial(paramMaterial) : (overwritten != this ? overwritten.isInsideOfMaterial(paramMaterial) : false);
        return _result;
    }

    public void afterIsInsideOfMaterial(Material paramMaterial) {
    }

    public void beforeIsOnLadder() {
    }

    public boolean isOnLadder() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenIsOnLadder(this);
        boolean _result = overwritten == null ? this.playerAPI.localIsOnLadder() : (overwritten != this ? overwritten.isOnLadder() : false);
        return _result;
    }

    public void afterIsOnLadder() {
    }

    public void beforeIsPlayerSleeping() {
    }

    public boolean isPlayerSleeping() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenIsPlayerSleeping(this);
        boolean _result = overwritten == null ? this.playerAPI.localIsPlayerSleeping() : (overwritten != this ? overwritten.isPlayerSleeping() : false);
        return _result;
    }

    public void afterIsPlayerSleeping() {
    }

    public void beforeIsSneaking() {
    }

    public boolean isSneaking() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenIsSneaking(this);
        boolean _result = overwritten == null ? this.playerAPI.localIsSneaking() : (overwritten != this ? overwritten.isSneaking() : false);
        return _result;
    }

    public void afterIsSneaking() {
    }

    public void beforeJump() {
    }

    public void jump() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenJump(this);
        if (overwritten == null) {
            this.playerAPI.localJump();
        } else if (overwritten != this) {
            overwritten.jump();
        }
    }

    public void afterJump() {
    }

    public void beforeKnockBack(Entity paramEntity, float paramFloat, double paramDouble1, double paramDouble2) {
    }

    public void knockBack(Entity paramEntity, float paramFloat, double paramDouble1, double paramDouble2) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenKnockBack(this);
        if (overwritten == null) {
            this.playerAPI.localKnockBack(paramEntity, paramFloat, paramDouble1, paramDouble2);
        } else if (overwritten != this) {
            overwritten.knockBack(paramEntity, paramFloat, paramDouble1, paramDouble2);
        }
    }

    public void afterKnockBack(Entity paramEntity, float paramFloat, double paramDouble1, double paramDouble2) {
    }

    public void beforeMountEntity(Entity paramEntity) {
    }

    public void mountEntity(Entity paramEntity) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenMountEntity(this);
        if (overwritten == null) {
            this.playerAPI.localMountEntity(paramEntity);
        } else if (overwritten != this) {
            overwritten.mountEntity(paramEntity);
        }
    }

    public void afterMountEntity(Entity paramEntity) {
    }

    public void beforeMoveEntity(double paramDouble1, double paramDouble2, double paramDouble3) {
    }

    public void moveEntity(double paramDouble1, double paramDouble2, double paramDouble3) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenMoveEntity(this);
        if (overwritten == null) {
            this.playerAPI.localMoveEntity(paramDouble1, paramDouble2, paramDouble3);
        } else if (overwritten != this) {
            overwritten.moveEntity(paramDouble1, paramDouble2, paramDouble3);
        }
    }

    public void afterMoveEntity(double paramDouble1, double paramDouble2, double paramDouble3) {
    }

    public void beforeMoveEntityWithHeading(float paramFloat1, float paramFloat2) {
    }

    public void moveEntityWithHeading(float paramFloat1, float paramFloat2) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenMoveEntityWithHeading(this);
        if (overwritten == null) {
            this.playerAPI.localMoveEntityWithHeading(paramFloat1, paramFloat2);
        } else if (overwritten != this) {
            overwritten.moveEntityWithHeading(paramFloat1, paramFloat2);
        }
    }

    public void afterMoveEntityWithHeading(float paramFloat1, float paramFloat2) {
    }

    public void beforeMoveFlying(float paramFloat1, float paramFloat2, float paramFloat3) {
    }

    public void moveFlying(float paramFloat1, float paramFloat2, float paramFloat3) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenMoveFlying(this);
        if (overwritten == null) {
            this.playerAPI.localMoveFlying(paramFloat1, paramFloat2, paramFloat3);
        } else if (overwritten != this) {
            overwritten.moveFlying(paramFloat1, paramFloat2, paramFloat3);
        }
    }

    public void afterMoveFlying(float paramFloat1, float paramFloat2, float paramFloat3) {
    }

    public void beforeOnDeath(DamageSource paramDamageSource) {
    }

    public void onDeath(DamageSource paramDamageSource) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenOnDeath(this);
        if (overwritten == null) {
            this.playerAPI.localOnDeath(paramDamageSource);
        } else if (overwritten != this) {
            overwritten.onDeath(paramDamageSource);
        }
    }

    public void afterOnDeath(DamageSource paramDamageSource) {
    }

    public void beforeOnLivingUpdate() {
    }

    public void onLivingUpdate() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenOnLivingUpdate(this);
        if (overwritten == null) {
            this.playerAPI.localOnLivingUpdate();
        } else if (overwritten != this) {
            overwritten.onLivingUpdate();
        }
    }

    public void afterOnLivingUpdate() {
    }

    public void beforeOnKillEntity(EntityLivingBase paramEntityLivingBase) {
    }

    public void onKillEntity(EntityLivingBase paramEntityLivingBase) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenOnKillEntity(this);
        if (overwritten == null) {
            this.playerAPI.localOnKillEntity(paramEntityLivingBase);
        } else if (overwritten != this) {
            overwritten.onKillEntity(paramEntityLivingBase);
        }
    }

    public void afterOnKillEntity(EntityLivingBase paramEntityLivingBase) {
    }

    public void beforeOnStruckByLightning(EntityLightningBolt paramEntityLightningBolt) {
    }

    public void onStruckByLightning(EntityLightningBolt paramEntityLightningBolt) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenOnStruckByLightning(this);
        if (overwritten == null) {
            this.playerAPI.localOnStruckByLightning(paramEntityLightningBolt);
        } else if (overwritten != this) {
            overwritten.onStruckByLightning(paramEntityLightningBolt);
        }
    }

    public void afterOnStruckByLightning(EntityLightningBolt paramEntityLightningBolt) {
    }

    public void beforeOnUpdate() {
    }

    public void onUpdate() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenOnUpdate(this);
        if (overwritten == null) {
            this.playerAPI.localOnUpdate();
        } else if (overwritten != this) {
            overwritten.onUpdate();
        }
    }

    public void afterOnUpdate() {
    }

    public void beforeOnUpdateEntity() {
    }

    public void onUpdateEntity() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenOnUpdateEntity(this);
        if (overwritten == null) {
            this.playerAPI.localOnUpdateEntity();
        } else if (overwritten != this) {
            overwritten.onUpdateEntity();
        }
    }

    public void afterOnUpdateEntity() {
    }

    public void beforeReadEntityFromNBT(NBTTagCompound paramNBTTagCompound) {
    }

    public void readEntityFromNBT(NBTTagCompound paramNBTTagCompound) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenReadEntityFromNBT(this);
        if (overwritten == null) {
            this.playerAPI.localReadEntityFromNBT(paramNBTTagCompound);
        } else if (overwritten != this) {
            overwritten.readEntityFromNBT(paramNBTTagCompound);
        }
    }

    public void afterReadEntityFromNBT(NBTTagCompound paramNBTTagCompound) {
    }

    public void beforeSetDead() {
    }

    public void setDead() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenSetDead(this);
        if (overwritten == null) {
            this.playerAPI.localSetDead();
        } else if (overwritten != this) {
            overwritten.setDead();
        }
    }

    public void afterSetDead() {
    }

    public void beforeSetEntityActionState(float paramFloat1, float paramFloat2, boolean paramBoolean1, boolean paramBoolean2) {
    }

    public void setEntityActionState(float paramFloat1, float paramFloat2, boolean paramBoolean1, boolean paramBoolean2) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenSetEntityActionState(this);
        if (overwritten == null) {
            this.playerAPI.localSetEntityActionState(paramFloat1, paramFloat2, paramBoolean1, paramBoolean2);
        } else if (overwritten != this) {
            overwritten.setEntityActionState(paramFloat1, paramFloat2, paramBoolean1, paramBoolean2);
        }
    }

    public void afterSetEntityActionState(float paramFloat1, float paramFloat2, boolean paramBoolean1, boolean paramBoolean2) {
    }

    public void beforeSetPosition(double paramDouble1, double paramDouble2, double paramDouble3) {
    }

    public void setPosition(double paramDouble1, double paramDouble2, double paramDouble3) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenSetPosition(this);
        if (overwritten == null) {
            this.playerAPI.localSetPosition(paramDouble1, paramDouble2, paramDouble3);
        } else if (overwritten != this) {
            overwritten.setPosition(paramDouble1, paramDouble2, paramDouble3);
        }
    }

    public void afterSetPosition(double paramDouble1, double paramDouble2, double paramDouble3) {
    }

    public void beforeSetSneaking(boolean paramBoolean) {
    }

    public void setSneaking(boolean paramBoolean) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenSetSneaking(this);
        if (overwritten == null) {
            this.playerAPI.localSetSneaking(paramBoolean);
        } else if (overwritten != this) {
            overwritten.setSneaking(paramBoolean);
        }
    }

    public void afterSetSneaking(boolean paramBoolean) {
    }

    public void beforeSetSprinting(boolean paramBoolean) {
    }

    public void setSprinting(boolean paramBoolean) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenSetSprinting(this);
        if (overwritten == null) {
            this.playerAPI.localSetSprinting(paramBoolean);
        } else if (overwritten != this) {
            overwritten.setSprinting(paramBoolean);
        }
    }

    public void afterSetSprinting(boolean paramBoolean) {
    }

    public void beforeSwingItem() {
    }

    public void swingItem() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenSwingItem(this);
        if (overwritten == null) {
            this.playerAPI.localSwingItem();
        } else if (overwritten != this) {
            overwritten.swingItem();
        }
    }

    public void afterSwingItem() {
    }

    public void beforeUpdateEntityActionState() {
    }

    public void updateEntityActionState() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenUpdateEntityActionState(this);
        if (overwritten == null) {
            this.playerAPI.localUpdateEntityActionState();
        } else if (overwritten != this) {
            overwritten.updateEntityActionState();
        }
    }

    public void afterUpdateEntityActionState() {
    }

    public void beforeUpdatePotionEffects() {
    }

    public void updatePotionEffects() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenUpdatePotionEffects(this);
        if (overwritten == null) {
            this.playerAPI.localUpdatePotionEffects();
        } else if (overwritten != this) {
            overwritten.updatePotionEffects();
        }
    }

    public void afterUpdatePotionEffects() {
    }

    public void beforeUpdateRidden() {
    }

    public void updateRidden() {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenUpdateRidden(this);
        if (overwritten == null) {
            this.playerAPI.localUpdateRidden();
        } else if (overwritten != this) {
            overwritten.updateRidden();
        }
    }

    public void afterUpdateRidden() {
    }

    public void beforeWakeUpPlayer(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3) {
    }

    public void wakeUpPlayer(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenWakeUpPlayer(this);
        if (overwritten == null) {
            this.playerAPI.localWakeUpPlayer(paramBoolean1, paramBoolean2, paramBoolean3);
        } else if (overwritten != this) {
            overwritten.wakeUpPlayer(paramBoolean1, paramBoolean2, paramBoolean3);
        }
    }

    public void afterWakeUpPlayer(boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3) {
    }

    public void beforeWriteEntityToNBT(NBTTagCompound paramNBTTagCompound) {
    }

    public void writeEntityToNBT(NBTTagCompound paramNBTTagCompound) {
        ServerPlayerBase overwritten = this.internalServerPlayerAPI.GetOverwrittenWriteEntityToNBT(this);
        if (overwritten == null) {
            this.playerAPI.localWriteEntityToNBT(paramNBTTagCompound);
        } else if (overwritten != this) {
            overwritten.writeEntityToNBT(paramNBTTagCompound);
        }
    }

    public void afterWriteEntityToNBT(NBTTagCompound paramNBTTagCompound) {
    }
}

