/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ClientHandler;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.PresetsList;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.util.ItemStackFilterParser;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ForkJoinTask;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;

public class CollapsibleItems {
    private static final String STATE_KEY = "collapsibleitems";
    protected File statesFile;
    protected final List<GroupItem> groups = new ArrayList<GroupItem>();
    protected final Map<ItemStack, Integer> cache = new ConcurrentHashMap<ItemStack, Integer>();

    public void load() {
        try {
            if (NEIClientConfig.world.nbt.func_74764_b(STATE_KEY)) {
                NBTTagCompound states = NEIClientConfig.world.nbt.func_74775_l(STATE_KEY);
                Map list = states.field_74784_a;
                HashMap<String, GroupItem> mapping = new HashMap<String, GroupItem>();
                for (GroupItem groupItem : this.groups) {
                    mapping.put(groupItem.guid, groupItem);
                }
                for (Map.Entry entry : list.entrySet()) {
                    if (!mapping.containsKey(entry.getKey())) continue;
                    ((GroupItem)mapping.get(entry.getKey())).expanded = ((NBTBase.NBTPrimitive)entry.getValue()).func_150290_f() == 1;
                }
            }
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error loading collapsible items states", (Throwable)e);
        }
        this.reloadGroups();
    }

    public void reloadGroups() {
        this.groups.clear();
        this.cache.clear();
        for (int i = PresetsList.presets.size() - 1; i >= 0; --i) {
            PresetsList.Preset preset = PresetsList.presets.get(i);
            if (!preset.enabled || preset.mode != PresetsList.PresetMode.GROUP) continue;
            GroupItem group = new GroupItem();
            group.setFilter(preset, UUID.nameUUIDFromBytes(preset.items.toString().getBytes()).toString());
            group.displayName = preset.name;
            this.addGroup(group);
        }
        if (NEIClientConfig.enableCollapsibleItems()) {
            ClientHandler.loadSettingsFile("collapsibleitems.cfg", lines -> this.parseFile(lines.collect(Collectors.toCollection(ArrayList::new))));
        }
    }

    private void parseFile(List<String> itemStrings) {
        JsonParser parser = new JsonParser();
        GroupItem group = new GroupItem();
        for (String itemStr : itemStrings) {
            try {
                if (itemStr.startsWith("; ")) {
                    String unlocalizedName;
                    String displayName;
                    JsonObject settings = parser.parse(itemStr.substring(2)).getAsJsonObject();
                    if (settings.get("displayName") != null) {
                        group.displayName = settings.get("displayName").getAsString();
                    }
                    if (settings.get("unlocalizedName") != null && !(displayName = StatCollector.func_74838_a((String)(unlocalizedName = settings.get("unlocalizedName").getAsString()))).equals(unlocalizedName)) {
                        group.displayName = displayName;
                    }
                    if (settings.get("expanded") != null) {
                        group.expanded = settings.get("expanded").getAsBoolean();
                    }
                } else {
                    group.setFilter(itemStr);
                }
                if (group == null || group.filter == null) continue;
                this.addGroup(group);
                group = new GroupItem();
            }
            catch (JsonSyntaxException | IllegalArgumentException | IllegalStateException e) {
                NEIClientConfig.logger.error("Failed to load collapsible items from json string:\n{}", new Object[]{itemStr});
            }
        }
    }

    protected void addGroup(GroupItem group) {
        if (group == null || group.filter == null || group.filter instanceof ItemList.EverythingItemFilter || group.filter instanceof ItemList.NothingItemFilter) {
            return;
        }
        this.groups.add(group);
    }

    public boolean isEmpty() {
        return this.groups.isEmpty();
    }

    public ItemFilter getItemFilter() {
        ItemList.AnyMultiItemFilter filter = new ItemList.AnyMultiItemFilter();
        for (GroupItem group : this.groups) {
            filter.filters.add(group.filter);
        }
        return filter;
    }

    public void updateCache(List<ItemStack> items) {
        this.cache.clear();
        try {
            ((ForkJoinTask)ItemList.forkJoinPool.submit(() -> items.parallelStream().forEach(stack -> {
                GroupItem group = this.groups.stream().filter(g -> g.matches((ItemStack)stack)).findFirst().orElse(null);
                if (group != null) {
                    this.cache.put((ItemStack)stack, this.groups.indexOf(group));
                }
            }))).get();
        }
        catch (Exception e) {
            NEIClientConfig.logger.error("Error create collapsible items groups", (Throwable)e);
        }
    }

    public int getGroupIndex(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        return this.cache.getOrDefault(stack, -1);
    }

    public String getDisplayName(int groupIndex) {
        if (groupIndex < this.groups.size()) {
            return this.groups.get((int)groupIndex).displayName;
        }
        return null;
    }

    public boolean isExpanded(int groupIndex) {
        if (groupIndex < this.groups.size()) {
            return this.groups.get((int)groupIndex).expanded;
        }
        return true;
    }

    public void setExpanded(int groupIndex, boolean expanded) {
        if (groupIndex < this.groups.size()) {
            this.groups.get((int)groupIndex).expanded = expanded;
            this.saveStates();
        }
    }

    public void toggleGroups(Boolean expanded) {
        if (expanded == null) {
            expanded = this.groups.stream().noneMatch(g -> g.expanded);
        }
        for (GroupItem group : this.groups) {
            group.expanded = expanded;
        }
        this.saveStates();
    }

    private void saveStates() {
        NBTTagCompound list = new NBTTagCompound();
        for (GroupItem group : this.groups) {
            list.func_74757_a(group.guid, group.expanded);
        }
        NEIClientConfig.world.nbt.func_74782_a(STATE_KEY, (NBTBase)list);
    }

    protected static class GroupItem {
        public String guid;
        public ItemFilter filter;
        public boolean expanded = false;
        public String displayName = "";

        public void setFilter(String filter) {
            this.filter = ItemStackFilterParser.parse(filter.trim());
            this.guid = this.filter != null ? UUID.nameUUIDFromBytes(filter.getBytes()).toString() : "";
        }

        public void setFilter(ItemFilter filter, String guid) {
            this.filter = filter;
            this.guid = guid;
        }

        public boolean matches(ItemStack stack) {
            return this.filter.matches(stack);
        }
    }
}

