/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ItemList;
import codechicken.nei.api.ItemFilter;
import gnu.trove.map.TCharCharMap;
import gnu.trove.map.hash.TCharCharHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.Language;
import net.minecraft.util.EnumChatFormatting;

public class SearchTokenParser {
    protected final List<ISearchParserProvider> searchProviders;
    protected final ProvidersCache providersCache = new ProvidersCache();
    protected final TCharCharMap prefixRedefinitions = new TCharCharHashMap();

    public SearchTokenParser(List<ISearchParserProvider> searchProviders) {
        this.searchProviders = searchProviders;
    }

    public SearchTokenParser() {
        this(new ArrayList<ISearchParserProvider>());
    }

    public void addProvider(ISearchParserProvider provider) {
        this.searchProviders.add(provider);
        this.providersCache.clear();
    }

    protected List<ISearchParserProvider> getProviders() {
        Language currentLanguage = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (!currentLanguage.func_135034_a().equals(this.providersCache.languageCode)) {
            HashMap<Character, ISearchParserProvider> providers = new HashMap<Character, ISearchParserProvider>();
            for (int index = this.searchProviders.size() - 1; index >= 0; --index) {
                ISearchParserProvider provider = this.searchProviders.get(index);
                if (providers.containsKey(Character.valueOf(provider.getPrefix())) || !provider.getMatchingLanguages().contains(currentLanguage)) continue;
                providers.put(Character.valueOf(provider.getPrefix()), provider);
            }
            this.providersCache.providers = new ArrayList(providers.values());
            this.providersCache.languageCode = currentLanguage.func_135034_a();
        }
        return this.providersCache.providers;
    }

    public ISearchParserProvider getProvider(char ch) {
        return this.getProviders().stream().filter(provider -> provider.getSearchMode() == SearchMode.PREFIX && this.getRedefinedPrefix(provider.getPrefix()) == ch).findFirst().orElse(null);
    }

    public ItemFilter getFilter(String filterText) {
        String[] parts = EnumChatFormatting.func_110646_a((String)filterText).toLowerCase().split("\\|");
        List searchTokens = Arrays.stream(parts).map(s -> this.parseSearchText((String)s)).filter(s -> s != null).collect(Collectors.toCollection(ArrayList::new));
        if (searchTokens.isEmpty()) {
            return new ItemList.EverythingItemFilter();
        }
        if (searchTokens.size() == 1) {
            return (ItemFilter)searchTokens.get(0);
        }
        return new ItemList.AnyMultiItemFilter(searchTokens);
    }

    public Pattern getSplitPattern() {
        StringBuilder prefixes = new StringBuilder().append('\u0000');
        for (ISearchParserProvider provider : this.getProviders()) {
            if (provider.getSearchMode() != SearchMode.PREFIX) continue;
            prefixes.append(this.getRedefinedPrefix(provider.getPrefix()));
        }
        return Pattern.compile("((-*)([" + Pattern.quote(prefixes.toString()) + "]*)(\\\".*?(?:\\\"|$)|\\S+))");
    }

    private char getRedefinedPrefix(char prefix) {
        if (this.prefixRedefinitions.containsKey(prefix)) {
            return this.prefixRedefinitions.get(prefix);
        }
        return prefix;
    }

    private ItemFilter parseSearchText(String filterText) {
        if (filterText.isEmpty()) {
            return null;
        }
        Matcher filterMatcher = this.getSplitPattern().matcher(filterText);
        ItemList.AllMultiItemFilter searchTokens = new ItemList.AllMultiItemFilter();
        while (filterMatcher.find()) {
            boolean quotes;
            boolean ignore = "-".equals(filterMatcher.group(2));
            String firstChar = filterMatcher.group(3);
            String token = filterMatcher.group(4);
            boolean bl = quotes = token.length() > 1 && token.startsWith("\"") && token.endsWith("\"");
            if (quotes) {
                token = token.substring(1, token.length() - 1);
            }
            if (!token.isEmpty()) {
                ItemFilter result = this.parseToken(firstChar, token);
                if (ignore) {
                    searchTokens.filters.add(new ItemList.NegatedItemFilter(result));
                    continue;
                }
                searchTokens.filters.add(result);
                continue;
            }
            if (ignore) continue;
            searchTokens.filters.add(new ItemList.NothingItemFilter());
        }
        return searchTokens;
    }

    private ItemFilter parseToken(String firstChar, String token) {
        ISearchParserProvider provider;
        ISearchParserProvider iSearchParserProvider = provider = firstChar.isEmpty() ? null : this.getProvider(firstChar.charAt(0));
        if (provider == null || provider.getSearchMode() == SearchMode.NEVER) {
            ArrayList<ItemFilter> filters = new ArrayList<ItemFilter>();
            for (ISearchParserProvider _provider : this.getProviders()) {
                ItemFilter filter;
                if (_provider.getSearchMode() != SearchMode.ALWAYS || (filter = _provider.getFilter(token)) == null) continue;
                filters.add(filter);
            }
            return filters.isEmpty() ? new ItemList.NothingItemFilter() : new ItemList.AnyMultiItemFilter(filters);
        }
        return provider.getFilter(token);
    }

    private static class ProvidersCache {
        public String languageCode = null;
        public List<ISearchParserProvider> providers = new ArrayList<ISearchParserProvider>();

        private ProvidersCache() {
        }

        public void clear() {
            this.languageCode = null;
            this.providers.clear();
        }
    }

    public static interface ISearchParserProvider {
        public ItemFilter getFilter(String var1);

        public static List<Language> getAllLanguages() {
            return new ArrayList<Language>(Minecraft.func_71410_x().func_135016_M().func_135040_d());
        }

        default public List<Language> getMatchingLanguages() {
            return ISearchParserProvider.getAllLanguages();
        }

        public char getPrefix();

        public EnumChatFormatting getHighlightedColor();

        public SearchMode getSearchMode();
    }

    public static enum SearchMode {
        ALWAYS,
        PREFIX,
        NEVER;


        public static SearchMode fromInt(int value) {
            SearchMode searchMode;
            switch (value) {
                case 0: {
                    searchMode = ALWAYS;
                    break;
                }
                case 1: {
                    searchMode = PREFIX;
                    break;
                }
                default: {
                    searchMode = NEVER;
                }
            }
            return searchMode;
        }
    }
}

