/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.recipe.FuelRecipeHandler;
import codechicken.nei.recipe.IRecipeHandler;
import codechicken.nei.recipe.ProfilerRecipeHandler;
import codechicken.nei.recipe.SearchRecipeHandler;
import codechicken.nei.util.AsyncTaskProfiler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinTask;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

class RecipeHandlerQuery<T extends IRecipeHandler> {
    private final Function<T, T> recipeHandlerFunction;
    private final List<T> recipeHandlers;
    private final List<T> serialRecipeHandlers;
    private final String[] errorMessage;
    private boolean error = false;

    RecipeHandlerQuery(Function<T, T> recipeHandlerFunction, List<T> recipeHandlers, List<T> serialRecipeHandlers, String ... errorMessage) {
        this.recipeHandlerFunction = recipeHandlerFunction;
        this.recipeHandlers = recipeHandlers;
        this.serialRecipeHandlers = serialRecipeHandlers;
        this.errorMessage = errorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<T> runWithProfiling(String profilerSection) {
        AsyncTaskProfiler profiler = ProfilerRecipeHandler.getProfiler();
        boolean profileRecipes = NEIClientConfig.isProfileRecipeEnabled();
        if (profileRecipes) {
            profiler.clear();
            profiler.start(profilerSection);
        }
        try {
            ArrayList<T> handlers = this.getRecipeHandlersParallel();
            if (this.error) {
                this.displayRecipeLookupError();
            }
            ArrayList<T> arrayList = handlers;
            return arrayList;
        }
        catch (InterruptedException | ExecutionException e) {
            this.printLog(e);
            this.displayRecipeLookupError();
            ArrayList arrayList = new ArrayList(0);
            return arrayList;
        }
        finally {
            if (profileRecipes) {
                profiler.end();
            }
        }
    }

    private ArrayList<T> getRecipeHandlersParallel() throws InterruptedException, ExecutionException {
        FuelRecipeHandler.findFuelsOnceParallel();
        ArrayList<T> handlers = this.getSerialHandlersWithRecipes();
        handlers.addAll(this.getHandlersWithRecipes());
        handlers.sort(NEIClientConfig.HANDLER_COMPARATOR);
        return handlers;
    }

    private ArrayList<T> getSerialHandlersWithRecipes() {
        return this.serialRecipeHandlers.stream().map(handler -> {
            AsyncTaskProfiler profiler = ProfilerRecipeHandler.getProfiler();
            profiler.clearCurrent();
            profiler.start(handler.getRecipeName());
            try {
                IRecipeHandler iRecipeHandler = this.isHidden(handler) ? null : (IRecipeHandler)this.recipeHandlerFunction.apply((IRecipeHandler)handler);
                return iRecipeHandler;
            }
            catch (Throwable t) {
                this.printLog(t);
                this.error = true;
                IRecipeHandler iRecipeHandler = null;
                return iRecipeHandler;
            }
            finally {
                profiler.end();
            }
        }).filter(h -> h != null && h.numRecipes() > 0 && SearchRecipeHandler.findFirst(h, recipeIndex -> true) != -1).collect(Collectors.toCollection(ArrayList::new));
    }

    private ArrayList<T> getHandlersWithRecipes() throws InterruptedException, ExecutionException {
        return (ArrayList)((ForkJoinTask)ItemList.forkJoinPool.submit(() -> this.recipeHandlers.parallelStream().map(handler -> {
            AsyncTaskProfiler profiler = ProfilerRecipeHandler.getProfiler();
            profiler.clearCurrent();
            profiler.start(handler.getRecipeName());
            try {
                IRecipeHandler iRecipeHandler = this.isHidden(handler) ? null : (IRecipeHandler)this.recipeHandlerFunction.apply((IRecipeHandler)handler);
                return iRecipeHandler;
            }
            catch (Throwable t) {
                this.printLog(t);
                this.error = true;
                IRecipeHandler iRecipeHandler = null;
                return iRecipeHandler;
            }
            finally {
                profiler.end();
            }
        }).filter(h -> h != null && h.numRecipes() > 0 && SearchRecipeHandler.findFirst(h, recipeIndex -> true) != -1).collect(Collectors.toCollection(ArrayList::new)))).get();
    }

    private boolean isHidden(T handler) {
        String handlerName = handler.getHandlerId();
        String handlerId = handler.getOverlayIdentifier();
        return NEIClientConfig.hiddenHandlers.stream().anyMatch(h -> h.equals(handlerId) || h.equals(handlerName));
    }

    private void printLog(Throwable t) {
        for (String message : this.errorMessage) {
            NEIClientConfig.logger.error(message);
        }
        t.printStackTrace();
    }

    private void displayRecipeLookupError() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            ChatComponentTranslation chat = new ChatComponentTranslation("nei.chat.recipe.error", new Object[0]);
            chat.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            player.func_146105_b((IChatComponent)chat);
        }
    }
}

