/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee;

import chylex.hee.api.HeeIMC;
import chylex.hee.entity.boss.dragon.managers.DragonChunkManager;
import chylex.hee.gui.core.GuiHandler;
import chylex.hee.init.BlockList;
import chylex.hee.init.EntityList;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.MiscEvents;
import chylex.hee.mechanics.RecipeList;
import chylex.hee.mechanics.charms.handler.CharmPouchHandler;
import chylex.hee.mechanics.compendium.KnowledgeRegistrations;
import chylex.hee.mechanics.compendium.events.CompendiumEvents;
import chylex.hee.mechanics.curse.CurseEvents;
import chylex.hee.mechanics.energy.EnergyEvents;
import chylex.hee.mechanics.misc.PlayerDataHandler;
import chylex.hee.mechanics.misc.PlayerTransportBeacons;
import chylex.hee.mechanics.misc.TempleEvents;
import chylex.hee.mechanics.orb.OrbAcquirableItems;
import chylex.hee.mechanics.orb.OrbSpawnableMobs;
import chylex.hee.mechanics.voidchest.VoidChestEvents;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.proxy.FXCommonProxy;
import chylex.hee.proxy.ModCommonProxy;
import chylex.hee.proxy.NotificationCommonProxy;
import chylex.hee.system.ConfigHandler;
import chylex.hee.system.ReflectionPublicizer;
import chylex.hee.system.achievements.AchievementEvents;
import chylex.hee.system.achievements.AchievementManager;
import chylex.hee.system.commands.HeeAdminCommand;
import chylex.hee.system.commands.HeeBaconCommand;
import chylex.hee.system.commands.HeeDebugCommand;
import chylex.hee.system.creativetab.ModCreativeTab;
import chylex.hee.system.integration.ModIntegrationManager;
import chylex.hee.system.logging.Log;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.savedata.WorldDataHandler;
import chylex.hee.system.test.UnitTester;
import chylex.hee.system.test.data.RunTime;
import chylex.hee.world.DimensionOverride;
import chylex.hee.world.loot.WorldLoot;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="HardcoreEnderExpansion", name="Hardcore Ender Expansion", version="1.11.2-GTNH", useMetadata=true, guiFactory="chylex.hee.gui.core.ModGuiFactory", dependencies="required-after:gtnhlib@[0.0.10,)")
public class HardcoreEnderExpansion {
    @Mod.Instance(value="HardcoreEnderExpansion")
    public static HardcoreEnderExpansion instance;
    @SidedProxy(clientSide="chylex.hee.proxy.ModClientProxy", serverSide="chylex.hee.proxy.ModCommonProxy")
    public static ModCommonProxy proxy;
    @SidedProxy(clientSide="chylex.hee.proxy.FXClientProxy", serverSide="chylex.hee.proxy.FXCommonProxy")
    public static FXCommonProxy fx;
    @SidedProxy(clientSide="chylex.hee.proxy.NotificationClientProxy", serverSide="chylex.hee.proxy.NotificationCommonProxy")
    public static NotificationCommonProxy notifications;
    public static final int buildId = 1897160;
    public static String modVersion;
    public static String configPath;
    public static File sourceFile;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        Stopwatch.time("PreInitEvent");
        modVersion = e.getModMetadata().version;
        configPath = e.getSuggestedConfigurationFile().getParentFile().getName();
        sourceFile = e.getSourceFile();
        e.getModMetadata().description = e.getModMetadata().description.replace('$', '\u00a7');
        ReflectionPublicizer.load();
        Log.initializeDebug();
        UnitTester.load();
        ConfigHandler.register(e.getSuggestedConfigurationFile());
        BlockList.loadBlocks();
        ItemList.loadItems();
        proxy.loadConfiguration();
        Stopwatch.time("PreInitEvent - data");
        ModCreativeTab.registerTabs();
        BlockList.registerBlocks();
        ItemList.registerItems();
        BlockList.configureBlocks();
        ItemList.configureItems();
        EntityList.registerEntities();
        BlockList.registerTileEntities();
        Stopwatch.finish("PreInitEvent - data");
        DimensionOverride.setup();
        AchievementManager.register();
        AchievementEvents.register();
        Stopwatch.time("PreInitEvent - events");
        MinecraftForge.EVENT_BUS.register((Object)new MiscEvents());
        PlayerDataHandler.register();
        CompendiumEvents.register();
        CharmPouchHandler.register();
        WorldDataHandler.register();
        VoidChestEvents.register();
        EnergyEvents.register();
        TempleEvents.register();
        CurseEvents.register();
        PlayerTransportBeacons.register();
        DragonChunkManager.register();
        Stopwatch.finish("PreInitEvent - events");
        proxy.registerSidedEvents();
        proxy.registerRenderers();
        notifications.register();
        UnitTester.trigger(RunTime.PREINIT);
        Stopwatch.finish("PreInitEvent");
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent e) {
        Stopwatch.time("InitEvent");
        PacketPipeline.initializePipeline();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)GuiHandler.instance);
        RecipeList.addRecipes();
        WorldLoot.registerWorldLoot();
        UnitTester.trigger(RunTime.INIT);
        Stopwatch.finish("InitEvent");
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent e) {
        Stopwatch.time("PostInitEvent");
        HeeIMC.runPostInit();
        KnowledgeRegistrations.initialize();
        OrbAcquirableItems.initialize(true);
        OrbSpawnableMobs.initialize();
        ModIntegrationManager.integrateMods();
        DimensionOverride.postInit();
        UnitTester.trigger(RunTime.POSTINIT);
        Stopwatch.finish("PostInitEvent");
    }

    @Mod.EventHandler
    public void onLoadComplete(FMLLoadCompleteEvent e) {
        Stopwatch.time("LoadCompleteEvent");
        try {
            DimensionOverride.verifyIntegrity();
            HeeIMC.runLoadComplete();
            UnitTester.trigger(RunTime.LOADCOMPLETE);
            UnitTester.finalizeEventTests();
        }
        catch (Throwable t) {
            FMLCommonHandler.instance().raiseException(t, "Critical error handling post-load data.", true);
        }
        Stopwatch.finish("LoadCompleteEvent");
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent e) {
        e.registerServerCommand((ICommand)new HeeAdminCommand());
        e.registerServerCommand((ICommand)new HeeBaconCommand());
        e.registerServerCommand((ICommand)new HeeDebugCommand());
    }

    @Mod.EventHandler
    public void onIMC(FMLInterModComms.IMCEvent e) {
        for (FMLInterModComms.IMCMessage message : e.getMessages()) {
            HeeIMC.acceptIMC(message);
        }
    }
}

