/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.test.list.system;

import chylex.hee.entity.mob.EntityMobEndermage;
import chylex.hee.system.test.Assert;
import chylex.hee.system.test.data.MethodType;
import chylex.hee.system.test.data.RunTime;
import chylex.hee.system.test.data.UnitTest;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.ColorUtil;
import chylex.hee.system.util.CycleProtection;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import org.apache.commons.lang3.ArrayUtils;

public class UtilClassTests {
    private final String mathError = "Unexpected value, expected $2, got $1.";
    private final String coordsError = "Unexpected coords, expected $2, got $1.";
    private final String coordError = "Unexpected coord, expected $2, got $1.";

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testColorUtilHsv() {
        float[] conv = ColorUtil.hsvToRgb(0.5f, 0.55f, 0.4f);
        Assert.equal(MathUtil.floor(conv[0] * 255.0f), 45, "Unexpected red value, expected $2, got $1.");
        Assert.equal(MathUtil.floor(conv[1] * 255.0f), 102, "Unexpected green value, expected $2, got $1.");
        Assert.equal(MathUtil.floor(conv[2] * 255.0f), 102, "Unexpected blue value, expected $2, got $1.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testCycleProtection() {
        CycleProtection.suppressLogging = true;
        CycleProtection.setCounter(50);
        for (int a = 0; a < 51; ++a) {
            CycleProtection.proceed();
        }
        Assert.state(CycleProtection.failed(), "Cycle protection did not report correct state, expected true on failed().");
        CycleProtection.suppressLogging = false;
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testDragonUtilVec() {
        double[] vec = DragonUtil.getNormalizedVector(2.0, 3.0);
        Vec3 vecRef = Vec3.func_72443_a((double)2.0, (double)0.0, (double)3.0).func_72432_b();
        Assert.equal(vec[0], vecRef.field_72450_a, "Unexpected normalized vector X, expected $2, got $1.");
        Assert.equal(vec[1], vecRef.field_72449_c, "Unexpected normalized vector Z, expected $2, got $1.");
        Assert.equal(DragonUtil.getRandomVector(new Random()).func_72433_c(), Float.valueOf(1.0f), "Unexpected length of randomized vector, expected $2, got $1.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testDragonUtilArrays() {
        String[] values = new String[]{"A", "B", null, "C", null};
        Object[] nonNullValues = DragonUtil.getNonNullValues(values);
        Assert.state(!ArrayUtils.contains((Object[])nonNullValues, null), "Unexpected array elements, expected to not find any null elements. Array: " + ArrayUtils.toString((Object)nonNullValues));
        Assert.equal(nonNullValues.length, 3, "Unexpected length of array after removing null elements, expected $2, got $1. Array: " + ArrayUtils.toString((Object)nonNullValues));
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testDragonUtilChat() {
        Assert.equal(DragonUtil.stripChatFormatting(EnumChatFormatting.GOLD + "Text"), "Text", "Unexpected characters after stripping chat formatting, expected '$2', got '$1'.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testDragonUtilParsing() {
        String error = "Unexpected parsing result, expected $2, got $1.";
        Assert.equal(DragonUtil.tryParse("15", 0), 15, error);
        Assert.equal(DragonUtil.tryParse("+15", 0), 15, error);
        Assert.equal(DragonUtil.tryParse("-200", 0), -200, error);
        Assert.equal(DragonUtil.tryParse("fail", 5), 5, error);
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testMathUtilDegrees() {
        Assert.equal(MathUtil.toRad(180.0), Math.PI, "Unexpected value, expected $2, got $1.");
        Assert.equal(Float.valueOf(MathUtil.toRad(180.0f)), Math.PI, "Unexpected value, expected $2, got $1.");
        Assert.equal(Float.valueOf(MathUtil.toDeg((float)Math.PI)), Float.valueOf(180.0f), "Unexpected value, expected $2, got $1.");
        Assert.equal(MathUtil.toDeg(Math.PI), Float.valueOf(180.0f), "Unexpected value, expected $2, got $1.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testMathUtilSquare() {
        Assert.equal(MathUtil.square(5), 25, "Unexpected value, expected $2, got $1.");
        Assert.equal(Float.valueOf(MathUtil.square(-2.5f)), Float.valueOf(6.25f), "Unexpected value, expected $2, got $1.");
        Assert.equal(MathUtil.square(-2.5), 6.25, "Unexpected value, expected $2, got $1.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testMathUtilDistance() {
        Assert.equal(MathUtil.distance(4.0, 3.0), 5.0, "Unexpected value, expected $2, got $1.");
        Assert.equal(MathUtil.distance(1.0, 2.0, 3.0), 3.7416573, "Unexpected value, expected $2, got $1.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testMathUtilRounding() {
        Assert.equal(MathUtil.floor(1.5), 1, "Unexpected value, expected $2, got $1.");
        Assert.equal(MathUtil.floor(1.5f), 1, "Unexpected value, expected $2, got $1.");
        Assert.equal(MathUtil.ceil(5.1), 6, "Unexpected value, expected $2, got $1.");
        Assert.equal(MathUtil.ceil(5.1f), 6, "Unexpected value, expected $2, got $1.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testMathUtilClamping() {
        Assert.equal(MathUtil.clamp(5.0, 6.0, 8.0), 6.0, "Unexpected value, expected $2, got $1.");
        Assert.equal(Float.valueOf(MathUtil.clamp(10.0f, 6.0f, 8.0f)), Float.valueOf(8.0f), "Unexpected value, expected $2, got $1.");
        Assert.equal(MathUtil.clamp(7, 6, 8), 7, "Unexpected value, expected $2, got $1.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testMathUtilRange() {
        Assert.state(MathUtil.inRangeIncl(30, 30, 50), "Number is supposed to be in range.");
        Assert.state(!MathUtil.inRangeIncl(29, 30, 50), "Number is not supposed to be in range.");
        Assert.state(MathUtil.inRangeIncl(50, 30, 50), "Number is supposed to be in range.");
        Assert.state(!MathUtil.inRangeIncl(51, 30, 50), "Number is not supposed to be in range.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testMathUtilFloats() {
        Assert.state(MathUtil.floatEquals(0.33333334f, 0.33333334f), "Numbers are supposed to be equal.");
        Assert.state(!MathUtil.floatEquals(0.3333f, 0.33333334f), "Numbers are not supposed to be equal.");
    }

    @UnitTest(type=MethodType.TEST, runTime=RunTime.LOADCOMPLETE)
    public void testBlockPosM() {
        BlockPosM pos = new BlockPosM();
        BlockPosM ref = new BlockPosM(1, 2, 3);
        Assert.equal(pos.set(ref), ref, "Unexpected coords, expected $2, got $1.");
        Assert.equal(pos.set(1, 2, 3), ref, "Unexpected coords, expected $2, got $1.");
        Assert.equal(pos.set(new int[]{1, 2, 3}), ref, "Unexpected coords, expected $2, got $1.");
        Assert.equal(pos.set(1.0, 2.2, 3.49), ref, "Unexpected coords, expected $2, got $1.");
        Assert.equal(pos.set(ref.toLong()), ref, "Unexpected coords, expected $2, got $1.");
        Assert.equal(pos.set((Entity)new EntityMobEndermage(null, 1.0, 2.0, 3.0)), ref, "Unexpected coords, expected $2, got $1.");
        pos.set(ref.setX(5).setY(1).setZ(-5));
        Assert.equal(pos.x, 5, "Unexpected coord, expected $2, got $1.");
        Assert.equal(pos.y, 1, "Unexpected coord, expected $2, got $1.");
        Assert.equal(pos.z, -5, "Unexpected coord, expected $2, got $1.");
        pos.set(ref).moveUp().moveEast().moveNorth();
        Assert.equal(pos.x, 4, "Unexpected coord, expected $2, got $1.");
        Assert.equal(pos.y, 2, "Unexpected coord, expected $2, got $1.");
        Assert.equal(pos.z, -6, "Unexpected coord, expected $2, got $1.");
        pos.set(ref).moveDown().moveWest().moveSouth();
        Assert.equal(pos.x, 6, "Unexpected coord, expected $2, got $1.");
        Assert.equal(pos.y, 0, "Unexpected coord, expected $2, got $1.");
        Assert.equal(pos.z, -4, "Unexpected coord, expected $2, got $1.");
        Assert.equal(pos.setY((int)0).move((int)1).move((int)1, (int)2).y, 3, "Unexpected coord, expected $2, got $1.");
    }
}

