/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation;

import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.util.Timer;

public class Animation {
    private ITransformable transformable;
    private Transformation transform;
    private int delay;
    private boolean started = false;
    private boolean finished = false;
    private boolean renderBefore = true;
    private boolean renderAfter = true;

    public Animation(ITransformable transformable, Transformation transform) {
        this.transformable = transformable;
        this.transform = transform;
    }

    public void setRender(boolean before, boolean after) {
        this.renderBefore = before;
        this.renderAfter = after;
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public ITransformable animate(long elapsedTime) {
        if (this.transform == null || this.transformable == null) {
            return this.transformable;
        }
        long elapsed = elapsedTime - Timer.tickToTime(this.delay);
        this.started = elapsed > this.transform.getDelay();
        boolean bl = this.finished = elapsed > this.transform.totalDuration() && this.transform.getLoops() != -1;
        if (!this.started && !this.renderBefore) {
            return null;
        }
        if (this.finished && !this.renderAfter) {
            return null;
        }
        this.transform.transform(this.transformable, elapsed);
        return this.transformable;
    }
}

