/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.syncer;

import cpw.mods.fml.common.discovery.ASMDataTable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.util.DoubleKeyMap;
import net.malisis.core.util.syncer.FieldData;
import net.malisis.core.util.syncer.ISyncHandler;
import net.malisis.core.util.syncer.ISyncableData;
import net.malisis.core.util.syncer.Sync;
import net.malisis.core.util.syncer.Syncable;
import net.malisis.core.util.syncer.handlers.TileEntitySyncHandler;
import net.malisis.core.util.syncer.message.SyncerMessage;

public class Syncer {
    private DoubleKeyMap<String, ISyncHandler<?, ? extends ISyncableData>> handlers = new DoubleKeyMap();
    private Map<Class<?>, ISyncHandler<?, ? extends ISyncableData>> classToHandler = new HashMap();
    private Map<Object, HashMap<String, Object>> syncCache = new HashMap<Object, HashMap<String, Object>>();
    private static Syncer instance;

    private Syncer() {
        this.registerSyncHandler(new TileEntitySyncHandler());
    }

    private void registerSyncHandler(ISyncHandler<?, ? extends ISyncableData> handler) {
        this.handlers.put(handler.getName(), handler);
    }

    public int getHandlerId(ISyncHandler<?, ? extends ISyncableData> handler) {
        return this.handlers.getIndex(handler.getName());
    }

    public ISyncHandler<?, ? extends ISyncableData> getHandlerFromId(int id) {
        return this.handlers.get((String)id);
    }

    public <T> ISyncHandler<? super T, ? extends ISyncableData> getHandler(T caller) {
        ISyncHandler<?, ? extends ISyncableData> handler = this.classToHandler.get(caller.getClass());
        if (handler == null) {
            MalisisCore.log.error("No ISyncHandler registered for type '{}'", new Object[]{caller.getClass()});
            return null;
        }
        return handler;
    }

    public void discover(ASMDataTable asmDataTable) {
        for (ASMDataTable.ASMData data : asmDataTable.getAll(Syncable.class.getName())) {
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                Syncable anno = clazz.getAnnotation(Syncable.class);
                ISyncHandler<?, ISyncableData> handler = this.handlers.get(anno.value());
                this.classToHandler.put(clazz, handler);
                for (Field f : clazz.getFields()) {
                    Sync syncAnno = f.getAnnotation(Sync.class);
                    if (syncAnno == null) continue;
                    handler.addFieldData(new FieldData(0, syncAnno.value(), f));
                }
            }
            catch (Exception e) {
                MalisisCore.log.error("Could not process {} syncable.", new Object[]{data.getClassName(), e});
            }
        }
    }

    private int getFieldIndexes(ISyncHandler<?, ? extends ISyncableData> handler, String ... syncNames) {
        int indexes = 0;
        for (String str : syncNames) {
            FieldData fd = handler.getFieldData(str);
            if (fd == null) continue;
            indexes |= 1 << fd.getIndex();
        }
        return indexes;
    }

    private Map<String, Object> getFieldValues(Object caller, ISyncHandler<?, ? extends ISyncableData> handler, String ... syncNames) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        try {
            for (String str : syncNames) {
                FieldData fd = handler.getFieldData(str);
                if (fd == null) continue;
                values.put(str, fd.getField().get(caller));
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        return values;
    }

    private <T> void doSync(T caller, String ... syncNames) {
        ISyncHandler<T, ISyncableData> handler = this.getHandler(caller);
        if (handler == null) {
            return;
        }
        ISyncableData data = handler.getSyncData(caller);
        int indexes = this.getFieldIndexes(handler, syncNames);
        Map<String, Object> values = this.getFieldValues(caller, handler, syncNames);
        SyncerMessage.Packet<T> packet = new SyncerMessage.Packet<T>(handler, data, indexes, values);
        handler.send(caller, packet);
    }

    private void registerAutoSync(Object caller) {
        if (this.syncCache.get(caller) != null) {
            return;
        }
    }

    public void updateValues(Object receiver, ISyncHandler<?, ? extends ISyncableData> handler, Map<String, Object> values) {
        if (receiver == null || handler == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            try {
                FieldData fd = handler.getFieldData(entry.getKey());
                if (fd == null) continue;
                fd.getField().set(receiver, entry.getValue());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                MalisisCore.log.error("Failed to update {} field for {}.", new Object[]{entry.getKey(), receiver.getClass().getSimpleName(), e});
            }
        }
    }

    public static Syncer get() {
        if (instance == null) {
            instance = new Syncer();
        }
        return instance;
    }

    public static void registerHandler(ISyncHandler<?, ? extends ISyncableData> handler) {
        Syncer.get().registerSyncHandler(handler);
    }

    public static void sync(Object caller, String ... syncNames) {
        Syncer.get().doSync(caller, syncNames);
    }

    public static void autoSync(Object caller) {
        Syncer.get().registerAutoSync(caller);
    }
}

