/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors;

import cpw.mods.fml.common.registry.GameRegistry;
import net.malisis.core.util.replacement.ReplacementTool;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.MalisisDoorsSettings;
import net.malisis.doors.block.BlockMixer;
import net.malisis.doors.block.DoorFactory;
import net.malisis.doors.block.GarageDoor;
import net.malisis.doors.block.MixedBlock;
import net.malisis.doors.block.PlayerSensor;
import net.malisis.doors.block.RustyLadder;
import net.malisis.doors.block.VanishingBlock;
import net.malisis.doors.block.VanishingDiamondBlock;
import net.malisis.doors.door.DoorDescriptor;
import net.malisis.doors.door.block.BigDoor;
import net.malisis.doors.door.block.CustomDoor;
import net.malisis.doors.door.block.FenceGate;
import net.malisis.doors.door.block.ForcefieldDoor;
import net.malisis.doors.door.block.RustyHatch;
import net.malisis.doors.door.block.SaloonDoorBlock;
import net.malisis.doors.door.descriptor.Curtain;
import net.malisis.doors.door.descriptor.FactoryDoor;
import net.malisis.doors.door.descriptor.GlassDoor;
import net.malisis.doors.door.descriptor.JailDoor;
import net.malisis.doors.door.descriptor.LaboratoryDoor;
import net.malisis.doors.door.descriptor.SaloonDoor;
import net.malisis.doors.door.descriptor.ShojiDoor;
import net.malisis.doors.door.descriptor.VanillaDoor;
import net.malisis.doors.door.descriptor.WoodDoor;
import net.malisis.doors.door.item.CustomDoorItem;
import net.malisis.doors.door.item.DoorItem;
import net.malisis.doors.door.item.ForcefieldItem;
import net.malisis.doors.door.tileentity.BigDoorTileEntity;
import net.malisis.doors.door.tileentity.CustomDoorTileEntity;
import net.malisis.doors.door.tileentity.DoorTileEntity;
import net.malisis.doors.door.tileentity.FenceGateTileEntity;
import net.malisis.doors.door.tileentity.ForcefieldTileEntity;
import net.malisis.doors.door.tileentity.RustyHatchTileEntity;
import net.malisis.doors.door.tileentity.SaloonDoorTileEntity;
import net.malisis.doors.entity.BlockMixerTileEntity;
import net.malisis.doors.entity.DoorFactoryTileEntity;
import net.malisis.doors.entity.GarageDoorTileEntity;
import net.malisis.doors.entity.MixedBlockTileEntity;
import net.malisis.doors.entity.VanishingDiamondTileEntity;
import net.malisis.doors.entity.VanishingTileEntity;
import net.malisis.doors.item.MixedBlockBlockItem;
import net.malisis.doors.item.VanishingBlockItem;
import net.malisis.doors.recipe.BigDoorRecipe;
import net.malisis.doors.trapdoor.descriptor.IronTrapDoor;
import net.malisis.doors.trapdoor.descriptor.SlidingTrapDoor;
import net.malisis.doors.trapdoor.descriptor.VanillaTrapDoor;
import net.malisis.doors.trapdoor.descriptor.WoodTrapDoor;
import net.malisis.doors.trapdoor.tileentity.TrapDoorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class Registers {
    public static void init() {
        if (MalisisDoorsSettings.modifyVanillaDoors.get().booleanValue()) {
            Registers.registerVanillaDoors();
            Registers.registerVanillaTrapDoor();
            Registers.registerVanillaFenceGate();
        }
        Registers.registerWoodDoors();
        Registers.registerDoors();
        Registers.registerSaloonDoor();
        Registers.registerFenceGates();
        Registers.registerTrapDoors();
        Registers.registerPlayerSensor();
        if (MalisisDoorsSettings.enableVanishingBlocks.get().booleanValue()) {
            Registers.registerVanishingBlock();
        }
        if (MalisisDoorsSettings.enableMixedBlocks.get().booleanValue()) {
            Registers.registerMixedBlock();
        }
        Registers.registerGarageDoor();
        Registers.registerDoorFactory();
        Registers.registerCustomDoor();
        Registers.registerRustyHatch();
        Registers.registerBigDoors();
        Registers.registerForcefieldDoor();
        GameRegistry.registerTileEntity(DoorTileEntity.class, (String)"doorTileEntity");
        GameRegistry.registerTileEntity(TrapDoorTileEntity.class, (String)"trapDoorTileEntity");
        GameRegistry.registerTileEntity(FenceGateTileEntity.class, (String)"fenceGateTileEntity");
    }

    private static void registerVanillaDoors() {
        VanillaDoor woodDoor = new VanillaDoor(Material.field_151575_d);
        woodDoor.create();
        ReplacementTool.replaceVanillaItem(324, "wooden_door", "field_151135_aq", woodDoor.getItem(), Items.field_151135_aq);
        ReplacementTool.replaceVanillaBlock(64, "wooden_door", "field_150466_ao", woodDoor.getBlock(), Blocks.field_150466_ao);
        VanillaDoor ironDoor = new VanillaDoor(Material.field_151573_f);
        ironDoor.create();
        ReplacementTool.replaceVanillaItem(330, "iron_door", "field_151139_aw", ironDoor.getItem(), Items.field_151139_aw);
        ReplacementTool.replaceVanillaBlock(71, "iron_door", "field_150454_av", ironDoor.getBlock(), Blocks.field_150454_av);
    }

    private static void registerVanillaTrapDoor() {
        VanillaTrapDoor vanillaTrapDoor = new VanillaTrapDoor();
        vanillaTrapDoor.create();
        ReplacementTool.replaceVanillaBlock(96, "trapdoor", "field_150415_aT", vanillaTrapDoor.getBlock(), Blocks.field_150415_aT);
    }

    private static void registerVanillaFenceGate() {
        MalisisDoors.Blocks.oakFenceGate = new FenceGate(FenceGate.Type.OAK);
        ReplacementTool.replaceVanillaBlock(107, "fence_gate", "field_150396_be", (Block)MalisisDoors.Blocks.oakFenceGate, Blocks.field_150396_be);
    }

    private static void registerWoodDoors() {
        DoorDescriptor desc = new WoodDoor("door_acacia", 4).register();
        MalisisDoors.Blocks.doorAcacia = desc.getBlock();
        MalisisDoors.Items.doorAcaciaItem = desc.getItem();
        desc = new WoodDoor("door_birch", 2).register();
        MalisisDoors.Blocks.doorBirch = desc.getBlock();
        MalisisDoors.Items.doorBirchItem = desc.getItem();
        desc = new WoodDoor("door_dark_oak", 5).register();
        MalisisDoors.Blocks.doorDarkOak = desc.getBlock();
        MalisisDoors.Items.doorDarkOakItem = desc.getItem();
        desc = new WoodDoor("door_jungle", 3).register();
        MalisisDoors.Blocks.doorJungle = desc.getBlock();
        MalisisDoors.Items.doorJungleItem = desc.getItem();
        desc = new WoodDoor("door_spruce", 1).register();
        MalisisDoors.Blocks.doorSpruce = desc.getBlock();
        MalisisDoors.Items.doorSpruceItem = desc.getItem();
    }

    private static void registerDoors() {
        DoorDescriptor desc = new GlassDoor(Material.field_151575_d).register();
        MalisisDoors.Blocks.woodSlidingDoor = desc.getBlock();
        MalisisDoors.Items.woodSlidingDoorItem = desc.getItem();
        desc = new GlassDoor(Material.field_151573_f).register();
        MalisisDoors.Blocks.ironSlidingDoor = desc.getBlock();
        MalisisDoors.Items.ironSlidingDoorItem = desc.getItem();
        desc = new JailDoor().register();
        MalisisDoors.Blocks.jailDoor = desc.getBlock();
        MalisisDoors.Items.jailDoorItem = desc.getItem();
        desc = new LaboratoryDoor().register();
        MalisisDoors.Blocks.laboratoryDoor = desc.getBlock();
        MalisisDoors.Items.laboratoryDoorItem = desc.getItem();
        desc = new FactoryDoor().register();
        MalisisDoors.Blocks.factoryDoor = desc.getBlock();
        MalisisDoors.Items.factoryDoorItem = desc.getItem();
        desc = new ShojiDoor().register();
        MalisisDoors.Blocks.shojiDoor = desc.getBlock();
        MalisisDoors.Items.shojiDoorItem = desc.getItem();
        for (int i = 0; i < ItemDye.field_150921_b.length; ++i) {
            new Curtain(ItemDye.field_150921_b[i], ~i & 0xF).register();
        }
    }

    private static void registerSaloonDoor() {
        SaloonDoor desc = new SaloonDoor();
        MalisisDoors.Blocks.saloonDoor = new SaloonDoorBlock(desc);
        MalisisDoors.Items.saloonDoorItem = new DoorItem(desc);
        desc.set(MalisisDoors.Blocks.saloonDoor, MalisisDoors.Items.saloonDoorItem);
        desc.register();
        GameRegistry.registerTileEntity(SaloonDoorTileEntity.class, (String)"saloonDoorTileEntity");
    }

    private static void registerFenceGates() {
        MalisisDoors.Blocks.acaciaFenceGate = new FenceGate(FenceGate.Type.ACACIA).register();
        MalisisDoors.Blocks.birchFenceGate = new FenceGate(FenceGate.Type.BIRCH).register();
        MalisisDoors.Blocks.darkOakFenceGate = new FenceGate(FenceGate.Type.DARK_OAK).register();
        MalisisDoors.Blocks.jungleFenceGate = new FenceGate(FenceGate.Type.JUNGLE).register();
        MalisisDoors.Blocks.spruceFenceGate = new FenceGate(FenceGate.Type.SPRUCE).register();
        MalisisDoors.Blocks.camoFenceGate = new FenceGate(FenceGate.Type.CAMO).register();
    }

    private static void registerTrapDoors() {
        DoorDescriptor desc = new IronTrapDoor().register();
        MalisisDoors.Blocks.ironTrapDoor = desc.getBlock();
        MalisisDoors.Items.ironTrapDoorItem = desc.getItem();
        desc = new SlidingTrapDoor().register();
        MalisisDoors.Blocks.slidingTrapDoor = desc.getBlock();
        MalisisDoors.Items.slidingTrapDoorItem = desc.getItem();
        for (WoodTrapDoor.Type type : WoodTrapDoor.Type.values()) {
            desc = new WoodTrapDoor(type).register();
        }
    }

    private static void registerPlayerSensor() {
        MalisisDoors.Blocks.playerSensor = new PlayerSensor();
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.playerSensor, (String)MalisisDoors.Blocks.playerSensor.func_149739_a().substring(5));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)MalisisDoors.Blocks.playerSensor), new Object[]{"ABA", "CCC", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), Items.field_151137_ax, Character.valueOf('C'), "blockGlassColorless"}));
    }

    private static void registerVanishingBlock() {
        MalisisDoors.Blocks.vanishingBlock = new VanishingBlock();
        MalisisDoors.Blocks.vanishingDiamondBlock = new VanishingDiamondBlock();
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.vanishingBlock, VanishingBlockItem.class, (String)MalisisDoors.Blocks.vanishingBlock.func_149739_a().substring(5));
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.vanishingDiamondBlock, (String)MalisisDoors.Blocks.vanishingDiamondBlock.func_149739_a().substring(5));
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MalisisDoors.Blocks.vanishingBlock, 4, 0), (Object[])new Object[]{"ABA", "BCB", "ABA", Character.valueOf('A'), Items.field_151137_ax, Character.valueOf('B'), Items.field_151055_y, Character.valueOf('C'), Items.field_151079_bi});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MalisisDoors.Blocks.vanishingBlock, 4, 1), (Object[])new Object[]{"ABA", "BCB", "ABA", Character.valueOf('A'), Items.field_151137_ax, Character.valueOf('B'), Items.field_151042_j, Character.valueOf('C'), Items.field_151079_bi});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MalisisDoors.Blocks.vanishingBlock, 4, 2), (Object[])new Object[]{"ABA", "BCB", "ABA", Character.valueOf('A'), Items.field_151137_ax, Character.valueOf('B'), Items.field_151043_k, Character.valueOf('C'), Items.field_151079_bi});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MalisisDoors.Blocks.vanishingBlock, 4, 3), (Object[])new Object[]{"ABA", "BCB", "ABA", Character.valueOf('A'), Items.field_151137_ax, Character.valueOf('B'), Items.field_151045_i, Character.valueOf('C'), Items.field_151079_bi});
        GameRegistry.registerTileEntity(VanishingTileEntity.class, (String)"vanishingTileEntity");
        GameRegistry.registerTileEntity(VanishingDiamondTileEntity.class, (String)"vanishingDiamondTileEntity");
    }

    private static void registerMixedBlock() {
        MalisisDoors.Blocks.blockMixer = new BlockMixer();
        MalisisDoors.Blocks.mixedBlock = new MixedBlock();
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.blockMixer, (String)MalisisDoors.Blocks.blockMixer.func_149739_a().substring(5));
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.mixedBlock, MixedBlockBlockItem.class, (String)MalisisDoors.Blocks.mixedBlock.func_149739_a().substring(5));
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MalisisDoors.Blocks.blockMixer), (Object[])new Object[]{"AAA", "B B", "AAA", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), Blocks.field_150331_J});
        GameRegistry.registerTileEntity(BlockMixerTileEntity.class, (String)"blockMixerTileEntity");
        GameRegistry.registerTileEntity(MixedBlockTileEntity.class, (String)"mixedBlockTileEntity");
    }

    private static void registerGarageDoor() {
        MalisisDoors.Blocks.garageDoor = new GarageDoor();
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.garageDoor, (String)MalisisDoors.Blocks.garageDoor.func_149739_a().substring(5));
        GameRegistry.registerTileEntity(GarageDoorTileEntity.class, (String)"garageDoorTileEntity");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MalisisDoors.Blocks.garageDoor), (Object[])new Object[]{"ABA", "AAA", Character.valueOf('A'), Blocks.field_150344_f, Character.valueOf('B'), Blocks.field_150359_w});
    }

    private static void registerDoorFactory() {
        MalisisDoors.Blocks.doorFactory = new DoorFactory();
        MalisisDoors.Blocks.doorFactory.register();
        GameRegistry.registerTileEntity(DoorFactoryTileEntity.class, (String)"doorFactoryTileEntity");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MalisisDoors.Blocks.doorFactory), (Object[])new Object[]{"ABA", "C C", "ADA", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), Items.field_151139_aw, Character.valueOf('C'), Items.field_151137_ax, Character.valueOf('D'), Blocks.field_150331_J});
    }

    private static void registerCustomDoor() {
        MalisisDoors.Blocks.customDoor = new CustomDoor();
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.customDoor, (String)MalisisDoors.Blocks.customDoor.func_149739_a().substring(5));
        MalisisDoors.Items.customDoorItem = new CustomDoorItem();
        GameRegistry.registerItem((Item)MalisisDoors.Items.customDoorItem, (String)MalisisDoors.Items.customDoorItem.func_77658_a());
        GameRegistry.registerTileEntity(CustomDoorTileEntity.class, (String)"customDoorTileEntity");
    }

    private static void registerRustyHatch() {
        MalisisDoors.Blocks.rustyHatch = new RustyHatch();
        MalisisDoors.Blocks.rustyHatch.register();
        MalisisDoors.Items.rustyHandle = new Item(){

            public void func_94581_a(IIconRegister register) {
            }
        }.func_77655_b("rustyHandle").func_77637_a(MalisisDoors.tab);
        GameRegistry.registerItem((Item)MalisisDoors.Items.rustyHandle, (String)MalisisDoors.Items.rustyHandle.func_77658_a());
        GameRegistry.registerTileEntity(RustyHatchTileEntity.class, (String)"rustyHatchTileEntity");
        GameRegistry.addRecipe((ItemStack)new ItemStack(MalisisDoors.Items.rustyHandle), (Object[])new Object[]{"AAA", " A ", Character.valueOf('A'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MalisisDoors.Blocks.rustyHatch), (Object[])new Object[]{"A ", "AB", "A ", Character.valueOf('A'), Items.field_151042_j, Character.valueOf('B'), MalisisDoors.Items.rustyHandle});
        MalisisDoors.Blocks.rustyLadder = new RustyLadder();
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.rustyLadder, (String)MalisisDoors.Blocks.rustyLadder.func_149739_a().substring(5));
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)MalisisDoors.Blocks.rustyLadder), (Object[])new Object[]{"AAA", Character.valueOf('A'), Items.field_151042_j});
    }

    private static void registerBigDoors() {
        MalisisDoors.Blocks.carriageDoor = new BigDoor(BigDoor.Type.CARRIAGE);
        MalisisDoors.Blocks.carriageDoor.register();
        MalisisDoors.Blocks.medievalDoor = new BigDoor(BigDoor.Type.MEDIEVAL);
        MalisisDoors.Blocks.medievalDoor.register();
        GameRegistry.registerTileEntityWithAlternatives(BigDoorTileEntity.class, (String)"bigDoorTileEntity", (String[])new String[]{"carriageDoorTileEntity"});
        GameRegistry.addRecipe((IRecipe)new BigDoorRecipe(BigDoor.Type.CARRIAGE));
        GameRegistry.addRecipe((IRecipe)new BigDoorRecipe(BigDoor.Type.MEDIEVAL));
    }

    private static void registerForcefieldDoor() {
        MalisisDoors.Blocks.forcefieldDoor = new ForcefieldDoor();
        GameRegistry.registerBlock((Block)MalisisDoors.Blocks.forcefieldDoor, (String)MalisisDoors.Blocks.forcefieldDoor.func_149739_a().substring(5));
        MalisisDoors.Items.forcefieldItem = new ForcefieldItem();
        GameRegistry.registerItem((Item)MalisisDoors.Items.forcefieldItem, (String)MalisisDoors.Items.forcefieldItem.func_77658_a());
        GameRegistry.registerTileEntity(ForcefieldTileEntity.class, (String)"forcefieldTileEntity");
        GameRegistry.addRecipe((ItemStack)new ItemStack((Item)MalisisDoors.Items.forcefieldItem), (Object[])new Object[]{"ABA", "CDC", "AEA", Character.valueOf('A'), Items.field_151045_i, Character.valueOf('B'), Blocks.field_150343_Z, Character.valueOf('C'), Items.field_151107_aW, Character.valueOf('D'), Items.field_151061_bv, Character.valueOf('E'), Items.field_151132_bS});
    }
}

