/*
 * Decompiled with CFR 0.152.
 */
package craftpresence.jvmdg.api.xyz.wagyourtail.jvmdg.j17.stub.java_base;

import craftpresence.jvmdg.api.xyz.wagyourtail.jvmdg.exc.MissingStubError;
import craftpresence.jvmdg.api.xyz.wagyourtail.jvmdg.j17.impl.random.BasicRandomGeneratorImpl;
import craftpresence.jvmdg.api.xyz.wagyourtail.jvmdg.j17.impl.random.SplittableRandomGeneratorImpl;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.j17.stub.java_base.J_U_R_RandomGenerator;
import xyz.wagyourtail.jvmdg.version.Adapter;
import xyz.wagyourtail.jvmdg.version.Coerce;
import xyz.wagyourtail.jvmdg.version.Stub;

@Adapter(value="java/util/random/RandomGenerator")
@NestMembers(value={J_U_R_RandomGenerator.ArbitrarilyJumpableGenerator.class, J_U_R_RandomGenerator.LeapableGenerator.class, J_U_R_RandomGenerator.JumpableGenerator.class, SplittableGenerator.class, StreamableGenerator.class})
public interface J_U_R_RandomGenerator {
    public static J_U_R_RandomGenerator jvmdg$checkcast(Object obj) {
        Object object = obj;
        if (object instanceof Random) {
            Random random = (Random)object;
            return new BasicRandomGeneratorImpl(random);
        }
        object = obj;
        if (object instanceof SplittableRandom) {
            SplittableRandom random = (SplittableRandom)object;
            return new SplittableRandomGeneratorImpl(random);
        }
        return (J_U_R_RandomGenerator)obj;
    }

    @Stub(noSpecial=true)
    public static int nextInt(@Coerce(value=J_U_R_RandomGenerator.class) Object obj, int bound) {
        return J_U_R_RandomGenerator.jvmdg$checkcast(obj).nextInt(bound);
    }

    default public boolean isDeprecated() {
        return false;
    }

    default public DoubleStream doubles() {
        return DoubleStream.generate(this::nextDouble).sequential();
    }

    default public DoubleStream doubles(double lower, double upper) {
        if (!(lower < upper) || !(upper - lower < Double.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        return DoubleStream.generate(() -> this.nextDouble(lower, upper)).sequential();
    }

    default public DoubleStream doubles(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        return this.doubles().limit(limit).sequential();
    }

    default public DoubleStream doubles(long limit, double origin, double bound) {
        if (limit < 0L) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        if (!(origin < bound) || !(bound - origin < Double.POSITIVE_INFINITY)) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        return DoubleStream.generate(() -> this.nextDouble(origin, bound)).limit(limit).sequential();
    }

    default public IntStream ints() {
        return IntStream.generate(this::nextInt).sequential();
    }

    default public IntStream ints(int origin, int bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        return IntStream.generate(() -> this.nextInt(origin, bound)).sequential();
    }

    default public IntStream ints(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        return this.ints().limit(limit).sequential();
    }

    default public IntStream ints(long limit, int origin, int bound) {
        if (limit < 0L) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        if (origin >= bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        return this.ints(origin, bound).limit(limit).sequential();
    }

    default public LongStream longs() {
        return LongStream.generate(this::nextLong).sequential();
    }

    default public LongStream longs(long origin, long bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        return LongStream.generate(() -> this.nextLong(origin, bound)).sequential();
    }

    default public LongStream longs(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        return this.longs().limit(limit).sequential();
    }

    default public LongStream longs(long limit, long origin, long bound) {
        if (limit < 0L) {
            throw new IllegalArgumentException("size must be non-negative");
        }
        if (origin >= bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        return this.longs(origin, bound).limit(limit).sequential();
    }

    default public boolean nextBoolean() {
        return this.nextInt() < 0;
    }

    default public void nextBytes(byte[] bytes) {
        int n;
        long rnd;
        int i = 0;
        int len = bytes.length;
        int words = len >> 3;
        while (words-- > 0) {
            rnd = this.nextLong();
            for (n = 0; n < 8; ++n) {
                bytes[i++] = (byte)rnd;
                rnd >>>= 8;
            }
        }
        if (i < len) {
            rnd = this.nextLong();
            for (n = 0; n < len - i; ++n) {
                bytes[i++] = (byte)rnd;
                rnd >>>= 8;
            }
        }
    }

    default public float nextFloat() {
        return (float)(this.nextInt() >>> 8) * 5.9604645E-8f;
    }

    default public float nextFloat(float bound) {
        if (bound <= 0.0f) {
            throw new IllegalArgumentException("bound must be positive");
        }
        float r = this.nextFloat();
        if ((r *= bound) >= bound) {
            r = Math.nextDown(bound);
        }
        return r;
    }

    default public float nextFloat(float origin, float bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        float r = this.nextFloat();
        if ((r = r * (bound - origin) + origin) >= bound) {
            r = Math.nextDown(bound);
        }
        return r;
    }

    default public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    default public double nextDouble(double bound) {
        if (bound <= 0.0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        double r = this.nextDouble();
        if ((r *= bound) >= bound) {
            r = Math.nextDown(bound);
        }
        return r;
    }

    default public double nextDouble(double origin, double bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        double r = this.nextDouble();
        if ((r = r * (bound - origin) + origin) >= bound) {
            r = Math.nextDown(bound);
        }
        return r;
    }

    default public int nextInt() {
        return (int)(this.nextLong() >>> 32);
    }

    default public int nextInt(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException("bound must be positive");
        }
        int r = this.nextInt();
        int m = bound - 1;
        if ((bound & m) == 0) {
            r &= m;
        } else {
            int u = r >>> 1;
            while (u + m - (r = u % bound) < 0) {
                u = this.nextInt() >>> 1;
            }
        }
        return r;
    }

    default public int nextInt(int origin, int bound) {
        int r = this.nextInt();
        if (origin < bound) {
            int n = bound - origin;
            int m = n - 1;
            if ((n & m) == 0) {
                r = (r & m) + origin;
            } else if (n > 0) {
                int u = r >>> 1;
                while (u + m - (r = u % n) < 0) {
                    u = this.nextInt() >>> 1;
                }
                r += origin;
            } else {
                while (r < origin || r >= bound) {
                    r = this.nextInt();
                }
            }
        }
        return r;
    }

    public long nextLong();

    default public long nextLong(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        long m = bound - 1L;
        long r = this.nextLong();
        if ((bound & m) == 0L) {
            r &= m;
        } else {
            long u = r >>> 1;
            while (u + m - (r = u % bound) < 0L) {
                u = this.nextLong() >>> 1;
            }
        }
        return r;
    }

    default public long nextLong(long origin, long bound) {
        if (origin >= bound) {
            throw new IllegalArgumentException("bound must be greater than origin");
        }
        long r = this.nextLong();
        long n = bound - origin;
        long m = n - 1L;
        if ((n & m) == 0L) {
            r = (r & m) + origin;
        } else if (n > 0L) {
            long u = r >>> 1;
            while (u + m - (r = u % n) < 0L) {
                u = this.nextLong() >>> 1;
            }
            r += origin;
        } else {
            while (r < origin || r >= bound) {
                r = this.nextLong();
            }
        }
        return r;
    }

    default public double nextGaussian() {
        throw MissingStubError.create();
    }

    default public double nextGaussian(double mean, double stdDev) {
        throw MissingStubError.create();
    }

    default public double nextExponential() {
        throw MissingStubError.create();
    }

    @Adapter(value="java/util/random/RandomGenerator$SplittableGenerator")
    @NestHost(value=J_U_R_RandomGenerator.class)
    public static interface SplittableGenerator
    extends StreamableGenerator {
        public SplittableGenerator split();

        public SplittableGenerator split(SplittableGenerator var1);

        default public Stream<SplittableGenerator> splits() {
            return this.splits(this);
        }

        public Stream<SplittableGenerator> splits(long var1);

        public Stream<SplittableGenerator> splits(SplittableGenerator var1);

        public Stream<SplittableGenerator> splits(long var1, SplittableGenerator var3);

        @Override
        default public Stream<J_U_R_RandomGenerator> rngs() {
            return this.splits();
        }

        @Override
        default public Stream<J_U_R_RandomGenerator> rngs(long limit) {
            return this.splits(limit);
        }
    }

    @Adapter(value="java/util/random/RandomGenerator$StreamableGenerator")
    @NestHost(value=J_U_R_RandomGenerator.class)
    public static interface StreamableGenerator
    extends J_U_R_RandomGenerator {
        public Stream<J_U_R_RandomGenerator> rngs();

        default public Stream<J_U_R_RandomGenerator> rngs(long limit) {
            if (limit < 0L) {
                throw new IllegalArgumentException("size must be non-negative");
            }
            return this.rngs().limit(limit);
        }
    }
}

