/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database.cachebuilder;

import com.sinthoras.visualprospecting.VP;
import com.sinthoras.visualprospecting.database.ServerCache;
import com.sinthoras.visualprospecting.database.cachebuilder.AnalysisProgressTracker;
import com.sinthoras.visualprospecting.database.cachebuilder.DimensionAnalysis;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import java.util.zip.DataFormatException;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.io.FileUtils;

public class WorldAnalysis {
    private final File worldFolder;

    public WorldAnalysis(File worldDirectory) throws IOException {
        this.worldFolder = worldDirectory;
    }

    public void cacheOverworldSpawnVeins(ChunkCoordinates spawn) throws IOException, DataFormatException {
        VP.info("Starting to parse world save to cache GT vein locations near spawn. This might take some time...");
        ServerCache.instance.resetSpawnChunks(spawn, 0);
        this.cacheVeins(IntSets.singleton((int)0));
    }

    public void cacheVeins() throws IOException, DataFormatException {
        VP.info("Starting to parse world save to cache GT vein locations. This might take some time...");
        ServerCache.instance.reset();
        this.cacheVeins(this.getDimensionIds());
    }

    private void cacheVeins(IntSet dimensionIds) {
        AnalysisProgressTracker.setNumberOfDimensions(dimensionIds.size());
        IntIterator intIterator = dimensionIds.iterator();
        while (intIterator.hasNext()) {
            int dimensionId = (Integer)intIterator.next();
            Collection<File> regionFiles = this.getRegionFilesForDim(dimensionId);
            DimensionAnalysis dimension = new DimensionAnalysis(dimensionId);
            dimension.processMinecraftWorld(regionFiles);
            AnalysisProgressTracker.dimensionProcessed();
        }
        AnalysisProgressTracker.processingFinished();
        VP.info("Saving ore vein cache...");
        ServerCache.instance.saveVeinCache();
    }

    public IntSet getDimensionIds() throws IOException {
        IntOpenHashSet dimensionIds = new IntOpenHashSet();
        dimensionIds.addAll(Arrays.asList(DimensionManager.getIDs()));
        try (Stream<Path> files = Files.walk(this.worldFolder.toPath(), 1, new FileVisitOption[0]);){
            files.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).filter(path -> path.startsWith("DIM")).map(path -> path.substring(3)).forEach(arg_0 -> WorldAnalysis.lambda$getDimensionIds$4((IntSet)dimensionIds, arg_0));
        }
        return dimensionIds;
    }

    public Collection<File> getRegionFilesForDim(int dimensionId) {
        File dimRegionDir;
        WorldServer world = DimensionManager.getWorld((int)dimensionId);
        if (world != null) {
            dimRegionDir = new File(world.getChunkSaveLocation(), "region");
        } else {
            String subfolder = dimensionId == 0 ? "" : "/DIM" + dimensionId;
            dimRegionDir = new File(this.worldFolder, subfolder + "/region");
        }
        if (dimRegionDir.exists()) {
            return FileUtils.listFiles((File)dimRegionDir, (String[])new String[]{"mca"}, (boolean)false);
        }
        return new ArrayList<File>();
    }

    private static /* synthetic */ void lambda$getDimensionIds$4(IntSet dimensionIds, String dim) {
        try {
            dimensionIds.add(Integer.parseInt(dim));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

