/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.api.drawable;

import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.drawable.ITextLine;
import com.cleanroommc.modularui.drawable.text.Spacer;
import com.cleanroommc.modularui.utils.Alignment;

public interface IRichTextBuilder<T extends IRichTextBuilder<T>> {
    public T getThis();

    public IRichTextBuilder<?> getRichText();

    default public T add(String s) {
        this.getRichText().add(s);
        return this.getThis();
    }

    default public T add(IDrawable drawable) {
        this.getRichText().add(drawable);
        return this.getThis();
    }

    default public T addLine(String s) {
        this.getRichText().add(s).newLine();
        return this.getThis();
    }

    default public T addLine(ITextLine line) {
        this.getRichText().addLine(line);
        return this.getThis();
    }

    default public T addLine(IDrawable line) {
        this.getRichText().add(line).newLine();
        return this.getThis();
    }

    default public T newLine() {
        return this.add(IKey.LINE_FEED);
    }

    default public T space() {
        return this.add(IKey.SPACE);
    }

    default public T spaceLine(int pixelSpace) {
        return this.addLine(Spacer.of(pixelSpace));
    }

    default public T spaceLine() {
        return this.addLine(Spacer.SPACER_2PX);
    }

    default public T emptyLine() {
        return this.addLine(Spacer.LINE_SPACER);
    }

    default public T addElements(Iterable<IDrawable> drawables) {
        for (IDrawable drawable : drawables) {
            this.getRichText().add(drawable);
        }
        return this.getThis();
    }

    default public T addDrawableLines(Iterable<IDrawable> drawables) {
        for (IDrawable drawable : drawables) {
            this.getRichText().add(drawable).newLine();
        }
        return this.getThis();
    }

    default public T addStringLines(Iterable<String> drawables) {
        for (String drawable : drawables) {
            this.getRichText().add(drawable).newLine();
        }
        return this.getThis();
    }

    default public T clearText() {
        this.getRichText().clearText();
        return this.getThis();
    }

    default public T alignment(Alignment alignment) {
        this.getRichText().alignment(alignment);
        return this.getThis();
    }

    default public T textColor(int color) {
        this.getRichText().textColor(color);
        return this.getThis();
    }

    default public T scale(float scale) {
        this.getRichText().scale(scale);
        return this.getThis();
    }

    default public T textShadow(boolean shadow) {
        this.getRichText().textShadow(shadow);
        return this.getThis();
    }
}

