/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets.slot;

import com.cleanroommc.modularui.utils.item.IItemHandler;
import com.cleanroommc.modularui.utils.item.SlotItemHandler;
import com.cleanroommc.modularui.value.sync.ItemSlotSH;
import com.cleanroommc.modularui.widgets.slot.IOnSlotChanged;
import com.cleanroommc.modularui.widgets.slot.SlotGroup;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModularSlot
extends SlotItemHandler {
    private boolean enabled = true;
    private boolean canTake = true;
    private boolean canPut = true;
    private Predicate<ItemStack> filter = stack -> true;
    private IOnSlotChanged changeListener = IOnSlotChanged.DEFAULT;
    private boolean ignoreMaxStackSize = false;
    private String slotGroupName = null;
    private SlotGroup slotGroup = null;
    private boolean phantom = false;
    private ItemSlotSH syncHandler = null;

    public ModularSlot(IItemHandler itemHandler, int index) {
        super(itemHandler, index, Integer.MIN_VALUE, Integer.MIN_VALUE);
        if (index < 0 || index >= itemHandler.getSlots()) {
            throw new IllegalArgumentException("Tried to create a slot with invalid index " + index + ". Valid index range is [0," + itemHandler.getSlots() + ")");
        }
    }

    @ApiStatus.Internal
    public void initialize(ItemSlotSH syncManager, boolean phantom) {
        this.syncHandler = syncManager;
        this.phantom = phantom;
    }

    protected boolean canPut() {
        return this.canPut;
    }

    protected boolean canTake() {
        return this.canTake;
    }

    @ApiStatus.Internal
    public void dispose() {
        this.syncHandler = null;
        this.phantom = false;
    }

    public boolean isInitialized() {
        return this.syncHandler != null;
    }

    @Override
    public boolean func_75214_a(@Nullable ItemStack stack) {
        return this.canPut && stack != null && this.filter.test(stack) && super.func_75214_a(stack);
    }

    @Override
    public boolean func_82869_a(EntityPlayer playerIn) {
        return this.canTake && super.func_82869_a(playerIn);
    }

    @Override
    public int getItemStackLimit(@NotNull ItemStack stack) {
        return this.ignoreMaxStackSize ? this.func_75219_a() : super.getItemStackLimit(stack);
    }

    public void func_75218_e() {
    }

    public void onSlotChangedReal(ItemStack itemStack, boolean onlyChangedAmount, boolean client, boolean init) {
        this.changeListener.onChange(itemStack, onlyChangedAmount, client, init);
        if (!init && this.isInitialized()) {
            this.getSyncHandler().getSyncManager().getContainer().onSlotChanged(this, itemStack, onlyChangedAmount);
        }
    }

    public void onCraftShiftClick(EntityPlayer player, ItemStack stack) {
    }

    @Override
    public void func_75215_d(ItemStack stack) {
        if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)this.func_75211_c())) {
            return;
        }
        super.func_75215_d(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBackgroundIconIndex() {
        return null;
    }

    @ApiStatus.Internal
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean func_111238_b() {
        return this.enabled;
    }

    public boolean isPhantom() {
        return this.phantom;
    }

    public boolean isIgnoreMaxStackSize() {
        return this.ignoreMaxStackSize;
    }

    @Nullable
    public String getSlotGroupName() {
        return this.slotGroupName;
    }

    @Nullable
    public SlotGroup getSlotGroup() {
        return this.slotGroup;
    }

    @NotNull
    public ItemSlotSH getSyncHandler() {
        if (this.syncHandler == null) {
            throw new IllegalStateException("ModularSlot is not yet initialized");
        }
        return this.syncHandler;
    }

    protected EntityPlayer getPlayer() {
        return this.getSyncHandler().getSyncManager().getPlayer();
    }

    public ModularSlot filter(Predicate<ItemStack> filter) {
        this.filter = filter != null ? filter : stack -> true;
        return this;
    }

    public ModularSlot changeListener(IOnSlotChanged changeListener) {
        this.changeListener = changeListener != null ? changeListener : IOnSlotChanged.DEFAULT;
        return this;
    }

    public ModularSlot accessibility(boolean canPut, boolean canTake) {
        this.canPut = canPut;
        this.canTake = canTake;
        return this;
    }

    @ApiStatus.Experimental
    public ModularSlot ignoreMaxStackSize(boolean ignoreMaxStackSize) {
        this.ignoreMaxStackSize = ignoreMaxStackSize;
        return this;
    }

    public ModularSlot slotGroup(String slotGroup) {
        this.slotGroupName = slotGroup;
        return this;
    }

    public ModularSlot slotGroup(SlotGroup slotGroup) {
        if (this.slotGroup == slotGroup) {
            return this;
        }
        if (this.slotGroup != null) {
            this.slotGroup.removeSlot(this);
        }
        this.slotGroup = slotGroup;
        if (this.slotGroup != null) {
            this.slotGroup.addSlot(this);
        }
        return this;
    }

    public ModularSlot singletonSlotGroup(int shiftClickPriority) {
        this.slotGroupName = null;
        return this.slotGroup(SlotGroup.singleton(((Object)((Object)this)).toString(), shiftClickPriority));
    }

    public ModularSlot singletonSlotGroup() {
        return this.singletonSlotGroup(100);
    }
}

