/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render.carts;

import mods.railcraft.api.carts.bore.IBoreHead;
import mods.railcraft.client.render.models.bore.ModelTunnelBore;
import mods.railcraft.common.carts.EntityTunnelBore;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderTunnelBore
extends Render {
    private static final ResourceLocation TEXTURE = new ResourceLocation("railcraft:textures/entities/carts/tunnel_bore.png");
    protected ModelTunnelBore modelTunnelBore;

    public RenderTunnelBore() {
        this.field_76989_e = 0.5f;
        this.modelTunnelBore = new ModelTunnelBore();
    }

    public void render(EntityTunnelBore bore, double x, double y, double z, float yaw, float time) {
        GL11.glPushMatrix();
        long var10 = (long)bore.func_145782_y() * 493286711L;
        var10 = var10 * var10 * 4392167121L + var10 * 98761L;
        float tx = (((float)(var10 >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float ty = (((float)(var10 >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float tz = (((float)(var10 >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        GL11.glTranslatef((float)tx, (float)ty, (float)tz);
        if (RenderManager.field_85095_o) {
            GL11.glPushAttrib((int)8192);
            GL11.glDisable((int)3553);
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3042);
            for (Entity part : bore.func_70021_al()) {
                GL11.glPushMatrix();
                double posX = part.field_70142_S + (part.field_70165_t - part.field_70142_S) * (double)time - RenderManager.field_78725_b;
                double posY = part.field_70137_T + (part.field_70163_u - part.field_70137_T) * (double)time - RenderManager.field_78726_c;
                double posZ = part.field_70136_U + (part.field_70161_v - part.field_70136_U) * (double)time - RenderManager.field_78723_d;
                GL11.glTranslatef((float)((float)posX), (float)((float)posY), (float)((float)posZ));
                float halfWidth = part.field_70130_N / 2.0f;
                AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)(-halfWidth), (double)0.0, (double)(-halfWidth), (double)halfWidth, (double)part.field_70131_O, (double)halfWidth);
                RenderGlobal.func_147590_a((AxisAlignedBB)axisalignedbb, (int)0xFFFFFF);
                GL11.glPopMatrix();
            }
            GL11.glPopAttrib();
        }
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        switch (bore.getFacing()) {
            case NORTH: {
                yaw = 90.0f;
                break;
            }
            case EAST: {
                yaw = 0.0f;
                break;
            }
            case SOUTH: {
                yaw = 270.0f;
                break;
            }
            case WEST: {
                yaw = 180.0f;
            }
        }
        GL11.glRotatef((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        float f3 = (float)bore.func_70496_j() - time;
        float f4 = bore.func_70491_i() - time;
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f3 > 0.0f) {
            float angle = MathHelper.func_76126_a((float)f3) * f3 * f4 / 10.0f;
            angle = Math.min(angle, 0.8f);
            angle = Math.copySign(angle, bore.func_70493_k());
            GL11.glRotatef((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        float light = bore.func_70013_c(time);
        light += (1.0f - light) * 0.4f;
        int j = 0xFFFFFF;
        float c1 = (float)(j >> 16 & 0xFF) / 255.0f;
        float c2 = (float)(j >> 8 & 0xFF) / 255.0f;
        float c3 = (float)(j & 0xFF) / 255.0f;
        GL11.glColor4f((float)(c1 * light), (float)(c2 * light), (float)(c3 * light), (float)1.0f);
        IBoreHead head = bore.getBoreHead();
        if (head != null) {
            this.func_110776_a(head.getBoreTexture());
            this.modelTunnelBore.setRenderBoreHead(true);
        } else {
            this.func_110776_a(TEXTURE);
            this.modelTunnelBore.setRenderBoreHead(false);
        }
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        this.modelTunnelBore.setBoreHeadRotation(bore.getBoreRotationAngle());
        this.modelTunnelBore.setBoreActive(bore.isMinecartPowered());
        this.modelTunnelBore.render(0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
    }

    public void func_76986_a(Entity entity, double d, double d1, double d2, float f, float f1) {
        this.render((EntityTunnelBore)entity, d, d1, d2, f, f1);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return TEXTURE;
    }
}

