/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class TrackControl
extends TrackBaseRailcraft
implements ITrackPowered,
ITrackReversable {
    private boolean powered = false;
    private boolean reversed = false;
    private static final double BOOST_AMOUNT = 0.02;
    private static final double SLOW_AMOUNT = 0.02;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.CONTROL;
    }

    @Override
    public IIcon getIcon() {
        if (this.isPowered() ^ this.reversed) {
            return this.getIcon(1);
        }
        return this.getIcon(0);
    }

    @Override
    public int getPowerPropagation() {
        return 16;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        int meta = this.tileEntity.func_145832_p();
        if (meta == 0 || meta == 4 || meta == 5) {
            if (cart.field_70179_y <= 0.0) {
                cart.field_70179_y = this.isPowered() ^ !this.reversed ? (cart.field_70179_y -= 0.02) : (cart.field_70179_y += 0.02);
            } else if (cart.field_70179_y >= 0.0) {
                cart.field_70179_y = !this.isPowered() ^ !this.reversed ? (cart.field_70179_y += 0.02) : (cart.field_70179_y -= 0.02);
            }
        } else if (meta == 1 || meta == 2 || meta == 3) {
            if (cart.field_70159_w <= 0.0) {
                cart.field_70159_w = this.isPowered() ^ this.reversed ? (cart.field_70159_w -= 0.02) : (cart.field_70159_w += 0.02);
            } else if (cart.field_70159_w >= 0.0) {
                cart.field_70159_w = !this.isPowered() ^ this.reversed ? (cart.field_70159_w += 0.02) : (cart.field_70159_w -= 0.02);
            }
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("powered", this.powered);
        nbttagcompound.func_74757_a("reversed", this.reversed);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.func_74767_n("powered");
        this.reversed = nbttagcompound.func_74767_n("reversed");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.reversed = data.readBoolean();
        this.markBlockNeedsUpdate();
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }
}

