/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.blocks.LogisticsSolidTileEntity;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IGuiTileEntity;
import logisticspipes.interfaces.ISecurityProvider;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.block.SecurityStationGui;
import logisticspipes.network.packets.block.SecurityStationAutoDestroy;
import logisticspipes.network.packets.block.SecurityStationCC;
import logisticspipes.network.packets.block.SecurityStationCCIDs;
import logisticspipes.network.packets.block.SecurityStationId;
import logisticspipes.network.packets.block.SecurityStationOpenPlayer;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.security.SecuritySettings;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifierInventory;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class LogisticsSecurityTileEntity
extends LogisticsSolidTileEntity
implements IGuiOpenControler,
ISecurityProvider,
IGuiTileEntity {
    public ItemIdentifierInventory inv = new ItemIdentifierInventory(1, "ID Slots", 64);
    private final PlayerCollectionList listener = new PlayerCollectionList();
    private UUID secId = null;
    private final Map<String, SecuritySettings> settingsList = new HashMap<String, SecuritySettings>();
    public List<Integer> excludedCC = new ArrayList<Integer>();
    public boolean allowCC = false;
    public boolean allowAutoDestroy = false;
    public static PlayerCollectionList byPassed = new PlayerCollectionList();
    public static final SecuritySettings allowAll = new SecuritySettings("");

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (MainProxy.isServer(this.getWorld())) {
            SimpleServiceLocator.securityStationManager.remove(this);
        }
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (MainProxy.isServer(this.getWorld())) {
            SimpleServiceLocator.securityStationManager.add(this);
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (MainProxy.isServer(this.getWorld())) {
            SimpleServiceLocator.securityStationManager.remove(this);
        }
    }

    public void deauthorizeStation() {
        SimpleServiceLocator.securityStationManager.deauthorizeUUID(this.getSecId());
    }

    public void authorizeStation() {
        SimpleServiceLocator.securityStationManager.authorizeUUID(this.getSecId());
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SecurityStationCC.class).setInteger(this.allowCC ? 1 : 0).setPosX(this.field_145851_c).setPosY(this.field_145848_d).setPosZ(this.field_145849_e), player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SecurityStationAutoDestroy.class).setInteger(this.allowAutoDestroy ? 1 : 0).setPosX(this.field_145851_c).setPosY(this.field_145848_d).setPosZ(this.field_145849_e), player);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SecurityStationId.class).setUuid(this.getSecId()).setPosX(this.field_145851_c).setPosY(this.field_145848_d).setPosZ(this.field_145849_e), player);
        SimpleServiceLocator.securityStationManager.sendClientAuthorizationList();
        this.listener.add(player);
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.listener.remove(player);
    }

    public UUID getSecId() {
        if (MainProxy.isServer(this.getWorld()) && this.secId == null) {
            this.secId = UUID.randomUUID();
        }
        return this.secId;
    }

    public void setClientUUID(UUID id) {
        if (MainProxy.isClient(this.getWorld())) {
            this.secId = id;
        }
    }

    public void setClientCC(boolean flag) {
        if (MainProxy.isClient(this.getWorld())) {
            this.allowCC = flag;
        }
    }

    public void setClientDestroy(boolean flag) {
        if (MainProxy.isClient(this.getWorld())) {
            this.allowAutoDestroy = flag;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound par1nbtTagCompound) {
        NBTBase base;
        super.func_145839_a(par1nbtTagCompound);
        if (par1nbtTagCompound.func_74764_b("UUID")) {
            this.secId = UUID.fromString(par1nbtTagCompound.func_74779_i("UUID"));
        }
        this.allowCC = par1nbtTagCompound.func_74767_n("allowCC");
        this.allowAutoDestroy = par1nbtTagCompound.func_74767_n("allowAutoDestroy");
        this.inv.readFromNBT(par1nbtTagCompound);
        this.settingsList.clear();
        NBTTagList list = par1nbtTagCompound.func_150295_c("settings", 10);
        while (list.func_74745_c() > 0) {
            base = list.func_74744_a(0);
            String name = ((NBTTagCompound)base).func_74779_i("name");
            NBTTagCompound value = ((NBTTagCompound)base).func_74775_l("content");
            SecuritySettings settings = new SecuritySettings(name);
            settings.readFromNBT(value);
            this.settingsList.put(name, settings);
        }
        this.excludedCC.clear();
        list = par1nbtTagCompound.func_150295_c("excludedCC", 3);
        while (list.func_74745_c() > 0) {
            base = list.func_74744_a(0);
            this.excludedCC.add(((NBTTagInt)base).func_150287_d());
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound par1nbtTagCompound) {
        super.func_145841_b(par1nbtTagCompound);
        par1nbtTagCompound.func_74778_a("UUID", this.getSecId().toString());
        par1nbtTagCompound.func_74757_a("allowCC", this.allowCC);
        par1nbtTagCompound.func_74757_a("allowAutoDestroy", this.allowAutoDestroy);
        this.inv.writeToNBT(par1nbtTagCompound);
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, SecuritySettings> entry : this.settingsList.entrySet()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("name", entry.getKey());
            NBTTagCompound value = new NBTTagCompound();
            entry.getValue().writeToNBT(value);
            nbt.func_74782_a("content", (NBTBase)value);
            list.func_74742_a((NBTBase)nbt);
        }
        par1nbtTagCompound.func_74782_a("settings", (NBTBase)list);
        list = new NBTTagList();
        for (Integer i : this.excludedCC) {
            list.func_74742_a((NBTBase)new NBTTagInt(i.intValue()));
        }
        par1nbtTagCompound.func_74782_a("excludedCC", (NBTBase)list);
    }

    public void buttonFreqCard(int integer, EntityPlayer player) {
        switch (integer) {
            case 0: {
                this.inv.clearInventorySlotContents(0);
                break;
            }
            case 1: {
                this.inv.func_70298_a(0, 1);
                break;
            }
            case 2: {
                if (!this.useEnergy(10)) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("lp.misc.noenergy", new Object[0]));
                    return;
                }
                if (this.inv.func_70301_a(0) == null) {
                    ItemStack stack = new ItemStack(LogisticsPipes.LogisticsItemCard, 1, 1);
                    stack.func_77982_d(new NBTTagCompound());
                    stack.func_77978_p().func_74778_a("UUID", this.getSecId().toString());
                    this.inv.func_70299_a(0, stack);
                    break;
                }
                ItemStack slot = this.inv.func_70301_a(0);
                if (slot.field_77994_a >= 64) break;
                ++slot.field_77994_a;
                slot.func_77982_d(new NBTTagCompound());
                slot.func_77978_p().func_74778_a("UUID", this.getSecId().toString());
                this.inv.func_70299_a(0, slot);
                break;
            }
            case 3: {
                if (!this.useEnergy(640)) {
                    player.func_146105_b((IChatComponent)new ChatComponentTranslation("lp.misc.noenergy", new Object[0]));
                    return;
                }
                ItemStack stack = new ItemStack(LogisticsPipes.LogisticsItemCard, 64, 1);
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74778_a("UUID", this.getSecId().toString());
                this.inv.func_70299_a(0, stack);
            }
        }
    }

    public void handleOpenSecurityPlayer(EntityPlayer player, String string) {
        SecuritySettings setting = this.settingsList.get(string);
        if (setting == null && string != null && !string.isEmpty()) {
            setting = new SecuritySettings(string);
            this.settingsList.put(string, setting);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        setting.writeToNBT(nbt);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SecurityStationOpenPlayer.class).setTag(nbt), player);
    }

    public void saveNewSecuritySettings(NBTTagCompound tag) {
        SecuritySettings setting = this.settingsList.get(tag.func_74779_i("name"));
        if (setting == null) {
            setting = new SecuritySettings(tag.func_74779_i("name"));
            this.settingsList.put(tag.func_74779_i("name"), setting);
        }
        setting.readFromNBT(tag);
    }

    public SecuritySettings getSecuritySettingsForPlayer(EntityPlayer entityplayer, boolean usePower) {
        if (byPassed.contains(entityplayer)) {
            return allowAll;
        }
        if (usePower && !this.useEnergy(10)) {
            entityplayer.func_146105_b((IChatComponent)new ChatComponentTranslation("lp.misc.noenergy", new Object[0]));
            return new SecuritySettings("No Energy");
        }
        SecuritySettings setting = this.settingsList.get(entityplayer.getDisplayName());
        if (setting == null) {
            setting = new SecuritySettings(entityplayer.getDisplayName());
            this.settingsList.put(entityplayer.getDisplayName(), setting);
        }
        return setting;
    }

    public void changeCC() {
        this.allowCC = !this.allowCC;
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(SecurityStationCC.class).setInteger(this.allowCC ? 1 : 0).setPosX(this.field_145851_c).setPosY(this.field_145848_d).setPosZ(this.field_145849_e), this.listener);
    }

    public void changeDestroy() {
        this.allowAutoDestroy = !this.allowAutoDestroy;
        MainProxy.sendToPlayerList((ModernPacket)PacketHandler.getPacket(SecurityStationAutoDestroy.class).setInteger(this.allowAutoDestroy ? 1 : 0).setPosX(this.field_145851_c).setPosY(this.field_145848_d).setPosZ(this.field_145849_e), this.listener);
    }

    public void addCCToList(Integer id) {
        if (!this.excludedCC.contains(id)) {
            this.excludedCC.add(id);
        }
        Collections.sort(this.excludedCC);
    }

    public void removeCCFromList(Integer id) {
        this.excludedCC.remove(id);
    }

    public void requestList(EntityPlayer player) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (Integer i : this.excludedCC) {
            list.func_74742_a((NBTBase)new NBTTagInt(i.intValue()));
        }
        tag.func_74782_a("list", (NBTBase)list);
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(SecurityStationCCIDs.class).setTag(tag).setPosX(this.field_145851_c).setPosY(this.field_145848_d).setPosZ(this.field_145849_e), player);
    }

    public void handleListPacket(NBTTagCompound tag) {
        this.excludedCC.clear();
        NBTTagList list = tag.func_150295_c("list", 3);
        while (list.func_74745_c() > 0) {
            NBTBase base = list.func_74744_a(0);
            this.excludedCC.add(((NBTTagInt)base).func_150287_d());
        }
    }

    @Override
    public boolean getAllowCC(int id) {
        if (!this.useEnergy(10)) {
            return false;
        }
        return this.allowCC != this.excludedCC.contains(id);
    }

    @Override
    public boolean canAutomatedDestroy() {
        if (!this.useEnergy(10)) {
            return false;
        }
        return this.allowAutoDestroy;
    }

    private boolean useEnergy(int amount) {
        for (int i = 0; i < 4; ++i) {
            TileEntity tile = OrientationsUtil.getTileNextToThis(this, ForgeDirection.VALID_DIRECTIONS[i + 2]);
            if (tile instanceof IRoutedPowerProvider && ((IRoutedPowerProvider)tile).useEnergy(amount)) {
                return true;
            }
            if (!(tile instanceof LogisticsTileGenericPipe) || !(((LogisticsTileGenericPipe)tile).pipe instanceof IRoutedPowerProvider) || !((IRoutedPowerProvider)((Object)((LogisticsTileGenericPipe)tile).pipe)).useEnergy(amount)) continue;
            return true;
        }
        return false;
    }

    public void func_145828_a(CrashReportCategory par1CrashReportCategory) {
        super.func_145828_a(par1CrashReportCategory);
        par1CrashReportCategory.func_71507_a("LP-Version", (Object)"1.4.22-GTNH");
    }

    public World getWorld() {
        return this.func_145831_w();
    }

    @Override
    public CoordinatesGuiProvider getGuiProvider() {
        return NewGuiHandler.getGui(SecurityStationGui.class);
    }

    static {
        LogisticsSecurityTileEntity.allowAll.openGui = true;
        LogisticsSecurityTileEntity.allowAll.openRequest = true;
        LogisticsSecurityTileEntity.allowAll.openUpgrades = true;
        LogisticsSecurityTileEntity.allowAll.openNetworkMonitor = true;
        LogisticsSecurityTileEntity.allowAll.removePipes = true;
    }
}

