/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialconnection;

import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.ISpecialPipedConnection;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.specialconnection.SpecialPipeConnection;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TeleportPipes
implements ISpecialPipedConnection {
    private static Class<? extends Pipe<?>> PipeItemTeleport;
    private static Method teleportPipeMethod;
    private static Object teleportManager;

    @Override
    public boolean init() {
        try {
            try {
                PipeItemTeleport = Class.forName("buildcraft.additionalpipes.pipes.PipeItemTeleport");
            }
            catch (Exception e) {
                PipeItemTeleport = Class.forName("net.minecraft.src.buildcraft.additionalpipes.pipes.PipeItemTeleport");
            }
            teleportPipeMethod = PipeItemTeleport.getMethod("getConnectedPipes", Boolean.TYPE);
            LogisticsPipes.log.debug("Additional pipes detected, adding compatibility");
            return true;
        }
        catch (Exception e1) {
            try {
                PipeItemTeleport = Class.forName("buildcraft.additionalpipes.pipes.PipeItemsTeleport");
                Class<?> tpmanager = Class.forName("buildcraft.additionalpipes.pipes.TeleportManager");
                teleportManager = tpmanager.getField("instance").get(null);
                teleportPipeMethod = tpmanager.getMethod("getConnectedPipes", Class.forName("buildcraft.additionalpipes.pipes.PipeTeleport"), Boolean.TYPE);
                LogisticsPipes.log.debug("Additional pipes detected, adding compatibility");
                return true;
            }
            catch (Exception e2) {
                LogisticsPipes.log.debug("Additional pipes not detected: " + e2.getMessage());
                return false;
            }
        }
    }

    @Override
    public boolean isType(IPipeInformationProvider tile) {
        if (tile.getTile() instanceof TileGenericPipe && ((TileGenericPipe)tile.getTile()).pipe != null) {
            return PipeItemTeleport.isAssignableFrom(((TileGenericPipe)tile.getTile()).pipe.getClass());
        }
        return false;
    }

    private LinkedList<? extends Pipe<?>> getConnectedTeleportPipes(Pipe<?> pipe) throws Exception {
        if (teleportManager != null) {
            return (LinkedList)teleportPipeMethod.invoke(teleportManager, pipe, false);
        }
        return (LinkedList)teleportPipeMethod.invoke(pipe, false);
    }

    @Override
    public List<SpecialPipeConnection.ConnectionInformation> getConnections(IPipeInformationProvider tile, EnumSet<PipeRoutingConnectionType> connection, ForgeDirection side) {
        ArrayList<SpecialPipeConnection.ConnectionInformation> list = new ArrayList<SpecialPipeConnection.ConnectionInformation>();
        if (tile.getTile() instanceof TileGenericPipe && ((TileGenericPipe)tile.getTile()).pipe != null) {
            try {
                LinkedList<Pipe<?>> pipes = this.getConnectedTeleportPipes(((TileGenericPipe)tile.getTile()).pipe);
                for (Pipe pipe : pipes) {
                    list.add(new SpecialPipeConnection.ConnectionInformation(SimpleServiceLocator.pipeInformationManager.getInformationProviderFor((TileEntity)pipe.container), connection, side, ForgeDirection.UNKNOWN, 0.0));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list;
    }
}

