/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.td;

import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.render.uv.IconTransformation;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.thermaldynamics.duct.item.TileItemDuct;
import cofh.thermaldynamics.render.RenderDuct;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.ITDProxy;
import logisticspipes.proxy.td.TDDuctInformationProvider;
import logisticspipes.proxy.td.subproxies.ITDPart;
import logisticspipes.proxy.td.subproxies.TDPart;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class ThermalDynamicsProxy
implements ITDProxy {
    private IconTransformation connectionTextureBasic;
    private IconTransformation connectionTextureActive;
    private IconTransformation connectionTextureInactive;

    @Override
    public void registerPipeInformationProvider() {
        SimpleServiceLocator.pipeInformationManager.registerProvider(TileItemDuct.class, TDDuctInformationProvider.class);
    }

    @Override
    public ITDPart getTDPart(LogisticsTileGenericPipe pipe) {
        return new TDPart(pipe);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public boolean isItemDuct(TileEntity tile) {
        return tile instanceof TileItemDuct;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderPipeConnections(LogisticsTileGenericPipe pipeTile, RenderBlocks renderer) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!pipeTile.renderState.pipeConnectionMatrix.isTDConnected(dir)) continue;
            IconTransformation texture = this.connectionTextureBasic;
            if (pipeTile.renderState.textureMatrix.isRouted()) {
                texture = pipeTile.renderState.textureMatrix.isRoutedInDir(dir) ? this.connectionTextureActive : this.connectionTextureInactive;
            }
            double move = 0.25;
            Translation localTranslation = new Translation((double)pipeTile.field_145851_c + 0.5 + (double)dir.offsetX * move, (double)pipeTile.field_145848_d + 0.5 + (double)dir.offsetY * move, (double)pipeTile.field_145849_e + 0.5 + (double)dir.offsetZ * move);
            RenderDuct.modelConnection[2][dir.ordinal()].render(new CCRenderState.IVertexOperation[]{localTranslation, texture});
        }
    }

    @Override
    public void registerTextures(IIconRegister iconRegister) {
        if (this.connectionTextureBasic == null) {
            this.connectionTextureBasic = new IconTransformation(iconRegister.func_94245_a("logisticspipes:pipes/ThermalDynamicsConnection-Basic"));
            this.connectionTextureActive = new IconTransformation(iconRegister.func_94245_a("logisticspipes:pipes/ThermalDynamicsConnection-Active"));
            this.connectionTextureInactive = new IconTransformation(iconRegister.func_94245_a("logisticspipes:pipes/ThermalDynamicsConnection-Inactive"));
        } else {
            this.connectionTextureBasic.icon = iconRegister.func_94245_a("logisticspipes:pipes/ThermalDynamicsConnection-Basic");
            this.connectionTextureActive.icon = iconRegister.func_94245_a("logisticspipes:pipes/ThermalDynamicsConnection-Active");
            this.connectionTextureInactive.icon = iconRegister.func_94245_a("logisticspipes:pipes/ThermalDynamicsConnection-Inactive");
        }
    }

    @Override
    public boolean isBlockedSide(TileEntity with, ForgeDirection opposite) {
        if (!(with instanceof TileItemDuct)) {
            return false;
        }
        return ((TileItemDuct)with).isBlockedSide(opposite.ordinal());
    }
}

