/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.armor.player;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class KnapsackInventory
implements IInventory {
    public ItemStack[] inventory = new ItemStack[27];
    public WeakReference<EntityPlayer> parent;

    public void init(EntityPlayer player) {
        this.parent = new WeakReference<EntityPlayer>(player);
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public boolean isStackInSlot(int slot) {
        return this.inventory[slot] != null;
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean canDropInventorySlot(int slot) {
        return true;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= quantity) {
                ItemStack stack = this.inventory[slot];
                this.inventory[slot] = null;
                return stack;
            }
            ItemStack split = this.inventory[slot].func_77979_a(quantity);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return split;
        }
        return null;
    }

    public String func_145825_b() {
        return "tconstruct.knapsack";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void openChest() {
    }

    public void closeChest() {
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return true;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void saveToNBT(NBTTagCompound tagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound invSlot = new NBTTagCompound();
            invSlot.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(invSlot);
            tagList.func_74742_a((NBTBase)invSlot);
        }
        tagCompound.func_74782_a("Knapsack", (NBTBase)tagList);
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        if (tagCompound == null || !tagCompound.func_74764_b("Knapsack")) {
            return;
        }
        NBTTagList tagList = tagCompound.func_150295_c("Knapsack", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = tagList.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            ItemStack itemstack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
            if (itemstack == null) continue;
            this.inventory[j] = itemstack;
        }
    }

    public void dropItems() {
        EntityPlayer player = (EntityPlayer)this.parent.get();
        if (player != null) {
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] == null) continue;
                player.func_146097_a(this.inventory[i], true, false);
                this.inventory[i] = null;
            }
        }
    }

    public void unequipItems() {
        EntityPlayer player = (EntityPlayer)this.parent.get();
        if (player != null) {
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] == null) continue;
                this.dropItemEntity((Entity)player, this.inventory[i]);
                this.inventory[i] = null;
            }
        }
    }

    void dropItemEntity(Entity dropper, ItemStack dropStack) {
        EntityItem entityitem = new EntityItem(dropper.field_70170_p, dropper.field_70165_t, dropper.field_70163_u, dropper.field_70161_v, dropStack);
        dropper.field_70170_p.func_72838_d((Entity)entityitem);
    }

    public void func_70296_d() {
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void writeInventoryToStream(ByteBuf os) {
        for (int i = 0; i < 27; ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)os, (ItemStack)this.inventory[i]);
        }
    }

    public void readInventoryFromStream(ByteBuf is) {
        for (int i = 0; i < 27; ++i) {
            this.inventory[i] = ByteBufUtils.readItemStack((ByteBuf)is);
        }
    }
}

