/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.cc.multiperipheral;

import cpw.mods.fml.common.Optional;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openperipheral.api.ApiAccess;
import openperipheral.api.architecture.cc.IComputerCraftObjectsFactory;
import openperipheral.api.peripheral.IOpenPeripheral;
import openperipheral.api.peripheral.IPeripheralBlacklist;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheral;
import pl.asie.computronics.api.multiperipheral.IMultiPeripheralProvider;
import pl.asie.computronics.cc.multiperipheral.DefaultMultiPeripheral;
import pl.asie.computronics.cc.multiperipheral.MultiPeripheral;
import pl.asie.computronics.cc.multiperipheral.OpenMultiPeripheral;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;

public class MultiPeripheralProvider
implements IPeripheralProvider {
    ArrayList<IMultiPeripheralProvider> peripheralProviders = new ArrayList();
    public static Logger log = LogManager.getLogger((String)"computronics-multiperipheral");
    private List<IPeripheralProvider> ccPeripheralProviders;
    private boolean ccErrored = false;

    public MultiPeripheralProvider(ArrayList<IMultiPeripheralProvider> peripheralProviders) {
        this.peripheralProviders = peripheralProviders;
    }

    public IPeripheral getPeripheral(World world, int x, int y, int z, int side) {
        IMultiPeripheral peripheral;
        ArrayList<IMultiPeripheral> periphs = new ArrayList<IMultiPeripheral>();
        for (IMultiPeripheralProvider peripheralProvider : this.peripheralProviders) {
            IMultiPeripheral p = peripheralProvider.getPeripheral(world, x, y, z, side);
            if (p == null) continue;
            periphs.add(p);
        }
        if (Config.CC_ALL_MULTI_PERIPHERALS) {
            this.getAllPeripherals(periphs, world, x, y, z, side);
        }
        if (Mods.isLoaded("OpenPeripheralCore") && Config.CC_OPEN_MULTI_PERIPHERAL && (peripheral = this.getOpenPeripheral(world, x, y, z)) != null) {
            periphs.add(peripheral);
        }
        if (!periphs.isEmpty()) {
            return periphs.size() == 1 ? (IPeripheral)periphs.get(0) : new MultiPeripheral(periphs);
        }
        return null;
    }

    @Optional.Method(modid="OpenPeripheralCore")
    private IMultiPeripheral getOpenPeripheral(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        try {
            if (tile != null && ApiAccess.isApiPresent(IComputerCraftObjectsFactory.class)) {
                IPeripheral peripheral = ((IComputerCraftObjectsFactory)ApiAccess.getApi(IComputerCraftObjectsFactory.class)).createPeripheral((Object)tile);
                boolean blacklisted = false;
                if (ApiAccess.isApiPresent(IPeripheralBlacklist.class)) {
                    blacklisted = ((IPeripheralBlacklist)ApiAccess.getApi(IPeripheralBlacklist.class)).isBlacklisted(tile.getClass());
                }
                if (peripheral != null && !blacklisted) {
                    return new OpenMultiPeripheral(peripheral);
                }
            }
        }
        catch (Exception e) {
            log.debug("An exception got thrown trying to get OpenPeripheral peripherals", (Throwable)e);
        }
        catch (Throwable t) {
            log.error("An error occured trying to get OpenPeripheral peripherals", t);
        }
        return null;
    }

    private void getCCProviders() {
        List ccperiphs;
        if (this.ccErrored || this.ccPeripheralProviders != null) {
            return;
        }
        this.ccPeripheralProviders = new ArrayList<IPeripheralProvider>();
        try {
            Class<?> cclass = Class.forName("dan200.computercraft.ComputerCraft");
            Field cfield = cclass.getDeclaredField("peripheralProviders");
            cfield.setAccessible(true);
            ccperiphs = (List)cfield.get(null);
        }
        catch (IllegalAccessException e) {
            log.error("Could not access ComputerCraft peripheral provider list");
            this.ccErrored = true;
            return;
        }
        catch (ClassNotFoundException e) {
            log.error("Could not find ComputerCraft main class");
            this.ccErrored = true;
            return;
        }
        catch (NoSuchFieldException e) {
            log.error("Could not find ComputerCraft peripheral provider list");
            this.ccErrored = true;
            return;
        }
        catch (ClassCastException e) {
            log.error("Could not cast ComputerCraft peripheral provider list");
            this.ccErrored = true;
            return;
        }
        catch (Exception e) {
            log.error("Could not wrap ComputerCraft peripheral provider list");
            this.ccErrored = true;
            return;
        }
        if (ccperiphs == null) {
            return;
        }
        if (Config.CC_ALWAYS_FIRST) {
            for (int i = 0; i < ccperiphs.size(); ++i) {
                Object o = ccperiphs.get(i);
                if (o == null || !(o instanceof MultiPeripheralProvider)) continue;
                ccperiphs.remove(i);
                ccperiphs.add(0, o);
                break;
            }
        }
        for (Object ccperiph : ccperiphs) {
            if (ccperiph == null || !(ccperiph instanceof IPeripheralProvider) || ccperiph instanceof MultiPeripheralProvider || Mods.isLoaded("OpenPeripheralCore") && this.isOpenPeripheral(ccperiph)) continue;
            this.ccPeripheralProviders.add((IPeripheralProvider)ccperiph);
        }
    }

    private void getAllPeripherals(ArrayList<IMultiPeripheral> periphs, World world, int x, int y, int z, int side) {
        if (this.ccErrored) {
            return;
        }
        if (this.ccPeripheralProviders == null) {
            this.getCCProviders();
        }
        try {
            for (IPeripheralProvider peripheralProvider : this.ccPeripheralProviders) {
                if (peripheralProvider == null) continue;
                try {
                    IPeripheral peripheral = peripheralProvider.getPeripheral(world, x, y, z, side);
                    if (peripheral == null) continue;
                    periphs.add(new DefaultMultiPeripheral(peripheral));
                }
                catch (Exception e) {
                    log.warn("An exception got thrown trying to get a peripheral from provider " + peripheralProvider.getClass().toString(), (Throwable)e);
                }
                catch (Throwable t) {
                    log.error("An error occured trying to get all a peripheral from provider " + peripheralProvider.getClass().toString(), t);
                }
            }
        }
        catch (Exception e) {
            log.warn("An exception got thrown trying to get all peripherals", (Throwable)e);
        }
        catch (Throwable t) {
            log.error("An error occured trying to get all peripherals", t);
        }
    }

    public void sort() {
        if (this.ccPeripheralProviders == null && !this.ccErrored && Config.CC_ALWAYS_FIRST) {
            this.getCCProviders();
        }
    }

    @Optional.Method(modid="OpenPeripheralCore")
    private boolean isOpenPeripheral(Object ccperiph) {
        return ccperiph != null && (ccperiph instanceof IOpenPeripheral || ccperiph.getClass().getName().startsWith("openperipheral"));
    }
}

