/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.multipart.microblock;

import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.MicroMaterialRegistry;
import codechicken.microblock.MicroblockRender;
import codechicken.multipart.MultipartGenerator;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import com.rwtema.extrautils.multipart.microblock.IWall;
import com.rwtema.extrautils.multipart.microblock.PartConnecting;
import com.rwtema.extrautils.multipart.microblock.PartWallDummy;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.world.World;

public class PartWall
extends PartConnecting
implements IWall {
    public static final Cuboid6[] partCuboids = new Cuboid6[]{new Cuboid6(0.25, 0.0, 0.25, 0.75, 1.0, 0.75), new Cuboid6(0.25, 0.0, 0.25, 0.75, 1.5, 0.75), new Cuboid6(0.25, 0.0, 0.0, 0.75, 1.5, 0.5), new Cuboid6(0.25, 0.0, 0.5, 0.75, 1.5, 1.0), new Cuboid6(0.0, 0.0, 0.25, 0.5, 1.5, 0.75), new Cuboid6(0.5, 0.0, 0.25, 1.0, 1.5, 0.75)};
    public static final Cuboid6[] renderCuboids1 = new Cuboid6[]{null, null, new Cuboid6(0.3125, 0.0, 0.0, 0.6875, 0.8125, 0.25), new Cuboid6(0.3125, 0.0, 0.75, 0.6875, 0.8125, 1.0), new Cuboid6(0.0, 0.0, 0.3125, 0.25, 0.8125, 0.6875), new Cuboid6(0.75, 0.0, 0.3125, 1.0, 0.8125, 0.6875)};
    public static final Cuboid6[] renderCuboids2 = new Cuboid6[]{null, null, new Cuboid6(0.3125, 0.0, 0.0, 0.6875, 0.8125, 0.5), new Cuboid6(0.3125, 0.0, 0.5, 0.6875, 0.8125, 1.0), new Cuboid6(0.0, 0.0, 0.3125, 0.5, 0.8125, 0.6875), new Cuboid6(0.5, 0.0, 0.3125, 1.0, 0.8125, 0.6875)};
    public static final String type = "extrautils:wall";

    @Override
    public String getType() {
        return type;
    }

    @Override
    public Cuboid6 getBounds() {
        return partCuboids[0];
    }

    @Override
    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList<Cuboid6> t = new ArrayList<Cuboid6>();
        if (this.isEthereal()) {
            return t;
        }
        if ((this.connectionMask & 2) != 0) {
            t.add(partCuboids[1].copy());
        }
        for (int i = 2; i < 6; ++i) {
            if ((this.connectionMask & 1 << i) == 0) continue;
            t.add(partCuboids[i].copy());
        }
        return t;
    }

    @Override
    public boolean shouldConnect(int x, int y, int z, int direction) {
        Block l = this.world().func_147439_a(x, y, z);
        if (this.world().func_147438_o(x, y, z) instanceof IWall && this.tile().canAddPart((TMultiPart)PartWallDummy.dummyArms[direction])) {
            return ((TileMultipart)this.world().func_147438_o(x, y, z)).canAddPart((TMultiPart)PartWallDummy.dummyArms[Facing.field_71588_a[direction]]);
        }
        return l.func_149688_o().func_76218_k() && l.func_149686_d() && this.tile().canAddPart((TMultiPart)PartWallDummy.dummyArms[direction]);
    }

    @Override
    public void registerPassThroughs() {
        MultipartGenerator.registerPassThroughInterface((String)IWall.class.getName());
    }

    @Override
    public void reloadShape() {
        int prevMask = this.connectionMask;
        this.connectionMask = 0;
        for (int i = 2; i < 6; ++i) {
            if (!this.shouldConnect(this.x() + Facing.field_71586_b[i], this.y() + Facing.field_71587_c[i], this.z() + Facing.field_71585_d[i], i)) continue;
            this.connectionMask |= 1 << i;
        }
        if (!this.world().func_147437_c(this.x(), this.y() + 1, this.z()) || this.connectionMask != 12 && this.connectionMask != 48) {
            this.connectionMask |= 2;
        }
        if (prevMask != this.connectionMask) {
            this.tile().notifyPartChange((TMultiPart)this);
            this.tile().markRender();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vector3 pos, int pass) {
        boolean hasCenter;
        this.reloadShape();
        if (this.mat == null) {
            this.mat = MicroMaterialRegistry.getMaterial((int)this.material);
        }
        boolean bl = hasCenter = (this.connectionMask & 2) != 0;
        if (this.mat != null && this.mat.canRenderInPass(pass)) {
            if (hasCenter) {
                MicroblockRender.renderCuboid((Vector3)new Vector3((double)this.x(), (double)this.y(), (double)this.z()), (MicroMaterialRegistry.IMicroMaterial)this.mat, (int)pass, (Cuboid6)this.getRenderBounds(), (int)0);
            }
            for (int i = 2; i < 6; ++i) {
                if ((this.connectionMask & 1 << i) == 0) continue;
                MicroblockRender.renderCuboid((Vector3)new Vector3((double)this.x(), (double)this.y(), (double)this.z()), (MicroMaterialRegistry.IMicroMaterial)this.mat, (int)pass, (Cuboid6)(hasCenter ? renderCuboids1[i] : renderCuboids2[i]), (int)(1 << Facing.field_71588_a[i] | 1 << i));
            }
            return true;
        }
        return false;
    }

    @Override
    public int getMetadata() {
        return 2;
    }

    @Override
    public TMultiPart newPart(boolean client) {
        return new PartWall();
    }

    public PartWall() {
    }

    public PartWall(int material) {
        super(material);
    }

    @Override
    public TMultiPart placePart(ItemStack stack, EntityPlayer player, World world, BlockCoord pos, int side, Vector3 arg5, int materialID) {
        return new PartWall(materialID);
    }

    @Override
    public void renderItem(ItemStack item, MicroMaterialRegistry.IMicroMaterial material) {
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)material, (int)-1, (Cuboid6)partCuboids[0], (int)0);
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)material, (int)-1, (Cuboid6)renderCuboids1[2], (int)0);
        MicroblockRender.renderCuboid((Vector3)new Vector3(0.0, 0.0, 0.0), (MicroMaterialRegistry.IMicroMaterial)material, (int)-1, (Cuboid6)renderCuboids1[3], (int)0);
    }
}

