/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.integration.terrafirmacraft.tag;

import com.bioxx.tfc.Core.Player.BodyTempStats;
import com.bioxx.tfc.Core.Player.SkillStats;
import com.bioxx.tfc.Core.TFC_Climate;
import com.bioxx.tfc.Core.TFC_Core;
import com.bioxx.tfc.Core.TFC_Time;
import com.bioxx.tfc.api.SkillsManager;
import com.github.lunatrius.ingameinfo.tag.TagIntegration;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public abstract class TagTerraFirmaCraft
extends TagIntegration {
    @Override
    public String getCategory() {
        return "terrafirmacraft";
    }

    public static void register() {
        TagRegistry.INSTANCE.register(new Rainfall().setName("tfcrainfall"));
        TagRegistry.INSTANCE.register(new Temperature().setName("tfctemperature"));
        TagRegistry.INSTANCE.register(new AverageTemperature().setName("tfcaveragetemperature"));
        TagRegistry.INSTANCE.register(new TemperatureWithHeatSources().setName("tfctemperatureheatsources"));
        TagRegistry.INSTANCE.register(new Season().setName("tfcseason"));
        TagRegistry.INSTANCE.register(new Date().setName("tfcdate"));
        TagRegistry.INSTANCE.register(new Day().setName("tfcday"));
        TagRegistry.INSTANCE.register(new Month().setName("tfcmonth"));
        TagRegistry.INSTANCE.register(new Year().setName("tfcyear"));
        for (SkillsManager.Skill skill : SkillsManager.instance.getSkillsArray()) {
            String skillName = skill.skillName.toLowerCase();
            if (skillName.startsWith("skill.")) {
                skillName = skillName.substring(6);
            }
            TagRegistry.INSTANCE.register(new Skill(skill.skillName).setName("tfcskill" + skillName));
            TagRegistry.INSTANCE.register(new SkillRank(skill.skillName).setName("tfcskillrank" + skillName));
            TagRegistry.INSTANCE.register(new SkillProgress(skill.skillName).setName("tfcskillprogress" + skillName));
        }
    }

    public static class Rainfall
    extends TagTerraFirmaCraft {
        @Override
        public String getValue() {
            try {
                return String.valueOf((int)TFC_Climate.getRainfall((World)world, (int)Rainfall.playerPosition.x, (int)Rainfall.playerPosition.y, (int)Rainfall.playerPosition.z));
            }
            catch (Throwable e) {
                this.log(this, e);
                return "-1";
            }
        }
    }

    public static class Temperature
    extends TagTerraFirmaCraft {
        @Override
        public String getValue() {
            try {
                return String.format(Locale.ENGLISH, "%.2f", Float.valueOf(TFC_Climate.getHeightAdjustedTemp((World)world, (int)Temperature.playerPosition.x, (int)Temperature.playerPosition.y, (int)Temperature.playerPosition.z)));
            }
            catch (Throwable e) {
                this.log(this, e);
                return "-1";
            }
        }
    }

    public static class AverageTemperature
    extends TagTerraFirmaCraft {
        @Override
        public String getValue() {
            try {
                return String.format(Locale.ENGLISH, "%.2f", Float.valueOf(TFC_Climate.getBioTemperatureHeight((World)world, (int)AverageTemperature.playerPosition.x, (int)AverageTemperature.playerPosition.y, (int)AverageTemperature.playerPosition.z)));
            }
            catch (Throwable e) {
                this.log(this, e);
                return "-1";
            }
        }
    }

    public static class TemperatureWithHeatSources
    extends TagTerraFirmaCraft {
        @Override
        public String getValue() {
            try {
                return String.format(Locale.ENGLISH, "%.2f", Float.valueOf(TFC_Climate.getHeightAdjustedTemp((World)world, (int)TemperatureWithHeatSources.playerPosition.x, (int)TemperatureWithHeatSources.playerPosition.y, (int)TemperatureWithHeatSources.playerPosition.z) + BodyTempStats.applyTemperatureFromHeatSources((EntityPlayer)player)));
            }
            catch (Throwable e) {
                this.log(this, e);
                return "-1";
            }
        }
    }

    public static class Season
    extends TagTerraFirmaCraft {
        @Override
        public String getValue() {
            try {
                return TFC_Time.getSeason();
            }
            catch (Throwable e) {
                this.log(this, e);
                return "";
            }
        }
    }

    public static class Date
    extends TagTerraFirmaCraft {
        @Override
        public String getValue() {
            try {
                return TFC_Time.getDateStringFromHours((int)((int)TFC_Time.getTotalHours()));
            }
            catch (Throwable e) {
                this.log(this, e);
                return "";
            }
        }
    }

    public static class Day
    extends TagTerraFirmaCraft {
        @Override
        public String getValue() {
            try {
                return String.valueOf(TFC_Time.getDayOfMonth());
            }
            catch (Throwable e) {
                this.log(this, e);
                return "";
            }
        }
    }

    public static class Month
    extends TagTerraFirmaCraft {
        @Override
        public String getValue() {
            try {
                return String.valueOf(TFC_Time.getMonth());
            }
            catch (Throwable e) {
                this.log(this, e);
                return "";
            }
        }
    }

    public static class Year
    extends TagTerraFirmaCraft {
        @Override
        public String getValue() {
            try {
                return String.valueOf(1000 + TFC_Time.getYear());
            }
            catch (Throwable e) {
                this.log(this, e);
                return "";
            }
        }
    }

    public static class Skill
    extends TagTerraFirmaCraft {
        private final String skillName;

        public Skill(String skillName) {
            this.skillName = skillName;
        }

        @Override
        public String getValue() {
            try {
                SkillStats skillStats = TFC_Core.getSkillStats((EntityPlayer)player);
                return String.format(Locale.ENGLISH, "%s (%s), %.1f%%", I18n.func_135052_a((String)this.skillName, (Object[])new Object[0]), skillStats.getSkillRank(this.skillName).getLocalizedName(), Float.valueOf(skillStats.getPercToNextRank(this.skillName) * 100.0f));
            }
            catch (Throwable e) {
                this.log(this, e);
                return "";
            }
        }

        @Override
        public String getLocalizedDescription() {
            return I18n.func_135052_a((String)("InGameInfoXML".toLowerCase() + ".tag.fmtskill.desc"), (Object[])new Object[]{I18n.func_135052_a((String)this.skillName, (Object[])new Object[0])});
        }
    }

    public static class SkillRank
    extends TagTerraFirmaCraft {
        private final String skillName;

        public SkillRank(String skillName) {
            this.skillName = skillName;
        }

        @Override
        public String getValue() {
            try {
                return TFC_Core.getSkillStats((EntityPlayer)player).getSkillRank(this.skillName).getLocalizedName();
            }
            catch (Throwable e) {
                this.log(this, e);
                return "";
            }
        }

        @Override
        public String getLocalizedDescription() {
            return I18n.func_135052_a((String)("InGameInfoXML".toLowerCase() + ".tag.fmtskillrank.desc"), (Object[])new Object[]{I18n.func_135052_a((String)this.skillName, (Object[])new Object[0])});
        }
    }

    public static class SkillProgress
    extends TagTerraFirmaCraft {
        private final String skillName;

        public SkillProgress(String skillName) {
            this.skillName = skillName;
        }

        @Override
        public String getValue() {
            try {
                return String.format(Locale.ENGLISH, "%.1f", Float.valueOf(TFC_Core.getSkillStats((EntityPlayer)player).getPercToNextRank(this.skillName) * 100.0f));
            }
            catch (Throwable e) {
                this.log(this, e);
                return "";
            }
        }

        @Override
        public String getLocalizedDescription() {
            return I18n.func_135052_a((String)("InGameInfoXML".toLowerCase() + ".tag.fmtskillprogress.desc"), (Object[])new Object[]{I18n.func_135052_a((String)this.skillName, (Object[])new Object[0])});
        }
    }
}

