/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.enums;

import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Element;
import gregtech.api.enums.FluidState;
import gregtech.api.enums.MaterialBuilder;
import gregtech.api.enums.MaterialsBotania;
import gregtech.api.enums.MaterialsKevlar;
import gregtech.api.enums.MaterialsOreAlum;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TCAspects;
import gregtech.api.enums.TextureSet;
import gregtech.api.fluid.GTFluidFactory;
import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.interfaces.IMaterialHandler;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.config.Gregtech;
import gregtech.common.render.items.CosmicNeutroniumRenderer;
import gregtech.common.render.items.GaiaSpiritRenderer;
import gregtech.common.render.items.GeneratedMaterialRenderer;
import gregtech.common.render.items.GlitchEffectRenderer;
import gregtech.common.render.items.InfinityRenderer;
import gregtech.common.render.items.RainbowOverlayRenderer;
import gregtech.common.render.items.TranscendentMetalRenderer;
import gregtech.common.render.items.UniversiumRenderer;
import gregtech.loaders.materialprocessing.ProcessingConfig;
import gregtech.loaders.materialprocessing.ProcessingModSupport;
import gregtech.loaders.materials.MaterialsInit1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class Materials
implements IColorModulationContainer,
ISubTagContainer {
    public static final List<IMaterialHandler> mMaterialHandlers = new ArrayList<IMaterialHandler>();
    private static final Map<String, Materials> MATERIALS_MAP = new LinkedHashMap<String, Materials>();
    public static final Map<Fluid, Materials> FLUID_MAP = new LinkedHashMap<Fluid, Materials>();
    @Deprecated
    public static Collection<Materials> VALUES = new LinkedHashSet<Materials>();
    public static Materials _NULL = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "NULL", "NULL", 0, 0, 0, 0, false, false, 1, 1, 1, Dyes._NULL, Element._NULL, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.VACUOS, 1L)));
    public static Materials Aluminium;
    public static Materials Americium;
    public static Materials Antimony;
    public static Materials Argon;
    public static Materials Arsenic;
    public static Materials Barium;
    public static Materials Beryllium;
    public static Materials Bismuth;
    public static Materials Boron;
    public static Materials Caesium;
    public static Materials Calcium;
    public static Materials Carbon;
    public static Materials Cadmium;
    public static Materials Cerium;
    public static Materials Chlorine;
    public static Materials Chrome;
    public static Materials Cobalt;
    public static Materials Copper;
    public static Materials Deuterium;
    public static Materials Dysprosium;
    public static Materials Empty;
    public static Materials Erbium;
    public static Materials Europium;
    public static Materials Fluorine;
    public static Materials Gadolinium;
    public static Materials Gallium;
    public static Materials Gold;
    public static Materials Holmium;
    public static Materials Hydrogen;
    public static Materials Helium;
    public static Materials Helium_3;
    public static Materials Indium;
    public static Materials Iridium;
    public static Materials Iron;
    public static Materials Lanthanum;
    public static Materials Lead;
    public static Materials Lithium;
    public static Materials Lutetium;
    public static Materials Magic;
    public static Materials Magnesium;
    public static Materials Manganese;
    public static Materials Mercury;
    public static Materials Molybdenum;
    public static Materials Neodymium;
    public static Materials Neutronium;
    public static Materials Nickel;
    public static Materials Niobium;
    public static Materials Nitrogen;
    public static Materials Osmium;
    public static Materials Oxygen;
    public static Materials Palladium;
    public static Materials Phosphorus;
    public static Materials Platinum;
    public static Materials Plutonium;
    public static Materials Plutonium241;
    public static Materials Potassium;
    public static Materials Praseodymium;
    public static Materials Promethium;
    public static Materials Radon;
    public static Materials Rubidium;
    public static Materials Samarium;
    public static Materials Scandium;
    public static Materials Silicon;
    public static Materials Silver;
    public static Materials Sodium;
    public static Materials Strontium;
    public static Materials Sulfur;
    public static Materials Tantalum;
    public static Materials Tellurium;
    public static Materials Terbium;
    public static Materials Thorium;
    public static Materials Thulium;
    public static Materials Tin;
    public static Materials Titanium;
    public static Materials Tritanium;
    public static Materials Tritium;
    public static Materials Tungsten;
    public static Materials Uranium;
    public static Materials Uranium235;
    public static Materials Vanadium;
    public static Materials Ytterbium;
    public static Materials Yttrium;
    public static Materials Zinc;
    public static Materials Grade1PurifiedWater;
    public static Materials Grade2PurifiedWater;
    public static Materials Grade3PurifiedWater;
    public static Materials Grade4PurifiedWater;
    public static Materials Grade5PurifiedWater;
    public static Materials Grade6PurifiedWater;
    public static Materials Grade7PurifiedWater;
    public static Materials Grade8PurifiedWater;
    public static Materials FlocculationWasteLiquid;
    public static Materials Flerovium;
    public static Materials Organic;
    public static Materials AnyCopper;
    public static Materials AnyBronze;
    public static Materials AnyIron;
    public static Materials AnyRubber;
    public static Materials AnySyntheticRubber;
    public static Materials Crystal;
    public static Materials Quartz;
    public static Materials Metal;
    public static Materials Unknown;
    public static Materials Cobblestone;
    public static Materials BrickNether;
    public static Materials Serpentine;
    public static Materials Flux;
    public static Materials OsmiumTetroxide;
    public static Materials RubberTreeSap;
    public static Materials PhasedIron;
    public static Materials PhasedGold;
    public static Materials HeeEndium;
    public static Materials Teslatite;
    public static Materials Fluix;
    public static Materials DarkThaumium;
    public static Materials Alfium;
    public static Materials Mutation;
    public static Materials Aquamarine;
    public static Materials Ender;
    public static Materials SodiumPeroxide;
    public static Materials IridiumSodiumOxide;
    public static Materials PlatinumGroupSludge;
    public static Materials Draconium;
    public static Materials DraconiumAwakened;
    public static Materials PurpleAlloy;
    public static Materials InfusedTeslatite;
    public static Materials Adamantium;
    public static Materials Adamite;
    public static Materials Adluorite;
    public static Materials Agate;
    public static Materials Alduorite;
    public static Materials Amber;
    public static Materials Ammonium;
    public static Materials Amordrine;
    public static Materials Andesite;
    public static Materials Angmallen;
    public static Materials Ardite;
    public static Materials Aredrite;
    public static Materials Atlarus;
    public static Materials Bitumen;
    public static Materials Black;
    public static Materials Blizz;
    public static Materials Blueschist;
    public static Materials Bluestone;
    public static Materials Bloodstone;
    public static Materials Blutonium;
    public static Materials Carmot;
    public static Materials Celenegil;
    public static Materials CertusQuartz;
    public static Materials CertusQuartzCharged;
    public static Materials Ceruclase;
    public static Materials Citrine;
    public static Materials CobaltHexahydrate;
    public static Materials ConstructionFoam;
    public static Materials Chert;
    public static Materials Chimerite;
    public static Materials Coral;
    public static Materials CrudeOil;
    public static Materials Chrysocolla;
    public static Materials CrystalFlux;
    public static Materials Cyanite;
    public static Materials Dacite;
    public static Materials DarkIron;
    public static Materials DarkStone;
    public static Materials Demonite;
    public static Materials Desh;
    public static Materials Desichalkos;
    public static Materials Dilithium;
    public static Materials Draconic;
    public static Materials Drulloy;
    public static Materials Duranium;
    public static Materials Eclogite;
    public static Materials ElectrumFlux;
    public static Materials Emery;
    public static Materials EnderiumBase;
    public static Materials Energized;
    public static Materials Epidote;
    public static Materials Eximite;
    public static Materials FierySteel;
    public static Materials Firestone;
    public static Materials Fluorite;
    public static Materials FoolsRuby;
    public static Materials Force;
    public static Materials Forcicium;
    public static Materials Forcillium;
    public static Materials Gabbro;
    public static Materials Glowstone;
    public static Materials Gneiss;
    public static Materials Graphite;
    public static Materials Graphene;
    public static Materials Greenschist;
    public static Materials Greenstone;
    public static Materials Greywacke;
    public static Materials Haderoth;
    public static Materials Hematite;
    public static Materials Hepatizon;
    public static Materials HSLA;
    public static Materials Ignatius;
    public static Materials Infernal;
    public static Materials Infuscolium;
    public static Materials InfusedGold;
    public static Materials InfusedAir;
    public static Materials InfusedFire;
    public static Materials InfusedEarth;
    public static Materials InfusedWater;
    public static Materials InfusedEntropy;
    public static Materials InfusedOrder;
    public static Materials InfusedVis;
    public static Materials InfusedDull;
    public static Materials Inolashite;
    public static Materials Invisium;
    public static Materials Jade;
    public static Materials Kalendrite;
    public static Materials Komatiite;
    public static Materials Lava;
    public static Materials Lemurite;
    public static Materials Limestone;
    public static Materials Magma;
    public static Materials Mawsitsit;
    public static Materials Mercassium;
    public static Materials MeteoricIron;
    public static Materials MeteoricSteel;
    public static Materials Meteorite;
    public static Materials Meutoite;
    public static Materials Migmatite;
    public static Materials Mimichite;
    public static Materials Moonstone;
    public static Materials Naquadah;
    public static Materials NaquadahAlloy;
    public static Materials NaquadahEnriched;
    public static Materials Naquadria;
    public static Materials Nether;
    public static Materials NetherBrick;
    public static Materials NetherQuartz;
    public static Materials NetherStar;
    public static Materials ObsidianFlux;
    public static Materials Oilsands;
    public static Materials Onyx;
    public static Materials Orichalcum;
    public static Materials Osmonium;
    public static Materials Oureclase;
    public static Materials Painite;
    public static Materials Peanutwood;
    public static Materials Petroleum;
    public static Materials Pewter;
    public static Materials Phoenixite;
    public static Materials Prometheum;
    public static Materials Quartzite;
    public static Materials Randomite;
    public static Materials Rhyolite;
    public static Materials Rubracium;
    public static Materials Sand;
    public static Materials Sanguinite;
    public static Materials Siltstone;
    public static Materials Sunstone;
    public static Materials Tar;
    public static Materials Tartarite;
    public static Materials UUAmplifier;
    public static Materials UUMatter;
    public static Materials Void;
    public static Materials Voidstone;
    public static Materials Vulcanite;
    public static Materials Vyroxeres;
    public static Materials Yellorium;
    public static Materials Zectium;
    public static Materials Ultimate;
    public static Materials Advanced;
    public static Materials ULV;
    public static Materials LV;
    public static Materials MV;
    public static Materials HV;
    public static Materials EV;
    public static Materials IV;
    public static Materials LuV;
    public static Materials ZPM;
    public static Materials UV;
    public static Materials UHV;
    public static Materials UEV;
    public static Materials UIV;
    public static Materials UMV;
    public static Materials UXV;
    public static Materials MAX;
    public static Materials Resistor;
    public static Materials Diode;
    public static Materials Transistor;
    public static Materials Capacitor;
    public static Materials Inductor;
    public static Materials Nano;
    public static Materials Piko;
    @Deprecated
    public static Materials Primitive;
    @Deprecated
    public static Materials Basic;
    @Deprecated
    public static Materials Good;
    @Deprecated
    public static Materials Data;
    @Deprecated
    public static Materials Elite;
    @Deprecated
    public static Materials Master;
    @Deprecated
    public static Materials Infinite;
    @Deprecated
    public static Materials Bio;
    @Deprecated
    public static Materials Optical;
    @Deprecated
    public static Materials Exotic;
    @Deprecated
    public static Materials Cosmic;
    @Deprecated
    public static Materials Transcendent;
    public static Materials Antimatter;
    public static Materials Protomatter;
    public static Materials AdvancedGlue;
    public static Materials Biomass;
    public static Materials CharcoalByproducts;
    public static Materials Cheese;
    public static Materials Chili;
    public static Materials Chocolate;
    public static Materials Cluster;
    public static Materials CoalFuel;
    public static Materials Cocoa;
    public static Materials Coffee;
    public static Materials Creosote;
    public static Materials Ethanol;
    public static Materials FishOil;
    public static Materials FermentedBiomass;
    public static Materials Fuel;
    public static Materials Glue;
    public static Materials Gunpowder;
    public static Materials FryingOilHot;
    public static Materials Honey;
    public static Materials Leather;
    public static Materials Lubricant;
    public static Materials McGuffium239;
    public static Materials MeatRaw;
    public static Materials MeatCooked;
    public static Materials Milk;
    public static Materials Mud;
    public static Materials Oil;
    public static Materials Paper;
    public static Materials Peat;
    public static Materials RareEarth;
    public static Materials Red;
    public static Materials Reinforced;
    public static Materials SeedOil;
    public static Materials SeedOilHemp;
    public static Materials SeedOilLin;
    public static Materials Stone;
    public static Materials TNT;
    public static Materials Unstable;
    public static Materials Unstableingot;
    public static Materials Vinegar;
    public static Materials Wheat;
    public static Materials WoodGas;
    public static Materials WoodTar;
    public static Materials WoodVinegar;
    public static Materials WeedEX9000;
    public static Materials AluminiumBrass;
    public static Materials Osmiridium;
    public static Materials Sunnarium;
    public static Materials Endstone;
    public static Materials Netherrack;
    public static Materials SoulSand;
    public static Materials Methane;
    public static Materials CarbonDioxide;
    public static Materials NobleGases;
    public static Materials Air;
    public static Materials LiquidAir;
    public static Materials LiquidNitrogen;
    public static Materials LiquidOxygen;
    public static Materials SiliconDioxide;
    public static Materials Jasper;
    public static Materials Almandine;
    public static Materials Andradite;
    public static Materials AnnealedCopper;
    public static Materials Asbestos;
    public static Materials Ash;
    public static Materials BandedIron;
    public static Materials BatteryAlloy;
    public static Materials BlueTopaz;
    public static Materials Bone;
    public static Materials Brass;
    public static Materials Bronze;
    public static Materials BrownLimonite;
    public static Materials Calcite;
    public static Materials Cassiterite;
    public static Materials CassiteriteSand;
    public static Materials Chalcopyrite;
    public static Materials Charcoal;
    public static Materials Chromite;
    public static Materials ChromiumDioxide;
    public static Materials Cinnabar;
    public static Materials Water;
    public static Materials Clay;
    public static Materials Coal;
    public static Materials Cobaltite;
    public static Materials Cooperite;
    public static Materials Cupronickel;
    public static Materials DarkAsh;
    public static Materials DeepIron;
    public static Materials Diamond;
    public static Materials Electrum;
    public static Materials Emerald;
    public static Materials FreshWater;
    public static Materials Galena;
    public static Materials Garnierite;
    public static Materials Glyceryl;
    public static Materials GreenSapphire;
    public static Materials Grossular;
    public static Materials HolyWater;
    public static Materials Ice;
    public static Materials Ilmenite;
    public static Materials Rutile;
    public static Materials Bauxite;
    public static Materials Titaniumtetrachloride;
    public static Materials Magnesiumchloride;
    public static Materials Invar;
    public static Materials Kanthal;
    public static Materials Lazurite;
    public static Materials Magnalium;
    public static Materials Magnesite;
    public static Materials Magnetite;
    public static Materials Molybdenite;
    public static Materials Nichrome;
    public static Materials NiobiumNitride;
    public static Materials NiobiumTitanium;
    public static Materials NitroCarbon;
    public static Materials NitrogenDioxide;
    public static Materials Obsidian;
    public static Materials Phosphate;
    public static Materials PigIron;
    public static Materials Plastic;
    public static Materials Epoxid;
    public static Materials Polydimethylsiloxane;
    public static Materials Silicone;
    public static Materials Polycaprolactam;
    public static Materials Polytetrafluoroethylene;
    public static Materials Powellite;
    public static Materials Pumice;
    public static Materials Pyrite;
    public static Materials Pyrolusite;
    public static Materials Pyrope;
    public static Materials RockSalt;
    public static Materials Rubber;
    public static Materials RawRubber;
    public static Materials Ruby;
    public static Materials Salt;
    public static Materials Saltpeter;
    public static Materials Sapphire;
    public static Materials Scheelite;
    public static Materials Snow;
    public static Materials Sodalite;
    public static Materials SodiumPersulfate;
    public static Materials SodiumSulfide;
    public static Materials HydricSulfide;
    public static Materials OilExtraHeavy;
    public static Materials OilHeavy;
    public static Materials OilMedium;
    public static Materials OilLight;
    public static Materials NatruralGas;
    public static Materials SulfuricGas;
    public static Materials Gas;
    public static Materials SulfuricNaphtha;
    public static Materials SulfuricLightFuel;
    public static Materials SulfuricHeavyFuel;
    public static Materials Naphtha;
    public static Materials LightFuel;
    public static Materials HeavyFuel;
    public static Materials LPG;
    public static Materials ReinforceGlass;
    public static Materials BioMediumRaw;
    public static Materials BioMediumSterilized;
    public static Materials Chlorobenzene;
    public static Materials DilutedHydrochloricAcid;
    public static Materials Pyrochlore;
    public static Materials GrowthMediumRaw;
    public static Materials GrowthMediumSterilized;
    public static Materials FerriteMixture;
    public static Materials NickelZincFerrite;
    public static Materials Massicot;
    public static Materials ArsenicTrioxide;
    public static Materials CobaltOxide;
    public static Materials Zincite;
    public static Materials AntimonyTrioxide;
    public static Materials CupricOxide;
    public static Materials Ferrosilite;
    public static Materials Magnesia;
    public static Materials Quicklime;
    public static Materials Potash;
    public static Materials SodaAsh;
    public static Materials BioDiesel;
    public static Materials NitrationMixture;
    public static Materials Glycerol;
    public static Materials SodiumBisulfate;
    public static Materials PolyphenyleneSulfide;
    public static Materials Dichlorobenzene;
    public static Materials Polystyrene;
    public static Materials Styrene;
    public static Materials Isoprene;
    public static Materials Tetranitromethane;
    public static Materials Ethenone;
    public static Materials Ethane;
    public static Materials Propane;
    public static Materials Butane;
    public static Materials Butene;
    public static Materials Butadiene;
    public static Materials RawStyreneButadieneRubber;
    public static Materials StyreneButadieneRubber;
    public static Materials Toluene;
    public static Materials Epichlorohydrin;
    public static Materials PolyvinylChloride;
    public static Materials VinylChloride;
    public static Materials SulfurDioxide;
    public static Materials SulfurTrioxide;
    public static Materials NitricAcid;
    public static Materials Dimethylhydrazine;
    public static Materials Chloramine;
    public static Materials Dimethylamine;
    public static Materials DinitrogenTetroxide;
    public static Materials NitricOxide;
    public static Materials Ammonia;
    public static Materials Dimethyldichlorosilane;
    public static Materials Chloromethane;
    public static Materials PhosphorousPentoxide;
    public static Materials Tetrafluoroethylene;
    public static Materials HydrofluoricAcid;
    public static Materials Chloroform;
    public static Materials BisphenolA;
    public static Materials AceticAcid;
    public static Materials CalciumAcetateSolution;
    public static Materials Acetone;
    public static Materials Methanol;
    public static Materials CarbonMonoxide;
    public static Materials MetalMixture;
    public static Materials Ethylene;
    public static Materials Propene;
    public static Materials VinylAcetate;
    public static Materials PolyvinylAcetate;
    public static Materials MethylAcetate;
    public static Materials AllylChloride;
    public static Materials HydrochloricAcid;
    public static Materials HypochlorousAcid;
    public static Materials SodiumOxide;
    public static Materials SodiumHydroxide;
    public static Materials Benzene;
    public static Materials Phenol;
    public static Materials Cumene;
    public static Materials PhosphoricAcid;
    public static Materials SaltWater;
    public static Materials IronIIIChloride;
    public static Materials LifeEssence;
    public static Materials RoastedCopper;
    public static Materials RoastedAntimony;
    public static Materials RoastedIron;
    public static Materials RoastedNickel;
    public static Materials RoastedZinc;
    public static Materials RoastedCobalt;
    public static Materials RoastedArsenic;
    public static Materials RoastedLead;
    public static Materials SiliconSG;
    public static Materials CalciumDisilicide;
    public static Materials SiliconTetrafluoride;
    public static Materials SiliconTetrachloride;
    public static Materials Trichlorosilane;
    public static Materials Hexachlorodisilane;
    public static Materials Dichlorosilane;
    public static Materials Silane;
    public static Materials Calciumhydride;
    public static Materials AluminiumFluoride;
    public static Materials SolderingAlloy;
    public static Materials GalliumArsenide;
    public static Materials IndiumGalliumPhosphide;
    public static Materials Spessartine;
    public static Materials Sphalerite;
    public static Materials StainlessSteel;
    public static Materials Steel;
    public static Materials Stibnite;
    public static Materials SulfuricAcid;
    public static Materials Tanzanite;
    public static Materials Tetrahedrite;
    public static Materials TinAlloy;
    public static Materials Topaz;
    public static Materials Tungstate;
    public static Materials Ultimet;
    public static Materials Uraninite;
    public static Materials Uvarovite;
    public static Materials VanadiumGallium;
    public static Materials Wood;
    public static Materials WroughtIron;
    public static Materials Wulfenite;
    public static Materials YellowLimonite;
    public static Materials YttriumBariumCuprate;
    public static Materials WoodSealed;
    public static Materials LiveRoot;
    public static Materials IronWood;
    public static Materials Glass;
    public static Materials BorosilicateGlass;
    public static Materials Perlite;
    public static Materials Borax;
    public static Materials Lignite;
    public static Materials Olivine;
    public static Materials Opal;
    public static Materials Amethyst;
    public static Materials Redstone;
    public static Materials Lapis;
    public static Materials Blaze;
    public static Materials EnderPearl;
    public static Materials EnderEye;
    public static Materials Flint;
    public static Materials Diatomite;
    public static Materials VolcanicAsh;
    public static Materials Niter;
    public static Materials Pyrotheum;
    public static Materials Cryotheum;
    public static Materials HydratedCoal;
    public static Materials Apatite;
    public static Materials Alumite;
    public static Materials Manyullyn;
    public static Materials Steeleaf;
    public static Materials Knightmetal;
    public static Materials SterlingSilver;
    public static Materials RoseGold;
    public static Materials BlackBronze;
    public static Materials BismuthBronze;
    public static Materials BlackSteel;
    public static Materials RedSteel;
    public static Materials BlueSteel;
    public static Materials DamascusSteel;
    public static Materials TungstenSteel;
    public static Materials NitroCoalFuel;
    public static Materials NitroFuel;
    public static Materials RedAlloy;
    public static Materials CobaltBrass;
    public static Materials TricalciumPhosphate;
    public static Materials Basalt;
    public static Materials GarnetRed;
    public static Materials GarnetYellow;
    public static Materials Marble;
    public static Materials Sugar;
    public static Materials Thaumium;
    public static Materials Vinteum;
    public static Materials Vis;
    public static Materials Redrock;
    public static Materials PotassiumFeldspar;
    public static Materials Biotite;
    public static Materials GraniteBlack;
    public static Materials GraniteRed;
    public static Materials Chrysotile;
    public static Materials Realgar;
    public static Materials VanadiumMagnetite;
    public static Materials BasalticMineralSand;
    public static Materials GraniticMineralSand;
    public static Materials GarnetSand;
    public static Materials QuartzSand;
    public static Materials Bastnasite;
    public static Materials Pentlandite;
    public static Materials Spodumene;
    public static Materials Pollucite;
    public static Materials Tantalite;
    public static Materials Lepidolite;
    public static Materials Glauconite;
    public static Materials GlauconiteSand;
    public static Materials Vermiculite;
    public static Materials Bentonite;
    public static Materials FullersEarth;
    public static Materials Pitchblende;
    public static Materials Monazite;
    public static Materials Malachite;
    public static Materials Mirabilite;
    public static Materials Mica;
    public static Materials Trona;
    public static Materials Barite;
    public static Materials Gypsum;
    public static Materials Alunite;
    public static Materials Dolomite;
    public static Materials Wollastonite;
    public static Materials Zeolite;
    public static Materials Kyanite;
    public static Materials Kaolinite;
    public static Materials Talc;
    public static Materials Soapstone;
    public static Materials Concrete;
    public static Materials IronMagnetic;
    public static Materials SteelMagnetic;
    public static Materials NeodymiumMagnetic;
    public static Materials SamariumMagnetic;
    public static Materials TungstenCarbide;
    public static Materials VanadiumSteel;
    public static Materials HSSG;
    public static Materials HSSE;
    public static Materials HSSS;
    public static Materials TPV;
    public static Materials DilutedSulfuricAcid;
    public static Materials EpoxidFiberReinforced;
    public static Materials SodiumCarbonate;
    public static Materials SodiumAluminate;
    public static Materials Aluminiumoxide;
    public static Materials Aluminiumhydroxide;
    public static Materials Cryolite;
    public static Materials RedMud;
    public static Materials Brick;
    public static Materials Fireclay;
    public static Materials PotassiumNitrade;
    public static Materials ChromiumTrioxide;
    public static Materials Nitrochlorobenzene;
    public static Materials Dimethylbenzene;
    public static Materials Potassiumdichromate;
    public static Materials PhthalicAcid;
    public static Materials Dichlorobenzidine;
    public static Materials Diaminobenzidin;
    public static Materials Diphenylisophthalate;
    public static Materials Polybenzimidazole;
    public static Materials MTBEMixture;
    public static Materials MTBEMixtureAlt;
    public static Materials NitrousOxide;
    public static Materials AntiKnock;
    public static Materials Octane;
    public static Materials GasolineRaw;
    public static Materials GasolineRegular;
    public static Materials GasolinePremium;
    public static Materials Electrotine;
    public static Materials Galgadorian;
    public static Materials EnhancedGalgadorian;
    public static Materials BloodInfusedIron;
    public static Materials Shadow;
    public static Materials Ledox;
    public static Materials Quantium;
    public static Materials Mytryl;
    public static Materials BlackPlutonium;
    public static Materials CallistoIce;
    public static Materials Duralumin;
    public static Materials Oriharukon;
    public static Materials MysteriousCrystal;
    public static Materials RedstoneAlloy;
    public static Materials Soularium;
    public static Materials ConductiveIron;
    public static Materials ElectricalSteel;
    public static Materials EnergeticAlloy;
    public static Materials VibrantAlloy;
    public static Materials PulsatingIron;
    public static Materials DarkSteel;
    public static Materials EndSteel;
    public static Materials CrudeSteel;
    public static Materials CrystallineAlloy;
    public static Materials MelodicAlloy;
    public static Materials StellarAlloy;
    public static Materials CrystallinePinkSlime;
    public static Materials EnergeticSilver;
    public static Materials VividAlloy;
    public static Materials Enderium;
    public static Materials Mithril;
    public static Materials BlueAlloy;
    public static Materials ShadowIron;
    public static Materials ShadowSteel;
    public static Materials AstralSilver;
    public static Materials InfinityCatalyst;
    public static Materials Infinity;
    public static Materials Bedrockium;
    public static Materials Trinium;
    public static Materials Ichorium;
    public static Materials CosmicNeutronium;
    public static Materials Pentacadmiummagnesiumhexaoxid;
    public static Materials Titaniumonabariumdecacoppereikosaoxid;
    public static Materials Uraniumtriplatinid;
    public static Materials Vanadiumtriindinid;
    public static Materials Tetraindiumditindibariumtitaniumheptacoppertetrakaidekaoxid;
    public static Materials Tetranaquadahdiindiumhexaplatiumosminid;
    public static Materials Longasssuperconductornameforuvwire;
    public static Materials Longasssuperconductornameforuhvwire;
    public static Materials SuperconductorUEVBase;
    public static Materials SuperconductorUIVBase;
    public static Materials SuperconductorUMVBase;
    public static Materials SuperconductorMV;
    public static Materials SuperconductorHV;
    public static Materials SuperconductorEV;
    public static Materials SuperconductorIV;
    public static Materials SuperconductorLuV;
    public static Materials SuperconductorZPM;
    public static Materials SuperconductorUV;
    public static Materials SuperconductorUHV;
    public static Materials SuperconductorUEV;
    public static Materials SuperconductorUIV;
    public static Materials SuperconductorUMV;
    public static Materials SuperCoolant;
    public static Materials EnrichedHolmium;
    public static Materials TengamPurified;
    public static Materials TengamAttuned;
    public static Materials TengamRaw;
    public static Materials DenseSteam;
    public static Materials DenseSuperheatedSteam;
    public static Materials DenseSupercriticalSteam;
    public static Materials ActivatedCarbon;
    public static Materials PreActivatedCarbon;
    public static Materials DirtyActivatedCarbon;
    public static Materials PolyAluminiumChloride;
    public static Materials Ozone;
    public static Materials StableBaryonicMatter;
    public static Materials RawRadox;
    public static Materials RadoxSuperLight;
    public static Materials RadoxLight;
    public static Materials RadoxHeavy;
    public static Materials RadoxSuperHeavy;
    public static Materials Xenoxene;
    public static Materials DilutedXenoxene;
    public static Materials RadoxCracked;
    public static Materials RadoxGas;
    public static Materials RadoxPolymer;
    public static Materials NetherAir;
    public static Materials NetherSemiFluid;
    public static Materials NefariousGas;
    public static Materials NefariousOil;
    public static Materials PoorNetherWaste;
    public static Materials RichNetherWaste;
    public static Materials HellishMetal;
    public static Materials Netherite;
    public static Materials ActivatedNetherite;
    public static Materials PrismarineSolution;
    public static Materials PrismarineContaminatedHydrogenPeroxide;
    public static Materials PrismarineRichNitrobenzeneSolution;
    public static Materials PrismarineContaminatedNitrobenzeSolution;
    public static Materials PrismaticGas;
    public static Materials PrismaticAcid;
    public static Materials PrismaticNaquadah;
    public static Materials PrismaticNaquadahCompositeSlurry;
    public static Materials ComplexityCatalyst;
    public static Materials EntropicCatalyst;
    public static Materials Steam;
    @Deprecated
    public static Materials Superconductor;
    private static Materials[] MATERIALS_ARRAY;
    public final short[] mRGBa = new short[]{255, 255, 255, 0};
    public final short[] mMoltenRGBa = new short[]{255, 255, 255, 0};
    public TextureSet mIconSet;
    public GeneratedMaterialRenderer renderer;
    public List<MaterialStack> mMaterialList = new ArrayList<MaterialStack>();
    public List<Materials> mOreByProducts = new ArrayList<Materials>();
    public List<Materials> mOreReRegistrations = new ArrayList<Materials>();
    public List<TCAspects.TC_AspectStack> mAspects = new ArrayList<TCAspects.TC_AspectStack>();
    public ArrayList<ItemStack> mMaterialItems = new ArrayList();
    public Collection<SubTag> mSubTags = new LinkedHashSet<SubTag>();
    public Enchantment mEnchantmentTools = null;
    public Enchantment mEnchantmentArmors = null;
    public boolean mUnificatable;
    public boolean mBlastFurnaceRequired = false;
    public boolean mAutoGenerateBlastFurnaceRecipes = true;
    public boolean mAutoGenerateVacuumFreezerRecipes = true;
    public boolean mAutoGenerateRecycleRecipes = true;
    public boolean mTransparent = false;
    public boolean mHasParentMod = true;
    public boolean mHasPlasma = false;
    public boolean mHasGas = false;
    public boolean mCustomOre = false;
    public byte mEnchantmentToolsLevel = 0;
    public byte mEnchantmentArmorsLevel = 0;
    public byte mToolQuality = 0;
    public short mBlastFurnaceTemp = 0;
    public int mMeltingPoint = 0;
    public int mGasTemp = 0;
    public int mMetaItemSubID;
    public int mTypes = 0;
    public int mDurability = 16;
    public int mFuelPower = 0;
    public int mFuelType = 0;
    public int mExtraData = 0;
    public int mOreValue = 0;
    public int mOreMultiplier = 1;
    public int mByProductMultiplier = 1;
    public int mSmeltingMultiplier = 1;
    public int mDensityMultiplier = 1;
    public int mDensityDivider = 1;
    public int processingMaterialTierEU = 0;
    public long mDensity = 3628800L;
    public float mToolSpeed = 1.0f;
    public float mHeatDamage = 0.0f;
    public float mSteamMultiplier = 1.0f;
    public float mGasMultiplier = 1.0f;
    public float mPlasmaMultiplier = 1.0f;
    public String mChemicalFormula = "?";
    public String mName;
    public String mDefaultLocalName;
    public String mCustomID = "null";
    public String mConfigSection = "null";
    public String mLocalizedName = "null";
    public Dyes mColor = Dyes._NULL;
    public Element mElement = null;
    public Materials mDirectSmelting = this;
    public Materials mOreReplacement = this;
    public Materials mMacerateInto = this;
    public Materials mSmeltInto = this;
    public Materials mArcSmeltInto = this;
    public Materials mHandleMaterial = this;
    public Materials mMaterialInto;
    public Fluid mSolid = null;
    public Fluid mFluid = null;
    public Fluid mGas = null;
    public Fluid mPlasma = null;
    public Fluid mStandardMoltenFluid = null;
    private boolean hasCorrespondingFluid = false;
    private boolean hasCorrespondingGas = false;
    private boolean canBeCracked = false;
    private Fluid[] hydroCrackedFluids = new Fluid[3];
    private Fluid[] steamCrackedFluids = new Fluid[3];

    private static Materials makeDenseSteam() {
        return new MaterialBuilder(232, TextureSet.SET_FLUID, "Dense Steam").addCell().addGas().setRGB(255, 255, 255).setColor(Dyes.dyeWhite).constructMaterial();
    }

    private static Materials makeDenseSuperheatedSteam() {
        return new MaterialBuilder(233, TextureSet.SET_FLUID, "Dense Superheated Steam").addCell().addGas().setRGB(255, 255, 255).setColor(Dyes.dyeWhite).constructMaterial();
    }

    private static Materials makeDenseSupercriticalSteam() {
        return new MaterialBuilder(234, TextureSet.SET_FLUID, "Dense Supercritical Steam").addCell().addGas().setRGB(255, 255, 255).setColor(Dyes.dyeWhite).constructMaterial();
    }

    public int getProcessingMaterialTierEU() {
        return this.processingMaterialTierEU;
    }

    public Materials setProcessingMaterialTierEU(long processingMaterialTierEU) {
        this.processingMaterialTierEU = (int)processingMaterialTierEU;
        return this;
    }

    public Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aDurability, int aToolQuality, boolean aUnificatable, String aName, String aDefaultLocalName) {
        this(aMetaItemSubID, aIconSet, aToolSpeed, aDurability, aToolQuality, aUnificatable, aName, aDefaultLocalName, "ore", false, "null");
    }

    public Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aDurability, int aToolQuality, boolean aUnificatable, String aName, String aDefaultLocalName, String aConfigSection, boolean aCustomOre, String aCustomID) {
        this.mMetaItemSubID = aMetaItemSubID;
        this.mDefaultLocalName = aDefaultLocalName;
        this.mName = aName;
        MATERIALS_MAP.put(this.mName, this);
        this.mCustomOre = aCustomOre;
        this.mCustomID = aCustomID;
        this.mConfigSection = aConfigSection;
        this.mUnificatable = aUnificatable;
        this.mDurability = aDurability;
        this.mToolSpeed = aToolSpeed;
        this.mToolQuality = (byte)aToolQuality;
        this.mMaterialInto = this;
        this.mIconSet = aIconSet;
    }

    public Materials(Materials aMaterialInto, boolean aReRegisterIntoThis) {
        this.mUnificatable = false;
        this.mDefaultLocalName = aMaterialInto.mDefaultLocalName;
        this.mName = aMaterialInto.mName;
        this.mMaterialInto = aMaterialInto.mMaterialInto;
        if (aReRegisterIntoThis) {
            this.mMaterialInto.mOreReRegistrations.add(this);
        }
        this.mChemicalFormula = aMaterialInto.mChemicalFormula;
        this.mMetaItemSubID = -1;
        this.mIconSet = TextureSet.SET_NONE;
    }

    public Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aDurability, int aToolQuality, int aTypes, int aR, int aG, int aB, int aA, String aName, String aDefaultLocalName, int aFuelType, int aFuelPower, int aMeltingPoint, int aBlastFurnaceTemp, boolean aBlastFurnaceRequired, boolean aTransparent, int aOreValue, int aDensityMultiplier, int aDensityDivider, Dyes aColor) {
        this(aMetaItemSubID, aIconSet, aToolSpeed, aDurability, aToolQuality, aTypes, aR, aG, aB, aA, aName, aDefaultLocalName, aFuelType, aFuelPower, aMeltingPoint, aBlastFurnaceTemp, aBlastFurnaceRequired, aTransparent, aOreValue, aDensityMultiplier, aDensityDivider, aColor, "ore", false, "null");
    }

    public Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aDurability, int aToolQuality, int aTypes, int aR, int aG, int aB, int aA, String aName, String aDefaultLocalName, int aFuelType, int aFuelPower, int aMeltingPoint, int aBlastFurnaceTemp, boolean aBlastFurnaceRequired, boolean aTransparent, int aOreValue, int aDensityMultiplier, int aDensityDivider, Dyes aColor, String aConfigSection) {
        this(aMetaItemSubID, aIconSet, aToolSpeed, aDurability, aToolQuality, aTypes, aR, aG, aB, aA, aName, aDefaultLocalName, aFuelType, aFuelPower, aMeltingPoint, aBlastFurnaceTemp, aBlastFurnaceRequired, aTransparent, aOreValue, aDensityMultiplier, aDensityDivider, aColor, aConfigSection, false, "null");
    }

    public Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aDurability, int aToolQuality, int aTypes, int aR, int aG, int aB, int aA, String aName, String aDefaultLocalName, int aFuelType, int aFuelPower, int aMeltingPoint, int aBlastFurnaceTemp, boolean aBlastFurnaceRequired, boolean aTransparent, int aOreValue, int aDensityMultiplier, int aDensityDivider, Dyes aColor, String aConfigSection, boolean aCustomOre, String aCustomID) {
        this(aMetaItemSubID, aIconSet, aToolSpeed, aDurability, aToolQuality, true, aName, aDefaultLocalName, aConfigSection, aCustomOre, aCustomID);
        this.mMeltingPoint = aMeltingPoint;
        this.mBlastFurnaceRequired = aBlastFurnaceRequired;
        this.mBlastFurnaceTemp = (short)aBlastFurnaceTemp;
        this.mTransparent = aTransparent;
        this.mFuelPower = aFuelPower;
        this.mFuelType = aFuelType;
        this.mOreValue = aOreValue;
        this.mDensityMultiplier = aDensityMultiplier;
        this.mDensityDivider = aDensityDivider;
        this.mDensity = 3628800L * (long)aDensityMultiplier / (long)aDensityDivider;
        this.mColor = aColor;
        this.mRGBa[0] = this.mMoltenRGBa[0] = (short)aR;
        this.mRGBa[1] = this.mMoltenRGBa[1] = (short)aG;
        this.mRGBa[2] = this.mMoltenRGBa[2] = (short)aB;
        this.mRGBa[3] = this.mMoltenRGBa[3] = (short)aA;
        this.mTypes = aTypes;
        if (this.mColor != null) {
            this.add(SubTag.HAS_COLOR);
        }
        if (this.mTransparent) {
            this.add(SubTag.TRANSPARENT);
        }
        if ((this.mTypes & 2) != 0) {
            this.add(SubTag.SMELTING_TO_FLUID);
        }
    }

    public Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aDurability, int aToolQuality, int aTypes, int aR, int aG, int aB, int aA, String aName, String aDefaultLocalName, int aFuelType, int aFuelPower, int aMeltingPoint, int aBlastFurnaceTemp, boolean aBlastFurnaceRequired, boolean aTransparent, int aOreValue, int aDensityMultiplier, int aDensityDivider, Dyes aColor, List<TCAspects.TC_AspectStack> aAspects) {
        this(aMetaItemSubID, aIconSet, aToolSpeed, aDurability, aToolQuality, aTypes, aR, aG, aB, aA, aName, aDefaultLocalName, aFuelType, aFuelPower, aMeltingPoint, aBlastFurnaceTemp, aBlastFurnaceRequired, aTransparent, aOreValue, aDensityMultiplier, aDensityDivider, aColor);
        this.mAspects.addAll(aAspects);
    }

    public Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aDurability, int aToolQuality, int aTypes, int aR, int aG, int aB, int aA, String aName, String aDefaultLocalName, int aFuelType, int aFuelPower, int aMeltingPoint, int aBlastFurnaceTemp, boolean aBlastFurnaceRequired, boolean aTransparent, int aOreValue, int aDensityMultiplier, int aDensityDivider, Dyes aColor, Element aElement, List<TCAspects.TC_AspectStack> aAspects) {
        this(aMetaItemSubID, aIconSet, aToolSpeed, aDurability, aToolQuality, aTypes, aR, aG, aB, aA, aName, aDefaultLocalName, aFuelType, aFuelPower, aMeltingPoint, aBlastFurnaceTemp, aBlastFurnaceRequired, aTransparent, aOreValue, aDensityMultiplier, aDensityDivider, aColor);
        this.mElement = aElement;
        this.mElement.mLinkedMaterials.add(this);
        if (aElement == Element._NULL) {
            this.mChemicalFormula = "Empty";
        } else {
            this.mChemicalFormula = aElement.toString();
            this.mChemicalFormula = this.mChemicalFormula.replaceAll("_", "-");
        }
        this.mAspects.addAll(aAspects);
    }

    public Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aDurability, int aToolQuality, int aTypes, int aR, int aG, int aB, int aA, String aName, String aDefaultLocalName, int aFuelType, int aFuelPower, int aMeltingPoint, int aBlastFurnaceTemp, boolean aBlastFurnaceRequired, boolean aTransparent, int aOreValue, int aDensityMultiplier, int aDensityDivider, Dyes aColor, int aExtraData, List<MaterialStack> aMaterialList) {
        this(aMetaItemSubID, aIconSet, aToolSpeed, aDurability, aToolQuality, aTypes, aR, aG, aB, aA, aName, aDefaultLocalName, aFuelType, aFuelPower, aMeltingPoint, aBlastFurnaceTemp, aBlastFurnaceRequired, aTransparent, aOreValue, aDensityMultiplier, aDensityDivider, aColor, aExtraData, aMaterialList, null);
    }

    public Materials(int aMetaItemSubID, TextureSet aIconSet, float aToolSpeed, int aDurability, int aToolQuality, int aTypes, int aR, int aG, int aB, int aA, String aName, String aDefaultLocalName, int aFuelType, int aFuelPower, int aMeltingPoint, int aBlastFurnaceTemp, boolean aBlastFurnaceRequired, boolean aTransparent, int aOreValue, int aDensityMultiplier, int aDensityDivider, Dyes aColor, int aExtraData, List<MaterialStack> aMaterialList, List<TCAspects.TC_AspectStack> aAspects) {
        this(aMetaItemSubID, aIconSet, aToolSpeed, aDurability, aToolQuality, aTypes, aR, aG, aB, aA, aName, aDefaultLocalName, aFuelType, aFuelPower, aMeltingPoint, aBlastFurnaceTemp, aBlastFurnaceRequired, aTransparent, aOreValue, aDensityMultiplier, aDensityDivider, aColor);
        this.mExtraData = aExtraData;
        this.mMaterialList.addAll(aMaterialList);
        this.mChemicalFormula = this.mMaterialList.size() == 1 ? this.mMaterialList.get(0).toString(true) : this.mMaterialList.stream().map(MaterialStack::toString).collect(Collectors.joining()).replaceAll("_", "-");
        int tAmountOfComponents = 0;
        int tMeltingPoint = 0;
        for (MaterialStack tMaterial : this.mMaterialList) {
            tAmountOfComponents = (int)((long)tAmountOfComponents + tMaterial.mAmount);
            if (tMaterial.mMaterial.mMeltingPoint > 0) {
                tMeltingPoint = (int)((long)tMeltingPoint + (long)tMaterial.mMaterial.mMeltingPoint * tMaterial.mAmount);
            }
            if (aAspects != null) continue;
            for (TCAspects.TC_AspectStack tAspect : tMaterial.mMaterial.mAspects) {
                tAspect.addToAspectList(this.mAspects);
            }
        }
        if (this.mMeltingPoint < 0) {
            this.mMeltingPoint = (short)(tMeltingPoint / tAmountOfComponents);
        }
        tAmountOfComponents *= aDensityMultiplier;
        tAmountOfComponents /= aDensityDivider;
        if (aAspects == null) {
            for (TCAspects.TC_AspectStack tAspect : this.mAspects) {
                tAspect.mAmount = Math.max(1L, tAspect.mAmount / (long)Math.max(1, tAmountOfComponents));
            }
        } else {
            this.mAspects.addAll(aAspects);
        }
    }

    private static void setSmeltingInto() {
        SamariumMagnetic.setSmeltingInto(Samarium).setMaceratingInto(Samarium).setArcSmeltingInto(Samarium);
        NeodymiumMagnetic.setSmeltingInto(Neodymium).setMaceratingInto(Neodymium).setArcSmeltingInto(Neodymium);
        SteelMagnetic.setSmeltingInto(Steel).setMaceratingInto(Steel).setArcSmeltingInto(Steel);
        Iron.setSmeltingInto(Iron).setMaceratingInto(Iron).setArcSmeltingInto(WroughtIron);
        AnyIron.setSmeltingInto(Iron).setMaceratingInto(Iron).setArcSmeltingInto(WroughtIron);
        PigIron.setSmeltingInto(Iron).setMaceratingInto(Iron).setArcSmeltingInto(WroughtIron);
        WroughtIron.setSmeltingInto(WroughtIron).setMaceratingInto(WroughtIron).setArcSmeltingInto(WroughtIron);
        IronMagnetic.setSmeltingInto(Iron).setMaceratingInto(Iron).setArcSmeltingInto(WroughtIron);
        Copper.setSmeltingInto(Copper).setMaceratingInto(Copper).setArcSmeltingInto(AnnealedCopper);
        AnyCopper.setSmeltingInto(Copper).setMaceratingInto(Copper).setArcSmeltingInto(AnnealedCopper);
        AnnealedCopper.setSmeltingInto(AnnealedCopper).setMaceratingInto(AnnealedCopper).setArcSmeltingInto(AnnealedCopper);
        Netherrack.setSmeltingInto(NetherBrick);
        MeatRaw.setSmeltingInto(MeatCooked);
        Sand.setSmeltingInto(Glass);
        Ice.setSmeltingInto(Water);
        Snow.setSmeltingInto(Water);
        TengamAttuned.setSmeltingInto(TengamPurified).setMaceratingInto(TengamPurified).setArcSmeltingInto(TengamPurified);
    }

    private static void setOthers() {
        Mercury.add(SubTag.SMELTING_TO_GEM);
    }

    private static void setDirectSmelting() {
        Cinnabar.setDirectSmelting(Mercury).add(SubTag.INDUCTIONSMELTING_LOW_OUTPUT).add(SubTag.SMELTING_TO_GEM);
        Tetrahedrite.setDirectSmelting(Copper).add(SubTag.INDUCTIONSMELTING_LOW_OUTPUT).add(SubTag.DONT_ADD_DEFAULT_BBF_RECIPE);
        Chalcopyrite.setDirectSmelting(Copper).add(SubTag.INDUCTIONSMELTING_LOW_OUTPUT).add(SubTag.DONT_ADD_DEFAULT_BBF_RECIPE);
        Malachite.setDirectSmelting(Copper).add(SubTag.INDUCTIONSMELTING_LOW_OUTPUT);
        Pentlandite.setDirectSmelting(Nickel).add(SubTag.INDUCTIONSMELTING_LOW_OUTPUT);
        Sphalerite.setDirectSmelting(Zinc).add(SubTag.INDUCTIONSMELTING_LOW_OUTPUT);
        Pyrite.setDirectSmelting(Iron).add(SubTag.INDUCTIONSMELTING_LOW_OUTPUT);
        BasalticMineralSand.setDirectSmelting(Iron).add(SubTag.INDUCTIONSMELTING_LOW_OUTPUT);
        GraniticMineralSand.setDirectSmelting(Iron).add(SubTag.INDUCTIONSMELTING_LOW_OUTPUT);
        YellowLimonite.setDirectSmelting(Iron).add(SubTag.INDUCTIONSMELTING_LOW_OUTPUT);
        BrownLimonite.setDirectSmelting(Iron);
        BandedIron.setDirectSmelting(Iron);
        Magnetite.setDirectSmelting(Iron);
        Cassiterite.setDirectSmelting(Tin);
        CassiteriteSand.setDirectSmelting(Tin);
        Chromite.setDirectSmelting(Chrome);
        Garnierite.setDirectSmelting(Nickel);
        Cobaltite.setDirectSmelting(Cobalt);
        Stibnite.setDirectSmelting(Antimony);
        Cooperite.setDirectSmelting(Platinum).add(SubTag.DONT_ADD_DEFAULT_BBF_RECIPE);
        Molybdenite.setDirectSmelting(Molybdenum).add(SubTag.DONT_ADD_DEFAULT_BBF_RECIPE);
        Galena.setDirectSmelting(Lead);
        RoastedIron.setDirectSmelting(Iron);
        RoastedAntimony.setDirectSmelting(Antimony);
        RoastedLead.setDirectSmelting(Lead);
        RoastedArsenic.setDirectSmelting(Arsenic);
        RoastedCobalt.setDirectSmelting(Cobalt);
        RoastedZinc.setDirectSmelting(Zinc);
        RoastedNickel.setDirectSmelting(Nickel);
        RoastedCopper.setDirectSmelting(Copper);
    }

    private static void setMultipliers() {
        Amber.setOreMultiplier(2).setSmeltingMultiplier(2);
        InfusedAir.setOreMultiplier(2).setSmeltingMultiplier(2);
        InfusedFire.setOreMultiplier(2).setSmeltingMultiplier(2);
        InfusedEarth.setOreMultiplier(2).setSmeltingMultiplier(2);
        InfusedWater.setOreMultiplier(2).setSmeltingMultiplier(2);
        InfusedEntropy.setOreMultiplier(2).setSmeltingMultiplier(2);
        InfusedOrder.setOreMultiplier(2).setSmeltingMultiplier(2);
        InfusedVis.setOreMultiplier(2).setSmeltingMultiplier(2);
        InfusedDull.setOreMultiplier(2).setSmeltingMultiplier(2);
        Salt.setOreMultiplier(2).setSmeltingMultiplier(2);
        RockSalt.setOreMultiplier(2).setSmeltingMultiplier(2);
        Scheelite.setOreMultiplier(2).setSmeltingMultiplier(2);
        Tungstate.setOreMultiplier(2).setSmeltingMultiplier(2);
        Cassiterite.setOreMultiplier(2).setSmeltingMultiplier(2);
        CassiteriteSand.setOreMultiplier(2).setSmeltingMultiplier(2);
        NetherQuartz.setOreMultiplier(2).setSmeltingMultiplier(2);
        CertusQuartz.setOreMultiplier(2).setSmeltingMultiplier(2);
        CertusQuartzCharged.setOreMultiplier(2).setSmeltingMultiplier(2);
        TricalciumPhosphate.setOreMultiplier(3).setSmeltingMultiplier(3);
        Saltpeter.setOreMultiplier(4).setSmeltingMultiplier(4);
        Apatite.setOreMultiplier(4).setSmeltingMultiplier(4).setByProductMultiplier(2);
        Electrotine.setOreMultiplier(5).setSmeltingMultiplier(5);
        Teslatite.setOreMultiplier(5).setSmeltingMultiplier(5);
        Redstone.setOreMultiplier(5).setSmeltingMultiplier(5);
        Glowstone.setOreMultiplier(5).setSmeltingMultiplier(5);
        Lapis.setOreMultiplier(6).setSmeltingMultiplier(6).setByProductMultiplier(4);
        Sodalite.setOreMultiplier(6).setSmeltingMultiplier(6).setByProductMultiplier(4);
        Lazurite.setOreMultiplier(6).setSmeltingMultiplier(6).setByProductMultiplier(4);
        Monazite.setOreMultiplier(8).setSmeltingMultiplier(8).setByProductMultiplier(2);
        Cryolite.setOreMultiplier(4).setByProductMultiplier(4);
        Coal.setOreMultiplier(2).setByProductMultiplier(2);
    }

    private static void setEnchantmentKnockbackTools() {
        Plastic.setEnchantmentForTools(Enchantment.field_77337_m, 1);
        PolyvinylChloride.setEnchantmentForTools(Enchantment.field_77337_m, 1);
        Polystyrene.setEnchantmentForTools(Enchantment.field_77337_m, 1);
        Rubber.setEnchantmentForTools(Enchantment.field_77337_m, 2);
        StyreneButadieneRubber.setEnchantmentForTools(Enchantment.field_77337_m, 2);
        InfusedAir.setEnchantmentForTools(Enchantment.field_77337_m, 2);
    }

    private static void setEnchantmentFortuneTools() {
        IronWood.setEnchantmentForTools(Enchantment.field_77346_s, 1);
        Steeleaf.setEnchantmentForTools(Enchantment.field_77346_s, 2);
        Mithril.setEnchantmentForTools(Enchantment.field_77346_s, 3);
        Vinteum.setEnchantmentForTools(Enchantment.field_77346_s, 1);
        Thaumium.setEnchantmentForTools(Enchantment.field_77346_s, 2);
        InfusedWater.setEnchantmentForTools(Enchantment.field_77346_s, 3);
    }

    private static void setEnchantmentFireAspectTools() {
        Flint.setEnchantmentForTools(Enchantment.field_77334_n, 1);
        DarkIron.setEnchantmentForTools(Enchantment.field_77334_n, 2);
        Firestone.setEnchantmentForTools(Enchantment.field_77334_n, 3);
        FierySteel.setEnchantmentForTools(Enchantment.field_77334_n, 3);
        Pyrotheum.setEnchantmentForTools(Enchantment.field_77334_n, 3);
        Blaze.setEnchantmentForTools(Enchantment.field_77334_n, 3);
        InfusedFire.setEnchantmentForTools(Enchantment.field_77334_n, 3);
    }

    private static void setEnchantmentSilkTouchTools() {
        Force.setEnchantmentForTools(Enchantment.field_77348_q, 1);
        Amber.setEnchantmentForTools(Enchantment.field_77348_q, 1);
        EnderPearl.setEnchantmentForTools(Enchantment.field_77348_q, 1);
        Enderium.setEnchantmentForTools(Enchantment.field_77348_q, 1);
        NetherStar.setEnchantmentForTools(Enchantment.field_77348_q, 1);
        InfusedOrder.setEnchantmentForTools(Enchantment.field_77348_q, 1);
    }

    private static void setEnchantmentSmiteTools() {
        BlackBronze.setEnchantmentForTools(Enchantment.field_77339_k, 2);
        Gold.setEnchantmentForTools(Enchantment.field_77339_k, 3);
        RoseGold.setEnchantmentForTools(Enchantment.field_77339_k, 4);
        Platinum.setEnchantmentForTools(Enchantment.field_77339_k, 5);
        InfusedVis.setEnchantmentForTools(Enchantment.field_77339_k, 5);
        Ichorium.setEnchantmentForTools(Enchantment.field_77339_k, 8);
    }

    private static void setEnchantmentBaneOfArthropodsTools() {
        Lead.setEnchantmentForTools(Enchantment.field_77336_l, 2);
        Nickel.setEnchantmentForTools(Enchantment.field_77336_l, 2);
        Invar.setEnchantmentForTools(Enchantment.field_77336_l, 3);
        Antimony.setEnchantmentForTools(Enchantment.field_77336_l, 3);
        BatteryAlloy.setEnchantmentForTools(Enchantment.field_77336_l, 4);
        Bismuth.setEnchantmentForTools(Enchantment.field_77336_l, 4);
        BismuthBronze.setEnchantmentForTools(Enchantment.field_77336_l, 5);
        InfusedEarth.setEnchantmentForTools(Enchantment.field_77336_l, 5);
    }

    private static void setEnchantmentSharpnessTools() {
        Iron.setEnchantmentForTools(Enchantment.field_77338_j, 1);
        Bronze.setEnchantmentForTools(Enchantment.field_77338_j, 1);
        Brass.setEnchantmentForTools(Enchantment.field_77338_j, 2);
        HSLA.setEnchantmentForTools(Enchantment.field_77338_j, 2);
        Steel.setEnchantmentForTools(Enchantment.field_77338_j, 2);
        WroughtIron.setEnchantmentForTools(Enchantment.field_77338_j, 2);
        StainlessSteel.setEnchantmentForTools(Enchantment.field_77338_j, 3);
        Knightmetal.setEnchantmentForTools(Enchantment.field_77338_j, 3);
        ShadowIron.setEnchantmentForTools(Enchantment.field_77338_j, 3);
        ShadowSteel.setEnchantmentForTools(Enchantment.field_77338_j, 4);
        BlackSteel.setEnchantmentForTools(Enchantment.field_77338_j, 4);
        RedSteel.setEnchantmentForTools(Enchantment.field_77338_j, 4);
        BlueSteel.setEnchantmentForTools(Enchantment.field_77338_j, 5);
        DamascusSteel.setEnchantmentForTools(Enchantment.field_77338_j, 5);
        InfusedEntropy.setEnchantmentForTools(Enchantment.field_77338_j, 5);
        TungstenCarbide.setEnchantmentForTools(Enchantment.field_77338_j, 5);
        HSSE.setEnchantmentForTools(Enchantment.field_77338_j, 5);
        HSSG.setEnchantmentForTools(Enchantment.field_77338_j, 4);
        HSSS.setEnchantmentForTools(Enchantment.field_77338_j, 5);
    }

    private static void setEnchantments() {
        Materials.setToolEnchantments();
        Materials.setArmorEnchantments();
    }

    private static void setToolEnchantments() {
        Materials.setEnchantmentKnockbackTools();
        Materials.setEnchantmentFortuneTools();
        Materials.setEnchantmentFireAspectTools();
        Materials.setEnchantmentSilkTouchTools();
        Materials.setEnchantmentSmiteTools();
        Materials.setEnchantmentBaneOfArthropodsTools();
        Materials.setEnchantmentSharpnessTools();
    }

    private static void setArmorEnchantments() {
        InfusedAir.setEnchantmentForArmors(Enchantment.field_77340_h, 3);
        InfusedFire.setEnchantmentForArmors(Enchantment.field_77330_e, 4);
        Steeleaf.setEnchantmentForArmors(Enchantment.field_77332_c, 2);
        Knightmetal.setEnchantmentForArmors(Enchantment.field_77332_c, 1);
        InfusedEarth.setEnchantmentForArmors(Enchantment.field_77332_c, 4);
        InfusedEntropy.setEnchantmentForArmors(Enchantment.field_92091_k, 3);
        InfusedWater.setEnchantmentForArmors(Enchantment.field_77341_i, 1);
        IronWood.setEnchantmentForArmors(Enchantment.field_77341_i, 1);
        InfusedOrder.setEnchantmentForArmors(Enchantment.field_77328_g, 4);
        InfusedDull.setEnchantmentForArmors(Enchantment.field_77327_f, 4);
        InfusedVis.setEnchantmentForArmors(Enchantment.field_77332_c, 4);
    }

    private static void setMaceratingInto() {
        Peanutwood.setMaceratingInto(Wood);
        WoodSealed.setMaceratingInto(Wood);
        NetherBrick.setMaceratingInto(Netherrack);
        AnyRubber.setMaceratingInto(Rubber);
    }

    private static void setReRegistration() {
        Materials.Iron.mOreReRegistrations.add(AnyIron);
        Materials.PigIron.mOreReRegistrations.add(AnyIron);
        Materials.WroughtIron.mOreReRegistrations.add(AnyIron);
        Materials.Copper.mOreReRegistrations.add(AnyCopper);
        Materials.AnnealedCopper.mOreReRegistrations.add(AnyCopper);
        Materials.Bronze.mOreReRegistrations.add(AnyBronze);
        Materials.Rubber.mOreReRegistrations.add(AnyRubber);
        Materials.StyreneButadieneRubber.mOreReRegistrations.add(AnyRubber);
        Materials.Silicone.mOreReRegistrations.add(AnyRubber);
        Materials.StyreneButadieneRubber.mOreReRegistrations.add(AnySyntheticRubber);
        Materials.Silicone.mOreReRegistrations.add(AnySyntheticRubber);
    }

    private static void setHeatDamage() {
        FryingOilHot.setHeatDamage(1.0f);
        Lava.setHeatDamage(3.0f);
        Firestone.setHeatDamage(5.0f);
        Pyrotheum.setHeatDamage(5.0f);
    }

    private static void setByProducts() {
        Mytryl.addOreByProducts(Samarium, Samarium, Zinc, Zinc);
        Rubracium.addOreByProducts(Samarium, Samarium, Samarium, Samarium);
        Chalcopyrite.addOreByProducts(Pyrite, Cobalt, Cadmium, Gold);
        Sphalerite.addOreByProducts(GarnetYellow, Cadmium, Gallium, Zinc);
        MeteoricIron.addOreByProducts(Iron, Nickel, Iridium, Platinum);
        GlauconiteSand.addOreByProducts(Sodium, Aluminiumoxide, Iron);
        Glauconite.addOreByProducts(Sodium, Aluminiumoxide, Iron);
        Vermiculite.addOreByProducts(Iron, Aluminiumoxide, Magnesium);
        FullersEarth.addOreByProducts(Aluminiumoxide, SiliconDioxide, Magnesium);
        Bentonite.addOreByProducts(Aluminiumoxide, Calcium, Magnesium);
        Uraninite.addOreByProducts(Uranium, Thorium, Uranium235);
        Pitchblende.addOreByProducts(Thorium, Uranium, Lead);
        Galena.addOreByProducts(Sulfur, Silver, Lead);
        Lapis.addOreByProducts(Lazurite, Sodalite, Pyrite);
        Pyrite.addOreByProducts(Sulfur, TricalciumPhosphate, Iron);
        Copper.addOreByProducts(Cobalt, Gold, Nickel);
        Nickel.addOreByProducts(Cobalt, Platinum, Iron);
        GarnetRed.addOreByProducts(Spessartine, Pyrope, Almandine);
        GarnetYellow.addOreByProducts(Andradite, Grossular, Uvarovite);
        Cooperite.addOreByProducts(Palladium, Nickel, Iridium);
        Cinnabar.addOreByProducts(Redstone, Sulfur, Glowstone);
        Tantalite.addOreByProducts(Manganese, Niobium, Tantalum);
        Pollucite.addOreByProducts(Caesium, Aluminiumoxide, Rubidium);
        Chrysotile.addOreByProducts(Asbestos, SiliconDioxide, Magnesium);
        Asbestos.addOreByProducts(Asbestos, SiliconDioxide, Magnesium);
        Pentlandite.addOreByProducts(Iron, Sulfur, Cobalt);
        Uranium.addOreByProducts(Lead, Uranium235, Thorium);
        Scheelite.addOreByProducts(Manganese, Molybdenum, Calcium);
        Tungstate.addOreByProducts(Manganese, Silver, Lithium);
        Bauxite.addOreByProducts(Grossular, Rutile, Gallium);
        QuartzSand.addOreByProducts(CertusQuartz, Quartzite, Barite);
        Redstone.addOreByProducts(Cinnabar, RareEarth, Glowstone);
        Monazite.addOreByProducts(Thorium, Neodymium, RareEarth);
        Forcicium.addOreByProducts(Thorium, Neodymium, RareEarth);
        Forcillium.addOreByProducts(Thorium, Neodymium, RareEarth);
        Malachite.addOreByProducts(Copper, BrownLimonite, Calcite);
        YellowLimonite.addOreByProducts(Nickel, BrownLimonite, Cobalt);
        Lepidolite.addOreByProducts(Lithium, Caesium);
        Andradite.addOreByProducts(GarnetYellow, Iron);
        Pyrolusite.addOreByProducts(Manganese, Tantalite, Niobium).add(SubTag.DONT_ADD_DEFAULT_BBF_RECIPE);
        TricalciumPhosphate.addOreByProducts(Apatite, Phosphate, Pyrochlore);
        Apatite.addOreByProducts(TricalciumPhosphate, Phosphate, Pyrochlore);
        Pyrochlore.addOreByProducts(Apatite, Calcite, Niobium);
        Quartzite.addOreByProducts(CertusQuartz, Barite);
        CertusQuartz.addOreByProducts(Quartzite, Barite);
        CertusQuartzCharged.addOreByProducts(CertusQuartz, Quartzite, Barite);
        BrownLimonite.addOreByProducts(Malachite, YellowLimonite);
        Neodymium.addOreByProducts(Monazite, RareEarth);
        Bastnasite.addOreByProducts(Neodymium, RareEarth);
        Glowstone.addOreByProducts(Redstone, Gold);
        Zinc.addOreByProducts(Tin, Gallium);
        Tungsten.addOreByProducts(Manganese, Molybdenum);
        Diatomite.addOreByProducts(BandedIron, Sapphire);
        Iron.addOreByProducts(Nickel, Tin);
        Gold.addOreByProducts(Copper, Nickel);
        Tin.addOreByProducts(Iron, Zinc);
        Antimony.addOreByProducts(Zinc, Iron);
        Silver.addOreByProducts(Lead, Sulfur);
        Lead.addOreByProducts(Silver, Sulfur);
        Thorium.addOreByProducts(Uranium, Lead);
        Plutonium.addOreByProducts(Uranium, Lead);
        Electrum.addOreByProducts(Gold, Silver);
        Electrotine.addOreByProducts(Redstone, Electrum);
        Bronze.addOreByProducts(Copper, Tin);
        Brass.addOreByProducts(Copper, Zinc);
        Coal.addOreByProducts(Lignite, Thorium);
        Ilmenite.addOreByProducts(Iron, Rutile);
        Manganese.addOreByProducts(Chrome, Iron);
        Sapphire.addOreByProducts(Aluminiumoxide, GreenSapphire);
        GreenSapphire.addOreByProducts(Aluminiumoxide, Sapphire);
        Platinum.addOreByProducts(Nickel, Iridium);
        Emerald.addOreByProducts(Beryllium, Aluminiumoxide);
        Olivine.addOreByProducts(Pyrope, Magnesium);
        Chrome.addOreByProducts(Iron, Magnesium);
        Chromite.addOreByProducts(Iron, Magnesium);
        Tetrahedrite.addOreByProducts(Antimony, Zinc);
        GarnetSand.addOreByProducts(GarnetRed, GarnetYellow);
        Magnetite.addOreByProducts(Iron, Gold);
        GraniticMineralSand.addOreByProducts(GraniteBlack, Magnetite);
        BasalticMineralSand.addOreByProducts(Basalt, Magnetite);
        Basalt.addOreByProducts(Olivine, DarkAsh);
        VanadiumMagnetite.addOreByProducts(Magnetite, Vanadium);
        Lazurite.addOreByProducts(Sodalite, Lapis);
        Sodalite.addOreByProducts(Lazurite, Lapis);
        Spodumene.addOreByProducts(Aluminiumoxide, Lithium);
        Ruby.addOreByProducts(Chrome, GarnetRed);
        Iridium.addOreByProducts(Platinum, Osmium);
        Pyrope.addOreByProducts(GarnetRed, Magnesium);
        Almandine.addOreByProducts(GarnetRed, Aluminiumoxide);
        Spessartine.addOreByProducts(GarnetRed, Manganese);
        Grossular.addOreByProducts(GarnetYellow, Calcium);
        Uvarovite.addOreByProducts(GarnetYellow, Chrome);
        Calcite.addOreByProducts(Andradite, Malachite);
        NaquadahEnriched.addOreByProducts(Naquadah, Naquadria);
        Salt.addOreByProducts(RockSalt, Borax);
        RockSalt.addOreByProducts(Salt, Borax);
        Naquadah.addOreByProducts(NaquadahEnriched);
        Molybdenite.addOreByProducts(Molybdenum);
        Stibnite.addOreByProducts(Antimony);
        Garnierite.addOreByProducts(Nickel);
        Lignite.addOreByProducts(Coal);
        Diamond.addOreByProducts(Graphite);
        Beryllium.addOreByProducts(Emerald);
        Electrotine.addOreByProducts(Diamond);
        Teslatite.addOreByProducts(Diamond);
        Magnesite.addOreByProducts(Magnesium);
        NetherQuartz.addOreByProducts(Netherrack);
        PigIron.addOreByProducts(Iron);
        DeepIron.addOreByProducts(Trinium, Iron, Trinium);
        ShadowIron.addOreByProducts(Iron);
        DarkIron.addOreByProducts(Iron);
        MeteoricIron.addOreByProducts(Iron);
        Steel.addOreByProducts(Iron);
        HSLA.addOreByProducts(Iron);
        Mithril.addOreByProducts(Platinum);
        AstralSilver.addOreByProducts(Silver);
        Graphite.addOreByProducts(Carbon);
        Netherrack.addOreByProducts(Sulfur);
        Flint.addOreByProducts(Obsidian);
        Cobaltite.addOreByProducts(Cobalt);
        Cobalt.addOreByProducts(Cobaltite);
        Sulfur.addOreByProducts(Sulfur);
        Saltpeter.addOreByProducts(Saltpeter);
        Endstone.addOreByProducts(Helium_3);
        Osmium.addOreByProducts(Iridium);
        Magnesium.addOreByProducts(Olivine);
        Aluminium.addOreByProducts(Bauxite);
        Titanium.addOreByProducts(Almandine);
        Obsidian.addOreByProducts(Olivine);
        Ash.addOreByProducts(Carbon);
        DarkAsh.addOreByProducts(Carbon);
        Redrock.addOreByProducts(Clay);
        Marble.addOreByProducts(Calcite);
        Clay.addOreByProducts(Clay);
        Cassiterite.addOreByProducts(Tin);
        CassiteriteSand.addOreByProducts(Tin);
        GraniteBlack.addOreByProducts(Biotite);
        GraniteRed.addOreByProducts(PotassiumFeldspar);
        Phosphate.addOreByProducts(Phosphorus);
        Phosphorus.addOreByProducts(Phosphate);
        Tanzanite.addOreByProducts(Opal);
        Opal.addOreByProducts(Tanzanite);
        Amethyst.addOreByProducts(Amethyst);
        FoolsRuby.addOreByProducts(Jasper);
        Amber.addOreByProducts(Amber);
        Topaz.addOreByProducts(BlueTopaz);
        BlueTopaz.addOreByProducts(Topaz);
        Niter.addOreByProducts(Saltpeter);
        Vinteum.addOreByProducts(Vinteum);
        Force.addOreByProducts(Force);
        Dilithium.addOreByProducts(Dilithium);
        Neutronium.addOreByProducts(Neutronium);
        Lithium.addOreByProducts(Lithium);
        Silicon.addOreByProducts(SiliconDioxide);
        InfusedGold.addOreByProduct(Gold);
        Cryolite.addOreByProducts(Aluminiumoxide, Sodium);
        Naquadria.addOreByProduct(Naquadria);
        RoastedNickel.addOreByProduct(Nickel);
        TengamRaw.addOreByProducts(NeodymiumMagnetic, SamariumMagnetic);
    }

    private static void setColors() {
        Materials.Naquadah.mMoltenRGBa[0] = 0;
        Materials.Naquadah.mMoltenRGBa[1] = 255;
        Materials.Naquadah.mMoltenRGBa[2] = 0;
        Materials.Naquadah.mMoltenRGBa[3] = 0;
        Materials.NaquadahEnriched.mMoltenRGBa[0] = 64;
        Materials.NaquadahEnriched.mMoltenRGBa[1] = 255;
        Materials.NaquadahEnriched.mMoltenRGBa[2] = 64;
        Materials.NaquadahEnriched.mMoltenRGBa[3] = 0;
        Materials.Naquadria.mMoltenRGBa[0] = 128;
        Materials.Naquadria.mMoltenRGBa[1] = 255;
        Materials.Naquadria.mMoltenRGBa[2] = 128;
        Materials.Naquadria.mMoltenRGBa[3] = 0;
    }

    private static void overrideChemicalFormulas() {
        Materials.InfusedAir.mChemicalFormula = "\ue000";
        Materials.InfusedEarth.mChemicalFormula = "\ue001";
        Materials.InfusedFire.mChemicalFormula = "\ue002";
        Materials.InfusedWater.mChemicalFormula = "\ue003";
        Materials.Glue.mChemicalFormula = "No Horses were harmed in the the making of this substance";
        Materials.AdvancedGlue.mChemicalFormula = "A chemically approved glue!";
        Materials.UUAmplifier.mChemicalFormula = "Accelerates the Mass Fabricator";
        Materials.WoodSealed.mChemicalFormula = "";
        Materials.Wood.mChemicalFormula = "";
        Materials.HeeEndium.mChemicalFormula = "Em";
        Materials.Alduorite.mChemicalFormula = "SpAl";
        Materials.PlatinumGroupSludge.mChemicalFormula = "(SiO\u2082)\ue020Au\ue020Pt\ue020Pd\ue020??";
        Materials.Ceruclase.mChemicalFormula = "SpAg";
        Materials.Orichalcum.mChemicalFormula = "SpBi";
        Materials.Rubracium.mChemicalFormula = "SpRb";
        Materials.Vulcanite.mChemicalFormula = "SpCu";
        Materials.Vyroxeres.mChemicalFormula = "SpBe";
        Materials.Force.mChemicalFormula = "Fc\u2699";
        Materials.DarkAsh.mChemicalFormula = "C\ue020??";
        Materials.Ash.mChemicalFormula = "??";
        Materials.FierySteel.mChemicalFormula = "\ue01eFe\u2085\ue01aC";
        Materials.RareEarth.mChemicalFormula = "??????";
        Materials.WroughtIron.mChemicalFormula = "Fe*";
        Materials.AnnealedCopper.mChemicalFormula = "Cu*";
        Materials.PigIron.mChemicalFormula = "\u00bfFe?";
        Materials.LiveRoot.mChemicalFormula = "(COH\u2083)Ma";
        Materials.Vinteum.mChemicalFormula = "FeMa*";
        Materials.Forcicium.mChemicalFormula = "\u25c3\u25c1\u25c0";
        Materials.Forcillium.mChemicalFormula = "\u25b6\u25b7\u25b9";
        Materials.DarkIron.mChemicalFormula = "Sp\u2086Fe\ue007";
        Materials.IronMagnetic.mChemicalFormula = "Fe\ue00e";
        Materials.SteelMagnetic.mChemicalFormula = "Fe\u2085\ue01aC\ue00e";
        Materials.NeodymiumMagnetic.mChemicalFormula = "Nd\ue00e";
        Materials.SamariumMagnetic.mChemicalFormula = "Sm\ue00e";
        Materials.MetalMixture.mChemicalFormula = "Fe\ue020O\ue020??";
        Materials.Void.mChemicalFormula = "ShFeMa\u2083";
        Materials.Shadow.mChemicalFormula = "Sh\u2086(FeMa\u2083)\u2082";
        Materials.BloodInfusedIron.mChemicalFormula = "\ue01eFe";
        Materials.DamascusSteel.mChemicalFormula = "(Fe\u2085\ue01aC)\u2089Mn\u2084Cr\u2084CSiV";
        Materials.Dilithium.mChemicalFormula = "\u2233Li\u2233Li\u2233";
        Materials.NetherStar.mChemicalFormula = "(Nh\u2082Ma)\u2083\ue01fC\u2086";
        Materials.Unstable.mChemicalFormula = "\ue01dFe/C\u230b";
        Materials.RoastedAntimony.mChemicalFormula = "Sb\ue020";
        Materials.RoastedArsenic.mChemicalFormula = "As\ue020";
        Materials.RoastedCobalt.mChemicalFormula = "Co\ue020";
        Materials.RoastedCopper.mChemicalFormula = "Cu\ue020";
        Materials.RoastedIron.mChemicalFormula = "Fe\ue020";
        Materials.RoastedLead.mChemicalFormula = "Pb\ue020";
        Materials.RoastedNickel.mChemicalFormula = "Ni\ue020";
        Materials.RoastedZinc.mChemicalFormula = "Zn\ue020";
        Materials.Reinforced.mChemicalFormula = "Fe\u2082(C(MgFeSi\u2082O\u2088)\u2088)";
        Materials.Galgadorian.mChemicalFormula = "???Fe\u2082C\u2089Nh\u2083";
        Materials.EnhancedGalgadorian.mChemicalFormula = "???Fe\u2082C\u2089Nh\u2083";
        Materials.QuartzSand.mChemicalFormula = "(SiO\u2082)\ue020??";
        Materials.Blizz.mChemicalFormula = "\u2746Ma";
        Materials.Firestone.mChemicalFormula = "\u2f55";
        Materials.InfusedOrder.mChemicalFormula = "\ue005";
        Materials.InfusedEntropy.mChemicalFormula = "\ue004";
        MaterialsUEVplus.BlackDwarfMatter.mChemicalFormula = ">>\u2205<<";
        MaterialsUEVplus.WhiteDwarfMatter.mChemicalFormula = "\u2205";
        Materials.MysteriousCrystal.mChemicalFormula = "\ue006";
        Materials.Cryotheum.mChemicalFormula = "(KNO\u2083)(" + Materials.Redstone.mChemicalFormula + ")(H\u2082O)(" + Materials.Blizz.mChemicalFormula + ")";
        Materials.Uranium235.mChemicalFormula = "\ue012\ue013\ue015U";
        Materials.Plutonium241.mChemicalFormula = "\ue012\ue014\ue011Pu";
        Materials.Electrotine.mChemicalFormula = "Rp";
        Materials.Trinium.mChemicalFormula = "Ke";
        Materials.Naquadah.mChemicalFormula = "Nq";
        Materials.NaquadahEnriched.mChemicalFormula = "Nq+";
        Materials.Naquadria.mChemicalFormula = "Nq*";
        Materials.NaquadahAlloy.mChemicalFormula = "Nq\u2082KeC";
        Materials.Sunnarium.mChemicalFormula = "Su";
        Materials.Adamantium.mChemicalFormula = "Ad";
        Materials.InfusedGold.mChemicalFormula = "AuMa*";
        Materials.MeteoricIron.mChemicalFormula = "SpFe";
        Materials.MeteoricSteel.mChemicalFormula = "SpFe\u2085\ue01aC";
        Materials.Duranium.mChemicalFormula = "Du";
        Materials.Tritanium.mChemicalFormula = "Tn";
        Materials.Ardite.mChemicalFormula = "Ai";
        Materials.Manyullyn.mChemicalFormula = "AiCo";
        Materials.Mytryl.mChemicalFormula = "SpPt\u2082FeMa";
        Materials.BlackPlutonium.mChemicalFormula = "SpPu";
        Materials.Ledox.mChemicalFormula = "SpPb";
        Materials.CallistoIce.mChemicalFormula = "SpH\u2082O";
        Materials.Quantium.mChemicalFormula = "Qt";
        Materials.Desh.mChemicalFormula = "De";
        Materials.Oriharukon.mChemicalFormula = "Oh";
        Materials.Draconium.mChemicalFormula = "D";
        Materials.DraconiumAwakened.mChemicalFormula = "D*";
        Materials.BlueAlloy.mChemicalFormula = "AgRp\u2084";
        Materials.RedAlloy.mChemicalFormula = "Cu(" + Materials.Redstone.mChemicalFormula + ")\u2084";
        Materials.AnyIron.mChemicalFormula = "Fe";
        Materials.AnyCopper.mChemicalFormula = "Cu";
        Materials.ElectrumFlux.mChemicalFormula = "The formula is too long...";
        Materials.DeepIron.mChemicalFormula = "Sp\u2082Fe";
        Materials.Ichorium.mChemicalFormula = "IcMa";
        Materials.Infinity.mChemicalFormula = "If*";
        Materials.InfinityCatalyst.mChemicalFormula = "If";
        Materials.CosmicNeutronium.mChemicalFormula = "SpNt";
        Materials.Aluminiumhydroxide.mChemicalFormula = "Al(OH)\u2083";
        MaterialsKevlar.LiquidCrystalKevlar.mChemicalFormula = "[-CO-C\u2086H\u2084-CO-NH-C\u2086H\u2084-NH-]n";
        MaterialsKevlar.RhodiumChloride.mChemicalFormula = "RhCl\u2083";
        MaterialsKevlar.OrganorhodiumCatalyst.mChemicalFormula = "RhHCO(P(C\u2086H\u2085)\u2083)\u2083";
        MaterialsKevlar.CobaltIINitrate.mChemicalFormula = "Co(NO\u2083)\u2082";
        MaterialsKevlar.CobaltIIHydroxide.mChemicalFormula = "Co(OH)\u2082";
        Materials.SiliconSG.mChemicalFormula = "Si*";
        Materials.NetherQuartz.mChemicalFormula = "SiO\u2082";
        Materials.Quartzite.mChemicalFormula = "SiO\u2082";
        Materials.CertusQuartz.mChemicalFormula = "SiO\u2082";
        Materials.CertusQuartzCharged.mChemicalFormula = "SiO\u2082\ue00a";
        MaterialsUEVplus.SpaceTime.mChemicalFormula = "Reality itself distilled into physical form";
        MaterialsUEVplus.Universium.mChemicalFormula = "A tear into the space beyond space";
        MaterialsUEVplus.Eternity.mChemicalFormula = "En\u29bc";
        MaterialsUEVplus.MagMatter.mChemicalFormula = "M\u238b";
        MaterialsUEVplus.RawStarMatter.mChemicalFormula = "\ue00c";
        MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter.mChemicalFormula = "\u21f2\ue008\ue00c\ue009\u21f1";
        Materials.Longasssuperconductornameforuvwire.mChemicalFormula = "Nq*\u2084(Ir\u2083Os)\u2083EuSm";
        Materials.Longasssuperconductornameforuhvwire.mChemicalFormula = "D\u2086(SpNt)\u2087Tn\u2085Am\u2086";
        Materials.SuperconductorUEVBase.mChemicalFormula = "D*\u2085If*\u2085(\u2726\u25c6\u2726)(\u26b7\u2699\u26b7Ni4Ti6)";
        Materials.SuperconductorUIVBase.mChemicalFormula = "(C\u2081\u2084Os\u2081\u2081O\u2087Ag\u2083SpH\u2082O)\u2084?\u2081\ue01a(Fs\u26b6)\u2086(\u2318\u262f\u262f\u2318)\u2085";
        Materials.SuperconductorUMVBase.mChemicalFormula = "?\u2086Or\u2083(Hy\u26b6)\u2081\u2081(((CW)\u2087Ti\u2083)\u2083\ue002\ue001\ue004)\u2085\u06de\u2082";
        Materials.Diatomite.mChemicalFormula = "(SiO\u2082)\u2088Fe\u2082O\u2083(Al\u2082O\u2083)";
        Materials.EnrichedHolmium.mChemicalFormula = "Nq+\u2084Ho\u2081";
        Materials.Grade1PurifiedWater.mChemicalFormula = "H\u2082O";
        Materials.Grade2PurifiedWater.mChemicalFormula = "H\u2082O";
        Materials.Grade3PurifiedWater.mChemicalFormula = "H\u2082O";
        Materials.Grade4PurifiedWater.mChemicalFormula = "H\u2082O";
        Materials.Grade5PurifiedWater.mChemicalFormula = "H\u2082O";
        Materials.Grade6PurifiedWater.mChemicalFormula = "H\u2082O";
        Materials.Grade7PurifiedWater.mChemicalFormula = "H\u2082O";
        Materials.Grade8PurifiedWater.mChemicalFormula = "H\u2082O";
        Materials.FlocculationWasteLiquid.mChemicalFormula = "Al\u2082(OH)\u2083??Cl\u2083";
        Materials.TengamRaw.mChemicalFormula = "M\ue020";
        Materials.TengamPurified.mChemicalFormula = "M";
        Materials.TengamAttuned.mChemicalFormula = "\ue00aM\ue00e";
        MaterialsUEVplus.ExcitedDTSC.mChemicalFormula = "[-Stellar-Stellar-]";
        MaterialsUEVplus.DimensionallyTranscendentStellarCatalyst.mChemicalFormula = "Stellar";
        MaterialsUEVplus.DimensionallyTranscendentResidue.mChemicalFormula = "\ue00d-\ue00f";
        Materials.PolyAluminiumChloride.mChemicalFormula = "Al\u2082(OH)\u2083Cl\u2083";
        MaterialsUEVplus.QuarkGluonPlasma.mChemicalFormula = EnumChatFormatting.OBFUSCATED + "X" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + "g" + EnumChatFormatting.OBFUSCATED + "X";
        MaterialsUEVplus.PhononCrystalSolution.mChemicalFormula = "\u3004";
        MaterialsUEVplus.PhononMedium.mChemicalFormula = "((Si\u2085O\u2081\ue01aFe)\u2083(Bi\u2082Te\u2083)\u2084ZrO\u2082Fe\u2085\ue01aC)\u2085Og*Pr\u2081\u2085((C\u2081\u2084Os\u2081\u2081O\u2087Ag\u2083SpH\u2082O)\u2084?\u2081\ue01a(Fs\u26b6)\u2086(\u2318\u262f\u262f\u2318)\u2085)\u2086\u3004\u2084";
        MaterialsUEVplus.SixPhasedCopper.mChemicalFormula = "\u2722";
        MaterialsUEVplus.Mellion.mChemicalFormula = "Tn\u2081\u2081Or\u2088Rb\u2081\u2081(" + Materials.FierySteel.mChemicalFormula + ")\u2087" + Materials.Firestone.mChemicalFormula + "\u2081\u2083?\u2081\u2083";
        MaterialsUEVplus.Creon.mChemicalFormula = "\u2e0e";
        Materials.Tartarite.mChemicalFormula = "Tt";
        MaterialsUEVplus.TranscendentMetal.mChemicalFormula = "Ts\u0416";
        MaterialsUEVplus.HotProtoHalkonite.mChemicalFormula = MaterialsUEVplus.MoltenProtoHalkoniteBase.mChemicalFormula = "(" + MaterialsUEVplus.TranscendentMetal.mChemicalFormula + ")\u2082(W\u2088Nq*\u2087(" + Materials.Bedrockium.mChemicalFormula + ")\u2084C\u2084V\u2083SpPu)\u2082" + Materials.Tartarite.mChemicalFormula + "\u2082((CW)\u2087Ti\u2083)\u2083" + "\ue002" + "\ue001" + "\ue004" + "If*";
        MaterialsUEVplus.ProtoHalkonite.mChemicalFormula = MaterialsUEVplus.MoltenProtoHalkoniteBase.mChemicalFormula;
        Materials.HellishMetal.mChemicalFormula = "RhMa";
        Materials.Netherite.mChemicalFormula = "NrAuMa*";
    }

    private static void initSubTags() {
        SubTag.ELECTROMAGNETIC_SEPERATION_NEODYMIUM.addTo(Bastnasite, Monazite, Forcicium, Forcillium);
        SubTag.ELECTROMAGNETIC_SEPERATION_GOLD.addTo(Magnetite, VanadiumMagnetite, BasalticMineralSand, GraniticMineralSand);
        SubTag.NO_RECIPES.addTo(MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter);
        SubTag.NO_RECYCLING_RECIPES.addTo(MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter);
        SubTag.NO_RECIPES.addTo(MaterialsUEVplus.HotProtoHalkonite);
        SubTag.NO_RECYCLING_RECIPES.addTo(MaterialsUEVplus.HotProtoHalkonite);
        SubTag.NO_RECIPES.addTo(MaterialsUEVplus.ProtoHalkonite);
        SubTag.NO_RECYCLING_RECIPES.addTo(MaterialsUEVplus.ProtoHalkonite);
        MaterialsUEVplus.HotProtoHalkonite.remove(SubTag.SMELTING_TO_FLUID);
        MaterialsUEVplus.ProtoHalkonite.remove(SubTag.SMELTING_TO_FLUID);
        SubTag.NO_RECIPES.addTo(MaterialsUEVplus.HotExoHalkonite);
        SubTag.NO_RECIPES.addTo(MaterialsUEVplus.ExoHalkonite);
        SubTag.NO_RECYCLING_RECIPES.addTo(MaterialsUEVplus.HotExoHalkonite);
        SubTag.NO_RECYCLING_RECIPES.addTo(MaterialsUEVplus.ExoHalkonite);
        MaterialsUEVplus.HotExoHalkonite.remove(SubTag.SMELTING_TO_FLUID);
        MaterialsUEVplus.ExoHalkonite.remove(SubTag.SMELTING_TO_FLUID);
        SubTag.NO_RECIPES.addTo(Netherite);
        Netherite.remove(SubTag.SMELTING_TO_FLUID);
        SubTag.ELECTROMAGNETIC_SEPERATION_IRON.addTo(YellowLimonite, BrownLimonite, Pyrite, BandedIron, Nickel, Vermiculite, Glauconite, GlauconiteSand, Pentlandite, Tin, Antimony, Ilmenite, Manganese, Chrome, Chromite, Andradite);
        SubTag.BLASTFURNACE_CALCITE_DOUBLE.addTo(Pyrite, BrownLimonite, YellowLimonite, BasalticMineralSand, GraniticMineralSand, Magnetite);
        SubTag.BLASTFURNACE_CALCITE_TRIPLE.addTo(Iron, PigIron, DeepIron, ShadowIron, WroughtIron, MeteoricIron);
        SubTag.WASHING_MERCURY.addTo(Gold, Osmium, Mithril, Platinum, Cooperite, AstralSilver);
        SubTag.WASHING_MERCURY_99_PERCENT.addTo(Silver);
        SubTag.WASHING_SODIUMPERSULFATE.addTo(Zinc, Nickel, Copper, Cobalt, Cobaltite, Tetrahedrite);
        SubTag.METAL.addTo(AnyIron, AnyCopper, AnyBronze, Metal, Aluminium, Americium, Antimony, Beryllium, Bismuth, Caesium, Cerium, Chrome, Cobalt, Copper, Dysprosium, Erbium, Europium, Gadolinium, Gallium, Gold, Holmium, Indium, Iridium, Iron, Lanthanum, Lead, Lutetium, Magnesium, Manganese, Mercury, Niobium, Molybdenum, Neodymium, Neutronium, Nickel, Osmium, Palladium, Platinum, Plutonium, Plutonium241, Praseodymium, Promethium, Rubidium, Samarium, Scandium, Silicon, Silver, Tantalum, Tellurium, Terbium, Thorium, Thulium, Tin, Titanium, Tungsten, Uranium, Uranium235, Vanadium, Ytterbium, Yttrium, Zinc, Flerovium, PhasedIron, PhasedGold, DarkSteel, TinAlloy, ConductiveIron, ElectricalSteel, EnergeticAlloy, VibrantAlloy, MelodicAlloy, StellarAlloy, VividAlloy, EnergeticSilver, CrystallinePinkSlime, CrystallineAlloy, CrudeSteel, EndSteel, PulsatingIron, DarkThaumium, Adamantium, Amordrine, Angmallen, Ardite, Aredrite, Atlarus, Carmot, Celenegil, Ceruclase, DarkIron, Desh, Desichalkos, Duranium, ElectrumFlux, Enderium, EnderiumBase, Eximite, FierySteel, Force, Haderoth, Hematite, Hepatizon, HSLA, Infuscolium, InfusedGold, Inolashite, Mercassium, MeteoricIron, BloodInfusedIron, MaterialsUEVplus.Universium, MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter, MeteoricSteel, Naquadah, NaquadahAlloy, NaquadahEnriched, Naquadria, ObsidianFlux, Orichalcum, Osmonium, Oureclase, Phoenixite, Prometheum, Sanguinite, CosmicNeutronium, Tartarite, Ichorium, Tritanium, Vulcanite, Vyroxeres, Yellorium, Zectium, AluminiumBrass, Osmiridium, Sunnarium, AnnealedCopper, BatteryAlloy, Brass, Bronze, ChromiumDioxide, Cupronickel, DeepIron, Electrum, Invar, Kanthal, Magnalium, Nichrome, NiobiumNitride, NiobiumTitanium, PigIron, SolderingAlloy, StainlessSteel, Steel, Ultimet, VanadiumGallium, WroughtIron, YttriumBariumCuprate, IronWood, Alumite, Manyullyn, ShadowIron, Shadow, ShadowSteel, Steeleaf, SterlingSilver, RoseGold, BlackBronze, BismuthBronze, BlackSteel, RedSteel, BlueSteel, DamascusSteel, TungstenSteel, TPV, AstralSilver, Mithril, BlueAlloy, RedAlloy, CobaltBrass, Thaumium, Void, IronMagnetic, SteelMagnetic, NeodymiumMagnetic, SamariumMagnetic, Knightmetal, HSSG, HSSE, HSSS, TungstenCarbide, HeeEndium, VanadiumSteel, Kalendrite, Ignatius, Trinium, Infinity, InfinityCatalyst, Realgar, Chrysotile, BlackPlutonium, Alduorite, Adluorite, Vinteum, Rubracium, Draconium, DraconiumAwakened, Pentacadmiummagnesiumhexaoxid, Titaniumonabariumdecacoppereikosaoxid, Uraniumtriplatinid, Vanadiumtriindinid, Tetraindiumditindibariumtitaniumheptacoppertetrakaidekaoxid, Tetranaquadahdiindiumhexaplatiumosminid, Longasssuperconductornameforuvwire, Longasssuperconductornameforuhvwire, SuperconductorUEVBase, SuperconductorUIVBase, SuperconductorUMVBase, Quantium, RedstoneAlloy, Bedrockium, EnrichedHolmium, TengamPurified, TengamAttuned, MaterialsUEVplus.Eternity, MaterialsUEVplus.MagMatter, MaterialsUEVplus.Creon, MaterialsUEVplus.Mellion, MaterialsUEVplus.HotProtoHalkonite, MaterialsUEVplus.ProtoHalkonite, MaterialsUEVplus.HotExoHalkonite, MaterialsUEVplus.ExoHalkonite);
        SubTag.MULTI_PLATE.addTo(Adamantium, Aluminium, Americium, BlackPlutonium, BlackSteel, Bronze, CallistoIce, Cobalt, Copper, CosmicNeutronium, CrystallinePinkSlime, Desh, Duralumin, Europium, Gold, HSSG, HSSS, Infinity, InfinityCatalyst, Iridium, Iron, Lead, Ledox, Magnesium, MaterialsKevlar.Kevlar, MelodicAlloy, MeteoricIron, Mithril, MysteriousCrystal, Mytryl, Naquadah, Naquadria, Neutronium, Nickel, Oriharukon, Osmiridium, Osmium, Paper, Platinum, Plutonium, Polybenzimidazole, Polycaprolactam, Polytetrafluoroethylene, Quantium, Shadow, SiliconSG, Silver, StainlessSteel, Steel, Sunnarium, Thaumium, Tin, Titanium, Trinium, Tungsten, TungstenSteel);
        SubTag.FOOD.addTo(MeatRaw, MeatCooked, Ice, Water, Salt, Chili, Cocoa, Cheese, Coffee, Chocolate, Milk, Honey, FryingOilHot, FishOil, SeedOil, SeedOilLin, SeedOilHemp, Wheat, Sugar, FreshWater);
        Wood.add(SubTag.WOOD, SubTag.FLAMMABLE, SubTag.NO_SMELTING, SubTag.NO_SMASHING);
        WoodSealed.add(SubTag.WOOD, SubTag.FLAMMABLE, SubTag.NO_SMELTING, SubTag.NO_SMASHING, SubTag.NO_WORKING);
        Peanutwood.add(SubTag.WOOD, SubTag.FLAMMABLE, SubTag.NO_SMELTING, SubTag.NO_SMASHING);
        LiveRoot.add(SubTag.WOOD, SubTag.FLAMMABLE, SubTag.NO_SMELTING, SubTag.NO_SMASHING, SubTag.MAGICAL, SubTag.MORTAR_GRINDABLE);
        IronWood.add(SubTag.WOOD, SubTag.FLAMMABLE, SubTag.MAGICAL, SubTag.MORTAR_GRINDABLE);
        Steeleaf.add(SubTag.WOOD, SubTag.FLAMMABLE, SubTag.MAGICAL, SubTag.MORTAR_GRINDABLE, SubTag.NO_SMELTING);
        MeatRaw.add(SubTag.NO_SMASHING);
        MeatCooked.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Snow.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.NO_RECYCLING);
        Ice.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.NO_RECYCLING);
        Water.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.NO_RECYCLING);
        Sulfur.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.FLAMMABLE);
        Saltpeter.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.FLAMMABLE);
        Graphite.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.FLAMMABLE, SubTag.NO_SMELTING);
        Wheat.add(SubTag.FLAMMABLE, SubTag.MORTAR_GRINDABLE);
        Paper.add(SubTag.FLAMMABLE, SubTag.NO_SMELTING, SubTag.NO_SMASHING, SubTag.MORTAR_GRINDABLE, SubTag.PAPER);
        Coal.add(SubTag.FLAMMABLE, SubTag.NO_SMELTING, SubTag.NO_SMASHING, SubTag.MORTAR_GRINDABLE);
        Charcoal.add(SubTag.FLAMMABLE, SubTag.NO_SMELTING, SubTag.NO_SMASHING, SubTag.MORTAR_GRINDABLE);
        Lignite.add(SubTag.FLAMMABLE, SubTag.NO_SMELTING, SubTag.NO_SMASHING, SubTag.MORTAR_GRINDABLE);
        Rubber.add(SubTag.FLAMMABLE, SubTag.NO_SMASHING, SubTag.BOUNCY, SubTag.STRETCHY);
        StyreneButadieneRubber.add(SubTag.FLAMMABLE, SubTag.NO_SMASHING, SubTag.BOUNCY, SubTag.STRETCHY);
        Plastic.add(SubTag.FLAMMABLE, SubTag.NO_SMASHING, SubTag.BOUNCY, SubTag.STRETCHY);
        PolyvinylChloride.add(SubTag.FLAMMABLE, SubTag.NO_SMASHING, SubTag.BOUNCY, SubTag.STRETCHY);
        Polystyrene.add(SubTag.FLAMMABLE, SubTag.NO_SMASHING, SubTag.BOUNCY, SubTag.STRETCHY);
        Silicone.add(SubTag.FLAMMABLE, SubTag.NO_SMASHING, SubTag.BOUNCY, SubTag.STRETCHY);
        Polytetrafluoroethylene.add(SubTag.FLAMMABLE, SubTag.NO_SMASHING, SubTag.STRETCHY);
        Polybenzimidazole.add(SubTag.FLAMMABLE, SubTag.NO_SMASHING, SubTag.STRETCHY);
        PolyphenyleneSulfide.add(SubTag.FLAMMABLE, SubTag.NO_SMASHING, SubTag.STRETCHY);
        MaterialsKevlar.Kevlar.add(SubTag.FLAMMABLE, SubTag.NO_SMASHING, SubTag.STRETCHY);
        TNT.add(SubTag.FLAMMABLE, SubTag.EXPLOSIVE, SubTag.NO_SMELTING, SubTag.NO_SMASHING);
        Gunpowder.add(SubTag.FLAMMABLE, SubTag.EXPLOSIVE, SubTag.NO_SMELTING, SubTag.NO_SMASHING);
        Glyceryl.add(SubTag.FLAMMABLE, SubTag.EXPLOSIVE, SubTag.NO_SMELTING, SubTag.NO_SMASHING);
        NitroCoalFuel.add(SubTag.FLAMMABLE, SubTag.EXPLOSIVE, SubTag.NO_SMELTING, SubTag.NO_SMASHING);
        NitroFuel.add(SubTag.FLAMMABLE, SubTag.EXPLOSIVE, SubTag.NO_SMELTING, SubTag.NO_SMASHING);
        NitroCarbon.add(SubTag.FLAMMABLE, SubTag.EXPLOSIVE, SubTag.NO_SMELTING, SubTag.NO_SMASHING);
        Lead.add(SubTag.MORTAR_GRINDABLE, SubTag.SOLDERING_MATERIAL, SubTag.SOLDERING_MATERIAL_BAD);
        Tin.add(SubTag.MORTAR_GRINDABLE, SubTag.SOLDERING_MATERIAL);
        SolderingAlloy.add(SubTag.MORTAR_GRINDABLE, SubTag.SOLDERING_MATERIAL, SubTag.SOLDERING_MATERIAL_GOOD);
        Cheese.add(SubTag.SMELTING_TO_FLUID);
        Sugar.add(SubTag.SMELTING_TO_FLUID);
        Concrete.add(SubTag.STONE, SubTag.NO_SMASHING, SubTag.SMELTING_TO_FLUID);
        ConstructionFoam.add(SubTag.STONE, SubTag.NO_SMASHING, SubTag.EXPLOSIVE, SubTag.NO_SMELTING);
        ReinforceGlass.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.SMELTING_TO_FLUID);
        BorosilicateGlass.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_RECYCLING, SubTag.SMELTING_TO_FLUID);
        Redstone.add(SubTag.STONE, SubTag.NO_SMASHING, SubTag.UNBURNABLE, SubTag.SMELTING_TO_FLUID, SubTag.PULVERIZING_CINNABAR);
        Glowstone.add(SubTag.STONE, SubTag.NO_SMASHING, SubTag.UNBURNABLE, SubTag.SMELTING_TO_FLUID);
        Electrotine.add(SubTag.STONE, SubTag.NO_SMASHING, SubTag.UNBURNABLE, SubTag.SMELTING_TO_FLUID);
        Teslatite.add(SubTag.STONE, SubTag.NO_SMASHING, SubTag.UNBURNABLE, SubTag.SMELTING_TO_FLUID);
        Netherrack.add(SubTag.STONE, SubTag.NO_SMASHING, SubTag.UNBURNABLE, SubTag.FLAMMABLE);
        Stone.add(SubTag.STONE, SubTag.NO_SMASHING, SubTag.NO_RECYCLING);
        Brick.add(SubTag.STONE, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        NetherBrick.add(SubTag.STONE, SubTag.NO_SMASHING);
        Endstone.add(SubTag.STONE, SubTag.NO_SMASHING);
        Marble.add(SubTag.STONE, SubTag.NO_SMASHING);
        Basalt.add(SubTag.STONE, SubTag.NO_SMASHING);
        Redrock.add(SubTag.STONE, SubTag.NO_SMASHING);
        Obsidian.add(SubTag.STONE, SubTag.NO_SMASHING);
        Flint.add(SubTag.STONE, SubTag.NO_SMASHING, SubTag.MORTAR_GRINDABLE);
        GraniteRed.add(SubTag.STONE, SubTag.NO_SMASHING, SubTag.SMELTING_TO_FLUID);
        GraniteBlack.add(SubTag.STONE, SubTag.NO_SMASHING, SubTag.SMELTING_TO_FLUID);
        Salt.add(SubTag.STONE, SubTag.NO_SMASHING);
        RockSalt.add(SubTag.STONE, SubTag.NO_SMASHING);
        Sand.add(SubTag.NO_RECYCLING);
        Gold.add(SubTag.MORTAR_GRINDABLE);
        Silver.add(SubTag.MORTAR_GRINDABLE);
        Iron.add(SubTag.MORTAR_GRINDABLE);
        IronMagnetic.add(SubTag.MORTAR_GRINDABLE);
        HSLA.add(SubTag.MORTAR_GRINDABLE);
        Steel.add(SubTag.MORTAR_GRINDABLE);
        SteelMagnetic.add(SubTag.MORTAR_GRINDABLE);
        Zinc.add(SubTag.MORTAR_GRINDABLE);
        Antimony.add(SubTag.MORTAR_GRINDABLE);
        Copper.add(SubTag.MORTAR_GRINDABLE);
        AnnealedCopper.add(SubTag.MORTAR_GRINDABLE);
        Bronze.add(SubTag.MORTAR_GRINDABLE);
        Nickel.add(SubTag.MORTAR_GRINDABLE);
        Invar.add(SubTag.MORTAR_GRINDABLE);
        Brass.add(SubTag.MORTAR_GRINDABLE);
        WroughtIron.add(SubTag.MORTAR_GRINDABLE);
        Electrum.add(SubTag.MORTAR_GRINDABLE);
        Clay.add(SubTag.MORTAR_GRINDABLE);
        Glass.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_RECYCLING, SubTag.SMELTING_TO_FLUID);
        Diamond.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.FLAMMABLE);
        Emerald.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Amethyst.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Tanzanite.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Topaz.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        BlueTopaz.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Amber.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        GreenSapphire.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Sapphire.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Ruby.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        FoolsRuby.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Opal.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Olivine.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Jasper.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        GarnetRed.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        GarnetYellow.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Mimichite.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        CrystalFlux.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Crystal.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Niter.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Apatite.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE);
        Lapis.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE);
        Sodalite.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE);
        Lazurite.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE);
        Monazite.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE);
        Quartzite.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE, SubTag.QUARTZ);
        Quartz.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE, SubTag.QUARTZ);
        SiliconDioxide.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE, SubTag.QUARTZ);
        Dilithium.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE, SubTag.QUARTZ);
        NetherQuartz.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE, SubTag.QUARTZ);
        CertusQuartz.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE, SubTag.QUARTZ);
        CertusQuartzCharged.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE, SubTag.QUARTZ);
        Fluix.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE, SubTag.QUARTZ);
        TricalciumPhosphate.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.FLAMMABLE, SubTag.EXPLOSIVE);
        Phosphate.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.FLAMMABLE, SubTag.EXPLOSIVE);
        InfusedAir.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.MAGICAL, SubTag.UNBURNABLE);
        InfusedFire.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.MAGICAL, SubTag.UNBURNABLE);
        InfusedEarth.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.MAGICAL, SubTag.UNBURNABLE);
        InfusedWater.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.MAGICAL, SubTag.UNBURNABLE);
        InfusedEntropy.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.MAGICAL, SubTag.UNBURNABLE);
        InfusedOrder.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.MAGICAL, SubTag.UNBURNABLE);
        InfusedVis.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.MAGICAL, SubTag.UNBURNABLE);
        InfusedDull.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.MAGICAL, SubTag.UNBURNABLE);
        NetherStar.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.MAGICAL, SubTag.UNBURNABLE);
        EnderPearl.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.MAGICAL, SubTag.PEARL);
        EnderEye.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.MAGICAL, SubTag.PEARL);
        Firestone.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE, SubTag.MAGICAL, SubTag.QUARTZ, SubTag.UNBURNABLE, SubTag.BURNING);
        Forcicium.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE, SubTag.MAGICAL);
        Forcillium.add(SubTag.CRYSTAL, SubTag.NO_SMASHING, SubTag.NO_SMELTING, SubTag.CRYSTALLISABLE, SubTag.MAGICAL);
        Force.add(SubTag.CRYSTAL, SubTag.MAGICAL, SubTag.UNBURNABLE);
        Magic.add(SubTag.CRYSTAL, SubTag.MAGICAL, SubTag.UNBURNABLE);
        Primitive.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Basic.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Good.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Advanced.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Data.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Elite.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Master.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Ultimate.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Superconductor.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Infinite.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Bio.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        SuperconductorMV.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        SuperconductorHV.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        SuperconductorEV.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        SuperconductorIV.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        SuperconductorLuV.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        SuperconductorZPM.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        SuperconductorUHV.add(SubTag.NO_SMASHING, SubTag.NO_SMELTING);
        Blaze.add(SubTag.MAGICAL, SubTag.SMELTING_TO_FLUID, SubTag.MORTAR_GRINDABLE, SubTag.UNBURNABLE, SubTag.BURNING);
        FierySteel.add(SubTag.MAGICAL, SubTag.UNBURNABLE, SubTag.BURNING);
        DarkThaumium.add(SubTag.MAGICAL);
        Thaumium.add(SubTag.MAGICAL);
        Void.add(SubTag.MAGICAL);
        Enderium.add(SubTag.MAGICAL);
        AstralSilver.add(SubTag.MAGICAL);
        Mithril.add(SubTag.MAGICAL);
        Carbon.add(SubTag.NO_SMELTING);
        Boron.add(SubTag.SMELTING_TO_FLUID);
        MaterialsUEVplus.TranscendentMetal.add(SubTag.BLACK_HOLE);
    }

    public static void init() {
        new ProcessingConfig();
        if (!GTMod.proxy.mEnableAllMaterials) {
            new ProcessingModSupport();
        }
        mMaterialHandlers.forEach(IMaterialHandler::onMaterialsInit);
        Materials.initMaterialProperties();
        MATERIALS_ARRAY = MATERIALS_MAP.values().toArray(new Materials[0]);
        VALUES = Arrays.asList(MATERIALS_ARRAY);
        Materials.disableUnusedHotIngots();
        Materials.fillGeneratedMaterialsMap();
    }

    private static void disableUnusedHotIngots() {
        OrePrefixes.ingotHot.mDisabledItems.addAll(((Stream)Arrays.stream(Materials.values()).parallel()).filter(OrePrefixes.ingotHot::doGenerateItem).filter(m -> m.mBlastFurnaceTemp < 1750 && m.mAutoGenerateBlastFurnaceRecipes).collect(Collectors.toSet()));
        OrePrefixes.ingotHot.disableComponent(Reinforced);
        OrePrefixes.ingotHot.disableComponent(ConductiveIron);
        OrePrefixes.ingotHot.disableComponent(FierySteel);
        OrePrefixes.ingotHot.disableComponent(ElectricalSteel);
        OrePrefixes.ingotHot.disableComponent(EndSteel);
        OrePrefixes.ingotHot.disableComponent(Soularium);
        OrePrefixes.ingotHot.disableComponent(EnergeticSilver);
        OrePrefixes.ingotHot.disableComponent(Cheese);
        OrePrefixes.ingotHot.disableComponent(Calcium);
        OrePrefixes.ingotHot.disableComponent(Flerovium);
        OrePrefixes.ingotHot.disableComponent(Cobalt);
        OrePrefixes.ingotHot.disableComponent(RedstoneAlloy);
        OrePrefixes.ingotHot.disableComponent(Ardite);
        OrePrefixes.ingotHot.disableComponent(DarkSteel);
        OrePrefixes.ingotHot.disableComponent(BlackSteel);
        OrePrefixes.ingotHot.disableComponent(EnergeticAlloy);
        OrePrefixes.ingotHot.disableComponent(PulsatingIron);
        OrePrefixes.ingotHot.disableComponent(CrudeSteel);
        OrePrefixes.ingotHot.disableComponent(MaterialsUEVplus.HotProtoHalkonite);
        OrePrefixes.ingotHot.disableComponent(MaterialsUEVplus.ProtoHalkonite);
        OrePrefixes.ingotHot.disableComponent(MaterialsUEVplus.HotExoHalkonite);
        OrePrefixes.ingotHot.disableComponent(MaterialsUEVplus.ExoHalkonite);
    }

    public static void initClient() {
        MaterialsUEVplus.TranscendentMetal.renderer = new TranscendentMetalRenderer();
        MaterialsBotania.GaiaSpirit.renderer = new GaiaSpiritRenderer();
        Materials.Infinity.renderer = new InfinityRenderer();
        Materials.CosmicNeutronium.renderer = new CosmicNeutroniumRenderer();
        MaterialsUEVplus.Universium.renderer = new UniversiumRenderer();
        MaterialsUEVplus.Eternity.renderer = new InfinityRenderer();
        MaterialsUEVplus.MagMatter.renderer = new InfinityRenderer();
        MaterialsUEVplus.SixPhasedCopper.renderer = new GlitchEffectRenderer();
        MaterialsUEVplus.GravitonShard.renderer = new InfinityRenderer();
        MaterialsUEVplus.ExoHalkonite.renderer = new InfinityRenderer();
        MaterialsUEVplus.HotExoHalkonite.renderer = new InfinityRenderer();
        Materials.PrismaticNaquadah.renderer = new RainbowOverlayRenderer(PrismaticNaquadah.getRGBA());
    }

    private static void fillGeneratedMaterialsMap() {
        for (Materials aMaterial : MATERIALS_ARRAY) {
            if (aMaterial.mMetaItemSubID < 0) continue;
            if (aMaterial.mMetaItemSubID < 1000) {
                if (!aMaterial.mHasParentMod) continue;
                if (GregTechAPI.sGeneratedMaterials[aMaterial.mMetaItemSubID] == null) {
                    GregTechAPI.sGeneratedMaterials[aMaterial.mMetaItemSubID] = aMaterial;
                    continue;
                }
                throw new IllegalArgumentException("The Material Index " + aMaterial.mMetaItemSubID + " for " + aMaterial.mName + " is already used!");
            }
            throw new IllegalArgumentException("The Material Index " + aMaterial.mMetaItemSubID + " for " + aMaterial.mName + " is/over the maximum of 1000");
        }
    }

    private static void addToolValues(Materials aMaterial) {
        Materials materials = aMaterial == Desh ? aMaterial.mHandleMaterial : (aMaterial == Diamond || aMaterial == Thaumium ? Wood : (aMaterial.contains(SubTag.BURNING) ? Blaze : (aMaterial.contains(SubTag.MAGICAL) && aMaterial.contains(SubTag.CRYSTAL) && Mods.Thaumcraft.isModLoaded() ? Thaumium : (aMaterial.getMass() > Element.Tc.getMass() * 2L ? TungstenSteel : (aMaterial.mHandleMaterial = aMaterial.getMass() > Element.Tc.getMass() ? Steel : Wood)))));
        if (aMaterial == MaterialsUEVplus.SpaceTime) {
            aMaterial.mHandleMaterial = Infinity;
        }
        if (aMaterial == MaterialsUEVplus.TranscendentMetal) {
            aMaterial.mHandleMaterial = DraconiumAwakened;
        }
        if (aMaterial == MaterialsUEVplus.Eternity) {
            aMaterial.mHandleMaterial = MaterialsUEVplus.SpaceTime;
        }
        if (aMaterial == MaterialsUEVplus.MagMatter) {
            aMaterial.mHandleMaterial = MaterialsUEVplus.MagnetohydrodynamicallyConstrainedStarMatter;
        }
    }

    private static void addEnchantmentValues(Materials aMaterial) {
        String aEnchantmentName;
        String string = aEnchantmentName = aMaterial.mEnchantmentTools != null ? aMaterial.mEnchantmentTools.func_77320_a() : "";
        if (aMaterial.mEnchantmentTools != null && !aEnchantmentName.equals(aMaterial.mEnchantmentTools.func_77320_a())) {
            IntStream.range(0, Enchantment.field_77331_b.length).filter(i -> aEnchantmentName.equals(Enchantment.field_77331_b[i].func_77320_a())).forEach(i -> {
                aMaterial.mEnchantmentTools = Enchantment.field_77331_b[i];
            });
        }
    }

    private static void addHasGasFluid(Materials aMaterial) {
        if (aMaterial.mIconSet.is_custom) {
            return;
        }
        if (aMaterial.mHasGas) {
            GTFluidFactory.of(aMaterial.mName.toLowerCase(), aMaterial.mDefaultLocalName, aMaterial, FluidState.GAS, aMaterial.mGasTemp);
        }
    }

    private static String getConfigPath(Materials aMaterial) {
        String cOre = aMaterial.mCustomOre ? aMaterial.mCustomID : aMaterial.mName;
        return "materials." + aMaterial.mConfigSection + "." + cOre;
    }

    private static void addHarvestLevelNerfs(Materials aMaterial) {
        if (GTMod.proxy.mChangeHarvestLevels && aMaterial.mToolQuality > 0 && aMaterial.mMetaItemSubID < GTMod.proxy.mHarvestLevel.length && aMaterial.mMetaItemSubID >= 0) {
            GTMod.proxy.mHarvestLevel[aMaterial.mMetaItemSubID] = aMaterial.mToolQuality;
        }
    }

    private static void addHarvestLevels() {
        GTMod.proxy.mChangeHarvestLevels = Gregtech.harvestLevel.activateHarvestLevelChange;
        GTMod.proxy.mMaxHarvestLevel = Math.min(15, Gregtech.harvestLevel.maxHarvestLevel);
        GTMod.proxy.mGraniteHavestLevel = Gregtech.harvestLevel.graniteHarvestLevel;
    }

    public static void initMaterialProperties() {
        Materials.addHarvestLevels();
        for (Materials aMaterial : MATERIALS_MAP.values()) {
            if (aMaterial == null || aMaterial == _NULL || aMaterial == Empty) continue;
            Materials.addToolValues(aMaterial);
            Materials.addEnchantmentValues(aMaterial);
            Materials.addHasGasFluid(aMaterial);
            Materials.addHarvestLevelNerfs(aMaterial);
        }
    }

    @Deprecated
    public static Materials valueOf(String aMaterialName) {
        return Materials.getMaterialsMap().get(aMaterialName);
    }

    public static Materials[] values() {
        return MATERIALS_ARRAY;
    }

    public static Map<String, Materials> getMaterialsMap() {
        return MATERIALS_MAP;
    }

    @Nonnull
    public static Materials get(String aMaterialName) {
        return Materials.getWithFallback(aMaterialName, _NULL);
    }

    @Nonnull
    public static Materials getWithFallback(String name, @Nonnull Materials fallback) {
        Materials material = Materials.getMaterialsMap().get(name);
        if (material != null) {
            return material;
        }
        return fallback;
    }

    public static Materials getRealMaterial(String aMaterialName) {
        return Materials.get((String)aMaterialName).mMaterialInto;
    }

    public static boolean add(IMaterialHandler aRegistrator) {
        if (aRegistrator == null) {
            return false;
        }
        return mMaterialHandlers.add(aRegistrator);
    }

    public static String getLocalizedNameForItem(String aFormat, int aMaterialID) {
        Materials aMaterial;
        if (aMaterialID >= 0 && aMaterialID < 1000 && (aMaterial = GregTechAPI.sGeneratedMaterials[aMaterialID]) != null) {
            return aMaterial.getLocalizedNameForItem(aFormat);
        }
        return aFormat;
    }

    public static Collection<Materials> getAll() {
        return MATERIALS_MAP.values();
    }

    public Materials disableAutoGeneratedBlastFurnaceRecipes() {
        this.mAutoGenerateBlastFurnaceRecipes = false;
        return this;
    }

    public Materials disableAutoGeneratedVacuumFreezerRecipe() {
        this.mAutoGenerateVacuumFreezerRecipes = false;
        return this;
    }

    public Materials setTurbineMultipliers(float steamMultiplier, float gasMultiplier, float plasmaMultiplier) {
        this.mSteamMultiplier = steamMultiplier;
        this.mGasMultiplier = gasMultiplier;
        this.mPlasmaMultiplier = plasmaMultiplier;
        return this;
    }

    public Materials disableAutoGeneratedRecycleRecipes() {
        this.mAutoGenerateRecycleRecipes = false;
        return this;
    }

    @Deprecated
    public String name() {
        return this.mName;
    }

    public boolean isRadioactive() {
        if (this.mElement != null) {
            return this.mElement.mHalfLifeSeconds >= 0L;
        }
        return this.mMaterialList.stream().map(stack -> stack.mMaterial).anyMatch(Materials::isRadioactive);
    }

    public long getProtons() {
        if (this.mElement != null) {
            return this.mElement.getProtons();
        }
        if (this.mMaterialList.isEmpty()) {
            return Element.Tc.getProtons();
        }
        long rAmount = 0L;
        long tAmount = 0L;
        for (MaterialStack tMaterial : this.mMaterialList) {
            tAmount += tMaterial.mAmount;
            rAmount += tMaterial.mAmount * tMaterial.mMaterial.getProtons();
        }
        return this.getDensity() * rAmount / (tAmount * 3628800L);
    }

    public long getNeutrons() {
        if (this.mElement != null) {
            return this.mElement.getNeutrons();
        }
        if (this.mMaterialList.isEmpty()) {
            return Element.Tc.getNeutrons();
        }
        long rAmount = 0L;
        long tAmount = 0L;
        for (MaterialStack tMaterial : this.mMaterialList) {
            tAmount += tMaterial.mAmount;
            rAmount += tMaterial.mAmount * tMaterial.mMaterial.getNeutrons();
        }
        return this.getDensity() * rAmount / (tAmount * 3628800L);
    }

    public long getMass() {
        if (this.mElement != null) {
            return this.mElement.getMass();
        }
        if (this.mMaterialList.isEmpty()) {
            return Element.Tc.getMass();
        }
        long rAmount = 0L;
        long tAmount = 0L;
        for (MaterialStack tMaterial : this.mMaterialList) {
            tAmount += tMaterial.mAmount;
            rAmount += tMaterial.mAmount * tMaterial.mMaterial.getMass();
        }
        return this.getDensity() * rAmount / (tAmount * 3628800L);
    }

    public long getDensity() {
        return this.mDensity;
    }

    public String getToolTip() {
        return this.getToolTip(1L, false);
    }

    public String getToolTip(boolean aShowQuestionMarks) {
        return this.getToolTip(1L, aShowQuestionMarks);
    }

    public String getToolTip(long aMultiplier) {
        return this.getToolTip(aMultiplier, false);
    }

    public String getToolTip(long aMultiplier, boolean aShowQuestionMarks) {
        if (!aShowQuestionMarks && this.mChemicalFormula.equals("?")) {
            return "";
        }
        if (aMultiplier >= 7257600L && !this.mMaterialList.isEmpty()) {
            return (this.mElement != null || this.mMaterialList.size() < 2 && this.mMaterialList.get((int)0).mAmount == 1L ? this.mChemicalFormula : "(" + this.mChemicalFormula + ")") + aMultiplier;
        }
        return this.mChemicalFormula;
    }

    public Materials add(ItemStack aStack) {
        if (aStack != null && !this.contains(aStack)) {
            this.mMaterialItems.add(aStack);
        }
        return this;
    }

    public boolean contains(ItemStack ... aStacks) {
        if (aStacks == null || aStacks.length == 0) {
            return false;
        }
        return this.mMaterialItems.stream().anyMatch(tStack -> Arrays.stream(aStacks).anyMatch(aStack -> GTUtility.areStacksEqual(aStack, tStack, !tStack.func_77942_o())));
    }

    public boolean remove(ItemStack aStack) {
        if (aStack == null) {
            return false;
        }
        boolean temp = false;
        int mMaterialItems_sS = this.mMaterialItems.size();
        for (int i = 0; i < mMaterialItems_sS; ++i) {
            if (!GTUtility.areStacksEqual(aStack, this.mMaterialItems.get(i))) continue;
            this.mMaterialItems.remove(i--);
            temp = true;
        }
        return temp;
    }

    @Override
    public ISubTagContainer add(SubTag ... aTags) {
        if (aTags != null) {
            for (SubTag aTag : aTags) {
                if (aTag == null || this.contains(aTag)) continue;
                aTag.addContainerToList(this);
                this.mSubTags.add(aTag);
            }
        }
        return this;
    }

    @Override
    public boolean contains(SubTag aTag) {
        return this.mSubTags.contains(aTag);
    }

    @Override
    public boolean remove(SubTag aTag) {
        return this.mSubTags.remove(aTag);
    }

    public Materials setHeatDamage(float aHeatDamage) {
        this.mHeatDamage = aHeatDamage;
        return this;
    }

    public Materials addOreByProduct(Materials aMaterial) {
        if (!this.mOreByProducts.contains(aMaterial.mMaterialInto)) {
            this.mOreByProducts.add(aMaterial.mMaterialInto);
        }
        return this;
    }

    public Materials addOreByProducts(Materials ... aMaterials) {
        for (Materials tMaterial : aMaterials) {
            if (tMaterial == null) continue;
            this.addOreByProduct(tMaterial);
        }
        return this;
    }

    public Materials setOreMultiplier(int aOreMultiplier) {
        if (aOreMultiplier > 0) {
            this.mOreMultiplier = aOreMultiplier;
        }
        return this;
    }

    public Materials setByProductMultiplier(int aByProductMultiplier) {
        if (aByProductMultiplier > 0) {
            this.mByProductMultiplier = aByProductMultiplier;
        }
        return this;
    }

    public Materials setSmeltingMultiplier(int aSmeltingMultiplier) {
        if (aSmeltingMultiplier > 0) {
            this.mSmeltingMultiplier = aSmeltingMultiplier;
        }
        return this;
    }

    public Materials setDirectSmelting(Materials aMaterial) {
        if (aMaterial != null) {
            this.mDirectSmelting = aMaterial.mMaterialInto.mDirectSmelting;
        }
        return this;
    }

    public Materials setOreReplacement(Materials aMaterial) {
        if (aMaterial != null) {
            this.mOreReplacement = aMaterial.mMaterialInto.mOreReplacement;
        }
        return this;
    }

    public Materials setSmeltingInto(Materials aMaterial) {
        if (aMaterial != null) {
            this.mSmeltInto = aMaterial.mMaterialInto.mSmeltInto;
        }
        return this;
    }

    public Materials setArcSmeltingInto(Materials aMaterial) {
        if (aMaterial != null) {
            this.mArcSmeltInto = aMaterial.mMaterialInto.mArcSmeltInto;
        }
        return this;
    }

    public Materials setMaceratingInto(Materials aMaterial) {
        if (aMaterial != null) {
            this.mMacerateInto = aMaterial.mMaterialInto.mMacerateInto;
        }
        return this;
    }

    public Materials setEnchantmentForTools(Enchantment aEnchantment, int aEnchantmentLevel) {
        this.mEnchantmentTools = aEnchantment;
        this.mEnchantmentToolsLevel = (byte)aEnchantmentLevel;
        return this;
    }

    public Materials setEnchantmentForArmors(Enchantment aEnchantment, int aEnchantmentLevel) {
        this.mEnchantmentArmors = aEnchantment;
        this.mEnchantmentArmorsLevel = (byte)aEnchantmentLevel;
        return this;
    }

    public FluidStack getSolid(long aAmount) {
        if (this.mSolid == null) {
            return null;
        }
        return new FluidStack(this.mSolid, (int)aAmount);
    }

    public FluidStack getFluid(long aAmount) {
        if (this.mFluid == null) {
            return null;
        }
        return new FluidStack(this.mFluid, (int)aAmount);
    }

    public FluidStack getGas(long aAmount) {
        if (this.mGas == null) {
            return null;
        }
        return new FluidStack(this.mGas, (int)aAmount);
    }

    public FluidStack getPlasma(long aAmount) {
        if (this.mPlasma == null) {
            return null;
        }
        return new FluidStack(this.mPlasma, (int)aAmount);
    }

    public FluidStack getMolten(long aAmount) {
        if (this.mStandardMoltenFluid == null) {
            return null;
        }
        return new FluidStack(this.mStandardMoltenFluid, (int)aAmount);
    }

    @Override
    public short[] getRGBA() {
        return this.mRGBa;
    }

    public String toString() {
        return this.mName;
    }

    public String getDefaultLocalizedNameForItem(String aFormat) {
        return GTUtility.formatStringSafe(aFormat.replace("%s", "%temp").replace("%material", "%s"), this.mDefaultLocalName).replace("%temp", "%s");
    }

    public String getLocalizedNameForItem(String aFormat) {
        return GTUtility.formatStringSafe(aFormat.replace("%s", "%temp").replace("%material", "%s"), this.mLocalizedName).replace("%temp", "%s");
    }

    public boolean hasCorrespondingFluid() {
        return this.hasCorrespondingFluid;
    }

    public Materials setHasCorrespondingFluid(boolean hasCorrespondingFluid) {
        this.hasCorrespondingFluid = hasCorrespondingFluid;
        return this;
    }

    public boolean hasCorrespondingGas() {
        return this.hasCorrespondingGas;
    }

    public Materials setHasCorrespondingGas(boolean hasCorrespondingGas) {
        this.hasCorrespondingGas = hasCorrespondingGas;
        return this;
    }

    public Materials setHasCorrespondingPlasma(boolean hasCorrespondingPlasma) {
        this.mHasPlasma = hasCorrespondingPlasma;
        return this;
    }

    public boolean canBeCracked() {
        return this.canBeCracked;
    }

    public Materials setCanBeCracked(boolean canBeCracked) {
        this.canBeCracked = canBeCracked;
        return this;
    }

    public int getLiquidTemperature() {
        return this.mMeltingPoint == 0 ? 295 : this.mMeltingPoint;
    }

    public Materials setLiquidTemperature(int liquidTemperature) {
        this.mMeltingPoint = liquidTemperature;
        return this;
    }

    public int getGasTemperature() {
        return this.mGasTemp == 0 ? 295 : this.mMeltingPoint;
    }

    public Materials setGasTemperature(int gasTemperature) {
        this.mGasTemp = gasTemperature;
        return this;
    }

    public Materials setHydroCrackedFluids(Fluid[] hydroCrackedFluids) {
        this.hydroCrackedFluids = hydroCrackedFluids;
        return this;
    }

    public FluidStack getLightlyHydroCracked(int amount) {
        if (this.hydroCrackedFluids[0] == null) {
            return null;
        }
        return new FluidStack(this.hydroCrackedFluids[0], amount);
    }

    public FluidStack getModeratelyHydroCracked(int amount) {
        if (this.hydroCrackedFluids[0] == null) {
            return null;
        }
        return new FluidStack(this.hydroCrackedFluids[1], amount);
    }

    public FluidStack getSeverelyHydroCracked(int amount) {
        if (this.hydroCrackedFluids[0] == null) {
            return null;
        }
        return new FluidStack(this.hydroCrackedFluids[2], amount);
    }

    public Materials setSteamCrackedFluids(Fluid[] steamCrackedFluids) {
        this.steamCrackedFluids = steamCrackedFluids;
        return this;
    }

    public FluidStack getLightlySteamCracked(int amount) {
        if (this.hydroCrackedFluids[0] == null) {
            return null;
        }
        return new FluidStack(this.steamCrackedFluids[0], amount);
    }

    public FluidStack getModeratelySteamCracked(int amount) {
        if (this.hydroCrackedFluids[0] == null) {
            return null;
        }
        return new FluidStack(this.steamCrackedFluids[1], amount);
    }

    public FluidStack getSeverelySteamCracked(int amount) {
        if (this.hydroCrackedFluids[0] == null) {
            return null;
        }
        return new FluidStack(this.steamCrackedFluids[2], amount);
    }

    public boolean isProperSolderingFluid() {
        return this.mStandardMoltenFluid != null && this.contains(SubTag.SOLDERING_MATERIAL) && (!GregTechAPI.mUseOnlyGoodSolderingMaterials || this.contains(SubTag.SOLDERING_MATERIAL_GOOD));
    }

    public ItemStack getCells(int amount) {
        return GTOreDictUnificator.get(OrePrefixes.cell, this, (long)amount);
    }

    public ItemStack getDust(int amount) {
        return GTOreDictUnificator.get(OrePrefixes.dust, this, (long)amount);
    }

    public ItemStack getDustSmall(int amount) {
        return GTOreDictUnificator.get(OrePrefixes.dustSmall, this, (long)amount);
    }

    public ItemStack getDustTiny(int amount) {
        return GTOreDictUnificator.get(OrePrefixes.dustTiny, this, (long)amount);
    }

    public ItemStack getGems(int amount) {
        return GTOreDictUnificator.get(OrePrefixes.gem, this, (long)amount);
    }

    public ItemStack getIngots(int amount) {
        return GTOreDictUnificator.get(OrePrefixes.ingot, this, (long)amount);
    }

    public ItemStack getNuggets(int amount) {
        return GTOreDictUnificator.get(OrePrefixes.nugget, this, (long)amount);
    }

    public ItemStack getBlocks(int amount) {
        return GTOreDictUnificator.get(OrePrefixes.block, this, (long)amount);
    }

    public ItemStack getPlates(int amount) {
        return GTOreDictUnificator.get(OrePrefixes.plate, this, (long)amount);
    }

    public static Materials getGtMaterialFromFluid(Fluid fluid) {
        return FLUID_MAP.get(fluid);
    }

    public ItemStack getNanite(int amount) {
        return GTOreDictUnificator.get(OrePrefixes.nanite, this, (long)amount);
    }

    static {
        Ultimate = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Ultimate", "Ultimate", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.MACHINA, 8L)));
        Advanced = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Advanced", "Advanced", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.MACHINA, 4L)));
        ULV = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Primitive", "Primitive", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.MACHINA, 1L)));
        LV = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Basic", "Basic", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.MACHINA, 2L)));
        MV = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Good", "Good", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.MACHINA, 3L)));
        HV = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Advanced", "Advanced", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.MACHINA, 4L)));
        EV = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Data", "Data", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.MACHINA, 5L)));
        IV = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Elite", "Elite", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.MACHINA, 6L)));
        LuV = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Master", "Master", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.MACHINA, 7L)));
        ZPM = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Ultimate", "Ultimate", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.MACHINA, 8L)));
        UV = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Superconductor", "Superconductor", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.MACHINA, 9L)));
        UHV = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Infinite", "Infinite", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 10L)));
        UEV = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Bio", "Bio", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 11L)));
        UIV = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Optical", "Optical", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 12L)));
        UMV = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Exotic", "Exotic", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 13L)));
        UXV = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Cosmic", "Cosmic", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 14L)));
        MAX = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Transcendent", "Transcendent", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 15L)));
        Resistor = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Resistor", "Resistor", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 1L)));
        Diode = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Diode", "Diode", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 1L)));
        Transistor = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Transistor", "Transistor", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 1L)));
        Capacitor = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Capacitor", "Capacitor", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 1L)));
        Inductor = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Inductor", "Inductor", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 1L)));
        Nano = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Nano", "Bio", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 11L)));
        Piko = new Materials(-1, TextureSet.SET_NONE, 1.0f, 0, 0, 0, 255, 255, 255, 0, "Piko", "Bio", 0, 0, -1, 0, false, false, 1, 1, 1, Dyes.dyeLightGray, Collections.singletonList(new TCAspects.TC_AspectStack(TCAspects.ELECTRUM, 12L)));
        Primitive = ULV;
        Basic = LV;
        Good = MV;
        Data = EV;
        Elite = IV;
        Master = LuV;
        Infinite = UHV;
        Bio = UEV;
        Optical = UIV;
        Exotic = UMV;
        Cosmic = UXV;
        Transcendent = MAX;
        DenseSteam = Materials.makeDenseSteam();
        DenseSuperheatedSteam = Materials.makeDenseSuperheatedSteam();
        DenseSupercriticalSteam = Materials.makeDenseSupercriticalSteam();
        MaterialsInit1.load();
        MaterialsBotania.init();
        MaterialsKevlar.init();
        MaterialsOreAlum.init();
        MaterialsUEVplus.init();
        Superconductor = new Materials(SuperconductorUHV, true);
        MATERIALS_ARRAY = new Materials[0];
        Materials.initSubTags();
        Materials.setReRegistration();
        Materials.setMaceratingInto();
        Materials.setSmeltingInto();
        Materials.setDirectSmelting();
        Materials.setOthers();
        Materials.setMultipliers();
        Materials.setEnchantments();
        Materials.setHeatDamage();
        Materials.setByProducts();
        Materials.setColors();
        Materials.overrideChemicalFormulas();
    }
}

