/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import blockrenderer6343.client.world.DummyWorld;
import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.ISBRWorldContext;
import gregtech.common.render.SBRContextBase;
import java.util.function.IntPredicate;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SBRWorldContext
extends SBRContextBase
implements ISBRWorldContext {
    private static final float NO_Z_FIGHT_OFFSET = 9.765625E-4f;
    private static final double FLUSH_MIN = 0.001;
    private static final double FLUSH_MAX = 0.999;
    private final int[][][] MBFB = new int[3][3][3];
    private final float[][][] AOLV = new float[3][3][3];
    private int worldRenderPass;
    @NotNull
    private IBlockAccess blockAccess = GTValues.DW;
    private int brightness;
    private float aoTopLeft;
    private float aoBottomLeft;
    private float aoBottomRight;
    private float aoTopRight;

    private static float getMixedAo(float ao1, float ao2, double ratio) {
        float diff = (float)((double)Math.abs(ao1 - ao2) * (1.0 - ratio));
        return ao1 > ao2 ? ao1 - diff : ao1 + diff;
    }

    public SBRWorldContext setup(int x, int y, int z, Block block, int modelId, RenderBlocks renderBlocks) {
        super.setup(block, modelId, renderBlocks);
        this.blockAccess = renderBlocks.field_147845_a;
        this.worldRenderPass = ForgeHooksClient.getWorldRenderPass();
        this.x = x;
        this.y = y;
        this.z = z;
        this.renderBlocks.field_147844_c = false;
        this.populatesLightingCaches();
        this.reset();
        return this;
    }

    @Override
    @NotNull
    public IBlockAccess getBlockAccess() {
        return this.blockAccess;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity() {
        return this.blockAccess.func_147438_o(this.x, this.y, this.z);
    }

    private void populatesLightingCaches() {
        boolean aoDisabled;
        Block blk = this.block;
        IBlockAccess acc = this.blockAccess;
        int x = this.x;
        int y = this.y;
        int z = this.z;
        int[][][] MBFB = this.MBFB;
        boolean bl = aoDisabled = Minecraft.func_71410_x().field_71474_y.field_74348_k == 0;
        if (aoDisabled) {
            MBFB[1][1][1] = blk.func_149677_c(acc, x, y, z);
            MBFB[0][1][1] = blk.func_149677_c(acc, x - 1, y, z);
            MBFB[2][1][1] = blk.func_149677_c(acc, x + 1, y, z);
            MBFB[1][0][1] = blk.func_149677_c(acc, x, y - 1, z);
            MBFB[1][2][1] = blk.func_149677_c(acc, x, y + 1, z);
            MBFB[1][1][0] = blk.func_149677_c(acc, x, y, z - 1);
            MBFB[1][1][2] = blk.func_149677_c(acc, x, y, z + 1);
        } else {
            float[][][] AOLV = this.AOLV;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        MBFB[dx + 1][dy + 1][dz + 1] = blk.func_149677_c(acc, x + dx, y + dy, z + dz);
                        AOLV[dx + 1][dy + 1][dz + 1] = acc.func_147439_a(x + dx, y + dy, z + dz).func_149685_I();
                    }
                }
            }
        }
    }

    @Override
    public ISBRWorldContext reset() {
        this.hasBrightnessOverride = false;
        this.hasColorOverride = false;
        this.hasLightnessOverride = false;
        this.renderBlocks.field_147863_w = Minecraft.func_71379_u() && GTMod.proxy.mRenderTileAmbientOcclusion;
        return this;
    }

    @Override
    public void renderNegativeYFacing(ITexture[] tex) {
        RenderBlocks renderBlocks = this.renderBlocks;
        if (!(renderBlocks.field_147849_o || renderBlocks.field_147837_f || this.block.func_149646_a(this.blockAccess, this.x, this.y - 1, this.z, 0))) {
            return;
        }
        this.setupLightingYNeg();
        super.renderNegativeYFacing(tex);
    }

    @Override
    public void renderPositiveYFacing(ITexture[] tex) {
        RenderBlocks renderBlocks = this.renderBlocks;
        if (!(renderBlocks.field_147849_o || renderBlocks.field_147837_f || this.block.func_149646_a(this.blockAccess, this.x, this.y + 1, this.z, 1))) {
            return;
        }
        this.setupLightingYPos();
        super.renderPositiveYFacing(tex);
    }

    @Override
    public void renderNegativeZFacing(ITexture[] tex) {
        RenderBlocks renderBlocks = this.renderBlocks;
        if (!(renderBlocks.field_147849_o || renderBlocks.field_147837_f || this.block.func_149646_a(this.blockAccess, this.x, this.y, this.z - 1, 2))) {
            return;
        }
        this.setupLightingZNeg();
        super.renderNegativeZFacing(tex);
    }

    @Override
    public void renderPositiveZFacing(ITexture[] tex) {
        RenderBlocks renderBlocks = this.renderBlocks;
        if (!(renderBlocks.field_147849_o || renderBlocks.field_147837_f || this.block.func_149646_a(this.blockAccess, this.x, this.y, this.z + 1, 3))) {
            return;
        }
        this.setupLightingZPos();
        super.renderPositiveZFacing(tex);
    }

    @Override
    public void renderNegativeXFacing(ITexture[] tex) {
        RenderBlocks renderBlocks = this.renderBlocks;
        if (!(renderBlocks.field_147849_o || renderBlocks.field_147837_f || this.block.func_149646_a(this.blockAccess, this.x - 1, this.y, this.z, 4))) {
            return;
        }
        this.setupLightingXNeg();
        super.renderNegativeXFacing(tex);
    }

    @Override
    public void renderPositiveXFacing(ITexture[] tex) {
        RenderBlocks renderBlocks = this.renderBlocks;
        if (!(renderBlocks.field_147849_o || renderBlocks.field_147837_f || this.block.func_149646_a(this.blockAccess, this.x + 1, this.y, this.z, 5))) {
            return;
        }
        this.setupLightingXPos();
        super.renderPositiveXFacing(tex);
    }

    @Override
    public ISBRWorldContext setupColor(ForgeDirection side, int hexColor) {
        float blue;
        float green;
        float red;
        float lightness = this.hasLightnessOverride ? this.lightnessOverride : LIGHTNESS[side.ordinal()];
        int color = this.hasColorOverride ? this.colorOverride : hexColor;
        float baseRed = (float)(color >> 16 & 0xFF) / 255.0f;
        float baseGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        float baseBlue = (float)(color & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            red = (baseRed * 30.0f + baseGreen * 59.0f + baseBlue * 11.0f) / 100.0f;
            green = (red * 30.0f + baseGreen * 70.0f) / 100.0f;
            blue = (red * 30.0f + baseBlue * 70.0f) / 100.0f;
        } else {
            red = baseRed;
            green = baseGreen;
            blue = baseBlue;
        }
        Tessellator tessellator = Tessellator.field_78398_a;
        if (this.renderBlocks.field_147863_w) {
            tessellator.func_78380_c(this.hasBrightnessOverride ? this.brightnessOverride : this.brightness);
            if (this.renderBlocks.func_147744_b()) {
                this.renderBlocks.field_147850_ar = this.renderBlocks.field_147848_as = red;
                this.renderBlocks.field_147852_aq = this.renderBlocks.field_147848_as;
                this.renderBlocks.field_147872_ap = this.renderBlocks.field_147848_as;
                this.renderBlocks.field_147858_av = this.renderBlocks.field_147856_aw = green;
                this.renderBlocks.field_147860_au = this.renderBlocks.field_147856_aw;
                this.renderBlocks.field_147846_at = this.renderBlocks.field_147856_aw;
                this.renderBlocks.field_147839_az = this.renderBlocks.field_147833_aA = blue;
                this.renderBlocks.field_147841_ay = this.renderBlocks.field_147833_aA;
                this.renderBlocks.field_147854_ax = this.renderBlocks.field_147833_aA;
            } else {
                this.renderBlocks.field_147850_ar = this.renderBlocks.field_147848_as = red * lightness;
                this.renderBlocks.field_147852_aq = this.renderBlocks.field_147848_as;
                this.renderBlocks.field_147872_ap = this.renderBlocks.field_147848_as;
                this.renderBlocks.field_147858_av = this.renderBlocks.field_147856_aw = green * lightness;
                this.renderBlocks.field_147860_au = this.renderBlocks.field_147856_aw;
                this.renderBlocks.field_147846_at = this.renderBlocks.field_147856_aw;
                this.renderBlocks.field_147839_az = this.renderBlocks.field_147833_aA = blue * lightness;
                this.renderBlocks.field_147841_ay = this.renderBlocks.field_147833_aA;
                this.renderBlocks.field_147854_ax = this.renderBlocks.field_147833_aA;
                this.renderBlocks.field_147872_ap *= this.aoTopLeft;
                this.renderBlocks.field_147846_at *= this.aoTopLeft;
                this.renderBlocks.field_147854_ax *= this.aoTopLeft;
                this.renderBlocks.field_147852_aq *= this.aoBottomLeft;
                this.renderBlocks.field_147860_au *= this.aoBottomLeft;
                this.renderBlocks.field_147841_ay *= this.aoBottomLeft;
                this.renderBlocks.field_147850_ar *= this.aoBottomRight;
                this.renderBlocks.field_147858_av *= this.aoBottomRight;
                this.renderBlocks.field_147839_az *= this.aoBottomRight;
                this.renderBlocks.field_147848_as *= this.aoTopRight;
                this.renderBlocks.field_147856_aw *= this.aoTopRight;
                this.renderBlocks.field_147833_aA *= this.aoTopRight;
            }
        } else {
            if (this.hasBrightnessOverride) {
                tessellator.func_78380_c(this.brightnessOverride);
            }
            tessellator.func_78386_a(red * lightness, green * lightness, blue * lightness);
        }
        return this;
    }

    @Override
    public boolean canRenderInPass(@NotNull IntPredicate predicate) {
        return this.blockAccess instanceof DummyWorld || predicate.test(this.worldRenderPass);
    }

    @Override
    public ISBRWorldContext setupLighting(ForgeDirection facing) {
        ISBRWorldContext iSBRWorldContext;
        switch (facing) {
            case DOWN: {
                iSBRWorldContext = this.setupLightingYNeg();
                break;
            }
            case UP: {
                iSBRWorldContext = this.setupLightingYPos();
                break;
            }
            case NORTH: {
                iSBRWorldContext = this.setupLightingZNeg();
                break;
            }
            case SOUTH: {
                iSBRWorldContext = this.setupLightingZPos();
                break;
            }
            case WEST: {
                iSBRWorldContext = this.setupLightingXNeg();
                break;
            }
            case EAST: {
                iSBRWorldContext = this.setupLightingXPos();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown side: " + facing);
            }
        }
        return iSBRWorldContext;
    }

    private ISBRWorldContext setupLightingYNeg() {
        int[][][] MBFB = this.MBFB;
        int iY = this.block.func_149665_z() < 0.001 ? 0 : 1;
        RenderBlocks renderBlocks = this.renderBlocks;
        if (renderBlocks.field_147863_w) {
            float aoLightValueScratchXYZPNP;
            float aoLightValueScratchXYZPNN;
            float aoLightValueScratchXYZNNP;
            float aoLightValueScratchXYZNNN;
            float aoLightValueScratchXYPN;
            float aoLightValueScratchYZNP;
            float aoLightValueScratchYZNN;
            float aoLightValueScratchXYNN;
            int aoBrightnessXYZPNP;
            int aoBrightnessXYZPNN;
            int aoBrightnessXYZNNP;
            int aoBrightnessXYZNNN;
            int aoBrightnessXYPN;
            int aoBrightnessYZNP;
            int aoBrightnessYZNN;
            int aoBrightnessXYNN;
            int mixedBrightness;
            float[][][] AOLV = this.AOLV;
            double renderMinY = renderBlocks.field_147855_j;
            double renderMinZ = renderBlocks.field_147851_l;
            double renderMaxZ = renderBlocks.field_147853_m;
            double renderMinX = renderBlocks.field_147859_h;
            double renderMaxX = renderBlocks.field_147861_i;
            this.brightness = mixedBrightness = MBFB[1][iY][1];
            double ratio = 1.0 - renderMinY;
            float aoLightValue = AOLV[1][0][1];
            renderBlocks.field_147831_S = aoBrightnessXYNN = MBFB[0][iY][1];
            renderBlocks.field_147825_U = aoBrightnessYZNN = MBFB[1][iY][0];
            renderBlocks.field_147828_V = aoBrightnessYZNP = MBFB[1][iY][2];
            renderBlocks.field_147835_X = aoBrightnessXYPN = MBFB[2][iY][1];
            renderBlocks.field_147832_R = aoBrightnessXYZNNN = MBFB[0][iY][0];
            renderBlocks.field_147826_T = aoBrightnessXYZNNP = MBFB[0][iY][2];
            renderBlocks.field_147827_W = aoBrightnessXYZPNN = MBFB[2][iY][0];
            renderBlocks.field_147834_Y = aoBrightnessXYZPNP = MBFB[2][iY][2];
            renderBlocks.field_147886_y = aoLightValueScratchXYNN = SBRWorldContext.getMixedAo(AOLV[0][0][1], AOLV[0][1][1], ratio);
            renderBlocks.field_147814_A = aoLightValueScratchYZNN = SBRWorldContext.getMixedAo(AOLV[1][0][0], AOLV[1][1][0], ratio);
            renderBlocks.field_147815_B = aoLightValueScratchYZNP = SBRWorldContext.getMixedAo(AOLV[1][0][2], AOLV[1][1][2], ratio);
            renderBlocks.field_147810_D = aoLightValueScratchXYPN = SBRWorldContext.getMixedAo(AOLV[2][0][1], AOLV[2][1][1], ratio);
            renderBlocks.field_147888_x = aoLightValueScratchXYZNNN = SBRWorldContext.getMixedAo(AOLV[0][0][0], AOLV[0][1][0], ratio);
            renderBlocks.field_147884_z = aoLightValueScratchXYZNNP = SBRWorldContext.getMixedAo(AOLV[0][0][2], AOLV[0][1][2], ratio);
            renderBlocks.field_147816_C = aoLightValueScratchXYZPNN = SBRWorldContext.getMixedAo(AOLV[2][0][0], AOLV[2][1][0], ratio);
            renderBlocks.field_147811_E = aoLightValueScratchXYZPNP = SBRWorldContext.getMixedAo(AOLV[2][0][2], AOLV[2][1][2], ratio);
            int brightnessMixedXYZPNP = renderBlocks.func_147778_a(aoBrightnessYZNP, aoBrightnessXYZPNP, aoBrightnessXYPN, mixedBrightness);
            int brightnessMixedXYZPNN = renderBlocks.func_147778_a(aoBrightnessYZNN, aoBrightnessXYPN, aoBrightnessXYZPNN, mixedBrightness);
            int brightnessMixedXYZNNN = renderBlocks.func_147778_a(aoBrightnessXYNN, aoBrightnessXYZNNN, aoBrightnessYZNN, mixedBrightness);
            int brightnessMixedXYZNNP = renderBlocks.func_147778_a(aoBrightnessXYZNNP, aoBrightnessXYNN, aoBrightnessYZNP, mixedBrightness);
            float aoMixedXYZPNP = (aoLightValueScratchYZNP + aoLightValue + aoLightValueScratchXYZPNP + aoLightValueScratchXYPN) / 4.0f;
            float aoMixedXYZPNN = (aoLightValue + aoLightValueScratchYZNN + aoLightValueScratchXYPN + aoLightValueScratchXYZPNN) / 4.0f;
            float aoMixedXYZNNN = (aoLightValueScratchXYNN + aoLightValueScratchXYZNNN + aoLightValue + aoLightValueScratchYZNN) / 4.0f;
            float aoMixedXYZNNP = (aoLightValueScratchXYZNNP + aoLightValueScratchXYNN + aoLightValueScratchYZNP + aoLightValue) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNNP * renderMaxZ * (1.0 - renderMinX) + (double)aoMixedXYZPNP * renderMaxZ * renderMinX + (double)aoMixedXYZPNN * (1.0 - renderMaxZ) * renderMinX + (double)aoMixedXYZNNN * (1.0 - renderMaxZ) * (1.0 - renderMinX));
            this.aoBottomLeft = (float)((double)aoMixedXYZNNP * renderMinZ * (1.0 - renderMinX) + (double)aoMixedXYZPNP * renderMinZ * renderMinX + (double)aoMixedXYZPNN * (1.0 - renderMinZ) * renderMinX + (double)aoMixedXYZNNN * (1.0 - renderMinZ) * (1.0 - renderMinX));
            this.aoBottomRight = (float)((double)aoMixedXYZNNP * renderMinZ * (1.0 - renderMaxX) + (double)aoMixedXYZPNP * renderMinZ * renderMaxX + (double)aoMixedXYZPNN * (1.0 - renderMinZ) * renderMaxX + (double)aoMixedXYZNNN * (1.0 - renderMinZ) * (1.0 - renderMaxX));
            this.aoTopRight = (float)((double)aoMixedXYZNNP * renderMaxZ * (1.0 - renderMaxX) + (double)aoMixedXYZPNP * renderMaxZ * renderMaxX + (double)aoMixedXYZPNN * (1.0 - renderMaxZ) * renderMaxX + (double)aoMixedXYZNNN * (1.0 - renderMaxZ) * (1.0 - renderMaxX));
            renderBlocks.field_147864_al = renderBlocks.func_147727_a(brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZNNN, renderMaxZ * (1.0 - renderMinX), renderMaxZ * renderMinX, (1.0 - renderMaxZ) * renderMinX, (1.0 - renderMaxZ) * (1.0 - renderMinX));
            renderBlocks.field_147874_am = renderBlocks.func_147727_a(brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZNNN, renderMinZ * (1.0 - renderMinX), renderMinZ * renderMinX, (1.0 - renderMinZ) * renderMinX, (1.0 - renderMinZ) * (1.0 - renderMinX));
            renderBlocks.field_147876_an = renderBlocks.func_147727_a(brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZNNN, renderMinZ * (1.0 - renderMaxX), renderMinZ * renderMaxX, (1.0 - renderMinZ) * renderMaxX, (1.0 - renderMinZ) * (1.0 - renderMaxX));
            renderBlocks.field_147870_ao = renderBlocks.func_147727_a(brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZNNN, renderMaxZ * (1.0 - renderMaxX), renderMaxZ * renderMaxX, (1.0 - renderMaxZ) * renderMaxX, (1.0 - renderMaxZ) * (1.0 - renderMaxX));
        } else {
            Tessellator.field_78398_a.func_78380_c(MBFB[1][iY][1]);
        }
        return this;
    }

    private ISBRWorldContext setupLightingYPos() {
        int[][][] MBFB = this.MBFB;
        int iY = this.block.func_149669_A() > 0.999 ? 2 : 1;
        RenderBlocks renderBlocks = this.renderBlocks;
        if (renderBlocks.field_147863_w) {
            float aoLightValueScratchXYZPPP;
            float aoLightValueScratchXYZNPP;
            float aoLightValueScratchXYZPPN;
            float aoLightValueScratchXYZNPN;
            float aoLightValueScratchYZPP;
            float aoLightValueScratchYZPN;
            float aoLightValueScratchXYPP;
            float aoLightValueScratchXYNP;
            int aoBrightnessXYZPPP;
            int aoBrightnessXYZNPP;
            int aoBrightnessXYZPPN;
            int aoBrightnessXYZNPN;
            int aoBrightnessYZPP;
            int aoBrightnessYZPN;
            int aoBrightnessXYPP;
            int aoBrightnessXYNP;
            int mixedBrightness;
            float[][][] AOLV = this.AOLV;
            double renderMaxY = renderBlocks.field_147857_k;
            double renderMinZ = renderBlocks.field_147851_l;
            double renderMaxZ = renderBlocks.field_147853_m;
            double renderMinX = renderBlocks.field_147859_h;
            double renderMaxX = renderBlocks.field_147861_i;
            this.brightness = mixedBrightness = MBFB[1][iY][1];
            double ratio = renderMaxY;
            float aoLightValue = AOLV[1][2][1];
            renderBlocks.field_147880_aa = aoBrightnessXYNP = MBFB[0][iY][1];
            renderBlocks.field_147885_ae = aoBrightnessXYPP = MBFB[2][iY][1];
            renderBlocks.field_147878_ac = aoBrightnessYZPN = MBFB[1][iY][0];
            renderBlocks.field_147887_af = aoBrightnessYZPP = MBFB[1][iY][2];
            renderBlocks.field_147836_Z = aoBrightnessXYZNPN = MBFB[0][iY][0];
            renderBlocks.field_147879_ad = aoBrightnessXYZPPN = MBFB[2][iY][0];
            renderBlocks.field_147881_ab = aoBrightnessXYZNPP = MBFB[0][iY][2];
            renderBlocks.field_147882_ag = aoBrightnessXYZPPP = MBFB[2][iY][2];
            renderBlocks.field_147813_G = aoLightValueScratchXYNP = SBRWorldContext.getMixedAo(AOLV[0][2][1], AOLV[0][1][1], ratio);
            renderBlocks.field_147824_K = aoLightValueScratchXYPP = SBRWorldContext.getMixedAo(AOLV[2][2][1], AOLV[2][1][1], ratio);
            renderBlocks.field_147822_I = aoLightValueScratchYZPN = SBRWorldContext.getMixedAo(AOLV[1][2][0], AOLV[1][1][0], ratio);
            renderBlocks.field_147817_L = aoLightValueScratchYZPP = SBRWorldContext.getMixedAo(AOLV[1][2][2], AOLV[1][1][2], ratio);
            renderBlocks.field_147812_F = aoLightValueScratchXYZNPN = SBRWorldContext.getMixedAo(AOLV[0][2][0], AOLV[0][1][0], ratio);
            renderBlocks.field_147823_J = aoLightValueScratchXYZPPN = SBRWorldContext.getMixedAo(AOLV[2][2][0], AOLV[2][1][0], ratio);
            renderBlocks.field_147821_H = aoLightValueScratchXYZNPP = SBRWorldContext.getMixedAo(AOLV[0][2][2], AOLV[0][1][2], ratio);
            renderBlocks.field_147818_M = aoLightValueScratchXYZPPP = SBRWorldContext.getMixedAo(AOLV[2][2][2], AOLV[2][1][2], ratio);
            int brightnessMixedXYZPPP = renderBlocks.func_147778_a(aoBrightnessYZPP, aoBrightnessXYZPPP, aoBrightnessXYPP, mixedBrightness);
            int brightnessMixedXYZPPN = renderBlocks.func_147778_a(aoBrightnessYZPN, aoBrightnessXYPP, aoBrightnessXYZPPN, mixedBrightness);
            int brightnessMixedXYZNPN = renderBlocks.func_147778_a(aoBrightnessXYNP, aoBrightnessXYZNPN, aoBrightnessYZPN, mixedBrightness);
            int brightnessMixedXYZNPP = renderBlocks.func_147778_a(aoBrightnessXYZNPP, aoBrightnessXYNP, aoBrightnessYZPP, mixedBrightness);
            float aoMixedXYZPPP = (aoLightValueScratchYZPP + aoLightValue + aoLightValueScratchXYZPPP + aoLightValueScratchXYPP) / 4.0f;
            float aoMixedXYZPPN = (aoLightValue + aoLightValueScratchYZPN + aoLightValueScratchXYPP + aoLightValueScratchXYZPPN) / 4.0f;
            float aoMixedXYZNPN = (aoLightValueScratchXYNP + aoLightValueScratchXYZNPN + aoLightValue + aoLightValueScratchYZPN) / 4.0f;
            float aoMixedXYZNPP = (aoLightValueScratchXYZNPP + aoLightValueScratchXYNP + aoLightValueScratchYZPP + aoLightValue) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNPP * renderMaxZ * (1.0 - renderMaxX) + (double)aoMixedXYZPPP * renderMaxZ * renderMaxX + (double)aoMixedXYZPPN * (1.0 - renderMaxZ) * renderMaxX + (double)aoMixedXYZNPN * (1.0 - renderMaxZ) * (1.0 - renderMaxX));
            this.aoBottomLeft = (float)((double)aoMixedXYZNPP * renderMinZ * (1.0 - renderMaxX) + (double)aoMixedXYZPPP * renderMinZ * renderMaxX + (double)aoMixedXYZPPN * (1.0 - renderMinZ) * renderMaxX + (double)aoMixedXYZNPN * (1.0 - renderMinZ) * (1.0 - renderMaxX));
            this.aoBottomRight = (float)((double)aoMixedXYZNPP * renderMinZ * (1.0 - renderMinX) + (double)aoMixedXYZPPP * renderMinZ * renderMinX + (double)aoMixedXYZPPN * (1.0 - renderMinZ) * renderMinX + (double)aoMixedXYZNPN * (1.0 - renderMinZ) * (1.0 - renderMinX));
            this.aoTopRight = (float)((double)aoMixedXYZNPP * renderMaxZ * (1.0 - renderMinX) + (double)aoMixedXYZPPP * renderMaxZ * renderMinX + (double)aoMixedXYZPPN * (1.0 - renderMaxZ) * renderMinX + (double)aoMixedXYZNPN * (1.0 - renderMaxZ) * (1.0 - renderMinX));
            renderBlocks.field_147864_al = renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZPPP, brightnessMixedXYZPPN, brightnessMixedXYZNPN, renderMaxZ * (1.0 - renderMaxX), renderMaxZ * renderMaxX, (1.0 - renderMaxZ) * renderMaxX, (1.0 - renderMaxZ) * (1.0 - renderMaxX));
            renderBlocks.field_147874_am = renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZPPP, brightnessMixedXYZPPN, brightnessMixedXYZNPN, renderMinZ * (1.0 - renderMaxX), renderMinZ * renderMaxX, (1.0 - renderMinZ) * renderMaxX, (1.0 - renderMinZ) * (1.0 - renderMaxX));
            renderBlocks.field_147876_an = renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZPPP, brightnessMixedXYZPPN, brightnessMixedXYZNPN, renderMinZ * (1.0 - renderMinX), renderMinZ * renderMinX, (1.0 - renderMinZ) * renderMinX, (1.0 - renderMinZ) * (1.0 - renderMinX));
            renderBlocks.field_147870_ao = renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZPPP, brightnessMixedXYZPPN, brightnessMixedXYZNPN, renderMaxZ * (1.0 - renderMinX), renderMaxZ * renderMinX, (1.0 - renderMaxZ) * renderMinX, (1.0 - renderMaxZ) * (1.0 - renderMinX));
        } else {
            Tessellator.field_78398_a.func_78380_c(MBFB[1][iY][1]);
        }
        return this;
    }

    private ISBRWorldContext setupLightingZNeg() {
        int[][][] MBFB = this.MBFB;
        int iZ = this.block.func_149706_B() < 0.001 ? 0 : 1;
        RenderBlocks renderBlocks = this.renderBlocks;
        if (renderBlocks.field_147863_w) {
            float aoLightValueScratchXYZPPN;
            float aoLightValueScratchXYZPNN;
            float aoLightValueScratchXYZNPN;
            float aoLightValueScratchXYZNNN;
            float aoLightValueScratchXZPN;
            float aoLightValueScratchYZPN;
            float aoLightValueScratchYZNN;
            float aoLightValueScratchXZNN;
            int aoBrightnessXYZPPN;
            int aoBrightnessXYZPNN;
            int aoBrightnessXYZNPN;
            int aoBrightnessXYZNNN;
            int aoBrightnessXZPN;
            int aoBrightnessYZPN;
            int aoBrightnessYZNN;
            int aoBrightnessXZNN;
            int mixedBrightness;
            float[][][] AOLV = this.AOLV;
            double renderMinY = renderBlocks.field_147855_j;
            double renderMaxY = renderBlocks.field_147857_k;
            double renderMinZ = renderBlocks.field_147851_l;
            double renderMinX = renderBlocks.field_147859_h;
            double renderMaxX = renderBlocks.field_147861_i;
            this.brightness = mixedBrightness = MBFB[1][1][iZ];
            double ratio = 1.0 - renderMinZ;
            float aoLightValue = AOLV[1][1][0];
            renderBlocks.field_147883_ah = aoBrightnessXZNN = MBFB[0][1][iZ];
            renderBlocks.field_147825_U = aoBrightnessYZNN = MBFB[1][0][iZ];
            renderBlocks.field_147878_ac = aoBrightnessYZPN = MBFB[1][2][iZ];
            renderBlocks.field_147866_ai = aoBrightnessXZPN = MBFB[2][1][iZ];
            renderBlocks.field_147832_R = aoBrightnessXYZNNN = MBFB[0][0][iZ];
            renderBlocks.field_147836_Z = aoBrightnessXYZNPN = MBFB[0][2][iZ];
            renderBlocks.field_147827_W = aoBrightnessXYZPNN = MBFB[2][0][iZ];
            renderBlocks.field_147879_ad = aoBrightnessXYZPPN = MBFB[2][2][iZ];
            renderBlocks.field_147819_N = aoLightValueScratchXZNN = SBRWorldContext.getMixedAo(AOLV[0][1][0], AOLV[0][1][1], ratio);
            renderBlocks.field_147814_A = aoLightValueScratchYZNN = SBRWorldContext.getMixedAo(AOLV[1][0][0], AOLV[1][0][1], ratio);
            renderBlocks.field_147822_I = aoLightValueScratchYZPN = SBRWorldContext.getMixedAo(AOLV[1][2][0], AOLV[1][2][1], ratio);
            renderBlocks.field_147820_O = aoLightValueScratchXZPN = SBRWorldContext.getMixedAo(AOLV[2][1][0], AOLV[2][1][1], ratio);
            renderBlocks.field_147888_x = aoLightValueScratchXYZNNN = SBRWorldContext.getMixedAo(AOLV[0][0][0], AOLV[0][0][1], ratio);
            renderBlocks.field_147812_F = aoLightValueScratchXYZNPN = SBRWorldContext.getMixedAo(AOLV[0][2][0], AOLV[0][2][1], ratio);
            renderBlocks.field_147816_C = aoLightValueScratchXYZPNN = SBRWorldContext.getMixedAo(AOLV[2][0][0], AOLV[2][0][1], ratio);
            renderBlocks.field_147823_J = aoLightValueScratchXYZPPN = SBRWorldContext.getMixedAo(AOLV[2][2][0], AOLV[2][2][1], ratio);
            int brightnessMixedXYZPPN = renderBlocks.func_147778_a(aoBrightnessYZPN, aoBrightnessXZPN, aoBrightnessXYZPPN, mixedBrightness);
            int brightnessMixedXYZPNN = renderBlocks.func_147778_a(aoBrightnessYZNN, aoBrightnessXYZPNN, aoBrightnessXZPN, mixedBrightness);
            int brightnessMixedXYZNNN = renderBlocks.func_147778_a(aoBrightnessXYZNNN, aoBrightnessXZNN, aoBrightnessYZNN, mixedBrightness);
            int brightnessMixedXYZNPN = renderBlocks.func_147778_a(aoBrightnessXZNN, aoBrightnessXYZNPN, aoBrightnessYZPN, mixedBrightness);
            float aoMixedXYZPPN = (aoLightValue + aoLightValueScratchYZPN + aoLightValueScratchXZPN + aoLightValueScratchXYZPPN) / 4.0f;
            float aoMixedXYZPNN = (aoLightValueScratchYZNN + aoLightValue + aoLightValueScratchXYZPNN + aoLightValueScratchXZPN) / 4.0f;
            float aoMixedXYZNNN = (aoLightValueScratchXYZNNN + aoLightValueScratchXZNN + aoLightValueScratchYZNN + aoLightValue) / 4.0f;
            float aoMixedXYZNPN = (aoLightValueScratchXZNN + aoLightValueScratchXYZNPN + aoLightValue + aoLightValueScratchYZPN) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNPN * renderMaxY * (1.0 - renderMinX) + (double)aoMixedXYZPPN * renderMaxY * renderMinX + (double)aoMixedXYZPNN * (1.0 - renderMaxY) * renderMinX + (double)aoMixedXYZNNN * (1.0 - renderMaxY) * (1.0 - renderMinX));
            this.aoBottomLeft = (float)((double)aoMixedXYZNPN * renderMaxY * (1.0 - renderMaxX) + (double)aoMixedXYZPPN * renderMaxY * renderMaxX + (double)aoMixedXYZPNN * (1.0 - renderMaxY) * renderMaxX + (double)aoMixedXYZNNN * (1.0 - renderMaxY) * (1.0 - renderMaxX));
            this.aoBottomRight = (float)((double)aoMixedXYZNPN * renderMinY * (1.0 - renderMaxX) + (double)aoMixedXYZPPN * renderMinY * renderMaxX + (double)aoMixedXYZPNN * (1.0 - renderMinY) * renderMaxX + (double)aoMixedXYZNNN * (1.0 - renderMinY) * (1.0 - renderMaxX));
            this.aoTopRight = (float)((double)aoMixedXYZNPN * renderMinY * (1.0 - renderMinX) + (double)aoMixedXYZPPN * renderMinY * renderMinX + (double)aoMixedXYZPNN * (1.0 - renderMinY) * renderMinX + (double)aoMixedXYZNNN * (1.0 - renderMinY) * (1.0 - renderMinX));
            renderBlocks.field_147864_al = renderBlocks.func_147727_a(brightnessMixedXYZNPN, brightnessMixedXYZPPN, brightnessMixedXYZPNN, brightnessMixedXYZNNN, renderMaxY * (1.0 - renderMinX), renderMaxY * renderMinX, (1.0 - renderMaxY) * renderMinX, (1.0 - renderMaxY) * (1.0 - renderMinX));
            renderBlocks.field_147874_am = renderBlocks.func_147727_a(brightnessMixedXYZNPN, brightnessMixedXYZPPN, brightnessMixedXYZPNN, brightnessMixedXYZNNN, renderMaxY * (1.0 - renderMaxX), renderMaxY * renderMaxX, (1.0 - renderMaxY) * renderMaxX, (1.0 - renderMaxY) * (1.0 - renderMaxX));
            renderBlocks.field_147876_an = renderBlocks.func_147727_a(brightnessMixedXYZNPN, brightnessMixedXYZPPN, brightnessMixedXYZPNN, brightnessMixedXYZNNN, renderMinY * (1.0 - renderMaxX), renderMinY * renderMaxX, (1.0 - renderMinY) * renderMaxX, (1.0 - renderMinY) * (1.0 - renderMaxX));
            renderBlocks.field_147870_ao = renderBlocks.func_147727_a(brightnessMixedXYZNPN, brightnessMixedXYZPPN, brightnessMixedXYZPNN, brightnessMixedXYZNNN, renderMinY * (1.0 - renderMinX), renderMinY * renderMinX, (1.0 - renderMinY) * renderMinX, (1.0 - renderMinY) * (1.0 - renderMinX));
        } else {
            Tessellator.field_78398_a.func_78380_c(MBFB[1][1][iZ]);
        }
        return this;
    }

    private ISBRWorldContext setupLightingZPos() {
        int[][][] MBFB = this.MBFB;
        int iZ = this.block.func_149693_C() > 0.999 ? 2 : 1;
        RenderBlocks renderBlocks = this.renderBlocks;
        if (renderBlocks.field_147863_w) {
            float aoLightValueScratchXYZPPP;
            float aoLightValueScratchXYZPNP;
            float aoLightValueScratchXYZNPP;
            float aoLightValueScratchXYZNNP;
            float aoLightValueScratchYZPP;
            float aoLightValueScratchYZNP;
            float aoLightValueScratchXZPP;
            float aoLightValueScratchXZNP;
            int aoBrightnessXYZPPP;
            int aoBrightnessXYZPNP;
            int aoBrightnessXYZNPP;
            int aoBrightnessXYZNNP;
            int aoBrightnessYZPP;
            int aoBrightnessYZNP;
            int aoBrightnessXZPP;
            int aoBrightnessXZNP;
            int mixedBrightness;
            float[][][] AOLV = this.AOLV;
            double renderMinY = renderBlocks.field_147855_j;
            double renderMaxY = renderBlocks.field_147857_k;
            double renderMaxZ = renderBlocks.field_147853_m;
            double renderMinX = renderBlocks.field_147859_h;
            double renderMaxX = renderBlocks.field_147861_i;
            this.brightness = mixedBrightness = MBFB[1][1][iZ];
            double ratio = renderMaxZ;
            float aoLightValue = AOLV[1][1][2];
            renderBlocks.field_147868_aj = aoBrightnessXZNP = MBFB[0][1][iZ];
            renderBlocks.field_147862_ak = aoBrightnessXZPP = MBFB[2][1][iZ];
            renderBlocks.field_147828_V = aoBrightnessYZNP = MBFB[1][0][iZ];
            renderBlocks.field_147887_af = aoBrightnessYZPP = MBFB[1][2][iZ];
            renderBlocks.field_147826_T = aoBrightnessXYZNNP = MBFB[0][0][iZ];
            renderBlocks.field_147881_ab = aoBrightnessXYZNPP = MBFB[0][2][iZ];
            renderBlocks.field_147834_Y = aoBrightnessXYZPNP = MBFB[2][0][iZ];
            renderBlocks.field_147882_ag = aoBrightnessXYZPPP = MBFB[2][2][iZ];
            renderBlocks.field_147830_P = aoLightValueScratchXZNP = SBRWorldContext.getMixedAo(AOLV[0][1][2], AOLV[0][1][1], ratio);
            renderBlocks.field_147829_Q = aoLightValueScratchXZPP = SBRWorldContext.getMixedAo(AOLV[2][1][2], AOLV[2][1][1], ratio);
            renderBlocks.field_147815_B = aoLightValueScratchYZNP = SBRWorldContext.getMixedAo(AOLV[1][0][2], AOLV[1][0][1], ratio);
            renderBlocks.field_147817_L = aoLightValueScratchYZPP = SBRWorldContext.getMixedAo(AOLV[1][2][2], AOLV[1][2][1], ratio);
            renderBlocks.field_147884_z = aoLightValueScratchXYZNNP = SBRWorldContext.getMixedAo(AOLV[0][0][2], AOLV[0][0][1], ratio);
            renderBlocks.field_147821_H = aoLightValueScratchXYZNPP = SBRWorldContext.getMixedAo(AOLV[0][2][2], AOLV[0][2][1], ratio);
            renderBlocks.field_147811_E = aoLightValueScratchXYZPNP = SBRWorldContext.getMixedAo(AOLV[2][0][2], AOLV[2][0][1], ratio);
            renderBlocks.field_147818_M = aoLightValueScratchXYZPPP = SBRWorldContext.getMixedAo(AOLV[2][2][2], AOLV[2][2][1], ratio);
            int brightnessMixedXYZNPP = renderBlocks.func_147778_a(aoBrightnessXZNP, aoBrightnessXYZNPP, aoBrightnessYZPP, mixedBrightness);
            int brightnessMixedXYZNNP = renderBlocks.func_147778_a(aoBrightnessXYZNNP, aoBrightnessXZNP, aoBrightnessYZNP, mixedBrightness);
            int brightnessMixedXYZPNP = renderBlocks.func_147778_a(aoBrightnessYZNP, aoBrightnessXYZPNP, aoBrightnessXZPP, mixedBrightness);
            int brightnessMixedXYZPPP = renderBlocks.func_147778_a(aoBrightnessYZPP, aoBrightnessXZPP, aoBrightnessXYZPPP, mixedBrightness);
            float aoMixedXYZNPP = (aoLightValueScratchXZNP + aoLightValueScratchXYZNPP + aoLightValue + aoLightValueScratchYZPP) / 4.0f;
            float aoMixedXYZNNP = (aoLightValueScratchXYZNNP + aoLightValueScratchXZNP + aoLightValueScratchYZNP + aoLightValue) / 4.0f;
            float aoMixedXYZPNP = (aoLightValueScratchYZNP + aoLightValue + aoLightValueScratchXYZPNP + aoLightValueScratchXZPP) / 4.0f;
            float aoMixedXYZPPP = (aoLightValue + aoLightValueScratchYZPP + aoLightValueScratchXZPP + aoLightValueScratchXYZPPP) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNPP * renderMaxY * (1.0 - renderMinX) + (double)aoMixedXYZPPP * renderMaxY * renderMinX + (double)aoMixedXYZPNP * (1.0 - renderMaxY) * renderMinX + (double)aoMixedXYZNNP * (1.0 - renderMaxY) * (1.0 - renderMinX));
            this.aoBottomLeft = (float)((double)aoMixedXYZNPP * renderMinY * (1.0 - renderMinX) + (double)aoMixedXYZPPP * renderMinY * renderMinX + (double)aoMixedXYZPNP * (1.0 - renderMinY) * renderMinX + (double)aoMixedXYZNNP * (1.0 - renderMinY) * (1.0 - renderMinX));
            this.aoBottomRight = (float)((double)aoMixedXYZNPP * renderMinY * (1.0 - renderMaxX) + (double)aoMixedXYZPPP * renderMinY * renderMaxX + (double)aoMixedXYZPNP * (1.0 - renderMinY) * renderMaxX + (double)aoMixedXYZNNP * (1.0 - renderMinY) * (1.0 - renderMaxX));
            this.aoTopRight = (float)((double)aoMixedXYZNPP * renderMaxY * (1.0 - renderMaxX) + (double)aoMixedXYZPPP * renderMaxY * renderMaxX + (double)aoMixedXYZPNP * (1.0 - renderMaxY) * renderMaxX + (double)aoMixedXYZNNP * (1.0 - renderMaxY) * (1.0 - renderMaxX));
            renderBlocks.field_147864_al = renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPPP, renderMaxY * (1.0 - renderMinX), (1.0 - renderMaxY) * (1.0 - renderMinX), (1.0 - renderMaxY) * renderMinX, renderMaxY * renderMinX);
            renderBlocks.field_147874_am = renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPPP, renderMinY * (1.0 - renderMinX), (1.0 - renderMinY) * (1.0 - renderMinX), (1.0 - renderMinY) * renderMinX, renderMinY * renderMinX);
            renderBlocks.field_147876_an = renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPPP, renderMinY * (1.0 - renderMaxX), (1.0 - renderMinY) * (1.0 - renderMaxX), (1.0 - renderMinY) * renderMaxX, renderMinY * renderMaxX);
            renderBlocks.field_147870_ao = renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNNP, brightnessMixedXYZPNP, brightnessMixedXYZPPP, renderMaxY * (1.0 - renderMaxX), (1.0 - renderMaxY) * (1.0 - renderMaxX), (1.0 - renderMaxY) * renderMaxX, renderMaxY * renderMaxX);
        } else {
            Tessellator.field_78398_a.func_78380_c(MBFB[1][1][iZ]);
        }
        return this;
    }

    private ISBRWorldContext setupLightingXNeg() {
        int[][][] MBFB = this.MBFB;
        int iX = this.block.func_149704_x() < 0.001 ? 0 : 1;
        RenderBlocks renderBlocks = this.renderBlocks;
        if (renderBlocks.field_147863_w) {
            float aoLightValueScratchXYZNPP;
            float aoLightValueScratchXYZNPN;
            float aoLightValueScratchXYZNNP;
            float aoLightValueScratchXYZNNN;
            float aoLightValueScratchXYNP;
            float aoLightValueScratchXZNP;
            float aoLightValueScratchXZNN;
            float aoLightValueScratchXYNN;
            int aoBrightnessXYZNPP;
            int aoBrightnessXYZNPN;
            int aoBrightnessXYZNNP;
            int aoBrightnessXYZNNN;
            int aoBrightnessXYNP;
            int aoBrightnessXZNP;
            int aoBrightnessXZNN;
            int aoBrightnessXYNN;
            int mixedBrightness;
            float[][][] AOLV = this.AOLV;
            double renderMinY = renderBlocks.field_147855_j;
            double renderMaxY = renderBlocks.field_147857_k;
            double renderMinZ = renderBlocks.field_147851_l;
            double renderMaxZ = renderBlocks.field_147853_m;
            double renderMinX = renderBlocks.field_147859_h;
            this.brightness = mixedBrightness = MBFB[iX][1][1];
            double ratio = 1.0 - renderMinX;
            float aoLightValue = AOLV[0][1][1];
            renderBlocks.field_147831_S = aoBrightnessXYNN = MBFB[iX][0][1];
            renderBlocks.field_147883_ah = aoBrightnessXZNN = MBFB[iX][1][0];
            renderBlocks.field_147868_aj = aoBrightnessXZNP = MBFB[iX][1][2];
            renderBlocks.field_147880_aa = aoBrightnessXYNP = MBFB[iX][2][1];
            renderBlocks.field_147832_R = aoBrightnessXYZNNN = MBFB[iX][0][0];
            renderBlocks.field_147826_T = aoBrightnessXYZNNP = MBFB[iX][0][2];
            renderBlocks.field_147836_Z = aoBrightnessXYZNPN = MBFB[iX][2][0];
            renderBlocks.field_147881_ab = aoBrightnessXYZNPP = MBFB[iX][2][2];
            renderBlocks.field_147886_y = aoLightValueScratchXYNN = SBRWorldContext.getMixedAo(AOLV[0][0][1], AOLV[1][0][1], ratio);
            renderBlocks.field_147819_N = aoLightValueScratchXZNN = SBRWorldContext.getMixedAo(AOLV[0][1][0], AOLV[1][1][0], ratio);
            renderBlocks.field_147830_P = aoLightValueScratchXZNP = SBRWorldContext.getMixedAo(AOLV[0][1][2], AOLV[1][1][2], ratio);
            renderBlocks.field_147813_G = aoLightValueScratchXYNP = SBRWorldContext.getMixedAo(AOLV[0][2][1], AOLV[1][2][1], ratio);
            renderBlocks.field_147888_x = aoLightValueScratchXYZNNN = SBRWorldContext.getMixedAo(AOLV[0][0][0], AOLV[1][0][0], ratio);
            renderBlocks.field_147884_z = aoLightValueScratchXYZNNP = SBRWorldContext.getMixedAo(AOLV[0][0][2], AOLV[1][0][2], ratio);
            renderBlocks.field_147812_F = aoLightValueScratchXYZNPN = SBRWorldContext.getMixedAo(AOLV[0][2][0], AOLV[1][2][0], ratio);
            renderBlocks.field_147821_H = aoLightValueScratchXYZNPP = SBRWorldContext.getMixedAo(AOLV[0][2][2], AOLV[1][2][2], ratio);
            int brightnessMixedXYZNPN = renderBlocks.func_147778_a(aoBrightnessXZNN, aoBrightnessXYZNPN, aoBrightnessXYNP, mixedBrightness);
            int brightnessMixedXYZNNN = renderBlocks.func_147778_a(aoBrightnessXYZNNN, aoBrightnessXYNN, aoBrightnessXZNN, mixedBrightness);
            int brightnessMixedXYZNNP = renderBlocks.func_147778_a(aoBrightnessXYNN, aoBrightnessXYZNNP, aoBrightnessXZNP, mixedBrightness);
            int brightnessMixedXYZNPP = renderBlocks.func_147778_a(aoBrightnessXZNP, aoBrightnessXYNP, aoBrightnessXYZNPP, mixedBrightness);
            float aoMixedXYZNPN = (aoLightValueScratchXZNN + aoLightValue + aoLightValueScratchXYZNPN + aoLightValueScratchXYNP) / 4.0f;
            float aoMixedXYZNNN = (aoLightValueScratchXYZNNN + aoLightValueScratchXYNN + aoLightValueScratchXZNN + aoLightValue) / 4.0f;
            float aoMixedXYZNNP = (aoLightValueScratchXYNN + aoLightValueScratchXYZNNP + aoLightValue + aoLightValueScratchXZNP) / 4.0f;
            float aoMixedXYZNPP = (aoLightValue + aoLightValueScratchXZNP + aoLightValueScratchXYNP + aoLightValueScratchXYZNPP) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZNPP * renderMaxY * renderMaxZ + (double)aoMixedXYZNPN * renderMaxY * (1.0 - renderMaxZ) + (double)aoMixedXYZNNN * (1.0 - renderMaxY) * (1.0 - renderMaxZ) + (double)aoMixedXYZNNP * (1.0 - renderMaxY) * renderMaxZ);
            this.aoBottomLeft = (float)((double)aoMixedXYZNPP * renderMaxY * renderMinZ + (double)aoMixedXYZNPN * renderMaxY * (1.0 - renderMinZ) + (double)aoMixedXYZNNN * (1.0 - renderMaxY) * (1.0 - renderMinZ) + (double)aoMixedXYZNNP * (1.0 - renderMaxY) * renderMinZ);
            this.aoBottomRight = (float)((double)aoMixedXYZNPP * renderMinY * renderMinZ + (double)aoMixedXYZNPN * renderMinY * (1.0 - renderMinZ) + (double)aoMixedXYZNNN * (1.0 - renderMinY) * (1.0 - renderMinZ) + (double)aoMixedXYZNNP * (1.0 - renderMinY) * renderMinZ);
            this.aoTopRight = (float)((double)aoMixedXYZNPP * renderMinY * renderMaxZ + (double)aoMixedXYZNPN * renderMinY * (1.0 - renderMaxZ) + (double)aoMixedXYZNNN * (1.0 - renderMinY) * (1.0 - renderMaxZ) + (double)aoMixedXYZNNP * (1.0 - renderMinY) * renderMaxZ);
            renderBlocks.field_147864_al = renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNPN, brightnessMixedXYZNNN, brightnessMixedXYZNNP, renderMaxY * renderMaxZ, renderMaxY * (1.0 - renderMaxZ), (1.0 - renderMaxY) * (1.0 - renderMaxZ), (1.0 - renderMaxY) * renderMaxZ);
            renderBlocks.field_147874_am = renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNPN, brightnessMixedXYZNNN, brightnessMixedXYZNNP, renderMaxY * renderMinZ, renderMaxY * (1.0 - renderMinZ), (1.0 - renderMaxY) * (1.0 - renderMinZ), (1.0 - renderMaxY) * renderMinZ);
            renderBlocks.field_147876_an = renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNPN, brightnessMixedXYZNNN, brightnessMixedXYZNNP, renderMinY * renderMinZ, renderMinY * (1.0 - renderMinZ), (1.0 - renderMinY) * (1.0 - renderMinZ), (1.0 - renderMinY) * renderMinZ);
            renderBlocks.field_147870_ao = renderBlocks.func_147727_a(brightnessMixedXYZNPP, brightnessMixedXYZNPN, brightnessMixedXYZNNN, brightnessMixedXYZNNP, renderMinY * renderMaxZ, renderMinY * (1.0 - renderMaxZ), (1.0 - renderMinY) * (1.0 - renderMaxZ), (1.0 - renderMinY) * renderMaxZ);
        } else {
            Tessellator.field_78398_a.func_78380_c(MBFB[iX][1][1]);
        }
        return this;
    }

    private ISBRWorldContext setupLightingXPos() {
        int[][][] MBFB = this.MBFB;
        int iX = this.block.func_149753_y() > 0.999 ? 2 : 1;
        RenderBlocks renderBlocks = this.renderBlocks;
        if (renderBlocks.field_147863_w) {
            float aoLightValueScratchXYZPPP;
            float aoLightValueScratchXYZPPN;
            float aoLightValueScratchXYZPNP;
            float aoLightValueScratchXYZPNN;
            float aoLightValueScratchXYPP;
            float aoLightValueScratchXZPP;
            float aoLightValueScratchXZPN;
            float aoLightValueScratchXYPN;
            int aoBrightnessXYZPPP;
            int aoBrightnessXYZPPN;
            int aoBrightnessXYZPNP;
            int aoBrightnessXYZPNN;
            int aoBrightnessXYPP;
            int aoBrightnessXZPP;
            int aoBrightnessXZPN;
            int aoBrightnessXYPN;
            int mixedBrightness;
            float[][][] AOLV = this.AOLV;
            double renderMinY = renderBlocks.field_147855_j;
            double renderMaxY = renderBlocks.field_147857_k;
            double renderMinZ = renderBlocks.field_147851_l;
            double renderMaxZ = renderBlocks.field_147853_m;
            double renderMaxX = renderBlocks.field_147861_i;
            this.brightness = mixedBrightness = MBFB[iX][1][1];
            double ratio = renderMaxX;
            float aoLightValue = AOLV[2][1][1];
            renderBlocks.field_147835_X = aoBrightnessXYPN = MBFB[iX][0][1];
            renderBlocks.field_147866_ai = aoBrightnessXZPN = MBFB[iX][1][0];
            renderBlocks.field_147862_ak = aoBrightnessXZPP = MBFB[iX][1][2];
            renderBlocks.field_147885_ae = aoBrightnessXYPP = MBFB[iX][2][1];
            renderBlocks.field_147827_W = aoBrightnessXYZPNN = MBFB[iX][0][0];
            renderBlocks.field_147834_Y = aoBrightnessXYZPNP = MBFB[iX][0][2];
            renderBlocks.field_147879_ad = aoBrightnessXYZPPN = MBFB[iX][2][0];
            renderBlocks.field_147882_ag = aoBrightnessXYZPPP = MBFB[iX][2][2];
            renderBlocks.field_147810_D = aoLightValueScratchXYPN = SBRWorldContext.getMixedAo(AOLV[2][0][1], AOLV[1][0][1], ratio);
            renderBlocks.field_147820_O = aoLightValueScratchXZPN = SBRWorldContext.getMixedAo(AOLV[2][1][0], AOLV[1][1][0], ratio);
            renderBlocks.field_147829_Q = aoLightValueScratchXZPP = SBRWorldContext.getMixedAo(AOLV[2][1][2], AOLV[1][1][2], ratio);
            renderBlocks.field_147824_K = aoLightValueScratchXYPP = SBRWorldContext.getMixedAo(AOLV[2][2][1], AOLV[1][2][1], ratio);
            renderBlocks.field_147816_C = aoLightValueScratchXYZPNN = SBRWorldContext.getMixedAo(AOLV[2][0][0], AOLV[1][0][0], ratio);
            renderBlocks.field_147811_E = aoLightValueScratchXYZPNP = SBRWorldContext.getMixedAo(AOLV[2][0][2], AOLV[1][0][2], ratio);
            renderBlocks.field_147823_J = aoLightValueScratchXYZPPN = SBRWorldContext.getMixedAo(AOLV[2][2][0], AOLV[1][2][0], ratio);
            renderBlocks.field_147818_M = aoLightValueScratchXYZPPP = SBRWorldContext.getMixedAo(AOLV[2][2][2], AOLV[1][2][2], ratio);
            int brightnessMixedXYZPPP = renderBlocks.func_147778_a(aoBrightnessXZPP, aoBrightnessXYPP, aoBrightnessXYZPPP, mixedBrightness);
            int brightnessMixedXYZPNP = renderBlocks.func_147778_a(aoBrightnessXYPN, aoBrightnessXYZPNP, aoBrightnessXZPP, mixedBrightness);
            int brightnessMixedXYZPNN = renderBlocks.func_147778_a(aoBrightnessXYZPNN, aoBrightnessXYPN, aoBrightnessXZPN, mixedBrightness);
            int brightnessMixedXYZPPN = renderBlocks.func_147778_a(aoBrightnessXZPN, aoBrightnessXYZPPN, aoBrightnessXYPP, mixedBrightness);
            float aoMixedXYZPPP = (aoLightValue + aoLightValueScratchXZPP + aoLightValueScratchXYPP + aoLightValueScratchXYZPPP) / 4.0f;
            float aoMixedXYZPNP = (aoLightValueScratchXYPN + aoLightValueScratchXYZPNP + aoLightValue + aoLightValueScratchXZPP) / 4.0f;
            float aoMixedXYZPNN = (aoLightValueScratchXYZPNN + aoLightValueScratchXYPN + aoLightValueScratchXZPN + aoLightValue) / 4.0f;
            float aoMixedXYZPPN = (aoLightValueScratchXZPN + aoLightValue + aoLightValueScratchXYZPPN + aoLightValueScratchXYPP) / 4.0f;
            this.aoTopLeft = (float)((double)aoMixedXYZPNP * (1.0 - renderMinY) * renderMaxZ + (double)aoMixedXYZPNN * (1.0 - renderMinY) * (1.0 - renderMaxZ) + (double)aoMixedXYZPPN * renderMinY * (1.0 - renderMaxZ) + (double)aoMixedXYZPPP * renderMinY * renderMaxZ);
            this.aoBottomLeft = (float)((double)aoMixedXYZPNP * (1.0 - renderMinY) * renderMinZ + (double)aoMixedXYZPNN * (1.0 - renderMinY) * (1.0 - renderMinZ) + (double)aoMixedXYZPPN * renderMinY * (1.0 - renderMinZ) + (double)aoMixedXYZPPP * renderMinY * renderMinZ);
            this.aoBottomRight = (float)((double)aoMixedXYZPNP * (1.0 - renderMaxY) * renderMinZ + (double)aoMixedXYZPNN * (1.0 - renderMaxY) * (1.0 - renderMinZ) + (double)aoMixedXYZPPN * renderMaxY * (1.0 - renderMinZ) + (double)aoMixedXYZPPP * renderMaxY * renderMinZ);
            this.aoTopRight = (float)((double)aoMixedXYZPNP * (1.0 - renderMaxY) * renderMaxZ + (double)aoMixedXYZPNN * (1.0 - renderMaxY) * (1.0 - renderMaxZ) + (double)aoMixedXYZPPN * renderMaxY * (1.0 - renderMaxZ) + (double)aoMixedXYZPPP * renderMaxY * renderMaxZ);
            renderBlocks.field_147864_al = renderBlocks.func_147727_a(brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZPPN, brightnessMixedXYZPPP, (1.0 - renderMinY) * renderMaxZ, (1.0 - renderMinY) * (1.0 - renderMaxZ), renderMinY * (1.0 - renderMaxZ), renderMinY * renderMaxZ);
            renderBlocks.field_147874_am = renderBlocks.func_147727_a(brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZPPN, brightnessMixedXYZPPP, (1.0 - renderMinY) * renderMinZ, (1.0 - renderMinY) * (1.0 - renderMinZ), renderMinY * (1.0 - renderMinZ), renderMinY * renderMinZ);
            renderBlocks.field_147876_an = renderBlocks.func_147727_a(brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZPPN, brightnessMixedXYZPPP, (1.0 - renderMaxY) * renderMinZ, (1.0 - renderMaxY) * (1.0 - renderMinZ), renderMaxY * (1.0 - renderMinZ), renderMaxY * renderMinZ);
            renderBlocks.field_147870_ao = renderBlocks.func_147727_a(brightnessMixedXYZPNP, brightnessMixedXYZPNN, brightnessMixedXYZPPN, brightnessMixedXYZPPP, (1.0 - renderMaxY) * renderMaxZ, (1.0 - renderMaxY) * (1.0 - renderMaxZ), renderMaxY * (1.0 - renderMaxZ), renderMaxY * renderMaxZ);
        } else {
            Tessellator.field_78398_a.func_78380_c(MBFB[iX][1][1]);
        }
        return this;
    }
}

