/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.IToolStats;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchMuffler;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.RenderOverlay;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GTUtilityClient;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.TurbineStatCalculator;
import gregtech.common.items.MetaGeneratedTool01;
import gregtech.common.pollution.Pollution;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public abstract class MTEAirFilterBase
extends MTEEnhancedMultiBlockBase<MTEAirFilterBase> {
    public static final int POLLUTION_THRESHOLD = 10000;
    public static final float BOOST_PER_FILTER = 2.0f;
    public static final float GLOBAL_MULTIPLIER = 30.0f;
    public static final float SCALING_FACTOR = 2.5f;
    public static final int USES_PER_FILTER = 30;
    private static final Random RANDOM = new XSTR();
    protected float baseEff = 0.0f;
    protected int multiTier = 0;
    protected int chunkIndex = 0;
    protected boolean hasPollution = false;
    protected int mode = 0;
    protected int size;
    protected boolean isFilterLoaded = false;
    protected int filterUsageRemaining = 0;
    protected int tickCounter = 0;
    protected final List<RenderOverlay.OverlayTicket> overlayTickets = new ArrayList<RenderOverlay.OverlayTicket>();
    private boolean mFormed;
    protected static final String STRUCTURE_PIECE_MAIN = "main";
    protected static final ClassValue<IStructureDefinition<MTEAirFilterBase>> STRUCTURE_DEFINITION = new ClassValue<IStructureDefinition<MTEAirFilterBase>>(){

        @Override
        protected IStructureDefinition<MTEAirFilterBase> computeValue(Class<?> type) {
            return StructureDefinition.builder().addShape(MTEAirFilterBase.STRUCTURE_PIECE_MAIN, StructureUtility.transpose((String[][])new String[][]{{"xxx", "xxx", "xxx"}, {"vmv", "m-m", "vmv"}, {"vmv", "m-m", "vmv"}, {"c~c", "ccc", "ccc"}})).addElement('c', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsNH, (int)x.getCasingMeta()), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addMaintenanceToMachineList, x.getCasingIndex(), 1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addInputToMachineList, x.getCasingIndex(), 1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, x.getCasingIndex(), 1), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addEnergyInputToMachineList, x.getCasingIndex(), 1)}))).addElement('x', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsNH, (int)x.getCasingMeta()))).addElement('v', (IStructureElement)StructureUtility.lazy(x -> StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsNH, (int)x.getPipeMeta()))).addElement('m', (IStructureElement)StructureUtility.lazy(x -> GTStructureUtility.ofHatchAdderOptional(MTEMultiBlockBase::addMufflerToMachineList, x.getCasingIndex(), 2, GregTechAPI.sBlockCasingsNH, x.getCasingMeta()))).build();
        }
    };
    private ItemStack cleanFilter;
    private ItemStack dirtyFilter;

    @Override
    public final IStructureDefinition<MTEAirFilterBase> getStructureDefinition() {
        return STRUCTURE_DEFINITION.get(this.getClass());
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 1, 3, 0);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return this.checkPiece(STRUCTURE_PIECE_MAIN, 1, 3, 0) && !this.mMufflerHatches.isEmpty() && this.mMaintenanceHatches.size() == 1;
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    public MTEAirFilterBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEAirFilterBase(String aName) {
        super(aName);
    }

    public abstract long getEUt();

    public String getCasingString() {
        String string;
        switch (this.getCasingMeta()) {
            case 0: {
                string = "Air Filter Turbine Casing";
                break;
            }
            case 3: {
                string = "Advanced Air Filter Turbine Casing";
                break;
            }
            case 5: {
                string = "Super Air Filter Turbine Casing";
                break;
            }
            default: {
                string = "fill a ticket on github if you read this";
            }
        }
        return string;
    }

    public String getPipeString() {
        String string;
        switch (this.getPipeMeta()) {
            case 1: {
                string = "Air Filter Vent Casing";
                break;
            }
            case 4: {
                string = "Advanced Air Filter Vent Casing";
                break;
            }
            case 6: {
                string = "Super Air Filter Vent Casing";
                break;
            }
            default: {
                string = "fill a ticket on github if you read this";
            }
        }
        return string;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Air Filter").addInfo("Needs a Turbine in the controller").addInfo("Can process " + (2 * this.multiTier + 1) + "x" + (2 * this.multiTier + 1) + " chunks").addInfo("Each muffler hatch reduces pollution in one chunk of the working area by:").addInfo("  " + EnumChatFormatting.WHITE + 30.0f + " * multiTierBonus * turbineEff * FLOOR(" + 2.5f + "^mufflerTier)").addInfo("every second").addInfo("- multiTierBonus for this controller is " + this.getBonusByTier()).addInfo("- turbineEff is the efficiency of the Turbine in controller slot").addInfo("- Effective muffler tier is limited by energy input tier").addInfo("- Uses " + this.getEUt() + " EU/t while working").addSeparator().addInfo("Insert Absorption Filter in an input bus").addInfo("  to double pollution cleaning amount (30 uses per item)").addInfo("Each maintenance issue reduces cleaning amount by 10%").beginStructureBlock(3, 4, 3, true).addController("Front bottom").addOtherStructurePart(this.getCasingString(), "Top and bottom layers").addOtherStructurePart(this.getPipeString(), "Corners of the middle two layers").addOtherStructurePart("Muffler Hatch", "Sides of the middle two layers").addEnergyHatch("Any bottom layer casing", 1).addMaintenanceHatch("Any bottom layer casing", 1).addInputBus("Any bottom layer casing", 1).addOutputBus("Any bottom layer casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        ITexture casingTexture = Textures.BlockIcons.getCasingTextureForId(this.getCasingIndex());
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{casingTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_ACTIVE_GLOW).glow().build()};
            }
            return new ITexture[]{casingTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_DIESEL_ENGINE_GLOW).glow().build()};
        }
        return new ITexture[]{casingTexture};
    }

    public abstract float getBonusByTier();

    public abstract int getCasingIndex();

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        if (aStack == null) {
            return false;
        }
        Item item = aStack.func_77973_b();
        if (!(item instanceof MetaGeneratedTool01)) {
            return false;
        }
        MetaGeneratedTool01 tool = (MetaGeneratedTool01)item;
        if (aStack.func_77960_j() < 170 || aStack.func_77960_j() > 179) {
            return false;
        }
        IToolStats stats = tool.getToolStats(aStack);
        if (stats == null || stats.getSpeedMultiplier() <= 0.0f) {
            return false;
        }
        Materials material = MetaGeneratedTool.getPrimaryMaterial(aStack);
        return material != null && material.mToolSpeed > 0.0f;
    }

    private float getTurbineDamage(ItemStack aStack) {
        Item item;
        if (aStack == null || !((item = aStack.func_77973_b()) instanceof MetaGeneratedTool)) {
            return -1.0f;
        }
        MetaGeneratedTool tool = (MetaGeneratedTool)item;
        return tool.getToolCombatDamage(aStack);
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    public int getPollutionCleaningRatePerTick(float turbineEff, float multiEff, boolean isRateBoosted) {
        return this.getPollutionCleaningRatePerSecond(turbineEff, multiEff, isRateBoosted) / 20;
    }

    public int getPollutionCleaningRatePerSecond(float turbineEff, float multiEff, boolean isRateBoosted) {
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GTUtility.getTier(tVoltage));
        int pollutionPerSecond = 0;
        for (MTEHatchMuffler tHatch : GTUtility.filterValidMTEs(this.mMufflerHatches)) {
            pollutionPerSecond += (int)GTUtility.powInt(2.5, Math.min(tTier, tHatch.mTier));
        }
        if (isRateBoosted) {
            pollutionPerSecond = (int)((float)pollutionPerSecond * 2.0f);
        }
        pollutionPerSecond = (int)((float)pollutionPerSecond * turbineEff * multiEff * this.getBonusByTier() * 30.0f);
        return pollutionPerSecond;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        this.mEfficiencyIncrease = 10000;
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.hasPollution = this.getTotalPollution() >= 10000;
        this.mMaxProgresstime = 200;
        this.mEUt = (int)(-this.getEUt());
        if (!this.hasPollution) {
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        ItemStack aStack = this.getControllerSlot();
        if (!this.isCorrectMachinePart(aStack)) {
            return CheckRecipeResultRegistry.NO_TURBINE_FOUND;
        }
        float damage = this.getTurbineDamage(aStack);
        if (damage == -1.0f) {
            return CheckRecipeResultRegistry.NO_TURBINE_FOUND;
        }
        TurbineStatCalculator turbine = new TurbineStatCalculator((MetaGeneratedTool)aStack.func_77973_b(), aStack);
        this.baseEff = turbine.getBaseEfficiency();
        this.tickCounter = 0;
        if (!this.isFilterLoaded) {
            ArrayList<ItemStack> tInputList = this.getStoredInputs();
            int tInputList_sS = tInputList.size();
            block0: for (int i = 0; i < tInputList_sS - 1; ++i) {
                for (int j = i + 1; j < tInputList_sS; ++j) {
                    if (!GTUtility.areStacksEqual(tInputList.get(i), tInputList.get(j))) continue;
                    if (tInputList.get((int)i).field_77994_a >= tInputList.get((int)j).field_77994_a) {
                        tInputList.remove(j--);
                        tInputList_sS = tInputList.size();
                        continue;
                    }
                    tInputList.remove(i--);
                    tInputList_sS = tInputList.size();
                    continue block0;
                }
            }
            ItemStack[] tInputs = Arrays.copyOfRange(tInputList.toArray(new ItemStack[0]), 0, 2);
            if (!tInputList.isEmpty()) {
                ItemStack cleanFilter = this.getCleanFilter();
                for (ItemStack input : tInputs) {
                    if (!GTUtility.areStacksEqual(input, cleanFilter, true)) continue;
                    --input.field_77994_a;
                    this.updateSlots();
                    this.filterUsageRemaining = 30;
                    this.isFilterLoaded = true;
                    break;
                }
            }
        }
        if (this.isFilterLoaded) {
            --this.filterUsageRemaining;
            if (this.filterUsageRemaining == 0) {
                this.mOutputItems = new ItemStack[]{this.getDirtyFilter()};
                this.isFilterLoaded = false;
            } else {
                this.mOutputItems = null;
            }
        }
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    private ItemStack getCleanFilter() {
        if (this.cleanFilter == null) {
            if (Mods.NewHorizonsCoreMod.isModLoaded()) {
                this.cleanFilter = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.AdsorptionFilter", 1L, 0);
            }
            if (this.cleanFilter == null) {
                this.cleanFilter = new ItemStack(Blocks.field_150348_b);
            }
        }
        return this.cleanFilter.func_77946_l();
    }

    private ItemStack getDirtyFilter() {
        if (this.dirtyFilter == null) {
            if (Mods.NewHorizonsCoreMod.isModLoaded()) {
                this.dirtyFilter = GTModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.AdsorptionFilterDirty", 1L, 0);
            }
            if (this.dirtyFilter == null) {
                this.dirtyFilter = new ItemStack(Blocks.field_150347_e);
            }
        }
        return this.dirtyFilter.func_77946_l();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74768_a("mode", this.mode);
        aNBT.func_74768_a("chunkIndex", this.chunkIndex);
        aNBT.func_74768_a("size", this.size);
        aNBT.func_74757_a("isFilterLoaded", this.isFilterLoaded);
        aNBT.func_74768_a("filterUsageRemaining", this.filterUsageRemaining);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mode = aNBT.func_74762_e("mode");
        this.chunkIndex = aNBT.func_74762_e("chunkIndex");
        this.size = aNBT.func_74762_e("size");
        this.isFilterLoaded = aNBT.func_74767_n("isFilterLoaded");
        this.filterUsageRemaining = aNBT.func_74762_e("filterUsageRemaining");
    }

    public void cleanPollution() {
        int cleaningRate = this.getPollutionCleaningRatePerSecond(this.baseEff, (float)this.mEfficiency / 10000.0f, this.isFilterLoaded);
        if (cleaningRate > 0) {
            World world = this.getBaseMetaTileEntity().getWorld();
            if (this.mode == 0) {
                this.removePollutionFromChunk(cleaningRate, world, this.chunkIndex);
                ++this.chunkIndex;
                if (this.chunkIndex >= this.size * this.size) {
                    this.chunkIndex = 0;
                }
            } else {
                int index;
                ArrayList<Integer> pollutedChunks = new ArrayList<Integer>();
                for (index = 0; index < this.size * this.size; ++index) {
                    if (this.getPollutionInChunk(world, index) <= 0) continue;
                    pollutedChunks.add(index);
                }
                if (!pollutedChunks.isEmpty()) {
                    index = (Integer)pollutedChunks.get(RANDOM.nextInt(pollutedChunks.size()));
                    this.removePollutionFromChunk(cleaningRate, world, index);
                }
            }
        }
    }

    protected final int getPollutionInChunk(World world, int chunkIndexIn) {
        int xCoordMulti = this.getBaseMetaTileEntity().getXCoord();
        int zCoordMulti = this.getBaseMetaTileEntity().getZCoord();
        int chunkX = xCoordMulti - 16 * (this.size / 2 - chunkIndexIn % this.size) >> 4;
        int chunkZ = zCoordMulti + 16 * (this.size / 2 - chunkIndexIn / this.size) >> 4;
        return Pollution.getPollution(world, chunkX, chunkZ);
    }

    protected final void removePollutionFromChunk(int amount, World world, int chunkIndexIn) {
        int xCoordMulti = this.getBaseMetaTileEntity().getXCoord();
        int zCoordMulti = this.getBaseMetaTileEntity().getZCoord();
        int chunkX = xCoordMulti - 16 * (this.size / 2 - chunkIndexIn % this.size) >> 4;
        int chunkZ = zCoordMulti + 16 * (this.size / 2 - chunkIndexIn / this.size) >> 4;
        Pollution.addPollution(world, chunkX, chunkZ, -amount);
    }

    public abstract int getPipeMeta();

    public abstract int getCasingMeta();

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.size == 0) {
            this.size = 2 * this.multiTier + 1;
        }
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    public int getTotalPollution() {
        int pollutionAmount = 0;
        World world = this.getBaseMetaTileEntity().getWorld();
        for (int i = 0; i < this.size * this.size; ++i) {
            pollutionAmount += this.getPollutionInChunk(world, i);
        }
        return pollutionAmount;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aTick % 200L == 0L) {
            int Xpos = aBaseMetaTileEntity.getXCoord() + aBaseMetaTileEntity.getBackFacing().offsetX;
            int Ypos = aBaseMetaTileEntity.getYCoord() + 3;
            int Zpos = aBaseMetaTileEntity.getZCoord() + aBaseMetaTileEntity.getBackFacing().offsetZ;
            try {
                aBaseMetaTileEntity.getWorld().func_147458_c(Xpos - 1, Ypos, Zpos - 1, Xpos + 1, Ypos, Zpos + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void onValueUpdate(byte aValue) {
        this.mFormed = aValue == 1;
        this.setTurbineOverlay();
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        if (this.getBaseMetaTileEntity().isClientSide()) {
            GTUtilityClient.clearTurbineOverlay(this.overlayTickets);
        }
    }

    @Override
    public byte getUpdateData() {
        return (byte)(this.mMachine ? 1 : 0);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.setTurbineOverlay();
    }

    protected void setTurbineOverlay() {
        IGregTechTileEntity tile = this.getBaseMetaTileEntity();
        if (tile.isServerSide()) {
            return;
        }
        IIconContainer[] tTextures = this.getBaseMetaTileEntity().isActive() ? Textures.BlockIcons.TURBINE_NEW_ACTIVE : Textures.BlockIcons.TURBINE_NEW;
        int[] xyz = new int[3];
        ExtendedFacing ext = this.getExtendedFacing();
        ext.getWorldOffset(new int[]{0, -3, 1}, xyz);
        GTUtilityClient.setTurbineOverlay(tile.getWorld(), xyz[0] + tile.getXCoord(), xyz[1] + tile.getYCoord(), xyz[2] + tile.getZCoord(), this.getExtendedFacing(), tTextures, this.overlayTickets);
    }

    @Override
    public void onTextureUpdate() {
        this.setTurbineOverlay();
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.tickCounter == 19 && this.hasPollution) {
            this.cleanPollution();
            this.tickCounter = 0;
        } else {
            ++this.tickCounter;
        }
        return super.onRunningTick(aStack);
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        try {
            if (this.isCorrectMachinePart(aStack) && this.hasPollution) {
                return this.getBaseMetaTileEntity().getRandomNumber(2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (!aPlayer.func_70093_af()) {
            int n = this.mode = this.mode == 1 ? 0 : 1;
            if (this.mode == 0) {
                this.chunkIndex = 0;
                aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Electric air filter now running in normal mode"));
            } else {
                aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Electric air filter now running in random mode"));
            }
        } else {
            this.size = this.size == 1 ? 2 * this.multiTier + 1 : (this.size -= 2);
            this.chunkIndex = 0;
            aPlayer.func_145747_a((IChatComponent)new ChatComponentText("Electric air filter is now working in a " + this.size + "x" + this.size + " area"));
        }
    }

    @Override
    public String[] getInfoData() {
        return new String[]{StatCollector.func_74837_a((String)"GT5U.infodata.progress", (Object[])new Object[]{EnumChatFormatting.GREEN + Integer.toString(this.mProgresstime / 20) + EnumChatFormatting.RESET, EnumChatFormatting.YELLOW + Integer.toString(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"GT5U.infodata.energy", (Object[])new Object[]{EnumChatFormatting.GREEN + Long.toString(this.getBaseMetaTileEntity().getStoredEU()) + EnumChatFormatting.RESET, EnumChatFormatting.YELLOW + Long.toString(this.getBaseMetaTileEntity().getEUCapacity()) + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"GT5U.infodata.probably_uses", (Object[])new Object[]{EnumChatFormatting.RED + Integer.toString(Math.abs(this.mEUt)) + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"GT5U.infodata.max_energy_income_tier", (Object[])new Object[]{EnumChatFormatting.YELLOW + Long.toString(this.getMaxInputVoltage()) + EnumChatFormatting.RESET, EnumChatFormatting.YELLOW + GTValues.VN[GTUtility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"GT5U.infodata.problems_efficiency", (Object[])new Object[]{EnumChatFormatting.RED + Integer.toString(this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET, EnumChatFormatting.YELLOW + Float.toString((float)this.mEfficiency / 100.0f) + EnumChatFormatting.RESET + " %"}), StatCollector.func_74837_a((String)"GT5U.infodata.air_filter.pollution_reduction", (Object[])new Object[]{EnumChatFormatting.GREEN + Integer.toString(this.getPollutionCleaningRatePerTick(this.baseEff, (float)this.mEfficiency / 10000.0f, this.isFilterLoaded)) + EnumChatFormatting.RESET}), StatCollector.func_74837_a((String)"GT5U.infodata.air_filter.has_filter", (Object[])new Object[]{this.isFilterLoaded}), StatCollector.func_74837_a((String)"GT5U.infodata.air_filter.remaining_cycles", (Object[])new Object[]{this.filterUsageRemaining})};
    }
}

