/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.ParticleFX;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ISecondaryDescribable;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTETooltipMultiBlockBase;
import gregtech.api.objects.XSTR;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.pollution.Pollution;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.ChunkPosition;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class MTECharcoalPit
extends MTETooltipMultiBlockBase
implements ISecondaryDescribable {
    private boolean running = false;

    public MTECharcoalPit(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTECharcoalPit(String aName) {
        super(aName);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return (facing.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) == 0;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        return false;
    }

    @Override
    @Nonnull
    public CheckRecipeResult checkProcessing() {
        if (!this.checkRecursiveBlocks()) {
            this.mEfficiency = 0;
            this.mEfficiencyIncrease = 0;
            this.mMaxProgresstime = 0;
            this.running = false;
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        if (this.mEfficiency == 0) {
            this.mEfficiency = 10000;
            this.mEfficiencyIncrease = 10000;
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            Pollution.addPollution(this.getBaseMetaTileEntity(), this.mMaxProgresstime * this.getPollutionPerTick(null));
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        this.mEfficiency = 0;
        this.mEfficiencyIncrease = 0;
        this.mMaxProgresstime = 0;
        return CheckRecipeResultRegistry.NO_RECIPE;
    }

    private boolean checkRecursiveBlocks() {
        ArrayList tList1 = new ArrayList();
        ArrayList<ChunkPosition> tList2 = new ArrayList<ChunkPosition>();
        Block tBlock = this.getBaseMetaTileEntity().getBlockOffset(0, -1, 0);
        if (this.isWoodLog(tBlock, this.getBaseMetaTileEntity().getMetaIDOffset(0, -1, 0))) {
            tList2.add(new ChunkPosition(0, -1, 0));
        } else {
            return false;
        }
        while (!tList2.isEmpty()) {
            ChunkPosition tPos = (ChunkPosition)tList2.get(0);
            tList2.remove(0);
            if (this.checkAllBlockSides(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c, tList1, tList2)) continue;
            return false;
        }
        if (this.running) {
            for (ChunkPosition tPos : tList1) {
                if (!this.isWoodLog(this.getBaseMetaTileEntity().getBlockOffset(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c), this.getBaseMetaTileEntity().getMetaIDOffset(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c))) continue;
                this.getBaseMetaTileEntity().getWorld().func_147465_d(this.getBaseMetaTileEntity().getXCoord() + tPos.field_151329_a, this.getBaseMetaTileEntity().getYCoord() + tPos.field_151327_b, this.getBaseMetaTileEntity().getZCoord() + tPos.field_151328_c, GregTechAPI.sBlockReinforced, 4, 3);
            }
            this.running = false;
            return false;
        }
        this.mMaxProgresstime = (int)Math.sqrt(tList1.size() * 240000);
        this.running = true;
        return true;
    }

    private boolean isWoodLog(Block log, int meta) {
        for (int id : OreDictionary.getOreIDs((ItemStack)new ItemStack(log, 1, meta))) {
            if (!OreDictionary.getOreName((int)id).equals("logWood")) continue;
            return true;
        }
        String tTool = log.getHarvestTool(meta);
        return OrePrefixes.log.contains(new ItemStack(log, 1, meta)) && "axe".equals(tTool) && log.func_149688_o() == Material.field_151575_d;
    }

    private boolean checkAllBlockSides(int aX, int aY, int aZ, ArrayList<? super ChunkPosition> aList1, ArrayList<? super ChunkPosition> aList2) {
        boolean expandToChunkXPos = false;
        boolean expandToChunkXNeg = false;
        boolean expandToChunkYPos = false;
        boolean expandToChunkYNeg = false;
        boolean expandToChunkZPos = false;
        boolean expandToChunkZNeg = false;
        Block blockXPos = this.getBaseMetaTileEntity().getBlockOffset(aX + 1, aY, aZ);
        if (aX + 1 < 6 && this.isWoodLog(blockXPos, this.getBaseMetaTileEntity().getMetaIDOffset(aX + 1, aY, aZ))) {
            if (!aList1.contains(new ChunkPosition(aX + 1, aY, aZ)) && !aList2.contains(new ChunkPosition(aX + 1, aY, aZ))) {
                expandToChunkXPos = true;
            }
        } else if (blockXPos != Blocks.field_150346_d && blockXPos != Blocks.field_150349_c) {
            return false;
        }
        Block blockXNeg = this.getBaseMetaTileEntity().getBlockOffset(aX - 1, aY, aZ);
        if (aX - 1 > -6 && this.isWoodLog(blockXNeg, this.getBaseMetaTileEntity().getMetaIDOffset(aX - 1, aY, aZ))) {
            if (!aList1.contains(new ChunkPosition(aX - 1, aY, aZ)) && !aList2.contains(new ChunkPosition(aX - 1, aY, aZ))) {
                expandToChunkXNeg = true;
            }
        } else if (blockXNeg != Blocks.field_150346_d && blockXNeg != Blocks.field_150349_c) {
            return false;
        }
        Block blockYPos = this.getBaseMetaTileEntity().getBlockOffset(aX, aY + 1, aZ);
        if (aY + 1 < 1 && this.isWoodLog(blockYPos, this.getBaseMetaTileEntity().getMetaIDOffset(aX, aY + 1, aZ))) {
            if (!aList1.contains(new ChunkPosition(aX, aY + 1, aZ)) && !aList2.contains(new ChunkPosition(aX, aY + 1, aZ))) {
                expandToChunkYPos = true;
            }
        } else if (blockYPos != Blocks.field_150346_d && blockYPos != Blocks.field_150349_c && (aX != 0 || aY != -1 || aZ != 0 || blockYPos != GregTechAPI.sBlockMachines)) {
            return false;
        }
        Block blockYNeg = this.getBaseMetaTileEntity().getBlockOffset(aX, aY - 1, aZ);
        if (aY - 1 > -6 && this.isWoodLog(blockYNeg, this.getBaseMetaTileEntity().getMetaIDOffset(aX, aY - 1, aZ))) {
            if (!aList1.contains(new ChunkPosition(aX, aY - 1, aZ)) && !aList2.contains(new ChunkPosition(aX, aY - 1, aZ))) {
                expandToChunkYNeg = true;
            }
        } else if (blockYNeg != Blocks.field_150336_V) {
            return false;
        }
        Block blockZPos = this.getBaseMetaTileEntity().getBlockOffset(aX, aY, aZ + 1);
        if (aZ + 1 < 6 && this.isWoodLog(blockZPos, this.getBaseMetaTileEntity().getMetaIDOffset(aX, aY, aZ + 1))) {
            if (!aList1.contains(new ChunkPosition(aX, aY, aZ + 1)) && !aList2.contains(new ChunkPosition(aX, aY, aZ + 1))) {
                expandToChunkZPos = true;
            }
        } else if (blockZPos != Blocks.field_150346_d && blockZPos != Blocks.field_150349_c) {
            return false;
        }
        Block blockZNeg = this.getBaseMetaTileEntity().getBlockOffset(aX, aY, aZ - 1);
        if (aZ - 1 > -6 && this.isWoodLog(blockZNeg, this.getBaseMetaTileEntity().getMetaIDOffset(aX, aY, aZ - 1))) {
            if (!aList1.contains(new ChunkPosition(aX, aY, aZ - 1)) && !aList2.contains(new ChunkPosition(aX, aY, aZ - 1))) {
                expandToChunkZNeg = true;
            }
        } else if (blockZNeg != Blocks.field_150346_d && blockZNeg != Blocks.field_150349_c) {
            return false;
        }
        aList1.add((ChunkPosition)new ChunkPosition(aX, aY, aZ));
        if (expandToChunkXPos) {
            aList2.add((ChunkPosition)new ChunkPosition(aX + 1, aY, aZ));
        }
        if (expandToChunkXNeg) {
            aList2.add((ChunkPosition)new ChunkPosition(aX - 1, aY, aZ));
        }
        if (expandToChunkYPos) {
            aList2.add((ChunkPosition)new ChunkPosition(aX, aY + 1, aZ));
        }
        if (expandToChunkYNeg) {
            aList2.add((ChunkPosition)new ChunkPosition(aX, aY - 1, aZ));
        }
        if (expandToChunkZPos) {
            aList2.add((ChunkPosition)new ChunkPosition(aX, aY, aZ + 1));
        }
        if (expandToChunkZNeg) {
            aList2.add((ChunkPosition)new ChunkPosition(aX, aY, aZ - 1));
        }
        return true;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        return true;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return GTMod.proxy.mPollutionCharcoalPitPerSecond;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTECharcoalPit(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Charcoal Pile Igniter").addInfo("Converts Logs into Brittle Charcoal blocks").addInfo("Will automatically start when valid").addPollutionAmount(this.getPollutionPerSecond(null)).beginVariableStructureBlock(3, 13, 3, 7, 3, 13, false).addStructureInfo("Can be up to 13x7x13 in size, including the dirt; shape doesn't matter").addOtherStructurePart("Controller", "Top layer, directly touching a wood log").addOtherStructurePart("Dirt/Grass", "Top and middle layers, covering wood logs").addOtherStructurePart("Bricks", "Bottom layer, under all wood logs").addOtherStructurePart("Wood Logs", "Up to 5 layers, inside the previously mentioned blocks").addStructureInfo("No air between logs allowed.").addStructureInfo("All logs must be within 6 x/z of the controller, so it must be dead-center for a full 11x11 square of wood.").toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == ForgeDirection.UP) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][10], TextureFactory.of(Textures.BlockIcons.OVERLAY_CHARCOAL_PIT_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_CHARCOAL_PIT_ACTIVE_GLOW).glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][10], TextureFactory.of(Textures.BlockIcons.OVERLAY_CHARCOAL_PIT)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][10]};
    }

    @Override
    public boolean polluteEnvironment(int aPollutionLevel) {
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        super.onPostTick(aBaseMetaTileEntity, aTimer);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive()) {
            ((WorldSpawnedEventBuilder.ParticleEventBuilder)new WorldSpawnedEventBuilder.ParticleEventBuilder().setMotion(0.0, 0.3, 0.0).setIdentifier((Enum)ParticleFX.LARGE_SMOKE)).setPosition((float)aBaseMetaTileEntity.getOffsetX(ForgeDirection.UP, 1) + XSTR.XSTR_INSTANCE.nextFloat(), aBaseMetaTileEntity.getOffsetY(ForgeDirection.UP, 1), (float)aBaseMetaTileEntity.getOffsetZ(ForgeDirection.UP, 1) + XSTR.XSTR_INSTANCE.nextFloat()).setWorld(this.getBaseMetaTileEntity().getWorld()).run();
        }
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }
}

