/*
 * Decompiled with CFR 0.152.
 */
package kekztech.common.tileentities;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.ItemStackPredicate;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.fluid.GTFluidTank;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.items.ItemIntegratedCircuit;
import gregtech.common.misc.GTStructureChannels;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import kekztech.common.Blocks;
import kekztech.common.tileentities.MTEHatchTFFT;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.jetbrains.annotations.NotNull;

public class MTETankTFFT
extends MTEEnhancedMultiBlockBase<MTETankTFFT>
implements ISurvivalConstructable {
    private static final IIconContainer TEXTURE_TFFT = new Textures.BlockIcons.CustomIcon("iconsets/TFFT");
    private static final IIconContainer TEXTURE_TFFT_ACTIVE = new Textures.BlockIcons.CustomIcon("iconsets/TFFT_ACTIVE");
    private static final IIconContainer TEXTURE_TFFT_ACTIVE_GLOW = new Textures.BlockIcons.CustomIcon("iconsets/TFFT_ACTIVE_GLOW");
    private static final int CASING_TEXTURE_ID_1 = 1663;
    private static final int CASING_TEXTURE_ID_2 = 176;
    private static final Block TFFT_FIELD = Blocks.tfftStorageField;
    private static final Item TFFT_FIELD_ITEM = Item.func_150898_a((Block)TFFT_FIELD);
    public static final int MAX_DISTINCT_FLUIDS = 25;
    private static final BigInteger MAX_CAPACITY = BigInteger.valueOf(Long.MAX_VALUE).multiply(BigInteger.valueOf(25L));
    private static final int CASING_META = 0;
    private static final int MIN_CASING_AMOUNT = 20;
    private static final int MAX_LAYER_AMOUNT = 13;
    private static final int DEFAULT_LAYER_AMOUNT = 3;
    private int glassTier = -1;
    private static final String STRUCTURE_PIECE_TOP = "top";
    private static final String STRUCTURE_PIECE_MID = "mid";
    private static final String STRUCTURE_PIECE_BOTTOM = "bottom";
    private static final String[] description = new String[]{StatCollector.func_74838_a((String)"tile.kekztech_tfftstoragefield_block.hint.1"), StatCollector.func_74838_a((String)"tile.kekztech_tfftstoragefield_block.hint.2"), StatCollector.func_74838_a((String)"tile.kekztech_tfftstoragefield_block.hint.3"), StatCollector.func_74838_a((String)"tile.kekztech_tfftstoragefield_block.hint.4")};
    private static final IStructureDefinition<MTETankTFFT> STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("top", StructureUtility.transpose((String[][])new String[][]{{"ccccc"}, {"cCCCc"}, {"cC~Cc"}, {"cCCCc"}, {"ccccc"}})).addShape("mid", StructureUtility.transpose((String[][])new String[][]{{"gGGGg"}, {"GfffG"}, {"GfffG"}, {"GfffG"}, {"gGGGg"}})).addShape("bottom", StructureUtility.transpose((String[][])new String[][]{{"ccccc"}, {"cCCCc"}, {"cCCCc"}, {"cCCCc"}, {"ccccc"}})).addElement('c', GTStructureUtility.buildHatchAdder(MTETankTFFT.class).atLeast(HatchElement.Energy, HatchElement.Maintenance).casingIndex(1663).dot(1).buildAndChain(StructureUtility.onElementPass(te -> ++te.casingAmount, (IStructureElement)StructureUtility.ofBlock((Block)TFFT_FIELD, (int)0)))).addElement('C', GTStructureUtility.buildHatchAdder(MTETankTFFT.class).casingIndex(1663).atLeast(HatchElement.Energy, HatchElement.Maintenance, HatchElement.InputHatch.or(TFFTMultiHatch.INSTANCE), HatchElement.OutputHatch.or(TFFTMultiHatch.INSTANCE)).dot(2).buildAndChain(StructureUtility.onElementPass(te -> ++te.casingAmount, (IStructureElement)StructureUtility.ofBlock((Block)TFFT_FIELD, (int)0)))).addElement('G', GTStructureUtility.buildHatchAdder(MTETankTFFT.class).atLeast(HatchElement.InputHatch.or(TFFTMultiHatch.INSTANCE), HatchElement.OutputHatch.or(TFFTMultiHatch.INSTANCE)).casingIndex(176).dot(3).buildAndChain(GTStructureUtility.chainAllGlasses(-1, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier))).addElement('g', GTStructureUtility.chainAllGlasses(-1, (te, t) -> {
        te.glassTier = t;
    }, te -> te.glassTier)).addElement('f', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{TFFTStorageFieldElement.INSTANCE})).build();
    public final GTFluidTank[] STORE = new GTFluidTank[25];
    private final int[] FIELDS;
    private BigInteger capacity;
    private long capacityPerFluid;
    private int casingAmount;
    private int runningCost;
    private boolean locked;
    private boolean doVoidExcess;
    private byte fluidSelector;
    private MTEHatchTFFT tfftHatch;

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    public MTETankTFFT(String aName) {
        super(aName);
        for (int i = 0; i < 25; ++i) {
            this.STORE[i] = new GTFluidTank(0L);
        }
        this.FIELDS = new int[Field.VALUES.length];
        this.capacity = BigInteger.ZERO;
        this.capacityPerFluid = 0L;
        this.casingAmount = 0;
        this.runningCost = 0;
        this.locked = true;
        this.doVoidExcess = false;
        this.fluidSelector = (byte)-1;
        this.tfftHatch = null;
    }

    public MTETankTFFT(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        for (int i = 0; i < 25; ++i) {
            this.STORE[i] = new GTFluidTank(0L);
        }
        this.FIELDS = new int[Field.VALUES.length];
        this.capacity = BigInteger.ZERO;
        this.capacityPerFluid = 0L;
        this.casingAmount = 0;
        this.runningCost = 0;
        this.locked = true;
        this.doVoidExcess = false;
        this.fluidSelector = (byte)-1;
        this.tfftHatch = null;
    }

    @Override
    public IStructureDefinition<MTETankTFFT> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTETankTFFT(this.mName);
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1663), TextureFactory.builder().addIcon(TEXTURE_TFFT_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(TEXTURE_TFFT_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1663), TextureFactory.builder().addIcon(TEXTURE_TFFT).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1663)};
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Fluid Tank").addInfo("High-Tech fluid tank that can hold up to 25 different fluids!").addInfo("Has 1/25th of the total capacity as capacity for each fluid").addInfo("Right clicking the controller with a screwdriver will turn on excess voiding").addInfo("Fluid storage amount and running cost depends on the storage field blocks used").addSeparator().addInfo("Note on hatch locking:").addInfo("Use an Integrated Circuit in the GUI slot to limit which fluid is output").addInfo("The index of a stored fluid can be obtained through the Tricorder").beginVariableStructureBlock(5, 5, 5, 15, 5, 5, false).addController("Top Center").addCasingInfoMin("T.F.F.T Casing", 20, false).addCasingInfoRange("Storage Field Blocks", 7, 117, true).addStructureInfo("Energy hatch is not required when running cost is 0").addCasingInfoRange("Any Tiered Glass (EV+)", 48, 208, false).addMaintenanceHatch("Any top or bottom casing").addEnergyHatch("Any top or bottom casing").addInputHatch("Instead of any casing or glass, has to touch storage field block").addOutputHatch("Instead of any casing or glass, has to touch storage field block").addStructureInfo("You can have a bunch of hatches").addOtherStructurePart("Multi I/O Hatches", "Instead of any casing or glass, has to touch storage field block").addStructureInfo("Use MIOH with conduits or fluid storage buses to see all fluids at once.").addSubChannelUsage(GTStructureChannels.BOROGLASS).toolTipFinisher(new String[0]);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int layer = GTStructureChannels.STRUCTURE_HEIGHT.getValueClamped(stackSize, 3, 13);
        this.buildPiece(STRUCTURE_PIECE_TOP, stackSize, hintsOnly, 2, 2, 0);
        for (int i = 1; i <= layer; ++i) {
            this.buildPiece(STRUCTURE_PIECE_MID, stackSize, hintsOnly, 2, 2, -i);
        }
        this.buildPiece(STRUCTURE_PIECE_BOTTOM, stackSize, hintsOnly, 2, 2, -layer - 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int build = this.survivalBuildPiece(STRUCTURE_PIECE_TOP, stackSize, 2, 2, 0, elementBudget, env, false, true);
        if (build >= 0) {
            return build;
        }
        int layer = GTStructureChannels.STRUCTURE_HEIGHT.getValueClamped(stackSize, 3, 13);
        for (int i = 1; i <= layer; ++i) {
            build = this.survivalBuildPiece(STRUCTURE_PIECE_MID, stackSize, 2, 2, -i, elementBudget, env, false, true);
            if (build < 0) continue;
            return build;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_BOTTOM, stackSize, 2, 2, -layer - 1, elementBudget, env, false, true);
    }

    @Override
    public void clearHatches() {
        super.clearHatches();
        if (this.tfftHatch != null) {
            this.tfftHatch.unbind();
            this.tfftHatch = null;
        }
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        Arrays.fill(this.FIELDS, 0);
        this.capacity = BigInteger.ZERO;
        this.capacityPerFluid = 0L;
        this.casingAmount = 0;
        this.runningCost = 0;
        this.glassTier = -1;
        if (!this.checkPiece(STRUCTURE_PIECE_TOP, 2, 2, 0)) {
            return false;
        }
        int layer = 1;
        while (this.checkPiece(STRUCTURE_PIECE_MID, 2, 2, -layer)) {
            ++layer;
        }
        if (layer - 1 > 13 || layer - 1 < 3) {
            return false;
        }
        if (!this.checkPiece(STRUCTURE_PIECE_BOTTOM, 2, 2, -layer)) {
            return false;
        }
        if (this.casingAmount >= 20 && (this.tfftHatch != null || !this.mInputHatches.isEmpty() && !this.mOutputHatches.isEmpty()) && this.mInputHatches.size() + this.mOutputHatches.size() <= 50) {
            BigInteger tempCap = BigInteger.ZERO;
            for (int i = 0; i < this.FIELDS.length; ++i) {
                tempCap = tempCap.add(BigInteger.valueOf(Field.VALUES[i].getCapacity()).multiply(BigInteger.valueOf(this.FIELDS[i])));
                this.runningCost += Field.VALUES[i].getCost() * this.FIELDS[i];
            }
            this.setCapacity(tempCap);
            if (this.tfftHatch != null) {
                this.tfftHatch.bind(this);
            }
            if (this.runningCost == 0) {
                return true;
            }
            return !this.mEnergyHatches.isEmpty() && this.glassTier >= 4;
        }
        return false;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        this.mEUt = this.runningCost;
        this.mMaxProgresstime = 20;
        ItemStack itemStack = this.getControllerSlot();
        this.fluidSelector = (byte)(itemStack != null && itemStack.func_77973_b() instanceof ItemIntegratedCircuit ? (int)itemStack.func_77960_j() : -1);
        ArrayList<FluidStack> inputFluids = this.getStoredFluids();
        if (!inputFluids.isEmpty()) {
            for (FluidStack aFluid : inputFluids) {
                FluidStack toDeplete = aFluid.copy();
                toDeplete.amount = this.pull(aFluid, true);
                this.depleteInput(toDeplete);
            }
        }
        if (!this.mOutputHatches.isEmpty()) {
            boolean isFluidSelected;
            GTFluidTank sFluid = this.getSelectedFluid();
            boolean bl = isFluidSelected = this.fluidSelector != -1;
            if (!isFluidSelected || !sFluid.isEmpty()) {
                for (MTEHatchOutput tHatch : this.mOutputHatches) {
                    boolean isFluidEmpty;
                    int hatchAmount;
                    int hatchCapacity = tHatch.getCapacity();
                    int remaining = hatchCapacity - (hatchAmount = tHatch.getFluidAmount());
                    if (remaining <= 0) continue;
                    FluidStack tFluid = tHatch.getFluid();
                    String lockedFluidName = tHatch.getLockedFluidName() == null ? "" : tHatch.getLockedFluidName();
                    String tFluidName = tFluid == null ? "" : tFluid.getFluid().getName();
                    boolean isFluidLocked = tHatch.isFluidLocked();
                    boolean bl2 = isFluidEmpty = tFluid == null || tHatch.getFluidAmount() == 0;
                    if (isFluidLocked && !this.contains(lockedFluidName) || !isFluidEmpty && !this.contains(tFluid) || isFluidLocked && !isFluidEmpty && !lockedFluidName.equals(tFluidName)) continue;
                    if (isFluidSelected) {
                        if (isFluidLocked && !lockedFluidName.equals(sFluid.name()) || !isFluidEmpty && !sFluid.contains(tFluid)) continue;
                        tHatch.fill(this.push(sFluid.get(remaining), true), true);
                        continue;
                    }
                    if (isFluidLocked) {
                        if (!isFluidEmpty && !lockedFluidName.equals(tFluid.getFluid().getName())) continue;
                        FluidStack aFluid = FluidRegistry.getFluidStack((String)lockedFluidName, (int)remaining);
                        tHatch.fill(this.push(aFluid, true), true);
                        continue;
                    }
                    if (isFluidEmpty) {
                        if (this.firstNotNull() == null) continue;
                        tHatch.fill(this.push(hatchCapacity, true), true);
                        continue;
                    }
                    tHatch.fill(this.push(new FluidStack(tFluid, remaining), true), true);
                }
            }
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide()) {
            this.locked = !aBaseMetaTileEntity.isActive();
        }
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> ll = new ArrayList<String>();
        NumberFormat nf = NumberFormat.getNumberInstance();
        ll.add(EnumChatFormatting.YELLOW + StatCollector.func_74837_a((String)"kekztech.infodata.tank.tfft.stored_fluids", (Object[])new Object[0]) + EnumChatFormatting.RESET);
        for (int i = 0; i < 25; ++i) {
            GTFluidTank tank = this.STORE[i];
            if (tank.isEmpty()) {
                ll.add(MessageFormat.format("{0} - {1}: {2}L ({3}%)", i, StatCollector.func_74838_a((String)"kekztech.infodata.tank.tfft.stored_fluids.null"), 0, 0));
                continue;
            }
            String localizedName = this.STORE[i].get().getLocalizedName();
            String amount = nf.format(this.STORE[i].amount());
            String percentage = this.capacityPerFluid > 0L ? String.valueOf(this.STORE[i].amount() * 100L / this.capacityPerFluid) : "";
            ll.add(MessageFormat.format("{0} - {1}: {2}L ({3}%)", i, localizedName, amount, percentage));
        }
        ll.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"kekztech.infodata.operational_data") + EnumChatFormatting.RESET);
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.tank.tfft.used", (Object[])new Object[]{nf.format(this.getStoredAmount())}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.tank.tfft.total", (Object[])new Object[]{nf.format(this.capacity)}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.tank.tfft.per_fluid_capacity", (Object[])new Object[]{nf.format(this.capacityPerFluid)}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.tank.tfft.running_cost", (Object[])new Object[]{this.getActualEnergyUsage()}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.tank.tfft.auto_voiding", (Object[])new Object[]{this.doVoidExcess}));
        ll.add(StatCollector.func_74837_a((String)"kekztech.infodata.multi.maintenance_status", (Object[])new Object[]{this.getRepairStatus() == this.getIdealStatus() ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"kekztech.infodata.multi.maintenance_status.ok") + EnumChatFormatting.RESET : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"kekztech.infodata.multi.maintenance_status.bad") + EnumChatFormatting.RESET}));
        ll.add(EnumChatFormatting.STRIKETHROUGH + "---------------------------------------------");
        return ll.toArray(new String[0]);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74773_a("capacity", this.capacity.toByteArray());
        aNBT.func_74757_a("doVoidExcess", this.doVoidExcess);
        aNBT.func_74768_a("runningCost", this.runningCost);
        aNBT.func_74757_a("lockFluid", this.locked);
        aNBT.func_74774_a("fluidSelector", this.fluidSelector);
        NBTTagCompound fluidNBT = new NBTTagCompound();
        aNBT.func_74782_a("STORE", (NBTBase)fluidNBT);
        for (int i = 0; i < 25; ++i) {
            this.STORE[i].writeToNBT(fluidNBT, String.valueOf(i));
        }
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.setCapacity(new BigInteger(aNBT.func_74770_j("capacity")));
        this.setDoVoidExcess(aNBT.func_74767_n("doVoidExcess"));
        this.runningCost = aNBT.func_74762_e("runningCost");
        this.locked = aNBT.func_74767_n("lockFluid");
        this.fluidSelector = aNBT.func_74771_c("fluidSelector");
        NBTTagCompound fluidNBT = (NBTTagCompound)aNBT.func_74781_a("STORE");
        for (int i = 0; i < 25; ++i) {
            this.STORE[i].readFromNBT(fluidNBT, String.valueOf(i));
        }
        super.loadNBTData(aNBT);
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ, aTool);
        this.setDoVoidExcess(!this.doVoidExcess);
        GTUtility.sendChatToPlayer(aPlayer, "Auto-voiding " + (this.doVoidExcess ? "enabled" : "disabled"));
    }

    private boolean addMultiHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity;
        if (aTileEntity != null && (aMetaTileEntity = aTileEntity.getMetaTileEntity()) instanceof MTEHatchTFFT) {
            if (this.tfftHatch != null) {
                return false;
            }
            this.tfftHatch = (MTEHatchTFFT)aMetaTileEntity;
            this.tfftHatch.updateTexture(aBaseCasingIndex);
            return true;
        }
        return false;
    }

    public int pull(FluidStack aFluid, boolean doPull) {
        if (this.locked) {
            return 0;
        }
        int index = this.getFluidPosition(aFluid);
        if (index >= 0) {
            return this.STORE[index].fill(aFluid, doPull);
        }
        if (this.fluidCount() < 25) {
            return this.STORE[this.getNullSlot()].setCapacity(this.capacityPerFluid).fill(aFluid, doPull);
        }
        return 0;
    }

    public long pull(FluidStack aFluid, long amount, boolean doPull) {
        if (this.locked) {
            return 0L;
        }
        int index = this.getFluidPosition(aFluid);
        if (index >= 0) {
            GTFluidTank tank = this.STORE[index];
            if (doPull) {
                return tank.add(amount);
            }
            return this.doVoidExcess ? amount : (tank.amount() + amount > tank.capacity() ? tank.capacity() - tank.amount() : amount);
        }
        if (this.fluidCount() < 25) {
            GTFluidTank tank = this.STORE[this.getNullSlot()];
            if (doPull) {
                return tank.add(amount, aFluid);
            }
            return this.doVoidExcess ? amount : Math.min(amount, tank.capacity());
        }
        return 0L;
    }

    public FluidStack push(FluidStack aFluid, boolean doPush) {
        if (this.locked) {
            return null;
        }
        int index = this.getFluidPosition(aFluid);
        if (index < 0) {
            return null;
        }
        return this.STORE[index].drain(aFluid.amount, doPush);
    }

    public FluidStack push(int amount, boolean doPush) {
        if (this.locked) {
            return null;
        }
        int index = this.firstNotNullSlot();
        if (index < 0) {
            return null;
        }
        return this.STORE[index].drain(amount, doPush);
    }

    public long push(FluidStack aFluid, long amount, boolean doPush) {
        if (this.locked) {
            return 0L;
        }
        int index = this.getFluidPosition(aFluid);
        if (index < 0) {
            return 0L;
        }
        if (doPush) {
            return this.STORE[index].remove(amount);
        }
        return this.STORE[index].amount(amount);
    }

    public long getCapacityPerFluid() {
        return this.capacityPerFluid;
    }

    public void setCapacity(BigInteger capacity) {
        if (capacity.compareTo(MAX_CAPACITY) > 0) {
            this.capacity = MAX_CAPACITY;
            this.capacityPerFluid = Long.MAX_VALUE;
        } else {
            this.capacity = capacity;
            this.capacityPerFluid = capacity.divide(BigInteger.valueOf(25L)).longValue();
        }
        for (int i = 0; i < 25; ++i) {
            GTFluidTank tank = this.STORE[i];
            if (tank.setCapacity(this.capacityPerFluid).amount() <= this.capacityPerFluid) continue;
            this.STORE[i] = new GTFluidTank(tank.get(), this.capacityPerFluid, this.capacityPerFluid);
        }
    }

    public int fluidCount() {
        int tCount = 0;
        for (int i = 0; i < 25; ++i) {
            if (this.STORE[i].isEmpty()) continue;
            ++tCount;
        }
        return tCount;
    }

    public int getFluidPosition(String fluidName) {
        for (int i = 0; i < 25; ++i) {
            if (this.STORE[i].isEmpty() || !this.STORE[i].name().equals(fluidName)) continue;
            return i;
        }
        return -1;
    }

    public int getFluidPosition(FluidStack aFluid) {
        for (int i = 0; i < 25; ++i) {
            if (!this.STORE[i].contains(aFluid)) continue;
            return i;
        }
        return -1;
    }

    public int getNullSlot() {
        for (int i = 0; i < 25; ++i) {
            if (!this.STORE[i].isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(String fluidName) {
        return this.getFluidPosition(fluidName) >= 0;
    }

    public boolean contains(FluidStack aFluid) {
        return this.getFluidPosition(aFluid) >= 0;
    }

    public int firstNotNullSlot() {
        for (int i = 0; i < 25; ++i) {
            if (this.STORE[i].isEmpty()) continue;
            return i;
        }
        return -1;
    }

    public GTFluidTank firstNotNull() {
        for (int i = 0; i < 25; ++i) {
            if (this.STORE[i].isEmpty()) continue;
            return this.STORE[i];
        }
        return null;
    }

    public BigInteger getStoredAmount() {
        BigInteger amount = BigInteger.ZERO;
        for (int i = 0; i < 25; ++i) {
            amount = amount.add(BigInteger.valueOf(this.STORE[i].amount()));
        }
        return amount;
    }

    public byte getFluidSelector() {
        return this.fluidSelector;
    }

    public GTFluidTank getSelectedFluid() {
        return this.fluidSelector != -1 ? this.STORE[this.fluidSelector] : null;
    }

    public void setDoVoidExcess(boolean doVoidExcess) {
        this.doVoidExcess = doVoidExcess;
        for (int i = 0; i < 25; ++i) {
            this.STORE[i].setVoidExcess(doVoidExcess);
        }
    }

    public FluidTankInfo[] getTankInfo() {
        FluidTankInfo[] info = new FluidTankInfo[25];
        for (int i = 0; i < 25; ++i) {
            this.STORE[i].getFluid();
            info[i] = this.STORE[i].getInfo();
        }
        return info;
    }

    public static enum Field {
        T1(1000000L, 1),
        T2(4000000L, 2),
        T3(16000000L, 5),
        T4(64000000L, 14),
        T5(256000000L, 42),
        T6(2048000000L, 132),
        T7(131072000000L, 429),
        T8(8388608000000L, 1430),
        T9(536870912000000L, 4862),
        T10(1099511627776000000L, 0);

        public static final Field[] VALUES;
        private final long capacity;
        private final int cost;

        private Field(long capacity, int cost) {
            this.capacity = capacity;
            this.cost = cost;
        }

        public long getCapacity() {
            return this.capacity;
        }

        public int getCost() {
            return this.cost;
        }

        static {
            VALUES = Field.values();
        }
    }

    private static enum TFFTMultiHatch implements IHatchElement<MTETankTFFT>
    {
        INSTANCE(new Class[0]);

        private final List<? extends Class<? extends IMetaTileEntity>> mteClasses;

        @SafeVarargs
        private TFFTMultiHatch(Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Arrays.asList(mteClasses);
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        @Override
        public IGTHatchAdder<? super MTETankTFFT> adder() {
            return (rec$, x$0, x$1) -> ((MTETankTFFT)rec$).addMultiHatchToMachineList(x$0, x$1);
        }

        @Override
        public long count(MTETankTFFT t) {
            return t.tfftHatch == null ? 0L : 1L;
        }
    }

    private static enum TFFTStorageFieldElement implements IStructureElement<MTETankTFFT>
    {
        INSTANCE;


        public boolean check(MTETankTFFT t, World world, int x, int y, int z) {
            Block worldBlock = world.func_147439_a(x, y, z);
            int meta = worldBlock.func_149643_k(world, x, y, z);
            if (TFFT_FIELD != worldBlock || meta == 0) {
                return false;
            }
            int[] nArray = t.FIELDS;
            int n = meta - 1;
            nArray[n] = nArray[n] + 1;
            return true;
        }

        public boolean couldBeValid(MTETankTFFT t, World world, int x, int y, int z, ItemStack trigger) {
            Block worldBlock = world.func_147439_a(x, y, z);
            int meta = worldBlock.func_149643_k(world, x, y, z);
            return TFFT_FIELD == worldBlock && meta != 0;
        }

        private int getHint(ItemStack stack) {
            return GTStructureChannels.TFFT_FIELD.getValueClamped(stack, 1, Field.VALUES.length);
        }

        public boolean spawnHint(MTETankTFFT t, World world, int x, int y, int z, ItemStack trigger) {
            StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)TFFT_FIELD, (int)this.getHint(trigger));
            return true;
        }

        public boolean placeBlock(MTETankTFFT t, World world, int x, int y, int z, ItemStack trigger) {
            world.func_147465_d(x, y, z, TFFT_FIELD, this.getHint(trigger), 3);
            return true;
        }

        public IStructureElement.PlaceResult survivalPlaceBlock(MTETankTFFT t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
            if (this.check(t, world, x, y, z)) {
                return IStructureElement.PlaceResult.SKIP;
            }
            int fieldTier = this.getHint(trigger);
            boolean isPreview = !(env.getActor() instanceof EntityPlayerMP);
            ItemStack result = env.getSource().takeOne(s -> s != null && s.field_77994_a >= 0 && s.func_77973_b() == TFFT_FIELD_ITEM && s.func_77960_j() != 0 && (isPreview ? s.func_77960_j() == fieldTier : s.func_77960_j() <= fieldTier), true);
            if (result == null) {
                return IStructureElement.PlaceResult.REJECT;
            }
            return StructureUtility.survivalPlaceBlock((ItemStack)result, (ItemStackPredicate.NBTMode)ItemStackPredicate.NBTMode.EXACT, null, (boolean)true, (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
        }
    }
}

