/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.pipe;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GTMod;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.render.TextureFactory;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.TecTech;
import tectech.loader.NetworkDispatcher;
import tectech.mechanics.pipe.IActivePipe;
import tectech.mechanics.pipe.IConnectsToDataPipe;
import tectech.mechanics.pipe.PipeActivityMessage;
import tectech.util.CommonValues;

public class MTEPipeData
extends MetaPipeEntity
implements IConnectsToDataPipe,
IActivePipe {
    private static Textures.BlockIcons.CustomIcon EMpipe;
    private static Textures.BlockIcons.CustomIcon EMbar;
    private static Textures.BlockIcons.CustomIcon EMbarActive;
    public byte connectionCount = 0;
    private boolean active;

    public MTEPipeData(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 0);
    }

    public MTEPipeData(String aName) {
        super(aName, 0);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MTEPipeData(this.mName);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        EMpipe = new Textures.BlockIcons.CustomIcon("iconsets/EM_DATA");
        EMbar = new Textures.BlockIcons.CustomIcon("iconsets/EM_BAR");
        EMbarActive = new Textures.BlockIcons.CustomIcon("iconsets/EM_BAR_ACTIVE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, int aConnections, int colorIndex, boolean aConnected, boolean aRedstone) {
        return new ITexture[]{TextureFactory.of(EMpipe), TextureFactory.of(this.getActive() ? EMbarActive : EMbar, Dyes.getModulation(colorIndex, Dyes.MACHINE_METAL.getRGBA()))};
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    @Override
    public void loadNBTData(NBTTagCompound nbtTagCompound) {
        this.active = nbtTagCompound.func_74767_n("eActive");
    }

    @Override
    public void saveNBTData(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74757_a("eActive", this.active);
    }

    @Override
    public boolean renderInside(ForgeDirection side) {
        return false;
    }

    @Override
    public byte getTileEntityBaseType() {
        return 4;
    }

    @Override
    public String[] getDescription() {
        return new String[]{CommonValues.TEC_MARK_EM, StatCollector.func_74838_a((String)"gt.blockmachines.pipe.datastream.desc.0"), EnumChatFormatting.AQUA.toString() + EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"gt.blockmachines.pipe.datastream.desc.1"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.pipe.datastream.desc.2"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.pipe.datastream.desc.3")};
    }

    public void updateNeighboringNetworks() {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            IMetaTileEntity iMetaTileEntity;
            IGregTechTileEntity gregTechTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSide(side);
            if (gregTechTileEntity == null || !((iMetaTileEntity = gregTechTileEntity.getMetaTileEntity()) instanceof MTEPipeData)) continue;
            MTEPipeData neighbor = (MTEPipeData)iMetaTileEntity;
            neighbor.updateNetwork(true);
        }
    }

    public void updateNetwork(boolean nestedCall) {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        this.active = false;
        this.mConnections = 0;
        this.connectionCount = 0;
        byte myColor = aBaseMetaTileEntity.getColorization();
        if (aBaseMetaTileEntity.getColorization() < 0) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            IConnectsToDataPipe pipe;
            byte tColor;
            IGregTechTileEntity gregTechTileEntity;
            IMetaTileEntity meta;
            ForgeDirection oppositeSide = side.getOpposite();
            TileEntity tTileEntity = aBaseMetaTileEntity.getTileEntityAtSide(side);
            if (tTileEntity instanceof IConnectsToDataPipe) {
                IConnectsToDataPipe pipe2 = (IConnectsToDataPipe)tTileEntity;
                byte tColor2 = pipe2.getColorization();
                if (tColor2 != myColor || !pipe2.canConnectData(oppositeSide)) continue;
                this.mConnections = (byte)(this.mConnections | side.flag);
                this.connectionCount = (byte)(this.connectionCount + 1);
                continue;
            }
            if (!(tTileEntity instanceof IGregTechTileEntity) || !((meta = (gregTechTileEntity = (IGregTechTileEntity)tTileEntity).getMetaTileEntity()) instanceof IConnectsToDataPipe) || (tColor = (pipe = (IConnectsToDataPipe)((Object)meta)).getColorization()) != myColor || !pipe.canConnectData(oppositeSide)) continue;
            this.mConnections = (byte)(this.mConnections | side.flag);
            this.connectionCount = (byte)(this.connectionCount + 1);
        }
        if (!nestedCall) {
            this.updateNeighboringNetworks();
        }
    }

    @Override
    public void onColorChangeServer(byte aColor) {
        this.updateNetwork(false);
        super.onColorChangeServer(aColor);
    }

    @Override
    public void onBlockDestroyed() {
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            MTEPipeData neighbor;
            IMetaTileEntity iMetaTileEntity;
            IGregTechTileEntity gregTechTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityAtSide(side);
            if (gregTechTileEntity == null || !((iMetaTileEntity = gregTechTileEntity.getMetaTileEntity()) instanceof MTEPipeData) || !(neighbor = (MTEPipeData)iMetaTileEntity).isConnectedAtSide(side.getOpposite())) continue;
            neighbor.mConnections = (byte)(neighbor.mConnections & ~side.getOpposite().flag);
            neighbor.connectionCount = (byte)(neighbor.connectionCount - 1);
        }
        super.onBlockDestroyed();
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        this.updateNetwork(false);
        super.onFirstTick(aBaseMetaTileEntity);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if ((aTick & 0x1FL) == 31L && TecTech.RANDOM.nextInt(15) == 0) {
                NetworkDispatcher.INSTANCE.sendToAllAround(new PipeActivityMessage.PipeActivityData(this), aBaseMetaTileEntity.getWorld().field_73011_w.field_76574_g, aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getZCoord(), 256.0);
            }
        } else if (aBaseMetaTileEntity.isClientSide() && GTMod.clientProxy().changeDetected() == 4) {
            aBaseMetaTileEntity.issueTextureUpdate();
        }
    }

    @Override
    public boolean canConnectData(ForgeDirection side) {
        return true;
    }

    @Override
    public IConnectsToDataPipe getNext(IConnectsToDataPipe source) {
        if (this.connectionCount != 2) {
            return null;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            IGregTechTileEntity gregTechTileEntity;
            IMetaTileEntity meta;
            if ((this.mConnections & side.flag) == 0) continue;
            TileEntity next = this.getBaseMetaTileEntity().getTileEntityAtSide(side);
            if (next instanceof IConnectsToDataPipe) {
                IConnectsToDataPipe connectsToPipe = (IConnectsToDataPipe)next;
                if (next != source) {
                    if (!connectsToPipe.isDataInputFacing(side.getOpposite())) continue;
                    return connectsToPipe;
                }
            }
            if (!(next instanceof IGregTechTileEntity) || !((meta = (gregTechTileEntity = (IGregTechTileEntity)next).getMetaTileEntity()) instanceof IConnectsToDataPipe)) continue;
            IConnectsToDataPipe connectsToPipe = (IConnectsToDataPipe)((Object)meta);
            if (meta == source) continue;
            if (meta instanceof MTEPipeData) {
                MTEPipeData pipeData = (MTEPipeData)meta;
                if (pipeData.connectionCount == 2) {
                    pipeData.markUsed();
                    return connectsToPipe;
                }
            }
            if (!connectsToPipe.isDataInputFacing(side.getOpposite())) continue;
            return connectsToPipe;
        }
        return null;
    }

    @Override
    public float getCollisionThickness() {
        return 0.375f;
    }

    @Override
    public boolean isDataInputFacing(ForgeDirection side) {
        return true;
    }

    @Override
    public byte getColorization() {
        return this.getBaseMetaTileEntity().getColorization();
    }

    @Override
    public void markUsed() {
        this.active = true;
    }

    @Override
    public void setActive(boolean state) {
        if (state != this.active) {
            this.active = state;
            this.getBaseMetaTileEntity().issueTextureUpdate();
        }
    }

    @Override
    public boolean getActive() {
        return this.active;
    }
}

